/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.api.AnnotationsProto;
import com.google.api.HttpBody;
import com.google.api.HttpRule;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.FieldMask;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.ListValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.server.grpc.HttpEndpointSpecification;
import com.linecorp.armeria.internal.server.grpc.HttpEndpointSupport;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.CaseFormat;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RouteBuilder;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.AbstractUnframedGrpcService;
import com.linecorp.armeria.server.grpc.FramedGrpcService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingOptions;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingPathParser;
import com.linecorp.armeria.server.grpc.HttpJsonTranscodingQueryParamMatchRule;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoMethodDescriptorSupplier;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpJsonTranscodingService
extends AbstractUnframedGrpcService
implements HttpEndpointSupport {
    private static final Logger logger = LoggerFactory.getLogger(HttpJsonTranscodingService.class);
    private static final ObjectMapper mapper = JacksonUtil.newDefaultObjectMapper();
    private final Map<Route, TranscodingSpec> routeAndSpecs;
    private final Set<Route> routes;

    static GrpcService of(GrpcService delegate, HttpJsonTranscodingOptions httpJsonTranscodingOptions) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(httpJsonTranscodingOptions, "httpJsonTranscodingOptions");
        HashMap<Route, TranscodingSpec> specs = new HashMap<Route, TranscodingSpec>();
        List<ServerServiceDefinition> serviceDefinitions = delegate.services();
        for (ServerServiceDefinition serviceDefinition : serviceDefinitions) {
            Descriptors.ServiceDescriptor serviceDesc = HttpJsonTranscodingService.serviceDescriptor(serviceDefinition);
            if (serviceDesc == null) continue;
            for (ServerMethodDefinition methodDefinition : serviceDefinition.getMethods()) {
                DescriptorProtos.MethodOptions methodOptions;
                Descriptors.MethodDescriptor methodDesc = HttpJsonTranscodingService.methodDescriptor(methodDefinition);
                if (methodDesc == null || !(methodOptions = methodDesc.getOptions()).hasExtension((ExtensionLite)AnnotationsProto.http)) continue;
                HttpRule httpRule = (HttpRule)methodOptions.getExtension((ExtensionLite)AnnotationsProto.http);
                if (methodDefinition.getMethodDescriptor().getType() != MethodDescriptor.MethodType.UNARY) {
                    logger.warn("Only unary methods can be configured with an HTTP/JSON endpoint: method={}, httpRule={}", (Object)methodDefinition.getMethodDescriptor().getFullMethodName(), (Object)httpRule);
                    continue;
                }
                @Nullable Map.Entry<Route, List<PathVariable>> routeAndVariables = HttpJsonTranscodingService.toRouteAndPathVariables(httpRule);
                if (routeAndVariables == null) continue;
                Set<HttpJsonTranscodingQueryParamMatchRule> queryParamMatchRules = httpJsonTranscodingOptions.queryParamMatchRules();
                Route route = routeAndVariables.getKey();
                List<PathVariable> pathVariables = routeAndVariables.getValue();
                Map<String, Field> originalFields = HttpJsonTranscodingService.buildFields(methodDesc.getInputType(), (List<String>)ImmutableList.of(), "", (Set<Descriptors.Descriptor>)ImmutableSet.of(), HttpJsonTranscodingQueryParamMatchRule.ORIGINAL_FIELD, (Set<HttpJsonTranscodingQueryParamMatchRule>)ImmutableSet.of((Object)((Object)HttpJsonTranscodingQueryParamMatchRule.ORIGINAL_FIELD)));
                List queryMappingFields = (List)queryParamMatchRules.stream().map(matchRule -> HttpJsonTranscodingService.buildFields(methodDesc.getInputType(), (List<String>)ImmutableList.of(), "", (Set<Descriptors.Descriptor>)ImmutableSet.of(), matchRule, queryParamMatchRules)).collect(ImmutableList.toImmutableList());
                if (specs.containsKey(route)) {
                    logger.warn("{} is not added because the route is duplicate: {}", (Object)httpRule, (Object)route);
                    continue;
                }
                List topLevelFields = methodDesc.getOutputType().getFields();
                String responseBody = HttpJsonTranscodingService.getResponseBody(topLevelFields, httpRule.getResponseBody());
                int order = 0;
                specs.put(route, new TranscodingSpec(order++, httpRule, methodDefinition, serviceDesc, methodDesc, originalFields, queryMappingFields, pathVariables, responseBody));
                for (HttpRule additionalHttpRule : httpRule.getAdditionalBindingsList()) {
                    @Nullable Map.Entry<Route, List<PathVariable>> additionalRouteAndVariables = HttpJsonTranscodingService.toRouteAndPathVariables(additionalHttpRule);
                    if (additionalRouteAndVariables == null) continue;
                    specs.put(additionalRouteAndVariables.getKey(), new TranscodingSpec(order++, additionalHttpRule, methodDefinition, serviceDesc, methodDesc, originalFields, queryMappingFields, additionalRouteAndVariables.getValue(), responseBody));
                }
            }
        }
        if (specs.isEmpty()) {
            return delegate;
        }
        return new HttpJsonTranscodingService(delegate, (Map<Route, TranscodingSpec>)ImmutableMap.copyOf(specs), httpJsonTranscodingOptions);
    }

    @Nullable
    private static Descriptors.ServiceDescriptor serviceDescriptor(ServerServiceDefinition serviceDefinition) {
        @Nullable Object desc = serviceDefinition.getServiceDescriptor().getSchemaDescriptor();
        if (desc instanceof ProtoServiceDescriptorSupplier) {
            return ((ProtoServiceDescriptorSupplier)desc).getServiceDescriptor();
        }
        return null;
    }

    @Nullable
    private static Descriptors.MethodDescriptor methodDescriptor(ServerMethodDefinition<?, ?> methodDefinition) {
        @Nullable Object desc = methodDefinition.getMethodDescriptor().getSchemaDescriptor();
        if (desc instanceof ProtoMethodDescriptorSupplier) {
            return ((ProtoMethodDescriptorSupplier)desc).getMethodDescriptor();
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    static Map.Entry<Route, List<PathVariable>> toRouteAndPathVariables(HttpRule httpRule) {
        HttpJsonTranscodingPathParser.PathSegment.PathMappingType pathMappingType;
        String path;
        RouteBuilder builder = Route.builder();
        switch (httpRule.getPatternCase()) {
            case GET: {
                builder.methods(new HttpMethod[]{HttpMethod.GET});
                path = httpRule.getGet();
                break;
            }
            case PUT: {
                builder.methods(new HttpMethod[]{HttpMethod.PUT});
                path = httpRule.getPut();
                break;
            }
            case POST: {
                builder.methods(new HttpMethod[]{HttpMethod.POST});
                path = httpRule.getPost();
                break;
            }
            case DELETE: {
                builder.methods(new HttpMethod[]{HttpMethod.DELETE});
                path = httpRule.getDelete();
                break;
            }
            case PATCH: {
                builder.methods(new HttpMethod[]{HttpMethod.PATCH});
                path = httpRule.getPatch();
                break;
            }
            default: {
                logger.warn("Ignoring unsupported route pattern: pattern={}, httpRule={}", (Object)httpRule.getPatternCase(), (Object)httpRule);
                return null;
            }
        }
        if (path.startsWith("exact:") || path.startsWith("prefix:") || path.startsWith("glob:") || path.startsWith("regex:")) {
            Route route = builder.path(path).build();
            List vars = (List)route.paramNames().stream().map(name -> new PathVariable(null, (String)name, (List<PathVariable.ValueDefinition>)ImmutableList.of((Object)new PathVariable.ValueDefinition(PathVariable.ValueDefinition.Type.REFERENCE, (String)name)))).collect(ImmutableList.toImmutableList());
            return new AbstractMap.SimpleImmutableEntry<Route, List<PathVariable>>(route, vars);
        }
        List<HttpJsonTranscodingPathParser.PathSegment> segments = HttpJsonTranscodingPathParser.parse(path);
        HttpJsonTranscodingPathParser.PathSegment.PathMappingType pathMappingType2 = pathMappingType = segments.stream().allMatch(segment -> segment.support(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED)) ? HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED : HttpJsonTranscodingPathParser.PathSegment.PathMappingType.GLOB;
        if (segments.get(segments.size() - 1) instanceof HttpJsonTranscodingPathParser.VerbPathSegment) {
            pathMappingType = HttpJsonTranscodingPathParser.PathSegment.PathMappingType.REGEX;
        }
        if (pathMappingType == HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED) {
            builder.path(HttpJsonTranscodingPathParser.Stringifier.segmentsToPath(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.PARAMETERIZED, segments, true));
        } else if (pathMappingType == HttpJsonTranscodingPathParser.PathSegment.PathMappingType.GLOB) {
            builder.glob(HttpJsonTranscodingPathParser.Stringifier.segmentsToPath(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.GLOB, segments, true));
        } else {
            builder.regex(HttpJsonTranscodingPathParser.Stringifier.segmentsToPath(HttpJsonTranscodingPathParser.PathSegment.PathMappingType.REGEX, segments, true));
        }
        return new AbstractMap.SimpleImmutableEntry<Route, List<PathVariable>>(builder.build(), PathVariable.from(segments, pathMappingType));
    }

    private static Map<String, Field> buildFields(Descriptors.Descriptor desc, List<String> parentNames, String namePrefix, Set<Descriptors.Descriptor> visitedTypes, HttpJsonTranscodingQueryParamMatchRule currentMatchRule, Set<HttpJsonTranscodingQueryParamMatchRule> matchRules) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        block11: for (Descriptors.FieldDescriptor field : desc.getFields()) {
            String fieldName;
            Descriptors.FieldDescriptor.JavaType type = field.getJavaType();
            switch (currentMatchRule) {
                case ORIGINAL_FIELD: {
                    fieldName = field.getName();
                    break;
                }
                case LOWER_CAMEL_CASE: {
                    fieldName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
                    break;
                }
                case JSON_NAME: {
                    if (field.toProto().hasJsonName()) {
                        fieldName = field.toProto().getJsonName();
                        break;
                    }
                    fieldName = null;
                    break;
                }
                default: {
                    throw new Error("Should never reach here");
                }
            }
            if (fieldName == null) continue;
            String key = namePrefix.isEmpty() ? fieldName : namePrefix + '.' + fieldName;
            switch (type) {
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: 
                case BYTE_STRING: 
                case ENUM: {
                    builder.put((Object)key, (Object)new Field(field, parentNames, field.getJavaType()));
                    break;
                }
                case MESSAGE: {
                    // Could not load outer class - annotation placement on inner may be incorrect
                     @Nullable Descriptors.FieldDescriptor.JavaType wellKnownFieldType = HttpJsonTranscodingService.getJavaTypeForWellKnownTypes(field);
                    if (wellKnownFieldType != null) {
                        builder.put((Object)key, (Object)new Field(field, parentNames, wellKnownFieldType));
                        break;
                    }
                    if (visitedTypes.contains(field.getMessageType())) {
                        throw new RecursiveTypeException(field.getMessageType());
                    }
                    Descriptors.Descriptor typeDesc = field.getMessageType();
                    String newParentName = field.getJsonName();
                    try {
                        for (HttpJsonTranscodingQueryParamMatchRule nestedMatchRule : matchRules) {
                            builder.putAll(HttpJsonTranscodingService.buildFields(typeDesc, (List<String>)ImmutableList.builder().addAll(parentNames).add((Object)newParentName).build(), key, (Set<Descriptors.Descriptor>)ImmutableSet.builder().addAll(visitedTypes).add((Object)field.getMessageType()).build(), nestedMatchRule, matchRules));
                        }
                        continue block11;
                    }
                    catch (RecursiveTypeException e) {
                        if (e.recursiveTypeDescriptor() != field.getMessageType()) {
                            throw e;
                        }
                        builder.put((Object)key, (Object)new Field(field, parentNames, Descriptors.FieldDescriptor.JavaType.MESSAGE));
                    }
                }
            }
        }
        return builder.buildKeepingLast();
    }

    @Nullable
    private static Descriptors.FieldDescriptor.JavaType getJavaTypeForWellKnownTypes(Descriptors.FieldDescriptor fd) {
        if (fd.isMapField()) {
            return Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }
        Descriptors.Descriptor messageType = fd.getMessageType();
        String fullName = messageType.getFullName();
        if (Timestamp.getDescriptor().getFullName().equals(fullName) || Duration.getDescriptor().getFullName().equals(fullName) || FieldMask.getDescriptor().getFullName().equals(fullName)) {
            return Descriptors.FieldDescriptor.JavaType.STRING;
        }
        if (DoubleValue.getDescriptor().getFullName().equals(fullName) || FloatValue.getDescriptor().getFullName().equals(fullName) || Int64Value.getDescriptor().getFullName().equals(fullName) || UInt64Value.getDescriptor().getFullName().equals(fullName) || Int32Value.getDescriptor().getFullName().equals(fullName) || UInt32Value.getDescriptor().getFullName().equals(fullName) || BoolValue.getDescriptor().getFullName().equals(fullName) || StringValue.getDescriptor().getFullName().equals(fullName) || BytesValue.getDescriptor().getFullName().equals(fullName)) {
            assert (messageType.getFields().size() == 1) : "Wrappers must have one 'value' field.";
            return ((Descriptors.FieldDescriptor)messageType.getFields().get(0)).getJavaType();
        }
        if (Struct.getDescriptor().getFullName().equals(fullName) || ListValue.getDescriptor().getFullName().equals(fullName) || Value.getDescriptor().getFullName().equals(fullName) || Any.getDescriptor().getFullName().equals(fullName)) {
            return Descriptors.FieldDescriptor.JavaType.MESSAGE;
        }
        return null;
    }

    @Nullable
    private static String getResponseBody(List<Descriptors.FieldDescriptor> topLevelFields, @Nullable String responseBody) {
        if (StringUtil.isNullOrEmpty((String)responseBody)) {
            return null;
        }
        for (Descriptors.FieldDescriptor fieldDescriptor : topLevelFields) {
            if (!fieldDescriptor.getName().equals(responseBody)) continue;
            return responseBody;
        }
        return null;
    }

    @Nullable
    private static Function<AggregatedHttpResponse, AggregatedHttpResponse> generateResponseConverter(TranscodingSpec spec) {
        if (HttpBody.getDescriptor().equals(spec.methodDescriptor.getOutputType())) {
            return httpResponse -> {
                HttpData data = httpResponse.content();
                JsonNode jsonNode = HttpJsonTranscodingService.extractHttpBody(data);
                if (jsonNode == null) {
                    return httpResponse;
                }
                PooledObjects.close((Object)data);
                String httpBody = jsonNode.get("data").asText();
                byte[] httpBodyBytes = Base64.getDecoder().decode(httpBody);
                ResponseHeaders newHeaders = httpResponse.headers().withMutations(builder -> {
                    JsonNode contentType = jsonNode.get("contentType");
                    if (contentType != null && contentType.isTextual()) {
                        builder.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType.textValue());
                    } else {
                        builder.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                    }
                });
                return AggregatedHttpResponse.of((ResponseHeaders)newHeaders, (HttpData)HttpData.wrap((byte[])httpBodyBytes));
            };
        }
        @Nullable String responseBody = spec.responseBody;
        if (responseBody == null) {
            return null;
        }
        return httpResponse -> {
            try (HttpData data = httpResponse.content();){
                HttpData convertedData = HttpJsonTranscodingService.convertHttpDataForResponseBody(responseBody, data);
                AggregatedHttpResponse aggregatedHttpResponse = AggregatedHttpResponse.of((ResponseHeaders)httpResponse.headers(), (HttpData)convertedData);
                return aggregatedHttpResponse;
            }
        };
    }

    @Nullable
    private static JsonNode extractHttpBody(HttpData data) {
        byte[] array = data.array();
        try {
            return (JsonNode)mapper.readValue(array, JsonNode.class);
        }
        catch (IOException e) {
            logger.warn("Unexpected exception while parsing HttpBody from {}", (Object)data, (Object)e);
            return null;
        }
    }

    private static HttpData convertHttpDataForResponseBody(String responseBody, HttpData data) {
        byte[] array = data.array();
        try {
            JsonNode jsonNode = (JsonNode)mapper.readValue(array, JsonNode.class);
            String lowerCamelCaseResponseBody = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, responseBody);
            Iterator fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String fieldName = (String)entry.getKey();
                JsonNode responseBodyJsonNode = (JsonNode)entry.getValue();
                if (!fieldName.equals(lowerCamelCaseResponseBody) && !fieldName.equals(responseBody)) continue;
                byte[] bytes = mapper.writeValueAsBytes((Object)responseBodyJsonNode);
                return HttpData.wrap((byte[])bytes);
            }
            return HttpData.ofUtf8((String)"null");
        }
        catch (IOException e) {
            logger.warn("Unexpected exception while extracting responseBody '{}' from {}", new Object[]{responseBody, data, e});
            return HttpData.wrap((byte[])array);
        }
    }

    private HttpJsonTranscodingService(GrpcService delegate, Map<Route, TranscodingSpec> routeAndSpecs, HttpJsonTranscodingOptions httpJsonTranscodingOptions) {
        super(delegate, httpJsonTranscodingOptions.errorHandler());
        this.routeAndSpecs = routeAndSpecs;
        this.routes = ImmutableSet.builder().addAll((Iterable)delegate.routes()).addAll(routeAndSpecs.keySet()).build();
    }

    @Override
    @Nullable
    public HttpEndpointSpecification httpEndpointSpecification(Route route) {
        Objects.requireNonNull(route, "route");
        TranscodingSpec spec = this.routeAndSpecs.get(route);
        if (spec == null) {
            return null;
        }
        Set paramNames = (Set)spec.pathVariables.stream().map(PathVariable::name).collect(ImmutableSet.toImmutableSet());
        Map parameterTypes = (Map)spec.originalFields.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, fieldEntry -> new HttpEndpointSpecification.Parameter(((Field)fieldEntry.getValue()).type(), ((Field)fieldEntry.getValue()).isRepeated())));
        return new HttpEndpointSpecification(spec.order, route, paramNames, spec.serviceDescriptor, spec.methodDescriptor, parameterTypes, spec.httpRule);
    }

    @Override
    public Set<Route> routes() {
        return this.routes;
    }

    @Override
    @Nullable
    public ServerMethodDefinition<?, ?> methodDefinition(ServiceRequestContext ctx) {
        TranscodingSpec spec = this.routeAndSpecs.get(ctx.config().mappedRoute());
        if (spec != null) {
            return spec.method;
        }
        return super.methodDefinition(ctx);
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        TranscodingSpec spec = this.routeAndSpecs.get(ctx.config().mappedRoute());
        if (spec != null) {
            return this.serve0(ctx, req, spec);
        }
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
    }

    private HttpResponse serve0(ServiceRequestContext ctx, HttpRequest req, TranscodingSpec spec) throws Exception {
        RequestHeaders clientHeaders = req.headers();
        RequestHeadersBuilder grpcHeaders = clientHeaders.toBuilder();
        if (grpcHeaders.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING) != null) {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"gRPC encoding is not supported for non-framed requests.");
        }
        grpcHeaders.method(HttpMethod.POST).contentType(GrpcSerializationFormats.JSON.mediaType());
        grpcHeaders.remove((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING);
        ctx.logBuilder().defer(new RequestLogProperty[]{RequestLogProperty.REQUEST_CONTENT, RequestLogProperty.RESPONSE_CONTENT});
        CompletableFuture responseFuture = new CompletableFuture();
        req.aggregate((EventExecutor)ctx.eventLoop()).handle((clientRequest, t) -> {
            try (SafeCloseable ignore = ctx.push();){
                if (t != null) {
                    responseFuture.completeExceptionally((Throwable)t);
                } else {
                    try {
                        ctx.setAttr(FramedGrpcService.RESOLVED_GRPC_METHOD, (Object)spec.method);
                        HttpData requestContent = HttpBody.getDescriptor().equals(spec.methodDescriptor.getInputType()) ? HttpJsonTranscodingService.convertToHttpBody(clientRequest) : HttpJsonTranscodingService.convertToJson(ctx, clientRequest, spec);
                        this.frameAndServe((Service<HttpRequest, HttpResponse>)((Service)this.unwrap()), ctx, grpcHeaders.build(), requestContent, responseFuture, HttpJsonTranscodingService.generateResponseConverter(spec));
                    }
                    catch (IllegalArgumentException iae) {
                        responseFuture.completeExceptionally((Throwable)HttpStatusException.of((HttpStatus)HttpStatus.BAD_REQUEST, (Throwable)iae));
                    }
                    catch (Exception e) {
                        responseFuture.completeExceptionally(e);
                    }
                }
            }
            return null;
        });
        return HttpResponse.of(responseFuture);
    }

    private static HttpData convertToHttpBody(AggregatedHttpRequest request) throws IOException {
        ObjectNode body = mapper.createObjectNode();
        try (HttpData content = request.content();){
            @Nullable MediaType requestContentType = request.contentType();
            MediaType contentType = requestContentType != null ? requestContentType : MediaType.OCTET_STREAM;
            body.put("content_type", contentType.toString());
            body.put("data", content.array());
            HttpData httpData = HttpData.wrap((byte[])mapper.writeValueAsBytes((Object)body));
            return httpData;
        }
    }

    private static HttpData convertToJson(ServiceRequestContext ctx, AggregatedHttpRequest request, TranscodingSpec spec) throws IOException {
        try {
            switch (request.method()) {
                case GET: {
                    HttpData httpData = HttpJsonTranscodingService.setParametersAndWriteJson(mapper.createObjectNode(), ctx, spec);
                    return httpData;
                }
                case PUT: 
                case POST: 
                case PATCH: 
                case DELETE: {
                    String bodyMapping = spec.httpRule.getBody();
                    if ("*".equals(bodyMapping)) {
                        ObjectNode root;
                        @Nullable JsonNode body = HttpJsonTranscodingService.getBodyContent(request);
                        if (body instanceof ObjectNode) {
                            root = (ObjectNode)body;
                        } else if (body == null) {
                            root = mapper.createObjectNode();
                        } else {
                            throw new IllegalArgumentException("Unexpected JSON: " + body + ", (expected: ObjectNode or null).");
                        }
                        HttpData httpData = HttpJsonTranscodingService.setParametersAndWriteJson(root, ctx, spec);
                        return httpData;
                    }
                    ObjectNode root = mapper.createObjectNode();
                    if (!Strings.isNullOrEmpty((String)bodyMapping)) {
                        ObjectNode current = root;
                        String[] nameParts = bodyMapping.split("\\.");
                        for (int i = 0; i < nameParts.length - 1; ++i) {
                            current = current.putObject(nameParts[i]);
                        }
                        @Nullable JsonNode body = HttpJsonTranscodingService.getBodyContent(request);
                        if (body != null) {
                            current.set(nameParts[nameParts.length - 1], body);
                        } else {
                            current.putNull(nameParts[nameParts.length - 1]);
                        }
                    }
                    HttpData httpData = HttpJsonTranscodingService.setParametersAndWriteJson(root, ctx, spec);
                    return httpData;
                }
            }
            throw HttpStatusException.of((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED);
        }
        finally {
            request.content().close();
        }
    }

    @Nullable
    private static JsonNode getBodyContent(AggregatedHttpRequest request) {
        @Nullable MediaType contentType = request.contentType();
        if (contentType == null || !contentType.isJson()) {
            if (request.content().isEmpty()) {
                return null;
            }
            throw new IllegalArgumentException("Missing or invalid content-type in JSON request.");
        }
        try {
            return mapper.readTree(request.contentUtf8());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to parse JSON request.", e);
        }
    }

    @VisibleForTesting
    static Map<String, String> populatePathVariables(ServiceRequestContext ctx, List<PathVariable> pathVariables) {
        return (Map)pathVariables.stream().map(var -> {
            String value = var.values().stream().map(def -> {
                if (((PathVariable.ValueDefinition)def).type == PathVariable.ValueDefinition.Type.REFERENCE) {
                    return ctx.pathParam(((PathVariable.ValueDefinition)def).value);
                }
                return ((PathVariable.ValueDefinition)def).value;
            }).collect(Collectors.joining("/"));
            return new AbstractMap.SimpleImmutableEntry<String, String>(var.name(), value);
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static HttpData setParametersAndWriteJson(ObjectNode root, ServiceRequestContext ctx, TranscodingSpec spec) throws JsonProcessingException {
        Map<String, String> resolvedPathVars = HttpJsonTranscodingService.populatePathVariables(ctx, spec.pathVariables);
        HttpJsonTranscodingService.setParametersToNode(root, resolvedPathVars.entrySet(), spec, true);
        QueryParams params = ctx.queryParams();
        if (!params.isEmpty()) {
            HttpJsonTranscodingService.setParametersToNode(root, (Iterable<Map.Entry<String, String>>)params, spec, false);
        }
        return HttpData.wrap((byte[])mapper.writeValueAsBytes((Object)root));
    }

    private static void setParametersToNode(ObjectNode root, Iterable<Map.Entry<String, String>> parameters, TranscodingSpec spec, boolean pathVariables) {
        for (Map.Entry<String, String> entry : parameters) {
            Object mappingFields;
            Field field = null;
            if (pathVariables) {
                field = (Field)spec.originalFields.get(entry.getKey());
            } else {
                Iterator iterator = spec.queryMappingFields.iterator();
                while (iterator.hasNext() && (field = (Field)(mappingFields = (Map)iterator.next()).get(entry.getKey())) == null) {
                }
            }
            if (field == null) continue;
            if (field.javaType == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new IllegalArgumentException("Unsupported message type: " + field.descriptor.getFullName());
            }
            ObjectNode currentNode = root;
            mappingFields = field.parentNames.iterator();
            while (mappingFields.hasNext()) {
                String parentName = (String)mappingFields.next();
                JsonNode node = currentNode.get(parentName);
                if (node != null) {
                    Preconditions.checkArgument((boolean)node.isObject(), (Object)"Invalid request body (must be a JSON object)");
                    currentNode = (ObjectNode)node;
                    continue;
                }
                currentNode = currentNode.putObject(parentName);
            }
            if (field.isRepeated()) {
                ArrayNode arrayNode;
                JsonNode node = currentNode.get(field.name());
                if (node != null) {
                    Preconditions.checkArgument((boolean)node.isArray(), (Object)"Invalid request body (must be a JSON array)");
                    arrayNode = (ArrayNode)node;
                } else {
                    arrayNode = currentNode.putArray(field.name());
                }
                HttpJsonTranscodingService.setValueToArrayNode(arrayNode, field, entry.getValue());
                continue;
            }
            HttpJsonTranscodingService.setValueToObjectNode(currentNode, field, entry.getValue());
        }
    }

    private static void setValueToArrayNode(ArrayNode node, Field field, String value) {
        switch (field.type()) {
            case INT: {
                node.add(Integer.parseInt(value));
                break;
            }
            case LONG: {
                node.add(Long.parseLong(value));
                break;
            }
            case FLOAT: {
                node.add(Float.parseFloat(value));
                break;
            }
            case DOUBLE: {
                node.add(Double.parseDouble(value));
                break;
            }
            case BOOLEAN: {
                node.add(Boolean.parseBoolean(value));
                break;
            }
            case STRING: 
            case BYTE_STRING: 
            case ENUM: {
                node.add(value);
            }
        }
    }

    private static void setValueToObjectNode(ObjectNode node, Field field, String value) {
        switch (field.type()) {
            case INT: {
                node.put(field.name(), Integer.parseInt(value));
                break;
            }
            case LONG: {
                node.put(field.name(), Long.parseLong(value));
                break;
            }
            case FLOAT: {
                node.put(field.name(), Float.parseFloat(value));
                break;
            }
            case DOUBLE: {
                node.put(field.name(), Double.parseDouble(value));
                break;
            }
            case BOOLEAN: {
                node.put(field.name(), Boolean.parseBoolean(value));
                break;
            }
            case STRING: 
            case BYTE_STRING: 
            case ENUM: {
                node.put(field.name(), value);
            }
        }
    }

    static final class TranscodingSpec {
        private final int order;
        private final HttpRule httpRule;
        private final ServerMethodDefinition<?, ?> method;
        private final Descriptors.ServiceDescriptor serviceDescriptor;
        private final Descriptors.MethodDescriptor methodDescriptor;
        private final Map<String, Field> originalFields;
        private final List<Map<String, Field>> queryMappingFields;
        private final List<PathVariable> pathVariables;
        @Nullable
        private final String responseBody;

        private TranscodingSpec(int order, HttpRule httpRule, ServerMethodDefinition<?, ?> method, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor, Map<String, Field> originalFields, List<Map<String, Field>> queryMappingFields, List<PathVariable> pathVariables, @Nullable String responseBody) {
            this.order = order;
            this.httpRule = httpRule;
            this.method = method;
            this.serviceDescriptor = serviceDescriptor;
            this.methodDescriptor = methodDescriptor;
            this.originalFields = originalFields;
            this.queryMappingFields = queryMappingFields;
            this.pathVariables = pathVariables;
            this.responseBody = responseBody;
        }
    }

    static final class PathVariable {
        @Nullable
        private final String parent;
        private final String name;
        private final List<ValueDefinition> values;

        static List<PathVariable> from(List<HttpJsonTranscodingPathParser.PathSegment> segments, HttpJsonTranscodingPathParser.PathSegment.PathMappingType type) {
            return (List)segments.stream().filter(HttpJsonTranscodingPathParser.VariablePathSegment.class::isInstance).flatMap(segment -> PathVariable.resolvePathVariables(null, (HttpJsonTranscodingPathParser.VariablePathSegment)segment, type).stream()).collect(ImmutableList.toImmutableList());
        }

        private static List<PathVariable> resolvePathVariables(@Nullable String parent, HttpJsonTranscodingPathParser.VariablePathSegment var, HttpJsonTranscodingPathParser.PathSegment.PathMappingType type) {
            ImmutableList.Builder pathVariables = ImmutableList.builder();
            ImmutableList.Builder valueDefinitions = ImmutableList.builder();
            var.valueSegments().forEach(segment -> {
                if (segment instanceof HttpJsonTranscodingPathParser.VariablePathSegment) {
                    List<PathVariable> children = PathVariable.resolvePathVariables(var.fieldPath(), (HttpJsonTranscodingPathParser.VariablePathSegment)segment, type);
                    children.stream().filter(child -> var.fieldPath().equals(child.parent())).forEach(child -> valueDefinitions.addAll(child.values()));
                    pathVariables.addAll(children);
                } else {
                    @Nullable String v = segment.pathVariable(type);
                    if (v != null) {
                        valueDefinitions.add((Object)new ValueDefinition(ValueDefinition.Type.REFERENCE, v));
                    } else {
                        valueDefinitions.add((Object)new ValueDefinition(ValueDefinition.Type.LITERAL, segment.segmentString(type)));
                    }
                }
            });
            return pathVariables.add((Object)new PathVariable(parent, var.fieldPath(), (List<ValueDefinition>)valueDefinitions.build())).build();
        }

        PathVariable(@Nullable String parent, String name, List<ValueDefinition> values) {
            this.parent = parent;
            this.name = Objects.requireNonNull(name, "name");
            this.values = Objects.requireNonNull(values, "values");
        }

        @Nullable
        String parent() {
            return this.parent;
        }

        String name() {
            return this.name;
        }

        List<ValueDefinition> values() {
            return this.values;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("parent", (Object)this.parent).add("name", (Object)this.name).add("values", this.values).toString();
        }

        static final class ValueDefinition {
            private final Type type;
            private final String value;

            ValueDefinition(Type type, String value) {
                this.type = Objects.requireNonNull(type, "type");
                this.value = Objects.requireNonNull(value, "value");
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("value", (Object)this.value).toString();
            }

            static enum Type {
                LITERAL,
                REFERENCE;

            }
        }
    }

    static final class Field {
        private final Descriptors.FieldDescriptor descriptor;
        private final List<String> parentNames;
        private final Descriptors.FieldDescriptor.JavaType javaType;

        private Field(Descriptors.FieldDescriptor descriptor, List<String> parentNames, Descriptors.FieldDescriptor.JavaType javaType) {
            this.descriptor = descriptor;
            this.parentNames = parentNames;
            this.javaType = javaType;
        }

        Descriptors.FieldDescriptor.JavaType type() {
            return this.javaType;
        }

        String name() {
            return this.descriptor.getJsonName();
        }

        boolean isRepeated() {
            return this.descriptor.isRepeated();
        }
    }

    private static class RecursiveTypeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = -6764357154559606786L;
        private final Descriptors.Descriptor recursiveTypeDescriptor;

        RecursiveTypeException(Descriptors.Descriptor recursiveTypeDescriptor) {
            this.recursiveTypeDescriptor = recursiveTypeDescriptor;
        }

        Descriptors.Descriptor recursiveTypeDescriptor() {
            return this.recursiveTypeDescriptor;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

