/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.server.grpc.ssl;

import io.grpc.netty.GrpcSslContexts;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.net.ssl.SSLException;
import org.apache.skywalking.oap.server.library.server.ssl.AbstractSslContext;
import org.apache.skywalking.oap.server.library.server.ssl.PrivateKeyUtil;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class DynamicSslContext
extends AbstractSslContext {
    public static DynamicSslContext forServer(String privateKeyFile, String certChainFile, String trustedCAsFile) {
        return new DynamicSslContext(privateKeyFile, certChainFile, trustedCAsFile);
    }

    public static DynamicSslContext forClient(String caFile) {
        return new DynamicSslContext(caFile);
    }

    protected DynamicSslContext(String privateKeyFile, String certChainFile, String trustedCAsFile) {
        super(privateKeyFile, certChainFile, trustedCAsFile);
    }

    protected DynamicSslContext(String caFile) {
        super(caFile);
    }

    @Override
    protected void updateContext(String caFile) {
        try {
            this.setCtx(GrpcSslContexts.forClient().trustManager(Paths.get(caFile, new String[0]).toFile()).build());
        }
        catch (SSLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void updateContext(String privateKeyFile, String certChainFile, String trustedCAsFile) {
        try (FileInputStream cert = new FileInputStream(Paths.get(certChainFile, new String[0]).toFile());
             InputStream key = PrivateKeyUtil.loadDecryptionKey(privateKeyFile);){
            SslContextBuilder builder = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forServer((InputStream)cert, (InputStream)key), (SslProvider)SslProvider.OPENSSL);
            if (StringUtil.isNotEmpty((String)trustedCAsFile)) {
                builder.trustManager(Paths.get(trustedCAsFile, new String[0]).toFile()).clientAuth(ClientAuth.REQUIRE);
            }
            this.setCtx(builder.build());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

