/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.telegraf.provider.handler;

import com.google.common.collect.ImmutableMap;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.RequestConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.oap.meter.analyzer.MetricConvert;
import org.apache.skywalking.oap.meter.analyzer.MetricRuleConfig;
import org.apache.skywalking.oap.meter.analyzer.dsl.Sample;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamily;
import org.apache.skywalking.oap.meter.analyzer.dsl.SampleFamilyBuilder;
import org.apache.skywalking.oap.meter.analyzer.prometheus.rule.Rule;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.telegraf.provider.handler.pojo.TelegrafData;
import org.apache.skywalking.oap.server.receiver.telegraf.provider.handler.pojo.TelegrafDatum;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelegrafServiceHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelegrafServiceHandler.class);
    private final HistogramMetrics histogram;
    private final CounterMetrics errorCounter;
    private List<MetricConvert> metricConvert;

    public TelegrafServiceHandler(ModuleManager moduleManager, MeterSystem meterSystem, List<Rule> rules) {
        this.metricConvert = rules.stream().map(r -> new MetricConvert((MetricRuleConfig)r, meterSystem)).collect(Collectors.toList());
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.histogram = metricsCreator.createHistogramMetric("telegraf_in_latency", "The process latency of telegraf data", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}), new double[0]);
        this.errorCounter = metricsCreator.createCounter("telegraf_error_count", "The error number of telegraf analysis", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"http"}));
    }

    public List<Sample> convertTelegraf(TelegrafDatum telegrafData) {
        ArrayList<Sample> sampleList = new ArrayList<Sample>();
        Map<String, Object> fields = telegrafData.getFields();
        String name = telegrafData.getName();
        Map<String, String> tags = telegrafData.getTags();
        ImmutableMap immutableTags = ImmutableMap.copyOf(tags);
        long timestamp = telegrafData.getTimestamp();
        fields.forEach((key, value) -> {
            if (value instanceof Number) {
                Sample.SampleBuilder builder = Sample.builder();
                Sample sample = builder.name(name + "_" + key).timestamp(timestamp * 1000L).value(((Number)value).doubleValue()).labels(immutableTags).build();
                sampleList.add(sample);
            }
        });
        return sampleList;
    }

    public List<ImmutableMap<String, SampleFamily>> convertSampleFamily(TelegrafData telegrafData) {
        ArrayList<Sample> allSamples = new ArrayList<Sample>();
        List<TelegrafDatum> metrics = telegrafData.getMetrics();
        for (TelegrafDatum m : metrics) {
            List<Sample> samples = this.convertTelegraf(m);
            allSamples.addAll(samples);
        }
        ArrayList<ImmutableMap<String, SampleFamily>> res = new ArrayList<ImmutableMap<String, SampleFamily>>();
        Map<Long, List<Sample>> sampleFamilyByTime = allSamples.stream().collect(Collectors.groupingBy(Sample::getTimestamp));
        for (List<Sample> s : sampleFamilyByTime.values()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            Map<String, List<Sample>> sampleFamilyByName = s.stream().collect(Collectors.groupingBy(Sample::getName));
            sampleFamilyByName.forEach((k, v) -> builder.put(k, (Object)SampleFamilyBuilder.newBuilder((Sample[])v.toArray(new Sample[0])).build()));
            res.add((ImmutableMap<String, SampleFamily>)builder.build());
        }
        return res;
    }

    @Post(value="/telegraf")
    @RequestConverter(value=TelegrafData.class)
    public Commands collectData(TelegrafData telegrafData) {
        try (HistogramMetrics.Timer ignored = this.histogram.createTimer();){
            List<ImmutableMap<String, SampleFamily>> sampleFamily = this.convertSampleFamily(telegrafData);
            sampleFamily.forEach(s -> this.metricConvert.forEach(m -> m.toMeter(s)));
        }
        catch (Exception e) {
            this.errorCounter.inc();
            log.error(e.getMessage(), (Throwable)e);
        }
        return Commands.newBuilder().build();
    }
}

