/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.query.HierarchyQueryService;
import org.apache.skywalking.oap.server.core.query.type.InstanceHierarchy;
import org.apache.skywalking.oap.server.core.query.type.LayerLevel;
import org.apache.skywalking.oap.server.core.query.type.ServiceHierarchy;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class HierarchyQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private HierarchyQueryService hierarchyQueryService;

    public HierarchyQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private HierarchyQueryService getHierarchyQueryService() {
        if (this.hierarchyQueryService == null) {
            this.hierarchyQueryService = (HierarchyQueryService)this.moduleManager.find("core").provider().getService(HierarchyQueryService.class);
        }
        return this.hierarchyQueryService;
    }

    public CompletableFuture<ServiceHierarchy> getServiceHierarchy(String serviceId, String layer) {
        return AsyncQueryUtils.queryAsync(() -> this.getHierarchyQueryService().getServiceHierarchy(serviceId, layer));
    }

    public CompletableFuture<InstanceHierarchy> getInstanceHierarchy(String instanceId, String layer) {
        return AsyncQueryUtils.queryAsync(() -> this.getHierarchyQueryService().getInstanceHierarchy(instanceId, layer));
    }

    public CompletableFuture<List<LayerLevel>> listLayerLevels() {
        return AsyncQueryUtils.queryAsync(() -> this.getHierarchyQueryService().listLayerLevels());
    }
}

