/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.library.client.elasticsearch;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchParams;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;

public class ElasticSearchScroller<T> {
    public static final Duration SCROLL_CONTEXT_RETENTION = Duration.ofSeconds(30L);
    final ElasticSearchClient client;
    final Search search;
    final String index;
    final int queryMaxSize;
    final SearchParams params;
    final Function<SearchHit, T> resultConverter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> scroll() {
        ArrayList<T> results = new ArrayList<T>();
        HashSet<String> scrollIds = new HashSet<String>();
        this.params.scroll(SCROLL_CONTEXT_RETENTION);
        SearchResponse response = this.client.search(this.index, this.search, this.params);
        try {
            while (true) {
                Object object;
                String scrollId = response.getScrollId();
                scrollIds.add(scrollId);
                if (response.getHits().getTotal() != 0) {
                    object = response.getHits().iterator();
                } else {
                    scrollIds.forEach(this.client::deleteScrollContextQuietly);
                    return results;
                }
                while (object.hasNext()) {
                    SearchHit searchHit = (SearchHit)object.next();
                    results.add(this.resultConverter.apply(searchHit));
                    if (this.queryMaxSize <= 0 || results.size() < this.queryMaxSize) continue;
                    ArrayList<T> arrayList = results;
                    return arrayList;
                }
                if (this.search.getSize() != null && response.getHits().getHits().size() < this.search.getSize()) {
                    object = results;
                    return object;
                }
                response = this.client.scroll(SCROLL_CONTEXT_RETENTION, scrollId);
            }
        }
        finally {
            scrollIds.forEach(this.client::deleteScrollContextQuietly);
        }
    }

    @Generated
    private static <T> int $default$queryMaxSize() {
        return 0;
    }

    @Generated
    private static <T> SearchParams $default$params() {
        return new SearchParams();
    }

    @Generated
    public static <T> ElasticSearchScrollerBuilder<T> builder() {
        return new ElasticSearchScrollerBuilder();
    }

    @Generated
    public ElasticSearchScroller(ElasticSearchClient client, Search search, String index, int queryMaxSize, SearchParams params, Function<SearchHit, T> resultConverter) {
        this.client = client;
        this.search = search;
        this.index = index;
        this.queryMaxSize = queryMaxSize;
        this.params = params;
        this.resultConverter = resultConverter;
    }

    @Generated
    public static class ElasticSearchScrollerBuilder<T> {
        @Generated
        private ElasticSearchClient client;
        @Generated
        private Search search;
        @Generated
        private String index;
        @Generated
        private boolean queryMaxSize$set;
        @Generated
        private int queryMaxSize$value;
        @Generated
        private boolean params$set;
        @Generated
        private SearchParams params$value;
        @Generated
        private Function<SearchHit, T> resultConverter;

        @Generated
        ElasticSearchScrollerBuilder() {
        }

        @Generated
        public ElasticSearchScrollerBuilder<T> client(ElasticSearchClient client) {
            this.client = client;
            return this;
        }

        @Generated
        public ElasticSearchScrollerBuilder<T> search(Search search) {
            this.search = search;
            return this;
        }

        @Generated
        public ElasticSearchScrollerBuilder<T> index(String index) {
            this.index = index;
            return this;
        }

        @Generated
        public ElasticSearchScrollerBuilder<T> queryMaxSize(int queryMaxSize) {
            this.queryMaxSize$value = queryMaxSize;
            this.queryMaxSize$set = true;
            return this;
        }

        @Generated
        public ElasticSearchScrollerBuilder<T> params(SearchParams params) {
            this.params$value = params;
            this.params$set = true;
            return this;
        }

        @Generated
        public ElasticSearchScrollerBuilder<T> resultConverter(Function<SearchHit, T> resultConverter) {
            this.resultConverter = resultConverter;
            return this;
        }

        @Generated
        public ElasticSearchScroller<T> build() {
            int queryMaxSize$value = this.queryMaxSize$value;
            if (!this.queryMaxSize$set) {
                queryMaxSize$value = ElasticSearchScroller.$default$queryMaxSize();
            }
            SearchParams params$value = this.params$value;
            if (!this.params$set) {
                params$value = ElasticSearchScroller.$default$params();
            }
            return new ElasticSearchScroller<T>(this.client, this.search, this.index, queryMaxSize$value, params$value, this.resultConverter);
        }

        @Generated
        public String toString() {
            return "ElasticSearchScroller.ElasticSearchScrollerBuilder(client=" + String.valueOf(this.client) + ", search=" + String.valueOf(this.search) + ", index=" + this.index + ", queryMaxSize$value=" + this.queryMaxSize$value + ", params$value=" + String.valueOf(this.params$value) + ", resultConverter=" + String.valueOf(this.resultConverter) + ")";
        }
    }
}

