/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.configmap;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.cache.Lister;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.configuration.configmap.ConfigmapConfigurationSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationConfigmapInformer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationConfigmapInformer.class);
    private final Lister<ConfigMap> configMapLister;

    public ConfigurationConfigmapInformer(ConfigmapConfigurationSettings settings) {
        KubernetesClient client = new KubernetesClientBuilder().build();
        SharedIndexInformer informer = ((FilterWatchListDeletable)((NonNamespaceOperation)client.configMaps().inNamespace(settings.getNamespace())).withLabelSelector(settings.getLabelSelector())).inform();
        this.configMapLister = new Lister(informer.getIndexer());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            informer.stop();
            client.close();
        }));
    }

    public Map<String, String> configMapData() {
        List list;
        HashMap<String, String> configMapData = new HashMap<String, String>();
        if (this.configMapLister != null && (list = this.configMapLister.list()) != null) {
            list.forEach(cf -> {
                Map data = cf.getData();
                if (data == null) {
                    return;
                }
                configMapData.putAll(data);
            });
        }
        return configMapData;
    }
}

