/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.alarm.AlarmRulesWatcherService;
import org.apache.skywalking.oap.server.core.alarm.AlarmStatusWatcherService;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmEntity;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.RunningRule;
import org.apache.skywalking.oap.server.core.alarm.provider.status.AlarmRuleDetail;
import org.apache.skywalking.oap.server.core.alarm.provider.status.AlarmRuleList;
import org.apache.skywalking.oap.server.core.alarm.provider.status.AlarmRunningContext;
import org.apache.skywalking.oap.server.core.analysis.metrics.DoubleValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.IntValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LabeledValueHolder;
import org.apache.skywalking.oap.server.core.analysis.metrics.LongValueHolder;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class AlarmStatusWatcher
implements AlarmStatusWatcherService {
    private static final Gson GSON = new Gson();
    private AlarmRulesWatcherService rulesWatcherService;
    private final ModuleManager moduleManager;
    private AlarmRulesWatcher alarmRulesWatcher;

    public AlarmStatusWatcher(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private AlarmRulesWatcher getAlarmRulesWatcher() {
        if (this.alarmRulesWatcher == null) {
            this.alarmRulesWatcher = (AlarmRulesWatcher)this.moduleManager.find("alarm").provider().getService(AlarmRulesWatcherService.class);
        }
        return this.alarmRulesWatcher;
    }

    public String getAlarmRules() {
        Map<String, RunningRule> runningRules = this.getAlarmRulesWatcher().getRunningContext().values().stream().map(Collection::stream).flatMap(r -> r).collect(Collectors.toMap(RunningRule::getRuleName, r -> r));
        AlarmRuleList alarmRuleList = new AlarmRuleList();
        runningRules.keySet().forEach(ruleName -> {
            AlarmRuleList.RuleInfo alarmRule = new AlarmRuleList.RuleInfo();
            alarmRule.setId((String)ruleName);
            alarmRuleList.getRuleList().add(alarmRule);
        });
        return GSON.toJson((Object)alarmRuleList);
    }

    public String getAlarmRuleById(String ruleId) {
        AlarmRuleDetail ruleDetail = new AlarmRuleDetail();
        Map<String, RunningRule> runningRules = this.getAlarmRulesWatcher().getRunningContext().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(RunningRule::getRuleName, r -> r));
        RunningRule rule = runningRules.get(ruleId);
        if (rule == null) {
            return "";
        }
        ruleDetail.setRuleId(rule.getRuleName());
        ruleDetail.setExpression(rule.getExpression());
        ruleDetail.setPeriod(rule.getPeriod());
        ruleDetail.setSilencePeriod(rule.getSilencePeriod());
        ruleDetail.setAdditionalPeriod(rule.getAdditionalPeriod());
        ruleDetail.setIncludeEntityNames(rule.getIncludeNames());
        ruleDetail.setExcludeEntityNames(rule.getExcludeNames());
        ruleDetail.setIncludeEntityNamesRegex(rule.getIncludeNamesRegex() == null ? "" : rule.getIncludeNamesRegex().toString());
        ruleDetail.setExcludeEntityNamesRegex(rule.getExcludeNamesRegex() == null ? "" : rule.getExcludeNamesRegex().toString());
        ruleDetail.setTags(rule.getTags());
        ruleDetail.setHooks(rule.getHooks());
        ruleDetail.setIncludeMetrics(rule.getIncludeMetrics());
        Map<AlarmEntity, RunningRule.Window> windows = rule.getWindows();
        windows.keySet().forEach(e -> {
            AlarmRuleDetail.RunningEntity entity = new AlarmRuleDetail.RunningEntity();
            entity.setScope(e.getScope());
            entity.setName(e.getName());
            entity.setFormattedMessage(rule.getFormatter().format((AlarmEntity)e));
            ruleDetail.getRunningEntities().add(entity);
        });
        return GSON.toJson((Object)ruleDetail);
    }

    public String getAlarmRuleContext(String ruleName, String entityName) {
        Map<String, RunningRule> runningRules = this.getAlarmRulesWatcher().getRunningContext().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(RunningRule::getRuleName, r -> r));
        RunningRule rule = runningRules.get(ruleName);
        if (rule == null) {
            return "";
        }
        AlarmRunningContext runningContext = new AlarmRunningContext();
        runningContext.setRuleId(rule.getRuleName());
        runningContext.setExpression(rule.getExpression());
        Map<AlarmEntity, RunningRule.Window> windows = rule.getWindows();
        RunningRule.Window window = windows.keySet().stream().filter(e -> e.getName().equals(entityName)).map(windows::get).findFirst().orElse(null);
        if (window == null) {
            return GSON.toJson((Object)runningContext);
        }
        runningContext.setEntityName(entityName);
        runningContext.setEndTime(window.getEndTime().toString());
        runningContext.setAdditionalPeriod(window.getAdditionalPeriod());
        runningContext.setSize(window.getSize());
        runningContext.setSilenceCountdown(window.getSilenceCountdown());
        window.scanWindowValues(values -> {
            for (int i = 0; i < values.size(); ++i) {
                AlarmRunningContext.WindowValue windowValue = new AlarmRunningContext.WindowValue();
                runningContext.getWindowValues().add(windowValue);
                windowValue.setIndex(i);
                Map m = (Map)values.get(i);
                if (null == m) continue;
                m.forEach((name, metric) -> {
                    AlarmRunningContext.Metric metricValue = new AlarmRunningContext.Metric();
                    metricValue.setTimeBucket(metric.getTimeBucket());
                    metricValue.setName((String)name);
                    String value = "";
                    if (metric instanceof LongValueHolder) {
                        value = Long.toString(((LongValueHolder)metric).getValue());
                    } else if (metric instanceof IntValueHolder) {
                        value = Integer.toString(((IntValueHolder)metric).getValue());
                    } else if (metric instanceof DoubleValueHolder) {
                        value = Double.toString(((DoubleValueHolder)metric).getValue());
                    } else if (metric instanceof LabeledValueHolder) {
                        value = ((LabeledValueHolder)metric).getValue().toString();
                    }
                    metricValue.setValue(value);
                    windowValue.getMetrics().add(metricValue);
                });
            }
        });
        runningContext.setMqeMetricsSnapshot(window.getMqeMetricsSnapshot());
        return GSON.toJson((Object)runningContext);
    }
}

