/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResultType;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValue;
import org.apache.skywalking.oap.server.core.query.mqe.MQEValues;

public class AggregationOp {
    public static ExpressionResult doAggregationOp(ExpressionResult result, int opType) throws IllegalExpressionException {
        switch (opType) {
            case 25: {
                return AggregationOp.aggregateResult(result, mqeValues -> mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue()).flatMapToDouble(mqeValue -> DoubleStream.of(mqeValue.getDoubleValue())).average());
            }
            case 26: {
                return AggregationOp.aggregateResult(result, mqeValues -> OptionalDouble.of(mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue()).count()));
            }
            case 27: {
                if (result.getType() != ExpressionResultType.TIME_SERIES_VALUES) {
                    throw new IllegalExpressionException("LATEST can only be used in time series result.");
                }
                return AggregationOp.selectResult(result, mqeValues -> Streams.findLast(mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue())));
            }
            case 28: {
                return AggregationOp.selectResult(result, mqeValues -> mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue()).max(Comparator.comparingDouble(MQEValue::getDoubleValue)));
            }
            case 29: {
                return AggregationOp.selectResult(result, mqeValues -> mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue()).min(Comparator.comparingDouble(MQEValue::getDoubleValue)));
            }
            case 30: {
                return AggregationOp.aggregateResult(result, mqeValues -> OptionalDouble.of(mqeValues.getValues().stream().filter(mqeValue -> !mqeValue.isEmptyValue()).flatMapToDouble(mqeValue -> DoubleStream.of(mqeValue.getDoubleValue())).sum()));
            }
        }
        throw new IllegalExpressionException("Unsupported aggregation operation.");
    }

    private static ExpressionResult aggregateResult(ExpressionResult result, Function<MQEValues, OptionalDouble> aggregator) {
        for (MQEValues resultValues : result.getResults()) {
            OptionalDouble resultValue = aggregator.apply(resultValues);
            ArrayList<MQEValue> mqeValueList = new ArrayList<MQEValue>(1);
            MQEValue mqeValue = new MQEValue();
            if (resultValue.isPresent()) {
                mqeValue.setEmptyValue(false);
                mqeValue.setDoubleValue(resultValue.getAsDouble());
            } else {
                mqeValue.setEmptyValue(true);
            }
            mqeValueList.add(mqeValue);
            resultValues.setValues(mqeValueList);
        }
        result.setType(ExpressionResultType.SINGLE_VALUE);
        return result;
    }

    private static ExpressionResult selectResult(ExpressionResult result, Function<MQEValues, Optional<MQEValue>> aggregator) {
        for (MQEValues resultValues : result.getResults()) {
            Optional<MQEValue> resultValue = aggregator.apply(resultValues);
            ArrayList<MQEValue> mqeValueList = new ArrayList<MQEValue>(1);
            if (resultValue.isPresent()) {
                mqeValueList.add(resultValue.get());
            } else {
                MQEValue mqeValue = new MQEValue();
                mqeValue.setEmptyValue(true);
                mqeValueList.add(mqeValue);
            }
            resultValues.setValues(mqeValueList);
        }
        result.setType(ExpressionResultType.SINGLE_VALUE);
        return result;
    }
}

