/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.mqe.rt.operation;

import org.apache.skywalking.mqe.rt.exception.IllegalExpressionException;
import org.apache.skywalking.mqe.rt.operation.LROp;
import org.apache.skywalking.oap.server.core.query.mqe.ExpressionResult;

public class BoolOp {
    public static ExpressionResult doBoolOp(ExpressionResult left, ExpressionResult right, int opType) throws IllegalExpressionException {
        if (!BoolOp.checkExpression(left)) {
            throw new IllegalExpressionException("Bool Operation: The result of the left expression is not a compare result.");
        }
        if (!BoolOp.checkExpression(right)) {
            throw new IllegalExpressionException("Bool Operation: The result of the right expression is not a compare result.");
        }
        try {
            return LROp.doLROp(left, right, opType, BoolOp::boolOp);
        }
        catch (IllegalExpressionException e) {
            throw new IllegalExpressionException("Unsupported bool operation: " + e.getMessage());
        }
    }

    private static double boolOp(double leftValue, double rightValue, int opType) throws IllegalExpressionException {
        if (!BoolOp.checkBool(leftValue)) {
            throw new IllegalExpressionException("Bool Operation: The result of the left expression is not 1 or 0.");
        }
        if (!BoolOp.checkBool(rightValue)) {
            throw new IllegalExpressionException("Bool Operation: The result of the right expression is not 1 or 0.");
        }
        switch (opType) {
            case 23: {
                if (leftValue == 1.0 && rightValue == 1.0) {
                    return 1.0;
                }
                return 0.0;
            }
            case 24: {
                if (leftValue == 1.0 || rightValue == 1.0) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        throw new IllegalExpressionException("Unsupported bool operation.");
    }

    private static boolean checkExpression(ExpressionResult result) {
        return result.isBoolResult();
    }

    private static boolean checkBool(double v) {
        int i = (int)v;
        return i == 0 || i == 1;
    }
}

