/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.FilterValidator;
import org.apache.jackrabbit.vault.validation.spi.MetaInfPathValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.NodePathValidator;
import org.apache.jackrabbit.vault.validation.spi.PropertiesValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageTypeValidator
implements NodePathValidator,
DocumentViewXmlValidator,
FilterValidator,
PropertiesValidator,
MetaInfPathValidator {
    private static final String NODETYPE_SLING_OSGI_CONFIG = "sling:OsgiConfig";
    protected static final String MESSAGE_FILTER_HAS_INCLUDE_EXCLUDES = "Package of type '%s' is not supposed to contain includes/excludes below any of its filters!";
    protected static final String MESSAGE_UNSUPPORTED_SUB_PACKAGE_OF_TYPE = "Package of type '%s' must only contain sub packages of type '%s' but found subpackage of type '%s'!";
    protected static final String MESSAGE_UNSUPPORTED_SUB_PACKAGE = "Package of type '%s' is not supposed to contain any subpackages!";
    protected static final String MESSAGE_DEPENDENCY = "Package of type '%s' must not have package dependencies but found dependencies '%s'!";
    protected static final String MESSAGE_LEGACY_TYPE = "Package of type '%s' is legacy. Use one of the other types instead!";
    protected static final String MESSAGE_PACKAGE_HOOKS = "Package of type '%s' must not contain package hooks but has '%s'!";
    protected static final String MESSAGE_NO_PACKAGE_TYPE_SET = "No package type set, make sure that property 'packageType' is set in the properties.xml!";
    protected static final String MESSAGE_NO_OSGI_BUNDLE_OR_CONFIG_ALLOWED = "Package of type '%s' is not supposed to contain OSGi bundles or configurations!";
    protected static final String MESSAGE_ONLY_OSGI_BUNDLE_OR_CONFIG_OR_SUBPACKAGE_ALLOWED = "Package of type '%s' is not supposed to contain anything but OSGi bundles/configurations and subpackages!";
    protected static final String MESSAGE_APP_CONTENT = "Package of type '%s' is not supposed to contain content below root nodes %s!";
    protected static final String MESSAGE_NO_APP_CONTENT_FOUND = "Package of type '%s' is not supposed to contain content outside root nodes %s!";
    protected static final String MESSAGE_PROHIBITED_MUTABLE_PACKAGE_TYPE = "All mutable package types are prohibited and this package is of mutable type '%s'";
    protected static final String MESSAGE_PROHIBITED_IMMUTABLE_PACKAGE_TYPE = "All immutable package types are prohibited and this package is of immutable type '%s'";
    protected static final String SLING_OSGI_CONFIG = "sling:OsgiConfig";
    protected static final Path PATH_HOOKS = Paths.get("vault", "hooks");
    @NotNull
    private final PackageType type;
    @NotNull
    private final ValidationMessageSeverity severity;
    @NotNull
    private final ValidationMessageSeverity severityForLegacyType;
    @NotNull
    private final Pattern jcrInstallerNodePathRegex;
    @NotNull
    private final Pattern jcrInstallerAdditionalFileNodePathRegex;
    @Nullable
    private final ValidationContext containerValidationContext;
    private final ValidationMessageSeverity severityForNoPackageType;
    private final boolean prohibitMutableContent;
    private final boolean prohibitImmutableContent;
    private final boolean allowComplexFilterRulesInApplicationPackages;
    private final boolean allowInstallHooksInApplicationPackages;
    @NotNull
    private final WorkspaceFilter filter;
    private final Set<String> immutableRootNodeNames;
    private List<String> validContainerNodePaths;
    private List<NodeContext> potentiallyDisallowedContainerNodes;

    public PackageTypeValidator(@NotNull WorkspaceFilter workspaceFilter, @NotNull ValidationMessageSeverity severity, @NotNull ValidationMessageSeverity severityForNoPackageType, @NotNull ValidationMessageSeverity severityForLegacyType, boolean prohibitMutableContent, boolean prohibitImmutableContent, boolean allowComplexFilterRulesInApplicationPackages, boolean allowInstallHooksInApplicationPackages, @NotNull PackageType type, @NotNull Pattern jcrInstallerNodePathRegex, Pattern jcrInstallerAdditionalFileNodePathRegex, @NotNull Set<String> immutableRootNodeNames, @Nullable ValidationContext containerValidationContext) {
        this.type = type;
        this.severity = severity;
        this.severityForNoPackageType = severityForNoPackageType;
        this.severityForLegacyType = severityForLegacyType;
        this.prohibitMutableContent = prohibitMutableContent;
        this.prohibitImmutableContent = prohibitImmutableContent;
        this.allowComplexFilterRulesInApplicationPackages = allowComplexFilterRulesInApplicationPackages;
        this.allowInstallHooksInApplicationPackages = allowInstallHooksInApplicationPackages;
        this.jcrInstallerNodePathRegex = jcrInstallerNodePathRegex;
        this.jcrInstallerAdditionalFileNodePathRegex = jcrInstallerAdditionalFileNodePathRegex;
        this.immutableRootNodeNames = immutableRootNodeNames;
        this.containerValidationContext = containerValidationContext;
        this.filter = workspaceFilter;
        this.validContainerNodePaths = new LinkedList<String>();
        this.potentiallyDisallowedContainerNodes = new LinkedList<NodeContext>();
    }

    private boolean isOsgiBundleOrConfigurationNode(String nodePath, boolean isFileNode) {
        if (!this.jcrInstallerNodePathRegex.matcher(nodePath).matches()) {
            return false;
        }
        if (isFileNode) {
            return this.jcrInstallerAdditionalFileNodePathRegex.matcher(nodePath).matches();
        }
        return true;
    }

    static boolean isSubPackage(String nodePath) {
        return nodePath.endsWith(".zip");
    }

    boolean isImmutableContent(String nodePath) {
        return this.immutableRootNodeNames.stream().anyMatch(rootNodeName -> ("/" + rootNodeName).equals(nodePath) || nodePath.startsWith("/" + rootNodeName + "/"));
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        List invalidNodes = this.potentiallyDisallowedContainerNodes.stream().filter(s -> this.validContainerNodePaths.stream().noneMatch(p -> p.startsWith(s.getNodePath() + "/") || p.equals(s.getNodePath()))).collect(Collectors.toList());
        if (!invalidNodes.isEmpty()) {
            return invalidNodes.stream().map(e -> new ValidationMessage(this.severity, String.format(MESSAGE_ONLY_OSGI_BUNDLE_OR_CONFIG_OR_SUBPACKAGE_ALLOWED, this.type), e.getNodePath(), e.getFilePath(), e.getBasePath(), null)).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull NodeContext nodeContext) {
        if (!this.filter.covers(nodeContext.getNodePath())) {
            return null;
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        switch (this.type) {
            case CONTENT: {
                if (this.isImmutableContent(nodeContext.getNodePath())) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_APP_CONTENT, this.type, this.immutableRootNodeNames.stream().collect(Collectors.joining("' or '", "'", "'")))));
                }
                if (!this.isOsgiBundleOrConfigurationNode(nodeContext.getNodePath(), true)) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_NO_OSGI_BUNDLE_OR_CONFIG_ALLOWED, this.type)));
                break;
            }
            case APPLICATION: {
                if (!this.isImmutableContent(nodeContext.getNodePath())) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_NO_APP_CONTENT_FOUND, this.type, this.immutableRootNodeNames.stream().collect(Collectors.joining("' or '", "'", "'")))));
                }
                if (!this.isOsgiBundleOrConfigurationNode(nodeContext.getNodePath(), true)) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_NO_OSGI_BUNDLE_OR_CONFIG_ALLOWED, this.type)));
                break;
            }
            case CONTAINER: {
                if (this.isOsgiBundleOrConfigurationNode(nodeContext.getNodePath(), true)) {
                    this.validContainerNodePaths.add(nodeContext.getNodePath());
                    break;
                }
                if (PackageTypeValidator.isSubPackage(nodeContext.getNodePath())) {
                    this.validContainerNodePaths.add(nodeContext.getNodePath());
                    break;
                }
                this.potentiallyDisallowedContainerNodes.add(nodeContext);
                break;
            }
        }
        return messages;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull WorkspaceFilter filter) {
        switch (this.type) {
            case APPLICATION: {
                if (this.allowComplexFilterRulesInApplicationPackages || !PackageTypeValidator.hasIncludesOrExcludes(filter)) break;
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_FILTER_HAS_INCLUDE_EXCLUDES, this.type)));
            }
        }
        return null;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull PackageProperties properties) {
        PackageType packageType = properties.getPackageType();
        if (packageType == null) {
            return Collections.singleton(new ValidationMessage(this.severityForNoPackageType, MESSAGE_NO_PACKAGE_TYPE_SET));
        }
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        if (this.containerValidationContext != null) {
            messages.add(new ValidationMessage(ValidationMessageSeverity.DEBUG, "Found sub package"));
            ValidationMessage message = this.validateSubPackageType(properties.getPackageType(), this.containerValidationContext.getProperties().getPackageType());
            if (message != null) {
                messages.add(message);
            }
        }
        switch (packageType) {
            case APPLICATION: {
                if (!properties.getExternalHooks().isEmpty() && !this.allowInstallHooksInApplicationPackages) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_PACKAGE_HOOKS, properties.getPackageType(), properties.getExternalHooks())));
                }
                if (!this.prohibitImmutableContent) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_PROHIBITED_IMMUTABLE_PACKAGE_TYPE, properties.getPackageType())));
                break;
            }
            case CONTENT: {
                if (!this.prohibitMutableContent) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_PROHIBITED_MUTABLE_PACKAGE_TYPE, properties.getPackageType())));
                break;
            }
            case CONTAINER: {
                if (properties.getDependencies() != null && properties.getDependencies().length > 0) {
                    messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_DEPENDENCY, properties.getPackageType(), StringUtils.join((Object[])properties.getDependencies()))));
                }
                if (!this.prohibitImmutableContent) break;
                messages.add(new ValidationMessage(ValidationMessageSeverity.ERROR, String.format(MESSAGE_PROHIBITED_IMMUTABLE_PACKAGE_TYPE, properties.getPackageType())));
                break;
            }
            case MIXED: {
                messages.add(new ValidationMessage(this.severityForLegacyType, String.format(MESSAGE_LEGACY_TYPE, properties.getPackageType())));
                if (this.prohibitImmutableContent) {
                    messages.add(new ValidationMessage(ValidationMessageSeverity.ERROR, String.format(MESSAGE_PROHIBITED_IMMUTABLE_PACKAGE_TYPE, properties.getPackageType())));
                }
                if (!this.prohibitMutableContent) break;
                messages.add(new ValidationMessage(ValidationMessageSeverity.ERROR, String.format(MESSAGE_PROHIBITED_MUTABLE_PACKAGE_TYPE, properties.getPackageType())));
            }
        }
        return messages;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode2 node, @NotNull NodeContext nodeContext, boolean isRoot) {
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        switch (this.type) {
            case CONTENT: 
            case APPLICATION: {
                if (!node.getPrimaryType().isPresent() || !"sling:OsgiConfig".equals(node.getPrimaryType().orElse("")) || !this.isOsgiBundleOrConfigurationNode(nodeContext.getNodePath(), false)) break;
                messages.add(new ValidationMessage(this.severity, String.format(MESSAGE_NO_OSGI_BUNDLE_OR_CONFIG_ALLOWED, this.type)));
                break;
            }
            case CONTAINER: {
                if (!node.getPrimaryType().isPresent() || !"sling:OsgiConfig".equals(node.getPrimaryType().orElse("")) || !this.isOsgiBundleOrConfigurationNode(nodeContext.getNodePath(), false)) break;
                this.validContainerNodePaths.add(nodeContext.getNodePath());
                break;
            }
        }
        return messages;
    }

    static boolean hasIncludesOrExcludes(WorkspaceFilter filter) {
        for (PathFilterSet set : filter.getFilterSets()) {
            if (set.getEntries().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private ValidationMessage validateSubPackageType(PackageType packageType, @Nullable PackageType containerPackageType) {
        ValidationMessage message = null;
        if (containerPackageType == null) {
            return null;
        }
        switch (containerPackageType) {
            case APPLICATION: {
                message = new ValidationMessage(this.severity, String.format(MESSAGE_UNSUPPORTED_SUB_PACKAGE, containerPackageType));
                break;
            }
            case CONTENT: {
                if (packageType == PackageType.CONTENT) break;
                message = new ValidationMessage(this.severity, String.format(MESSAGE_UNSUPPORTED_SUB_PACKAGE_OF_TYPE, containerPackageType, PackageType.CONTENT.toString(), packageType));
                break;
            }
            case CONTAINER: {
                if (packageType == PackageType.APPLICATION || packageType == PackageType.CONTAINER || packageType == PackageType.CONTENT) break;
                message = new ValidationMessage(this.severity, String.format(MESSAGE_UNSUPPORTED_SUB_PACKAGE_OF_TYPE, containerPackageType, StringUtils.join((Object[])new String[]{PackageType.APPLICATION.toString(), PackageType.CONTENT.toString(), PackageType.CONTAINER.toString()}, (String)", "), packageType));
                break;
            }
        }
        return message;
    }

    @Override
    public Collection<ValidationMessage> validateMetaInfPath(@NotNull Path filePath, @NotNull Path basePath, boolean isFolder) {
        switch (this.type) {
            case APPLICATION: {
                if (!filePath.startsWith(PATH_HOOKS) || this.allowInstallHooksInApplicationPackages) break;
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_PACKAGE_HOOKS, this.type, filePath)));
            }
        }
        return null;
    }
}

