/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.executor.OutputMetrics;
import scala.Function0;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.util.DynamicVariable;
import scala.util.Random;

public final class SparkHadoopWriterUtils$ {
    public static SparkHadoopWriterUtils$ MODULE$;
    private final int RECORDS_BETWEEN_BYTES_WRITTEN_METRIC_UPDATES;
    private final Random RAND;
    private final DynamicVariable<Object> disableOutputSpecValidation;

    static {
        new SparkHadoopWriterUtils$();
    }

    private int RECORDS_BETWEEN_BYTES_WRITTEN_METRIC_UPDATES() {
        return this.RECORDS_BETWEEN_BYTES_WRITTEN_METRIC_UPDATES;
    }

    private Random RAND() {
        return this.RAND;
    }

    public JobID createJobID(Date time, int id) {
        String jobTrackerID = this.createJobTrackerID(time);
        return this.createJobID(jobTrackerID, id);
    }

    public JobID createJobID(String jobTrackerID, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("Job number is negative");
        }
        return new JobID(jobTrackerID, id);
    }

    public String createJobTrackerID(Date time) {
        String base = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(time);
        long l1 = this.RAND().nextLong();
        if (l1 < 0L) {
            l1 = -l1;
        }
        return new StringBuilder(0).append(base).append(l1).toString();
    }

    public Path createPathFromString(String path, JobConf conf) {
        if (path == null) {
            throw new IllegalArgumentException("Output path is null");
        }
        Path outputPath = new Path(path);
        FileSystem fs = outputPath.getFileSystem((Configuration)conf);
        if (fs == null) {
            throw new IllegalArgumentException("Incorrectly formatted output path");
        }
        return outputPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    public boolean isOutputSpecValidationEnabled(SparkConf conf) {
        boolean validationDisabled = BoxesRunTime.unboxToBoolean((Object)this.disableOutputSpecValidation().value());
        boolean enabledInConf = conf.getBoolean("spark.hadoop.validateOutputSpecs", true);
        return enabledInConf && !validationDisabled;
    }

    public Tuple2<OutputMetrics, Function0<Object>> initHadoopOutputMetrics(TaskContext context) {
        Function0<Object> bytesWrittenCallback = SparkHadoopUtil$.MODULE$.get().getFSBytesWrittenOnThreadCallback();
        return new Tuple2((Object)context.taskMetrics().outputMetrics(), bytesWrittenCallback);
    }

    public void maybeUpdateOutputMetrics(OutputMetrics outputMetrics, Function0<Object> callback, long recordsWritten) {
        if (recordsWritten % (long)this.RECORDS_BETWEEN_BYTES_WRITTEN_METRIC_UPDATES() == 0L) {
            outputMetrics.setBytesWritten(callback.apply$mcJ$sp());
            outputMetrics.setRecordsWritten(recordsWritten);
            return;
        }
    }

    public DynamicVariable<Object> disableOutputSpecValidation() {
        return this.disableOutputSpecValidation;
    }

    private SparkHadoopWriterUtils$() {
        MODULE$ = this;
        this.RECORDS_BETWEEN_BYTES_WRITTEN_METRIC_UPDATES = 256;
        this.RAND = new Random();
        this.disableOutputSpecValidation = new DynamicVariable((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }
}

