/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.csv.CSVDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.json.JsonDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetDataSourceV2;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005h\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0017\"A\u0001\u000b\u0001BK\u0002\u0013\u0005\u0011\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003S\u0011\u0015a\u0006\u0001\"\u0001^\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015i\u0007\u0001\"\u0003o\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fA\u0011\"!\n\u0001\u0003\u0003%\t!a\n\t\u0013\u00055\u0002!%A\u0005\u0002\u0005=\u0002\"CA#\u0001E\u0005I\u0011AA$\u0011%\tY\u0005AA\u0001\n\u0003\ni\u0005C\u0005\u0002^\u0001\t\t\u0011\"\u0001\u0002`!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003k\u0002\u0011\u0011!C!\u0003oB\u0011\"!\"\u0001\u0003\u0003%\t!a\"\t\u0013\u0005E\u0005!!A\u0005B\u0005M\u0005\"CAL\u0001\u0005\u0005I\u0011IAM\u000f%\tijGA\u0001\u0012\u0003\tyJ\u0002\u0005\u001b7\u0005\u0005\t\u0012AAQ\u0011\u0019aF\u0003\"\u0001\u0002:\"I\u00111\u0018\u000b\u0002\u0002\u0013\u0015\u0013Q\u0018\u0005\n\u0003\u007f#\u0012\u0011!CA\u0003\u0003D\u0011\"a2\u0015\u0003\u0003%\t)!3\t\u0013\u0005]G#!A\u0005\n\u0005e'aG!mi\u0016\u0014H+\u00192mK\u0006#GmQ8mk6t7oQ8n[\u0006tGM\u0003\u0002\u001d;\u000591m\\7nC:$'B\u0001\u0010 \u0003%)\u00070Z2vi&|gN\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001SM:T\b\u0005\u0002+c5\t1F\u0003\u0002-[\u00059An\\4jG\u0006d'B\u0001\u00180\u0003\u0015\u0001H.\u00198t\u0015\t\u0001t$\u0001\u0005dCR\fG._:u\u0013\t\u00114FA\u0006M_\u001eL7-\u00197QY\u0006t\u0007C\u0001\u001b6\u001b\u0005Y\u0012B\u0001\u001c\u001c\u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"(\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(A\u0003uC\ndW-F\u0001L!\taU*D\u00010\u0013\tquFA\bUC\ndW-\u00133f]RLg-[3s\u0003\u0019!\u0018M\u00197fA\u0005I1m\u001c7t)>\fE\rZ\u000b\u0002%B\u0019ahU+\n\u0005QC%aA*fcB\u0011a+W\u0007\u0002/*\u0011\u0001lH\u0001\u0006if\u0004Xm]\u0005\u00035^\u00131b\u0015;sk\u000e$h)[3mI\u0006Q1m\u001c7t)>\fE\r\u001a\u0011\u0002\rqJg.\u001b;?)\rqv\f\u0019\t\u0003i\u0001AQ!S\u0003A\u0002-CQ\u0001U\u0003A\u0002I\u000b1A];o)\t\u0019\u0007\u000eE\u0002?'\u0012\u0004\"!\u001a4\u000e\u0003}I!aZ\u0010\u0003\u0007I{w\u000fC\u0003j\r\u0001\u0007!.\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002fW&\u0011An\b\u0002\r'B\f'o[*fgNLwN\\\u0001\u001am\u0016\u0014\u0018NZ=BYR,'\u000fV1cY\u0016\fE\rZ\"pYVlg\u000eF\u0003pkv\f\u0019\u0001\u0005\u0002qg6\t\u0011O\u0003\u0002s_\u000591-\u0019;bY><\u0017B\u0001;r\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011\u00151x\u00011\u0001x\u0003\u0011\u0019wN\u001c4\u0011\u0005a\\X\"A=\u000b\u0005i|\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005qL(aB*R\u0019\u000e{gN\u001a\u0005\u0006e\u001e\u0001\rA \t\u0003a~L1!!\u0001r\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQ!S\u0004A\u0002-\u000b!fY8ogR\fg\u000e\u001e$pY\u0012\u001cUO\u001d:f]R$UMZ1vYR\u001cHk\\#ySN$H)\u001a4bk2$8\u000fF\u0003S\u0003\u0013\tY\u0001C\u0003j\u0011\u0001\u0007!\u000eC\u0004\u0002\u000e!\u0001\r!a\u0004\u0002\u001bQ\f'\r\\3Qe>4\u0018\u000eZ3s!\u0015A\u0014\u0011CA\u000b\u0013\r\t\u0019\"\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005]\u0011q\u0004\b\u0005\u00033\tY\u0002\u0005\u0002As%\u0019\u0011QD\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\"O\u0001\u0005G>\u0004\u0018\u0010F\u0003_\u0003S\tY\u0003C\u0004J\u0013A\u0005\t\u0019A&\t\u000fAK\u0001\u0013!a\u0001%\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0019U\rY\u00151G\u0016\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0005v]\u000eDWmY6fI*\u0019\u0011qH\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA%U\r\u0011\u00161G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\u0011\t\t#a\u0015\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u0005\u0004c\u0001\u001d\u0002d%\u0019\u0011QM\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005-\u0014\u0011\u000f\t\u0004q\u00055\u0014bAA8s\t\u0019\u0011I\\=\t\u0013\u0005Md\"!AA\u0002\u0005\u0005\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002zA1\u00111PAA\u0003Wj!!! \u000b\u0007\u0005}\u0014(\u0001\u0006d_2dWm\u0019;j_:LA!a!\u0002~\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI)a$\u0011\u0007a\nY)C\u0002\u0002\u000ef\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002tA\t\t\u00111\u0001\u0002l\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\ty%!&\t\u0013\u0005M\u0014#!AA\u0002\u0005\u0005\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\n\u0006m\u0005\"CA:%\u0005\u0005\t\u0019AA6\u0003m\tE\u000e^3s)\u0006\u0014G.Z!eI\u000e{G.^7og\u000e{W.\\1oIB\u0011A\u0007F\n\u0006)\u0005\r\u0016q\u0016\t\b\u0003K\u000bYk\u0013*_\u001b\t\t9KC\u0002\u0002*f\nqA];oi&lW-\u0003\u0003\u0002.\u0006\u001d&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011WA\\\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0013AA5p\u0013\r9\u00151\u0017\u000b\u0003\u0003?\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\nQ!\u00199qYf$RAXAb\u0003\u000bDQ!S\fA\u0002-CQ\u0001U\fA\u0002I\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002L\u0006M\u0007#\u0002\u001d\u0002\u0012\u00055\u0007#\u0002\u001d\u0002P.\u0013\u0016bAAis\t1A+\u001e9mKJB\u0001\"!6\u0019\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAn!\u0011\t\t&!8\n\t\u0005}\u00171\u000b\u0002\u0007\u001f\nTWm\u0019;")
public class AlterTableAddColumnsCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final Seq<StructField> colsToAdd;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterTableAddColumnsCommand x$0) {
        return AlterTableAddColumnsCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<StructField>>, AlterTableAddColumnsCommand> tupled() {
        return AlterTableAddColumnsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<StructField>, AlterTableAddColumnsCommand>> curried() {
        return AlterTableAddColumnsCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = this;
        synchronized (alterTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable catalogTable = this.verifyAlterTableAddColumn(sparkSession.sessionState().conf(), catalog, this.table());
        Seq<StructField> colsWithProcessedDefaults = this.constantFoldCurrentDefaultsToExistDefaults(sparkSession, (Option<String>)catalogTable.provider());
        CommandUtils$.MODULE$.uncacheTableOrView(sparkSession, this.table().quotedString());
        catalog.refreshTable(this.table());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)((IterableOps)colsWithProcessedDefaults.$plus$plus((IterableOnce)catalogTable.schema())).map((Function1 & Serializable)x$2 -> x$2.name()), this.conf().caseSensitiveAnalysis());
        DDLUtils$.MODULE$.checkTableColumns(catalogTable, StructType$.MODULE$.apply(colsWithProcessedDefaults));
        StructType existingSchema = CharVarcharUtils$.MODULE$.getRawSchema(catalogTable.dataSchema());
        catalog.alterTableDataSchema(this.table(), StructType$.MODULE$.apply((Seq)existingSchema.$plus$plus(colsWithProcessedDefaults)));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private CatalogTable verifyAlterTableAddColumn(SQLConf conf, SessionCatalog catalog, TableIdentifier table) {
        CatalogTable catalogTable = catalog.getTempViewOrPermanentTableMetadata(table);
        CatalogTableType catalogTableType = catalogTable.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportViewError(table);
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(catalogTable)) {
            Object obj = DataSource$.MODULE$.lookupDataSource((String)catalogTable.provider().get(), conf).getConstructor(new Class[0]).newInstance(new Object[0]);
            boolean bl = obj instanceof CSVFileFormat ? true : (obj instanceof JsonFileFormat ? true : obj instanceof ParquetFileFormat);
            if (bl) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = obj instanceof JsonDataSourceV2 ? true : (obj instanceof CSVDataSourceV2 ? true : (obj instanceof OrcDataSourceV2 ? true : obj instanceof ParquetDataSourceV2));
                if (bl2) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (obj.getClass().getCanonicalName().endsWith("OrcFileFormat")) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw QueryCompilationErrors$.MODULE$.alterAddColNotSupportDatasourceTableError(obj, table);
                }
            }
        }
        return catalogTable;
    }

    private Seq<StructField> constantFoldCurrentDefaultsToExistDefaults(SparkSession sparkSession, Option<String> tableProvider) {
        return (Seq)this.colsToAdd().map((Function1 & Serializable)col -> {
            StructField structField;
            if (col.metadata().contains(ResolveDefaultColumns$.MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
                StructType schema = new StructType((StructField[])((Object[])new StructField[]{col}));
                ResolveDefaultColumns$.MODULE$.validateTableProviderForDefaultValue(schema, tableProvider, "ALTER TABLE ADD COLUMNS", true);
                StructType foldedStructType = ResolveDefaultColumns$.MODULE$.constantFoldCurrentDefaultsToExistDefaults(schema, "ALTER TABLE ADD COLUMNS");
                structField = foldedStructType.fields()[0];
            } else {
                structField = col;
            }
            return structField;
        });
    }

    public AlterTableAddColumnsCommand copy(TableIdentifier table, Seq<StructField> colsToAdd) {
        return new AlterTableAddColumnsCommand(table, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.table();
                break;
            }
            case 1: {
                object = this.colsToAdd();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableAddColumnsCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "table";
                break;
            }
            case 1: {
                string = "colsToAdd";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = alterTableAddColumnsCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableAddColumnsCommand(TableIdentifier table, Seq<StructField> colsToAdd) {
        this.table = table;
        this.colsToAdd = colsToAdd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

