/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.InputFormatInfo$;
import org.apache.spark.scheduler.SplitInfo;
import org.apache.spark.scheduler.SplitInfo$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0005}c\u0001B\r\u001b\u0001\rB\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\tu\u0001\u0011\t\u0011)A\u0005e!A1\b\u0001BC\u0002\u0013\u0005A\b\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003>\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"91\u000e\u0001a\u0001\n\u0003a\u0007B\u0002:\u0001A\u0003&\u0001\u000eC\u0004t\u0001\u0001\u0007I\u0011A4\t\u000fQ\u0004\u0001\u0019!C\u0001k\"1q\u000f\u0001Q!\n!DQ\u0001\u001f\u0001\u0005BeDQA\u001f\u0001\u0005BmDaa \u0001\u0005B\u0005\u0005\u0001bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t)\u0003\u0001C\u0005\u0003\u001bAq!a\n\u0001\t\u0013\tiaB\u0004\u00028iA\t!!\u000f\u0007\reQ\u0002\u0012AA\u001e\u0011\u0019Yf\u0003\"\u0001\u0002>!9\u0011q\b\f\u0005\u0002\u0005\u0005#aD%oaV$hi\u001c:nCRLeNZ8\u000b\u0005ma\u0012!C:dQ\u0016$W\u000f\\3s\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,]5\tAF\u0003\u0002.9\u0005A\u0011N\u001c;fe:\fG.\u0003\u00020Y\t9Aj\\4hS:<\u0017!D2p]\u001aLw-\u001e:bi&|g.F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003d_:4'BA\u001c\u001f\u0003\u0019A\u0017\rZ8pa&\u0011\u0011\b\u000e\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u001d\r|gNZ5hkJ\fG/[8oA\u0005\u0001\u0012N\u001c9vi\u001a{'/\\1u\u00072\f'P_\u000b\u0002{A\u0012ah\u0013\t\u0004\u007f\u0019KeB\u0001!E!\t\te%D\u0001C\u0015\t\u0019%%\u0001\u0004=e>|GOP\u0005\u0003\u000b\u001a\na\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0015\u0019E.Y:t\u0015\t)e\u0005\u0005\u0002K\u00172\u0001A!\u0003'\u0005\u0003\u0003\u0005\tQ!\u0001O\u0005\ryF%M\u0001\u0012S:\u0004X\u000f\u001e$pe6\fGo\u00117buj\u0004\u0013CA(S!\t)\u0003+\u0003\u0002RM\t9aj\u001c;iS:<\u0007CA\u0013T\u0013\t!fEA\u0002B]f\fA\u0001]1uQV\tq\u000b\u0005\u0002@1&\u0011\u0011\f\u0013\u0002\u0007'R\u0014\u0018N\\4\u0002\u000bA\fG\u000f\u001b\u0011\u0002\rqJg.\u001b;?)\u0011iv\fY3\u0011\u0005y\u0003Q\"\u0001\u000e\t\u000bA:\u0001\u0019\u0001\u001a\t\u000bm:\u0001\u0019A11\u0005\t$\u0007cA GGB\u0011!\n\u001a\u0003\n\u0019\u0002\f\t\u0011!A\u0003\u00029CQ!V\u0004A\u0002]\u000bA#\\1qe\u0016$WoY3J]B,HOR8s[\u0006$X#\u00015\u0011\u0005\u0015J\u0017B\u00016'\u0005\u001d\u0011un\u001c7fC:\f\u0001$\\1qe\u0016$WoY3J]B,HOR8s[\u0006$x\fJ3r)\ti\u0007\u000f\u0005\u0002&]&\u0011qN\n\u0002\u0005+:LG\u000fC\u0004r\u0013\u0005\u0005\t\u0019\u00015\u0002\u0007a$\u0013'A\u000bnCB\u0014X\rZ;dK&s\u0007/\u001e;G_Jl\u0017\r\u001e\u0011\u0002#5\f\u0007O]3e\u0013:\u0004X\u000f\u001e$pe6\fG/A\u000bnCB\u0014X\rZ%oaV$hi\u001c:nCR|F%Z9\u0015\u000554\bbB9\r\u0003\u0003\u0005\r\u0001[\u0001\u0013[\u0006\u0004(/\u001a3J]B,HOR8s[\u0006$\b%\u0001\u0005u_N#(/\u001b8h)\u00059\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003q\u0004\"!J?\n\u0005y4#aA%oi\u00061Q-];bYN$2\u0001[A\u0002\u0011\u0019\t)\u0001\u0005a\u0001%\u0006)q\u000e\u001e5fe\u0006Aa/\u00197jI\u0006$X\rF\u0001n\u0003\u0001\u0002(/\u001a4M_\u000e\u001chI]8n\u001b\u0006\u0004(/\u001a3vG\u0016Le\u000e];u\r>\u0014X.\u0019;\u0015\u0005\u0005=\u0001CBA\t\u00037\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003%IW.\\;uC\ndWMC\u0002\u0002\u001a\u0019\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti\"a\u0005\u0003\u0007M+G\u000fE\u0002_\u0003CI1!a\t\u001b\u0005%\u0019\u0006\u000f\\5u\u0013:4w.A\u000fqe\u00164Gj\\2t\rJ|W.T1qe\u0016$\u0017J\u001c9vi\u001a{'/\\1u\u0003Y1\u0017N\u001c3Qe\u00164WM\u001d:fI2{7-\u0019;j_:\u001c\bf\u0001\u0001\u0002,A!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022q\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)$a\f\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\u0002\u001f%s\u0007/\u001e;G_Jl\u0017\r^%oM>\u0004\"A\u0018\f\u0014\u0005Y!CCAA\u001d\u0003e\u0019w.\u001c9vi\u0016\u0004&/\u001a4feJ,G\rT8dCRLwN\\:\u0015\t\u0005\r\u0013\u0011\n\t\u0007\u007f\u0005\u0015s+a\u0004\n\u0007\u0005\u001d\u0003JA\u0002NCBDq!a\u0013\u0019\u0001\u0004\ti%A\u0004g_Jl\u0017\r^:\u0011\u000b\u0005=\u0013\u0011L/\u000f\t\u0005E\u0013Q\u000b\b\u0004\u0003\u0006M\u0013\"A\u0014\n\u0007\u0005]c%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005m\u0013Q\f\u0002\u0004'\u0016\f(bAA,M\u0001")
public class InputFormatInfo
implements Logging {
    private final Configuration configuration;
    private final Class<?> inputFormatClazz;
    private final String path;
    private boolean mapreduceInputFormat;
    private boolean mapredInputFormat;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Map<String, Set<SplitInfo>> computePreferredLocations(Seq<InputFormatInfo> formats) {
        return InputFormatInfo$.MODULE$.computePreferredLocations(formats);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Configuration configuration() {
        return this.configuration;
    }

    public Class<?> inputFormatClazz() {
        return this.inputFormatClazz;
    }

    public String path() {
        return this.path;
    }

    public boolean mapreduceInputFormat() {
        return this.mapreduceInputFormat;
    }

    public void mapreduceInputFormat_$eq(boolean x$1) {
        this.mapreduceInputFormat = x$1;
    }

    public boolean mapredInputFormat() {
        return this.mapredInputFormat;
    }

    public void mapredInputFormat_$eq(boolean x$1) {
        this.mapredInputFormat = x$1;
    }

    public String toString() {
        return new StringBuilder(46).append("InputFormatInfo ").append(super.toString()).append(" .. inputFormatClazz ").append(this.inputFormatClazz()).append(", ").append("path : ").append(this.path()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int hashCode = this.inputFormatClazz().hashCode();
        hashCode = hashCode * 31 + this.path().hashCode();
        return (int)var1_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof InputFormatInfo)) return false;
        InputFormatInfo inputFormatInfo = (InputFormatInfo)object;
        Class<?> clazz = this.inputFormatClazz();
        Class<?> clazz2 = inputFormatInfo.inputFormatClazz();
        if (clazz == null) {
            if (clazz2 != null) {
                return false;
            }
        } else if (!clazz.equals(clazz2)) return false;
        String string = this.path();
        String string2 = inputFormatInfo.path();
        if (string == null) {
            if (string2 == null) return true;
            return false;
        } else {
            if (!string.equals(string2)) return false;
            return true;
        }
    }

    private void validate() {
        block4: {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("validate InputFormatInfo : ").append(this.inputFormatClazz()).append(", path  ").append(this.path()).toString());
            try {
                if (InputFormat.class.isAssignableFrom(this.inputFormatClazz())) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "inputformat is from mapreduce package");
                    this.mapreduceInputFormat_$eq(true);
                    break block4;
                }
                if (org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(this.inputFormatClazz())) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "inputformat is from mapred package");
                    this.mapredInputFormat_$eq(true);
                    break block4;
                }
                throw new IllegalArgumentException(new StringBuilder(112).append("Specified inputformat ").append(this.inputFormatClazz()).append(" is NOT a supported input format ? does not implement either of the supported hadoop ").append("api's").toString());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Specified inputformat ").append(this.inputFormatClazz()).append(" cannot be found ?").toString(), e);
            }
        }
    }

    private Set<SplitInfo> prefLocsFromMapreduceInputFormat() {
        JobConf conf = new JobConf(this.configuration());
        SparkHadoopUtil$.MODULE$.get().addCredentials(conf);
        FileInputFormat.setInputPaths((JobConf)conf, (String)this.path());
        InputFormat instance = (InputFormat)ReflectionUtils.newInstance(this.inputFormatClazz(), (Configuration)conf);
        Job job = Job.getInstance((Configuration)conf);
        ArrayBuffer retval = new ArrayBuffer();
        List list = instance.getSplits((JobContext)job);
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).foreach((Function1 & Serializable)split -> (ArrayBuffer)retval.$plus$plus$eq(SplitInfo$.MODULE$.toSplitInfo(this.inputFormatClazz(), this.path(), (InputSplit)split)));
        return retval.toSet();
    }

    private Set<SplitInfo> prefLocsFromMapredInputFormat() {
        JobConf jobConf = new JobConf(this.configuration());
        SparkHadoopUtil$.MODULE$.get().addCredentials(jobConf);
        FileInputFormat.setInputPaths((JobConf)jobConf, (String)this.path());
        org.apache.hadoop.mapred.InputFormat instance = (org.apache.hadoop.mapred.InputFormat)ReflectionUtils.newInstance(this.inputFormatClazz(), (Configuration)jobConf);
        ArrayBuffer retval = new ArrayBuffer();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])instance.getSplits(jobConf, jobConf.getNumMapTasks())), (Function1 & Serializable)elem -> (ArrayBuffer)retval.$plus$plus$eq(SplitInfo$.MODULE$.toSplitInfo(this.inputFormatClazz(), this.path(), (org.apache.hadoop.mapred.InputSplit)elem)));
        return retval.toSet();
    }

    public Set<SplitInfo> org$apache$spark$scheduler$InputFormatInfo$$findPreferredLocations() {
        Set<SplitInfo> set;
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("mapreduceInputFormat : ").append(this.mapreduceInputFormat()).append(", mapredInputFormat : ").append(this.mapredInputFormat()).append(", inputFormatClazz : ").append(this.inputFormatClazz()).toString());
        if (this.mapreduceInputFormat()) {
            set = this.prefLocsFromMapreduceInputFormat();
        } else {
            Predef$.MODULE$.assert(this.mapredInputFormat());
            set = this.prefLocsFromMapredInputFormat();
        }
        return set;
    }

    public InputFormatInfo(Configuration configuration, Class<?> inputFormatClazz, String path) {
        this.configuration = configuration;
        this.inputFormatClazz = inputFormatClazz;
        this.path = path;
        Logging.$init$((Logging)this);
        this.mapreduceInputFormat = false;
        this.mapredInputFormat = false;
        this.validate();
    }
}

