/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.counters.LimitExceededException;

@InterfaceAudience.Private
public class Limits {
    private int totalCounters;
    private LimitExceededException firstViolation;
    private static boolean isInited;
    private static int GROUP_NAME_MAX;
    private static int COUNTER_NAME_MAX;
    private static int GROUPS_MAX;
    private static int COUNTERS_MAX;

    public static synchronized void init(Configuration conf) {
        if (!isInited) {
            if (conf == null) {
                conf = new JobConf();
            }
            GROUP_NAME_MAX = conf.getInt("mapreduce.job.counters.group.name.max", 128);
            COUNTER_NAME_MAX = conf.getInt("mapreduce.job.counters.counter.name.max", 64);
            GROUPS_MAX = conf.getInt("mapreduce.job.counters.groups.max", 50);
            COUNTERS_MAX = conf.getInt("mapreduce.job.counters.max", 120);
        }
        isInited = true;
    }

    public static int getGroupNameMax() {
        if (!isInited) {
            Limits.init(null);
        }
        return GROUP_NAME_MAX;
    }

    public static int getCounterNameMax() {
        if (!isInited) {
            Limits.init(null);
        }
        return COUNTER_NAME_MAX;
    }

    public static int getGroupsMax() {
        if (!isInited) {
            Limits.init(null);
        }
        return GROUPS_MAX;
    }

    public static int getCountersMax() {
        if (!isInited) {
            Limits.init(null);
        }
        return COUNTERS_MAX;
    }

    public static String filterName(String name, int maxLen) {
        return name.length() > maxLen ? name.substring(0, maxLen - 1) : name;
    }

    public static String filterCounterName(String name) {
        return Limits.filterName(name, Limits.getCounterNameMax());
    }

    public static String filterGroupName(String name) {
        return Limits.filterName(name, Limits.getGroupNameMax());
    }

    public synchronized void checkCounters(int size) {
        if (this.firstViolation != null) {
            throw new LimitExceededException(this.firstViolation);
        }
        int countersMax = Limits.getCountersMax();
        if (size > countersMax) {
            this.firstViolation = new LimitExceededException("Too many counters: " + size + " max=" + countersMax);
            throw this.firstViolation;
        }
    }

    public synchronized void incrCounters() {
        this.checkCounters(this.totalCounters + 1);
        ++this.totalCounters;
    }

    public synchronized void checkGroups(int size) {
        if (this.firstViolation != null) {
            throw new LimitExceededException(this.firstViolation);
        }
        int groupsMax = Limits.getGroupsMax();
        if (size > groupsMax) {
            this.firstViolation = new LimitExceededException("Too many counter groups: " + size + " max=" + groupsMax);
        }
    }

    public synchronized LimitExceededException violation() {
        return this.firstViolation;
    }
}

