/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LU$primitive$LU_DM_Impl_Double$;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.cholesky$;
import breeze.linalg.cholesky$ImplCholesky_DM$;
import breeze.linalg.det$;
import breeze.linalg.diag$;
import breeze.linalg.inv$;
import breeze.linalg.mpow$;
import breeze.linalg.mpow$implDM_Double_Int$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.sum$;
import breeze.linalg.trace$;
import breeze.numerics.package$multidigamma$;
import breeze.numerics.package$multidigamma$multidigammaImplDoubleInt$;
import breeze.numerics.package$multidigammalog$;
import breeze.numerics.package$multidigammalog$multidigammalogImplDoubleInt$;
import breeze.stats.distributions.ChiSquared;
import breeze.stats.distributions.ContinuousDistr;
import breeze.stats.distributions.Density;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.Wishart$;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001\u0002\u0014(\u0001:B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u007f!Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003:\u0011!\t\u0006A!A!\u0002\u0017\u0011\u0006\"B+\u0001\t\u00031\u0006b\u0002/\u0001\u0005\u0004%I!\u0018\u0005\u0007C\u0002\u0001\u000b\u0011\u00020\t\u000f\t\u0004!\u0019!C\u0005\u001f\"11\r\u0001Q\u0001\neBq\u0001\u001a\u0001C\u0002\u0013%q\n\u0003\u0004f\u0001\u0001\u0006I!\u000f\u0005\u0006M\u0002!\ta\u001a\u0005\u0006U\u0002!\t\u0001\u0014\u0005\u0006W\u0002!\ta\u0014\u0005\u0006Y\u0002!\ta\u0014\u0005\u0006[\u0002!\t\u0001\u0014\u0005\u0006]\u0002!\ta\u0014\u0005\u0006_\u0002!\t\u0001\u001d\u0005\bc\u0002\t\t\u0011\"\u0001s\u0011\u001d9\b!%A\u0005\u0002aD\u0011\"a\u0002\u0001#\u0003%\t!!\u0003\t\u0013\u00055\u0001!!A\u0005B\u0005=\u0001\u0002CA\u0011\u0001\u0005\u0005I\u0011A/\t\u0013\u0005\r\u0002!!A\u0005\u0002\u0005\u0015\u0002\"CA\u0019\u0001\u0005\u0005I\u0011IA\u001a\u0011%\t\t\u0005AA\u0001\n\u0003\t\u0019\u0005C\u0005\u0002N\u0001\t\t\u0011\"\u0011\u0002P!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00131\u000b\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/:\u0011\"a\u0017(\u0003\u0003E\t!!\u0018\u0007\u0011\u0019:\u0013\u0011!E\u0001\u0003?Ba!\u0016\u0011\u0005\u0002\u0005\u0005\u0004\"CA)A\u0005\u0005IQIA*\u0011%\t\u0019\u0007IA\u0001\n\u0003\u000b)\u0007C\u0005\u0002p\u0001\n\t\u0011\"!\u0002r!I\u00111\u0011\u0011\u0002\u0002\u0013%\u0011Q\u0011\u0002\b/&\u001c\b.\u0019:u\u0015\tA\u0013&A\u0007eSN$(/\u001b2vi&|gn\u001d\u0006\u0003U-\nQa\u001d;biNT\u0011\u0001L\u0001\u0007EJ,WM_3\u0004\u0001M1\u0001aL\u001bC\u000b\"\u0003\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007c\u0001\u001c8s5\tq%\u0003\u00029O\ty1i\u001c8uS:,x.^:ESN$(\u000fE\u0002;{}j\u0011a\u000f\u0006\u0003y-\na\u0001\\5oC2<\u0017B\u0001 <\u0005-!UM\\:f\u001b\u0006$(/\u001b=\u0011\u0005A\u0002\u0015BA!2\u0005\u0019!u.\u001e2mKB!agQ\u001d:\u0013\t!uEA\u0004N_6,g\u000e^:\u0011\u0005A2\u0015BA$2\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001M%\n\u0005)\u000b$\u0001D*fe&\fG.\u001b>bE2,\u0017A\u00013g+\u0005y\u0014a\u00013gA\u0005)1oY1mKV\t\u0011(\u0001\u0004tG\u0006dW\rI\u0001\ne\u0006tGMQ1tSN\u0004\"AN*\n\u0005Q;#!\u0003*b]\u0012\u0014\u0015m]5t\u0003\u0019a\u0014N\\5u}Q\u0019qKW.\u0015\u0005aK\u0006C\u0001\u001c\u0001\u0011\u0015\tf\u0001q\u0001S\u0011\u0015Ye\u00011\u0001@\u0011\u0015qe\u00011\u0001:\u0003\u0011!\u0017.\\:\u0016\u0003y\u0003\"\u0001M0\n\u0005\u0001\f$aA%oi\u0006)A-[7tA\u0005A\u0011N\u001c<TG\u0006dW-A\u0005j]Z\u001c6-\u00197fA\u0005!1\r[8m\u0003\u0015\u0019\u0007n\u001c7!\u0003I)hN\\8s[\u0006d\u0017N_3e\u0019><\u0007\u000b\u001a4\u0015\u0005}B\u0007\"B5\u000e\u0001\u0004I\u0014!\u0001=\u0002\u001b1|wMT8s[\u0006d\u0017N_3s\u0003\u0011iW-\u00198\u0002\u0011Y\f'/[1oG\u0016\fq!\u001a8ue>\u0004\u00180\u0001\u0003n_\u0012,\u0017\u0001\u00023sC^$\u0012!O\u0001\u0005G>\u0004\u0018\u0010F\u0002tkZ$\"\u0001\u0017;\t\u000bE#\u00029\u0001*\t\u000f-#\u0002\u0013!a\u0001\u007f!9a\n\u0006I\u0001\u0002\u0004I\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0002s*\u0012qH_\u0016\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0001c\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0007\u0005\u0015QPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\f)\u0012\u0011H_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"!\u0006\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\n\u0002.A\u0019\u0001'!\u000b\n\u0007\u0005-\u0012GA\u0002B]fD\u0001\"a\f\u001a\u0003\u0003\u0005\rAX\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0002CBA\u001c\u0003{\t9#\u0004\u0002\u0002:)\u0019\u00111H\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0005e\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0012\u0002LA\u0019\u0001'a\u0012\n\u0007\u0005%\u0013GA\u0004C_>dW-\u00198\t\u0013\u0005=2$!AA\u0002\u0005\u001d\u0012\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003y\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003#\ta!Z9vC2\u001cH\u0003BA#\u00033B\u0011\"a\f\u001f\u0003\u0003\u0005\r!a\n\u0002\u000f]K7\u000f[1siB\u0011a\u0007I\n\u0004A=BECAA/\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t9'a\u001b\u0002nQ\u0019\u0001,!\u001b\t\u000bE\u001b\u00039\u0001*\t\u000b-\u001b\u0003\u0019A \t\u000b9\u001b\u0003\u0019A\u001d\u0002\u000fUt\u0017\r\u001d9msR!\u00111OA@!\u0015\u0001\u0014QOA=\u0013\r\t9(\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bA\nYhP\u001d\n\u0007\u0005u\u0014G\u0001\u0004UkBdWM\r\u0005\t\u0003\u0003#\u0013\u0011!a\u00011\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000f\u0003B!a\u0005\u0002\n&!\u00111RA\u000b\u0005\u0019y%M[3di\u0002")
public class Wishart
implements ContinuousDistr<DenseMatrix<Object>>,
Moments<DenseMatrix<Object>, DenseMatrix<Object>>,
Product {
    private final double df;
    private final DenseMatrix<Object> scale;
    private final RandBasis randBasis;
    private final int dims;
    private final DenseMatrix<Object> invScale;
    private final DenseMatrix<Object> chol;
    private double normalizer;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Object, DenseMatrix<Object>>> unapply(Wishart wishart) {
        return Wishart$.MODULE$.unapply(wishart);
    }

    @Override
    public double pdf(Object x) {
        return ContinuousDistr.pdf$(this, x);
    }

    @Override
    public double logPdf(Object x) {
        return ContinuousDistr.logPdf$(this, x);
    }

    @Override
    public double unnormalizedPdf(Object x) {
        return ContinuousDistr.unnormalizedPdf$(this, x);
    }

    @Override
    public double apply(Object x) {
        return ContinuousDistr.apply$(this, x);
    }

    @Override
    public double logApply(Object x) {
        return ContinuousDistr.logApply$(this, x);
    }

    @Override
    public double draw$mcD$sp() {
        return Rand.draw$mcD$sp$(this);
    }

    @Override
    public int draw$mcI$sp() {
        return Rand.draw$mcI$sp$(this);
    }

    @Override
    public Object get() {
        return Rand.get$(this);
    }

    @Override
    public double get$mcD$sp() {
        return Rand.get$mcD$sp$(this);
    }

    @Override
    public int get$mcI$sp() {
        return Rand.get$mcI$sp$(this);
    }

    @Override
    public Option<DenseMatrix<Object>> drawOpt() {
        return Rand.drawOpt$(this);
    }

    @Override
    public Object sample() {
        return Rand.sample$(this);
    }

    @Override
    public double sample$mcD$sp() {
        return Rand.sample$mcD$sp$(this);
    }

    @Override
    public int sample$mcI$sp() {
        return Rand.sample$mcI$sp$(this);
    }

    @Override
    public IndexedSeq<DenseMatrix<Object>> sample(int n) {
        return Rand.sample$(this, n);
    }

    @Override
    public Iterator<DenseMatrix<Object>> samples() {
        return Rand.samples$(this);
    }

    @Override
    public <U> DenseVector<U> samplesVector(int size, ClassTag<U> m) {
        return Rand.samplesVector$(this, size, m);
    }

    @Override
    public <U> DenseVector<U> samplesVector$mcD$sp(int size, ClassTag<U> m) {
        return Rand.samplesVector$mcD$sp$(this, size, m);
    }

    @Override
    public <U> DenseVector<U> samplesVector$mcI$sp(int size, ClassTag<U> m) {
        return Rand.samplesVector$mcI$sp$(this, size, m);
    }

    @Override
    public <E> Rand<E> flatMap(Function1<DenseMatrix<Object>, Rand<E>> f) {
        return Rand.flatMap$(this, f);
    }

    @Override
    public <E> Rand<E> flatMap$mcD$sp(Function1<Object, Rand<E>> f) {
        return Rand.flatMap$mcD$sp$(this, f);
    }

    @Override
    public <E> Rand<E> flatMap$mcI$sp(Function1<Object, Rand<E>> f) {
        return Rand.flatMap$mcI$sp$(this, f);
    }

    @Override
    public <E> Rand<E> map(Function1<DenseMatrix<Object>, E> f) {
        return Rand.map$(this, f);
    }

    @Override
    public <E> Rand<E> map$mcD$sp(Function1<Object, E> f) {
        return Rand.map$mcD$sp$(this, f);
    }

    @Override
    public <E> Rand<E> map$mcI$sp(Function1<Object, E> f) {
        return Rand.map$mcI$sp$(this, f);
    }

    @Override
    public void foreach(Function1<DenseMatrix<Object>, BoxedUnit> f) {
        Rand.foreach$(this, f);
    }

    @Override
    public void foreach$mcD$sp(Function1<Object, BoxedUnit> f) {
        Rand.foreach$mcD$sp$(this, f);
    }

    @Override
    public void foreach$mcI$sp(Function1<Object, BoxedUnit> f) {
        Rand.foreach$mcI$sp$(this, f);
    }

    @Override
    public Rand<DenseMatrix<Object>> filter(Function1<DenseMatrix<Object>, Object> p) {
        return Rand.filter$(this, p);
    }

    @Override
    public Rand<Object> filter$mcD$sp(Function1<Object, Object> p) {
        return Rand.filter$mcD$sp$(this, p);
    }

    @Override
    public Rand<Object> filter$mcI$sp(Function1<Object, Object> p) {
        return Rand.filter$mcI$sp$(this, p);
    }

    @Override
    public Rand<DenseMatrix<Object>> withFilter(Function1<DenseMatrix<Object>, Object> p) {
        return Rand.withFilter$(this, p);
    }

    @Override
    public Rand<Object> withFilter$mcD$sp(Function1<Object, Object> p) {
        return Rand.withFilter$mcD$sp$(this, p);
    }

    @Override
    public Rand<Object> withFilter$mcI$sp(Function1<Object, Object> p) {
        return Rand.withFilter$mcI$sp$(this, p);
    }

    @Override
    public Rand<DenseMatrix<Object>> condition(Function1<DenseMatrix<Object>, Object> p) {
        return Rand.condition$(this, p);
    }

    @Override
    public Rand<Object> condition$mcD$sp(Function1<Object, Object> p) {
        return Rand.condition$mcD$sp$(this, p);
    }

    @Override
    public Rand<Object> condition$mcI$sp(Function1<Object, Object> p) {
        return Rand.condition$mcI$sp$(this, p);
    }

    private double normalizer$lzycompute() {
        Wishart wishart = this;
        synchronized (wishart) {
            if (!this.bitmap$0) {
                this.normalizer = ContinuousDistr.normalizer$(this);
                this.bitmap$0 = true;
            }
        }
        return this.normalizer;
    }

    @Override
    public double normalizer() {
        return !this.bitmap$0 ? this.normalizer$lzycompute() : this.normalizer;
    }

    public double df() {
        return this.df;
    }

    public DenseMatrix<Object> scale() {
        return this.scale;
    }

    private int dims() {
        return this.dims;
    }

    private DenseMatrix<Object> invScale() {
        return this.invScale;
    }

    private DenseMatrix<Object> chol() {
        return this.chol;
    }

    @Override
    public double unnormalizedLogPdf(DenseMatrix<Object> x) {
        return package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)det$.MODULE$.apply(x, det$.MODULE$.canDetUsingLU(LU$primitive$LU_DM_Impl_Double$.MODULE$)))) * 0.5 * (this.df() - (double)this.dims() - 1.0) - 0.5 * BoxesRunTime.unboxToDouble((Object)trace$.MODULE$.apply(this.invScale().$times(x, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), trace$.MODULE$.impl_trace_using_diag_and_sum(diag$.MODULE$.diagDMDVImpl(), sum$.MODULE$.reduce_Double(HasOps$.MODULE$.DV_canIterateValues()))));
    }

    @Override
    public double logNormalizer() {
        return package$.MODULE$.log(2.0) * (double)this.dims() * 0.5 * this.df() + package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)det$.MODULE$.apply(this.scale(), det$.MODULE$.canDetUsingLU(LU$primitive$LU_DM_Impl_Double$.MODULE$)))) * 0.5 * this.df() + package$multidigammalog$.MODULE$.apply$mDIDc$sp(0.5 * this.df(), this.dims(), package$multidigammalog$multidigammalogImplDoubleInt$.MODULE$);
    }

    @Override
    public DenseMatrix<Object> mean() {
        return this.scale().$times$colon$times(BoxesRunTime.boxToDouble((double)this.df()), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
    }

    @Override
    public DenseMatrix<Object> variance() {
        DenseMatrix<Object> t = diag$.MODULE$.apply(this.scale(), diag$.MODULE$.diagDMDVImpl()).toDenseMatrix$mcD$sp();
        return ((ImmutableNumericOps)((NumericOps)mpow$.MODULE$.apply(this.scale(), BoxesRunTime.boxToInteger((int)2), mpow$implDM_Double_Int$.MODULE$)).$plus(t.$times(t.t(HasOps$.MODULE$.canTranspose_DM()), HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD()), HasOps$.MODULE$.op_DM_DM_Double_OpAdd())).$times$colon$times(BoxesRunTime.boxToDouble((double)this.df()), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
    }

    @Override
    public double entropy() {
        double elnx = package$multidigamma$.MODULE$.apply$mDIDc$sp(this.df() / (double)2, this.dims(), package$multidigamma$multidigammaImplDoubleInt$.MODULE$) + (double)this.dims() * package$.MODULE$.log(2.0) + package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)det$.MODULE$.apply(this.scale(), det$.MODULE$.canDetUsingLU(LU$primitive$LU_DM_Impl_Double$.MODULE$))));
        return -this.logNormalizer() - (this.df() - (double)this.dims() - 1.0) / (double)2 * elnx + this.df() * (double)this.dims() / (double)2;
    }

    @Override
    public DenseMatrix<Object> mode() {
        Predef$.MODULE$.require(this.df() >= (double)(this.dims() + 1));
        return this.scale().$times$colon$times(BoxesRunTime.boxToDouble((double)(this.df() - (double)this.dims() - 1.0)), HasOps$.MODULE$.op_DM_S_Double_OpMulScalar());
    }

    @Override
    public DenseMatrix<Object> draw() {
        Matrix a = DenseMatrix$.MODULE$.zeros$mDc$sp(this.dims(), this.dims(), ClassTag$.MODULE$.Double(), (Zero)Zero$.MODULE$.DoubleZero());
        int limit$macro$9 = this.dims();
        for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
            ((DenseMatrix)a).update$mcD$sp(index$macro$7, index$macro$7, package$.MODULE$.sqrt(new ChiSquared(this.df() - (double)index$macro$7, this.randBasis).draw()));
            int limit$macro$4 = index$macro$7;
            for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                ((DenseMatrix)a).update$mcD$sp(index$macro$7, index$macro$2, this.randBasis.gaussian().draw$mcD$sp());
            }
        }
        DenseMatrix<Object> sample = this.chol().$times(a, HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        sample = sample.$times(sample.t(HasOps$.MODULE$.canTranspose_DM()), HasOps$.MODULE$.impl_OpMulMatrix_DMD_DMD_eq_DMD());
        return sample;
    }

    public Wishart copy(double df, DenseMatrix<Object> scale, RandBasis randBasis) {
        return new Wishart(df, scale, randBasis);
    }

    public double copy$default$1() {
        return this.df();
    }

    public DenseMatrix<Object> copy$default$2() {
        return this.scale();
    }

    public String productPrefix() {
        return "Wishart";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToDouble((double)this.df());
                break;
            }
            case 1: {
                object = this.scale();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Wishart;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.df()));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.scale()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Wishart)) return false;
        boolean bl = true;
        if (!bl) return false;
        Wishart wishart = (Wishart)x$1;
        if (this.df() != wishart.df()) return false;
        DenseMatrix<Object> denseMatrix = this.scale();
        DenseMatrix<Object> denseMatrix2 = wishart.scale();
        if (denseMatrix == null) {
            if (denseMatrix2 != null) {
                return false;
            }
        } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
        if (!wishart.canEqual(this)) return false;
        return true;
    }

    public Wishart(double df, DenseMatrix<Object> scale, RandBasis randBasis) {
        this.df = df;
        this.scale = scale;
        this.randBasis = randBasis;
        Density.$init$(this);
        Rand.$init$(this);
        ContinuousDistr.$init$(this);
        Product.$init$((Product)this);
        this.dims = scale.rows();
        Predef$.MODULE$.require(this.dims() == scale.cols(), (Function0 & Serializable & scala.Serializable)() -> "Scale must be a square matrix");
        Predef$.MODULE$.require(df > (double)(this.dims() - 1), (Function0 & Serializable & scala.Serializable)() -> "df must be greater than one less than the dimensionality");
        this.invScale = inv$.MODULE$.apply(scale, inv$.MODULE$.canInvUsingLU_Double(LU$primitive$LU_DM_Impl_Double$.MODULE$));
        this.chol = cholesky$.MODULE$.apply(scale, cholesky$ImplCholesky_DM$.MODULE$);
    }
}

