/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import org.apache.spark.network.shuffledb.DBBackend;
import org.apache.spark.network.shuffledb.LevelDB;
import org.apache.spark.network.shuffledb.StoreVersion;
import org.apache.spark.network.util.LevelDBProvider;
import org.apache.spark.network.util.RocksDBProvider;
import org.iq80.leveldb.DB;
import org.rocksdb.RocksDB;
import org.sparkproject.guava.annotations.VisibleForTesting;

public class DBProvider {
    public static org.apache.spark.network.shuffledb.DB initDB(DBBackend dbBackend, File dbFile, StoreVersion version, ObjectMapper mapper) throws IOException {
        if (dbFile != null) {
            switch (dbBackend) {
                case LEVELDB: {
                    DB levelDB = LevelDBProvider.initLevelDB(dbFile, version, mapper);
                    return levelDB != null ? new LevelDB(levelDB) : null;
                }
                case ROCKSDB: {
                    RocksDB rocksDB = RocksDBProvider.initRockDB(dbFile, version, mapper);
                    return rocksDB != null ? new org.apache.spark.network.shuffledb.RocksDB(rocksDB) : null;
                }
            }
            throw new IllegalArgumentException("Unsupported DBBackend: " + (Object)((Object)dbBackend));
        }
        return null;
    }

    @VisibleForTesting
    public static org.apache.spark.network.shuffledb.DB initDB(DBBackend dbBackend, File file) throws IOException {
        if (file != null) {
            switch (dbBackend) {
                case LEVELDB: {
                    return new LevelDB(LevelDBProvider.initLevelDB(file));
                }
                case ROCKSDB: {
                    return new org.apache.spark.network.shuffledb.RocksDB(RocksDBProvider.initRocksDB(file));
                }
            }
            throw new IllegalArgumentException("Unsupported DBBackend: " + (Object)((Object)dbBackend));
        }
        return null;
    }
}

