% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{structType}
\alias{structType}
\alias{structType.jobj}
\alias{structType.structField}
\alias{structType.character}
\title{structType}
\usage{
structType(x, ...)

\method{structType}{jobj}(x, ...)

\method{structType}{structField}(x, ...)

\method{structType}{character}(x, ...)
}
\arguments{
\item{x}{a structField object (created with the \code{structField} method). Since Spark 2.3,
this can be a DDL-formatted string, which is a comma separated list of field
definitions, e.g., "a INT, b STRING".}

\item{...}{additional structField objects}
}
\value{
a structType object
}
\description{
Create a structType object that contains the metadata for a SparkDataFrame. Intended for
use with createDataFrame and toDF.
}
\note{
structType since 1.4.0
}
\examples{
\dontrun{
schema <- structType(structField("a", "integer"), structField("c", "string"),
                      structField("avg", "double"))
df1 <- gapply(df, list("a", "c"),
              function(key, x) { y <- data.frame(key, mean(x$b), stringsAsFactors = FALSE) },
              schema)
schema <- structType("a INT, c STRING, avg DOUBLE")
df1 <- gapply(df, list("a", "c"),
              function(key, x) { y <- data.frame(key, mean(x$b), stringsAsFactors = FALSE) },
              schema)
}
}
