/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.CriticalHeaderParamsAware;
import org.apache.hadoop.shaded.com.nimbusds.jose.JOSEException;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSHeader;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSVerifier;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.HMAC;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl.MACProvider;
import org.apache.hadoop.shaded.com.nimbusds.jose.crypto.utils.ConstantTimeUtils;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.OctetSequenceKey;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.Base64URL;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StandardCharset;
import org.apache.hadoop.shaded.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACVerifier
extends MACProvider
implements JWSVerifier,
CriticalHeaderParamsAware {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public MACVerifier(byte[] secret) throws JOSEException {
        this(secret, (Set<String>)null);
    }

    public MACVerifier(String secretString) throws JOSEException {
        this(secretString.getBytes(StandardCharset.UTF_8));
    }

    public MACVerifier(SecretKey secretKey) throws JOSEException {
        this(secretKey, (Set<String>)null);
    }

    public MACVerifier(OctetSequenceKey jwk) throws JOSEException {
        this(jwk.toByteArray());
    }

    public MACVerifier(byte[] secret, Set<String> defCritHeaders) throws JOSEException {
        super(secret, (Set<JWSAlgorithm>)SUPPORTED_ALGORITHMS);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public MACVerifier(SecretKey secretKey, Set<String> defCritHeaders) throws JOSEException {
        super(secretKey, (Set<JWSAlgorithm>)SUPPORTED_ALGORITHMS);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
    }

    public MACVerifier(OctetSequenceKey jwk, Set<String> defCritHeaders) throws JOSEException {
        this(jwk.toByteArray(), defCritHeaders);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public boolean verify(JWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        if (!this.critPolicy.headerPasses(header)) {
            return false;
        }
        String jcaAlg = MACVerifier.getJCAAlgorithmName(header.getAlgorithm());
        byte[] expectedHMAC = HMAC.compute(jcaAlg, this.getSecretKey(), signedContent, this.getJCAContext().getProvider());
        return ConstantTimeUtils.areEqual(expectedHMAC, signature.decode());
    }
}

