/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.ByteTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.DateTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.HiveCharTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.HiveVarcharTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.IntegerTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.LongTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.ShortTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.StringTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.UnsupportedDatatypeTransformAdapter;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

abstract class AbstractTransformerAdapter {
    final AbstractTransformer transformer;

    AbstractTransformerAdapter(AbstractTransformer transformer) {
        this.transformer = transformer;
    }

    abstract Object getTransformedWritable(GenericUDF.DeferredObject var1) throws HiveException;

    static AbstractTransformerAdapter getTransformerAdapter(PrimitiveObjectInspector columnType, AbstractTransformer transformer) {
        AbstractTransformerAdapter ret;
        switch (columnType.getPrimitiveCategory()) {
            case STRING: {
                ret = new StringTransformerAdapter((StringObjectInspector)columnType, transformer);
                break;
            }
            case CHAR: {
                ret = new HiveCharTransformerAdapter((HiveCharObjectInspector)columnType, transformer);
                break;
            }
            case VARCHAR: {
                ret = new HiveVarcharTransformerAdapter((HiveVarcharObjectInspector)columnType, transformer);
                break;
            }
            case BYTE: {
                ret = new ByteTransformerAdapter((ByteObjectInspector)columnType, transformer);
                break;
            }
            case SHORT: {
                ret = new ShortTransformerAdapter((ShortObjectInspector)columnType, transformer);
                break;
            }
            case INT: {
                ret = new IntegerTransformerAdapter((IntObjectInspector)columnType, transformer);
                break;
            }
            case LONG: {
                ret = new LongTransformerAdapter((LongObjectInspector)columnType, transformer);
                break;
            }
            case DATE: {
                ret = new DateTransformerAdapter((DateObjectInspector)columnType, transformer);
                break;
            }
            default: {
                ret = new UnsupportedDatatypeTransformAdapter(columnType, transformer);
            }
        }
        return ret;
    }
}

