/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.DatabaseAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.PartitionsAlreadyExistException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0011ea\u0001B'O\u0001mC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\")1\u000f\u0001C\u0001i\u001a!\u0001\u0010\u0001\u0003z\u0011!QHA!a\u0001\n\u0003Y\b\"C@\u0005\u0005\u0003\u0007I\u0011AA\u0001\u0011%\ti\u0001\u0002B\u0001B\u0003&A\u0010\u0003\u0004t\t\u0011\u0005\u0011q\u0002\u0005\n\u0003/!\u0001\u0019!C\u0001\u00033A\u0011\"a\u0010\u0005\u0001\u0004%\t!!\u0011\t\u0011\u0005\u0015C\u0001)Q\u0005\u000371a!a\u0012\u0001\t\u0005%\u0003BCA&\u0019\t\u0005\r\u0011\"\u0001\u0002N!Q\u0011Q\u000b\u0007\u0003\u0002\u0004%\t!a\u0016\t\u0015\u0005mCB!A!B\u0013\ty\u0005\u0003\u0004t\u0019\u0011\u0005\u0011Q\f\u0005\n\u0003Gb!\u0019!C\u0001\u0003KB\u0001\"a \rA\u0003%\u0011q\r\u0005\n\u0003\u0003c!\u0019!C\u0001\u0003\u0007C\u0001\"!$\rA\u0003%\u0011Q\u0011\u0005\t\u001f\u0002\u0011\r\u0011\"\u0003\u0002\u0010\"A\u00111\u0013\u0001!\u0002\u0013\t\t\nC\u0004\u0002\u0016\u0002!I!a&\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBAg\u0001\u0011%\u0011q\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\ti\u0010\u0001C\u0005\u0003\u007fDq!a6\u0001\t\u0013\u0011\u0019\u0001C\u0004\u0003\f\u0001!\tE!\u0004\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!9!Q\u0005\u0001\u0005B\t\u001d\u0002b\u0002B\u0016\u0001\u0011\u0005#Q\u0006\u0005\b\u0005c\u0001A\u0011\tB\u001a\u0011\u001d\u00119\u0004\u0001C!\u0005sAqAa\u000e\u0001\t\u0003\u0012i\u0004C\u0004\u0003D\u0001!\tE!\u0012\t\u000f\t%\u0003\u0001\"\u0011\u0003L!9!1\u000b\u0001\u0005B\tU\u0003b\u0002B1\u0001\u0011\u0005#1\r\u0005\b\u0005_\u0002A\u0011\tB9\u0011\u001d\u0011)\b\u0001C!\u0005oBqA!$\u0001\t\u0003\u0012y\tC\u0004\u0003\u001a\u0002!\tEa'\t\u000f\tE\u0006\u0001\"\u0011\u00034\"9!\u0011\u0018\u0001\u0005B\tm\u0006b\u0002Bb\u0001\u0011\u0005#Q\u0019\u0005\b\u0005\u0017\u0004A\u0011\tBg\u0011\u001d\u0011Y\r\u0001C!\u0005#DqAa6\u0001\t\u0003\u0012I\u000eC\u0004\u0003`\u0002!\tE!9\t\u000f\tM\b\u0001\"\u0011\u0003v\"91\u0011\u0002\u0001\u0005B\r-\u0001bBB\u0012\u0001\u0011\u00053Q\u0005\u0005\b\u0007c\u0001A\u0011IB\u001a\u0011\u001d\u0019\u0019\u0005\u0001C!\u0007\u000bBqaa\u0015\u0001\t\u0003\u001a)\u0006C\u0004\u0004`\u0001!\te!\u0019\t\u000f\r-\u0004\u0001\"\u0011\u0004n!91q\u000f\u0001\u0005B\re\u0004\"CBB\u0001E\u0005I\u0011ABC\u0011\u001d\u0019Y\n\u0001C!\u0007;C\u0011ba*\u0001#\u0003%\ta!\"\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"91q\u0019\u0001\u0005B\r%\u0007bBBi\u0001\u0011\u000531\u001b\u0005\b\u00077\u0004A\u0011IBo\u0011\u001d\u0019\u0019\u000f\u0001C!\u0007KDqa!<\u0001\t\u0003\u001ay\u000fC\u0004\u0004v\u0002!\tea>\t\u000f\ru\b\u0001\"\u0011\u0004\u0000\u001eIAQ\u0001(\u0002\u0002#\u0005Aq\u0001\u0004\t\u001b:\u000b\t\u0011#\u0001\u0005\n!11/\u0013C\u0001\t\u0017A\u0011\u0002\"\u0004J#\u0003%\t\u0001b\u0004\t\u0013\u0011M\u0011*%A\u0005\u0002\u0011U!aD%o\u001b\u0016lwN]=DCR\fGn\\4\u000b\u0005=\u0003\u0016aB2bi\u0006dwn\u001a\u0006\u0003#J\u000b\u0001bY1uC2L8\u000f\u001e\u0006\u0003'R\u000b1a]9m\u0015\t)f+A\u0003ta\u0006\u00148N\u0003\u0002X1\u00061\u0011\r]1dQ\u0016T\u0011!W\u0001\u0004_J<7\u0001A\n\u0004\u0001q\u0013\u0007CA/a\u001b\u0005q&\"A0\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005t&AB!osJ+g\r\u0005\u0002dI6\ta*\u0003\u0002f\u001d\nyQ\t\u001f;fe:\fGnQ1uC2|w-\u0001\u0003d_:4\u0007C\u00015j\u001b\u0005!\u0016B\u00016U\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0007iC\u0012|w\u000e]\"p]\u001aLw\r\u0005\u0002nc6\taN\u0003\u0002g_*\u0011\u0001OV\u0001\u0007Q\u0006$wn\u001c9\n\u0005It'!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004kZ<\bCA2\u0001\u0011\u001d17\u0001%AA\u0002\u001dDqa[\u0002\u0011\u0002\u0003\u0007ANA\u0005UC\ndW\rR3tGN\u0011A\u0001X\u0001\u0006i\u0006\u0014G.Z\u000b\u0002yB\u00111-`\u0005\u0003}:\u0013AbQ1uC2|w\rV1cY\u0016\f\u0011\u0002^1cY\u0016|F%Z9\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004;\u0006\u0015\u0011bAA\u0004=\n!QK\\5u\u0011!\tYABA\u0001\u0002\u0004a\u0018a\u0001=%c\u00051A/\u00192mK\u0002\"B!!\u0005\u0002\u0016A\u0019\u00111\u0003\u0003\u000e\u0003\u0001AQA\u001f\u0005A\u0002q\f!\u0002]1si&$\u0018n\u001c8t+\t\tY\u0002\u0005\u0005\u0002\u001e\u0005\u001d\u00121FA\u001d\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003Kq\u0016AC2pY2,7\r^5p]&!\u0011\u0011FA\u0010\u0005\u001dA\u0015m\u001d5NCB\u0004B!!\f\u000249\u00191-a\f\n\u0007\u0005Eb*\u0001\u0007DCR\fGn\\4UsB,7/\u0003\u0003\u00026\u0005]\"A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eT1!!\rO!\r\u0019\u00171H\u0005\u0004\u0003{q%!F\"bi\u0006dwn\u001a+bE2,\u0007+\u0019:uSRLwN\\\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cx\fJ3r)\u0011\t\u0019!a\u0011\t\u0013\u0005-!\"!AA\u0002\u0005m\u0011a\u00039beRLG/[8og\u0002\u0012A\u0002R1uC\n\f7/\u001a#fg\u000e\u001c\"\u0001\u0004/\u0002\u0005\u0011\u0014WCAA(!\r\u0019\u0017\u0011K\u0005\u0004\u0003'r%aD\"bi\u0006dwn\u001a#bi\u0006\u0014\u0017m]3\u0002\r\u0011\u0014w\fJ3r)\u0011\t\u0019!!\u0017\t\u0013\u0005-a\"!AA\u0002\u0005=\u0013a\u00013cAQ!\u0011qLA1!\r\t\u0019\u0002\u0004\u0005\b\u0003\u0017\u0002\u0002\u0019AA(\u0003\u0019!\u0018M\u00197fgV\u0011\u0011q\r\t\t\u0003;\t9#!\u001b\u0002\u0012A!\u00111NA=\u001d\u0011\ti'!\u001e\u0011\u0007\u0005=d,\u0004\u0002\u0002r)\u0019\u00111\u000f.\u0002\rq\u0012xn\u001c;?\u0013\r\t9HX\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0014Q\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]d,A\u0004uC\ndWm\u001d\u0011\u0002\u0013\u0019,hn\u0019;j_:\u001cXCAAC!!\ti\"a\n\u0002j\u0005\u001d\u0005cA2\u0002\n&\u0019\u00111\u0012(\u0003\u001f\r\u000bG/\u00197pO\u001a+hn\u0019;j_:\f!BZ;oGRLwN\\:!+\t\t\t\n\u0005\u0005\u0002\u001e\u0005\u001d\u0012\u0011NA0\u0003!\u0019\u0017\r^1m_\u001e\u0004\u0013a\u00049beRLG/[8o\u000bbL7\u000f^:\u0015\u0011\u0005e\u0015qTAQ\u0003G\u00032!XAN\u0013\r\tiJ\u0018\u0002\b\u0005>|G.Z1o\u0011\u001d\tYe\u0006a\u0001\u0003SBaA_\fA\u0002\u0005%\u0004bBAS/\u0001\u0007\u00111F\u0001\u0005gB,7-A\u000bsKF,\u0018N]3UC\ndWMT8u\u000bbL7\u000f^:\u0015\r\u0005\r\u00111VAW\u0011\u001d\tY\u0005\u0007a\u0001\u0003SBaA\u001f\rA\u0002\u0005%\u0014A\u0006:fcVL'/\u001a)beRLG/[8og\u0016C\u0018n\u001d;\u0015\u0011\u0005\r\u00111WA[\u0003oCq!a\u0013\u001a\u0001\u0004\tI\u0007\u0003\u0004{3\u0001\u0007\u0011\u0011\u000e\u0005\b\u0003sK\u0002\u0019AA^\u0003\u0015\u0019\b/Z2t!\u0019\ti,a2\u0002,9!\u0011qXAb\u001d\u0011\ty'!1\n\u0003}K1!!2_\u0003\u001d\u0001\u0018mY6bO\u0016LA!!3\u0002L\n\u00191+Z9\u000b\u0007\u0005\u0015g,A\rsKF,\u0018N]3QCJ$\u0018\u000e^5p]Ntu\u000e^#ySN$H\u0003CA\u0002\u0003#\f\u0019.!6\t\u000f\u0005-#\u00041\u0001\u0002j!1!P\u0007a\u0001\u0003SBq!!/\u001b\u0001\u0004\tY,\u0001\fu_\u000e\u000bG/\u00197pOB\u000b'\u000f^5uS>t7\u000b]3d+\t\tY\u000eE\u0004^\u0003;\f\t/!9\n\u0007\u0005}gLA\u0005Gk:\u001cG/[8ocA!\u00111]A\u001a\u001d\u0011\t)/a\f\u000f\t\u0005\u001d\u00181 \b\u0005\u0003S\fIP\u0004\u0003\u0002l\u0006]h\u0002BAw\u0003ktA!a<\u0002t:!\u0011qNAy\u0013\u0005I\u0016BA,Y\u0013\t)f+\u0003\u0002T)&\u0011\u0011KU\u0005\u0003\u001fB\u000bq\u0003^8DCR\fGn\\4QCJ$\u0018\u000e^5p]N\u0003XmY:\u0015\t\u0005m&\u0011\u0001\u0005\b\u0003sc\u0002\u0019AA^)\u0011\u0011)Aa\u0002\u0011\r\u0005u\u0016qYA\u001d\u0011\u001d\u0011I!\ba\u0001\u0005\u000b\tQ\u0001]1siN\fab\u0019:fCR,G)\u0019;bE\u0006\u001cX\r\u0006\u0004\u0002\u0004\t=!1\u0003\u0005\b\u0005#q\u0002\u0019AA(\u00031!'\rR3gS:LG/[8o\u0011\u001d\u0011)B\ba\u0001\u00033\u000ba\"[4o_J,\u0017JZ#ySN$8/\u0001\u0007ee>\u0004H)\u0019;bE\u0006\u001cX\r\u0006\u0005\u0002\u0004\tm!Q\u0004B\u0011\u0011\u001d\tYe\ba\u0001\u0003SBqAa\b \u0001\u0004\tI*A\tjO:|'/Z%g\u001d>$X\t_5tiNDqAa\t \u0001\u0004\tI*A\u0004dCN\u001c\u0017\rZ3\u0002\u001b\u0005dG/\u001a:ECR\f'-Y:f)\u0011\t\u0019A!\u000b\t\u000f\tE\u0001\u00051\u0001\u0002P\u0005Yq-\u001a;ECR\f'-Y:f)\u0011\tyEa\f\t\u000f\u0005-\u0013\u00051\u0001\u0002j\u0005qA-\u0019;bE\u0006\u001cX-\u0012=jgR\u001cH\u0003BAM\u0005kAq!a\u0013#\u0001\u0004\tI'A\u0007mSN$H)\u0019;bE\u0006\u001cXm\u001d\u000b\u0003\u0005w\u0001b!!0\u0002H\u0006%D\u0003\u0002B\u001e\u0005\u007fAqA!\u0011%\u0001\u0004\tI'A\u0004qCR$XM\u001d8\u0002%M,GoQ;se\u0016tG\u000fR1uC\n\f7/\u001a\u000b\u0005\u0003\u0007\u00119\u0005C\u0004\u0002L\u0015\u0002\r!!\u001b\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0007\u0003\u0007\u0011iE!\u0015\t\r\t=c\u00051\u0001}\u0003=!\u0018M\u00197f\t\u00164\u0017N\\5uS>t\u0007b\u0002B\u000bM\u0001\u0007\u0011\u0011T\u0001\nIJ|\u0007\u000fV1cY\u0016$\"\"a\u0001\u0003X\te#1\fB/\u0011\u001d\tYe\na\u0001\u0003SBaA_\u0014A\u0002\u0005%\u0004b\u0002B\u0010O\u0001\u0007\u0011\u0011\u0014\u0005\b\u0005?:\u0003\u0019AAM\u0003\u0015\u0001XO]4f\u0003-\u0011XM\\1nKR\u000b'\r\\3\u0015\u0011\u0005\r!Q\rB4\u0005WBq!a\u0013)\u0001\u0004\tI\u0007C\u0004\u0003j!\u0002\r!!\u001b\u0002\u000f=dGMT1nK\"9!Q\u000e\u0015A\u0002\u0005%\u0014a\u00028fo:\u000bW.Z\u0001\u000bC2$XM\u001d+bE2,G\u0003BA\u0002\u0005gBaAa\u0014*\u0001\u0004a\u0018\u0001F1mi\u0016\u0014H+\u00192mK\u0012\u000bG/Y*dQ\u0016l\u0017\r\u0006\u0005\u0002\u0004\te$1\u0010B?\u0011\u001d\tYE\u000ba\u0001\u0003SBaA\u001f\u0016A\u0002\u0005%\u0004b\u0002B@U\u0001\u0007!\u0011Q\u0001\u000e]\u0016<H)\u0019;b'\u000eDW-\\1\u0011\t\t\r%\u0011R\u0007\u0003\u0005\u000bS1Aa\"S\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u0011YI!\"\u0003\u0015M#(/^2u)f\u0004X-\u0001\tbYR,'\u000fV1cY\u0016\u001c6\r[3nCRA\u00111\u0001BI\u0005'\u0013)\nC\u0004\u0002L-\u0002\r!!\u001b\t\ri\\\u0003\u0019AA5\u0011\u001d\u00119j\u000ba\u0001\u0005\u0003\u000b\u0011B\\3x'\u000eDW-\\1\u0002\u001f\u0005dG/\u001a:UC\ndWm\u0015;biN$\u0002\"a\u0001\u0003\u001e\n}%\u0011\u0015\u0005\b\u0003\u0017b\u0003\u0019AA5\u0011\u0019QH\u00061\u0001\u0002j!9!1\u0015\u0017A\u0002\t\u0015\u0016!B:uCR\u001c\b#B/\u0003(\n-\u0016b\u0001BU=\n1q\n\u001d;j_:\u00042a\u0019BW\u0013\r\u0011yK\u0014\u0002\u0012\u0007\u0006$\u0018\r\\8h'R\fG/[:uS\u000e\u001c\u0018\u0001C4fiR\u000b'\r\\3\u0015\u000bq\u0014)La.\t\u000f\u0005-S\u00061\u0001\u0002j!1!0\fa\u0001\u0003S\nqbZ3u)\u0006\u0014G.Z:Cs:\u000bW.\u001a\u000b\u0007\u0005{\u0013yL!1\u0011\u000b\u0005u\u0016q\u0019?\t\u000f\u0005-c\u00061\u0001\u0002j!9\u00111\r\u0018A\u0002\tm\u0012a\u0003;bE2,W\t_5tiN$b!!'\u0003H\n%\u0007bBA&_\u0001\u0007\u0011\u0011\u000e\u0005\u0007u>\u0002\r!!\u001b\u0002\u00151L7\u000f\u001e+bE2,7\u000f\u0006\u0003\u0003<\t=\u0007bBA&a\u0001\u0007\u0011\u0011\u000e\u000b\u0007\u0005w\u0011\u0019N!6\t\u000f\u0005-\u0013\u00071\u0001\u0002j!9!\u0011I\u0019A\u0002\u0005%\u0014!\u00037jgR4\u0016.Z<t)\u0019\u0011YDa7\u0003^\"9\u00111\n\u001aA\u0002\u0005%\u0004b\u0002B!e\u0001\u0007\u0011\u0011N\u0001\nY>\fG\rV1cY\u0016$B\"a\u0001\u0003d\n\u0015(q\u001dBv\u0005_Dq!a\u00134\u0001\u0004\tI\u0007\u0003\u0004{g\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005S\u001c\u0004\u0019AA5\u0003!aw.\u00193QCRD\u0007b\u0002Bwg\u0001\u0007\u0011\u0011T\u0001\fSN|e/\u001a:xe&$X\rC\u0004\u0003rN\u0002\r!!'\u0002\u0015%\u001c8K]2M_\u000e\fG.A\u0007m_\u0006$\u0007+\u0019:uSRLwN\u001c\u000b\u0011\u0003\u0007\u00119P!?\u0003|\nu8\u0011AB\u0002\u0007\u000fAq!a\u00135\u0001\u0004\tI\u0007\u0003\u0004{i\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005S$\u0004\u0019AA5\u0011\u001d\u0011y\u0010\u000ea\u0001\u0003W\t\u0011\u0002]1si&$\u0018n\u001c8\t\u000f\t5H\u00071\u0001\u0002\u001a\"91Q\u0001\u001bA\u0002\u0005e\u0015!E5oQ\u0016\u0014\u0018\u000e\u001e+bE2,7\u000b]3dg\"9!\u0011\u001f\u001bA\u0002\u0005e\u0015!\u00067pC\u0012$\u0015P\\1nS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000f\u0003\u0007\u0019iaa\u0004\u0004\u0012\rM1QCB\r\u0011\u001d\tY%\u000ea\u0001\u0003SBaA_\u001bA\u0002\u0005%\u0004b\u0002Buk\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005\u007f,\u0004\u0019AA\u0016\u0011\u001d\u00199\"\u000ea\u0001\u00033\u000bqA]3qY\u0006\u001cW\rC\u0004\u0004\u001cU\u0002\ra!\b\u0002\u000b9,X\u000e\u0012)\u0011\u0007u\u001by\"C\u0002\u0004\"y\u00131!\u00138u\u0003A\u0019'/Z1uKB\u000b'\u000f^5uS>t7\u000f\u0006\u0006\u0002\u0004\r\u001d2\u0011FB\u0016\u0007_Aq!a\u00137\u0001\u0004\tI\u0007\u0003\u0004{m\u0001\u0007\u0011\u0011\u000e\u0005\b\u0007[1\u0004\u0019\u0001B\u0003\u0003!qWm\u001e)beR\u001c\bb\u0002B\u000bm\u0001\u0007\u0011\u0011T\u0001\u000fIJ|\u0007\u000fU1si&$\u0018n\u001c8t)9\t\u0019a!\u000e\u00048\re21HB\u001f\u0007\u007fAq!a\u00138\u0001\u0004\tI\u0007\u0003\u0004{o\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005\u00139\u0004\u0019AA^\u0011\u001d\u0011yb\u000ea\u0001\u00033CqAa\u00188\u0001\u0004\tI\nC\u0004\u0004B]\u0002\r!!'\u0002\u0015I,G/Y5o\t\u0006$\u0018-\u0001\tsK:\fW.\u001a)beRLG/[8ogRQ\u00111AB$\u0007\u0013\u001aYea\u0014\t\u000f\u0005-\u0003\b1\u0001\u0002j!1!\u0010\u000fa\u0001\u0003SBqa!\u00149\u0001\u0004\tY,A\u0005ge>l7\u000b]3dg\"91\u0011\u000b\u001dA\u0002\u0005m\u0016a\u0002;p'B,7m]\u0001\u0010C2$XM\u001d)beRLG/[8ogRA\u00111AB,\u00073\u001aY\u0006C\u0004\u0002Le\u0002\r!!\u001b\t\riL\u0004\u0019AA5\u0011\u001d\u0019i&\u000fa\u0001\u0005\u000b\t!\"\u00197uKJ\u0004\u0016M\u001d;t\u000319W\r\u001e)beRLG/[8o)!\tIda\u0019\u0004f\r\u001d\u0004bBA&u\u0001\u0007\u0011\u0011\u000e\u0005\u0007uj\u0002\r!!\u001b\t\u000f\r%$\b1\u0001\u0002,\u0005A\u0001/\u0019:u'B,7-\u0001\nhKR\u0004\u0016M\u001d;ji&|gn\u00149uS>tG\u0003CB8\u0007c\u001a\u0019h!\u001e\u0011\u000bu\u00139+!\u000f\t\u000f\u0005-3\b1\u0001\u0002j!1!p\u000fa\u0001\u0003SBqa!\u001b<\u0001\u0004\tY#\u0001\nmSN$\b+\u0019:uSRLwN\u001c(b[\u0016\u001cH\u0003\u0003B\u001e\u0007w\u001aiha \t\u000f\u0005-C\b1\u0001\u0002j!1!\u0010\u0010a\u0001\u0003SB\u0011b!\u001b=!\u0003\u0005\ra!!\u0011\u000bu\u00139+a\u000b\u000291L7\u000f\u001e)beRLG/[8o\u001d\u0006lWm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111q\u0011\u0016\u0005\u0007\u0003\u001bIi\u000b\u0002\u0004\fB!1QRBL\u001b\t\u0019yI\u0003\u0003\u0004\u0012\u000eM\u0015!C;oG\",7m[3e\u0015\r\u0019)JX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BBM\u0007\u001f\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039a\u0017n\u001d;QCJ$\u0018\u000e^5p]N$\u0002B!\u0002\u0004 \u000e\u000561\u0015\u0005\b\u0003\u0017r\u0004\u0019AA5\u0011\u0019Qh\b1\u0001\u0002j!I1Q\u0015 \u0011\u0002\u0003\u00071\u0011Q\u0001\fa\u0006\u0014H/[1m'B,7-\u0001\rmSN$\b+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIM\na\u0003\\5tiB\u000b'\u000f^5uS>t7OQ=GS2$XM\u001d\u000b\u000b\u0005\u000b\u0019ika,\u00042\u000e\r\u0007bBA&\u0001\u0002\u0007\u0011\u0011\u000e\u0005\u0007u\u0002\u0003\r!!\u001b\t\u000f\rM\u0006\t1\u0001\u00046\u0006Q\u0001O]3eS\u000e\fG/Z:\u0011\r\u0005u\u0016qYB\\!\u0011\u0019Ila0\u000e\u0005\rm&bAB_!\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u0019\tma/\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0004F\u0002\u0003\r!!\u001b\u0002#\u0011,g-Y;miRKW.\u001a.p]\u0016LE-\u0001\bde\u0016\fG/\u001a$v]\u000e$\u0018n\u001c8\u0015\r\u0005\r11ZBg\u0011\u001d\tY%\u0011a\u0001\u0003SBqaa4B\u0001\u0004\t9)\u0001\u0003gk:\u001c\u0017\u0001\u00043s_B4UO\\2uS>tGCBA\u0002\u0007+\u001c9\u000eC\u0004\u0002L\t\u0003\r!!\u001b\t\u000f\re'\t1\u0001\u0002j\u0005Aa-\u001e8d\u001d\u0006lW-A\u0007bYR,'OR;oGRLwN\u001c\u000b\u0007\u0003\u0007\u0019yn!9\t\u000f\u0005-3\t1\u0001\u0002j!91qZ\"A\u0002\u0005\u001d\u0015A\u0004:f]\u0006lWMR;oGRLwN\u001c\u000b\t\u0003\u0007\u00199o!;\u0004l\"9\u00111\n#A\u0002\u0005%\u0004b\u0002B5\t\u0002\u0007\u0011\u0011\u000e\u0005\b\u0005[\"\u0005\u0019AA5\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0015\r\u0005\u001d5\u0011_Bz\u0011\u001d\tY%\u0012a\u0001\u0003SBqa!7F\u0001\u0004\tI'\u0001\bgk:\u001cG/[8o\u000bbL7\u000f^:\u0015\r\u0005e5\u0011`B~\u0011\u001d\tYE\u0012a\u0001\u0003SBqa!7G\u0001\u0004\tI'A\u0007mSN$h)\u001e8di&|gn\u001d\u000b\u0007\u0005w!\t\u0001b\u0001\t\u000f\u0005-s\t1\u0001\u0002j!9!\u0011I$A\u0002\u0005%\u0014aD%o\u001b\u0016lwN]=DCR\fGn\\4\u0011\u0005\rL5CA%])\t!9!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\t#Q3aZBE\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011Aq\u0003\u0016\u0004Y\u000e%\u0005")
public class InMemoryCatalog
implements ExternalCatalog {
    private final Configuration hadoopConfig;
    private final HashMap<String, DatabaseDesc> catalog;

    public static Configuration $lessinit$greater$default$2() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$2();
    }

    public static SparkConf $lessinit$greater$default$1() {
        return InMemoryCatalog$.MODULE$.$lessinit$greater$default$1();
    }

    @Override
    public void requireDbExists(String db) {
        ExternalCatalog.requireDbExists$(this, db);
    }

    @Override
    public void requireTableExists(String db, String table) {
        ExternalCatalog.requireTableExists$(this, db, table);
    }

    @Override
    public void requireFunctionExists(String db, String funcName) {
        ExternalCatalog.requireFunctionExists$(this, db, funcName);
    }

    @Override
    public void requireFunctionNotExists(String db, String funcName) {
        ExternalCatalog.requireFunctionNotExists$(this, db, funcName);
    }

    private HashMap<String, DatabaseDesc> catalog() {
        return this.catalog;
    }

    private boolean partitionExists(String db, String table, Map<String, String> spec) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().contains(spec);
    }

    private void requireTableNotExists(String db, String table) {
        if (this.tableExists(db, table)) {
            throw new TableAlreadyExistsException(db, table);
        }
    }

    private void requirePartitionsExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private void requirePartitionsNotExist(String db, String table, Seq<Map<String, String>> specs) {
        specs.foreach((Function1 & Serializable)s -> {
            InMemoryCatalog.$anonfun$requirePartitionsNotExist$1(this, db, table, s);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<Map<String, String>, Map<String, String>> toCatalogPartitionSpec() {
        return (Function1 & Serializable)x$1 -> ExternalCatalogUtils$.MODULE$.convertNullPartitionValues((Map<String, String>)x$1);
    }

    private Seq<Map<String, String>> toCatalogPartitionSpecs(Seq<Map<String, String>> specs) {
        return (Seq)specs.map(this.toCatalogPartitionSpec());
    }

    private Seq<CatalogTablePartition> toCatalogPartitionSpec(Seq<CatalogTablePartition> parts) {
        return (Seq)parts.map((Function1 & Serializable)part -> part.copy((Map<String, String>)((Map)this.toCatalogPartitionSpec().apply(part.spec())), part.copy$default$2(), part.copy$default$3(), part.copy$default$4(), part.copy$default$5(), part.copy$default$6()));
    }

    @Override
    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (this.catalog().contains((Object)dbDefinition.name())) {
                if (!ignoreIfExists) {
                    throw new DatabaseAlreadyExistsException(dbDefinition.name());
                }
                v0 = BoxedUnit.UNIT;
            } else {
                this.liftedTree1$1(dbDefinition);
                Map x$1 = (Map)dbDefinition.properties().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"owner"), (Object)Utils$.MODULE$.getCurrentUserName())})));
                String x$2 = dbDefinition.copy$default$1();
                String x$3 = dbDefinition.copy$default$2();
                URI x$4 = dbDefinition.copy$default$3();
                CatalogDatabase newDb = dbDefinition.copy(x$2, x$3, x$4, (Map<String, String>)x$1);
                v0 = this.catalog().put((Object)dbDefinition.name(), (Object)new DatabaseDesc(this, newDb));
            }
        }
    }

    @Override
    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            if (this.catalog().contains((Object)db)) {
                if (!cascade && (((DatabaseDesc)this.catalog().apply((Object)db)).tables().nonEmpty() || ((DatabaseDesc)this.catalog().apply((Object)db)).functions().nonEmpty())) {
                    throw QueryCompilationErrors$.MODULE$.cannotDropNonemptyDatabaseError(db);
                }
                CatalogDatabase dbDefinition = ((DatabaseDesc)this.catalog().apply((Object)db)).db();
                this.liftedTree2$1(dbDefinition);
                v0 = this.catalog().remove((Object)db);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchDatabaseException(db);
                }
                v0 = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public synchronized void alterDatabase(CatalogDatabase dbDefinition) {
        this.requireDbExists(dbDefinition.name());
        ((DatabaseDesc)this.catalog().apply((Object)dbDefinition.name())).db_$eq(dbDefinition);
    }

    @Override
    public synchronized CatalogDatabase getDatabase(String db) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).db();
    }

    @Override
    public synchronized boolean databaseExists(String db) {
        return this.catalog().contains((Object)db);
    }

    @Override
    public synchronized Seq<String> listDatabases() {
        return (Seq)this.catalog().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listDatabases(String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listDatabases(), pattern);
    }

    @Override
    public void setCurrentDatabase(String db) {
    }

    @Override
    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
            String db = (String)tableDefinition.identifier().database().get();
            this.requireDbExists(db);
            String table = tableDefinition.identifier().table();
            if (this.tableExists(db, table)) {
                if (!ignoreIfExists) {
                    throw new TableAlreadyExistsException(db, table);
                }
                v0 = BoxedUnit.UNIT;
            } else {
                Map tableProp;
                CatalogTable catalogTable;
                boolean needDefaultTableLocation;
                CatalogTableType catalogTableType = tableDefinition.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                boolean bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null) && tableDefinition.storage().locationUri().isEmpty() ? true : (needDefaultTableLocation = false);
                if (needDefaultTableLocation) {
                    Path defaultTableLocation = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), table);
                    this.liftedTree3$1(defaultTableLocation, table);
                    catalogTable = tableDefinition.withNewStorage((Option<URI>)new Some((Object)defaultTableLocation.toUri()), tableDefinition.withNewStorage$default$2(), tableDefinition.withNewStorage$default$3(), tableDefinition.withNewStorage$default$4(), tableDefinition.withNewStorage$default$5(), tableDefinition.withNewStorage$default$6());
                } else {
                    catalogTable = tableDefinition;
                }
                CatalogTable tableWithLocation = catalogTable;
                Map x$1 = tableProp = (Map)tableWithLocation.properties().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$createTable$1(x$2)));
                TableIdentifier x$22 = tableWithLocation.copy$default$1();
                CatalogTableType x$3 = tableWithLocation.copy$default$2();
                CatalogStorageFormat x$4 = tableWithLocation.copy$default$3();
                StructType x$5 = tableWithLocation.copy$default$4();
                Option<String> x$6 = tableWithLocation.copy$default$5();
                Seq<String> x$7 = tableWithLocation.copy$default$6();
                Option<BucketSpec> x$8 = tableWithLocation.copy$default$7();
                String x$9 = tableWithLocation.copy$default$8();
                long x$10 = tableWithLocation.copy$default$9();
                long x$11 = tableWithLocation.copy$default$10();
                String x$12 = tableWithLocation.copy$default$11();
                Option<CatalogStatistics> x$13 = tableWithLocation.copy$default$13();
                Option<String> x$14 = tableWithLocation.copy$default$14();
                Option<String> x$15 = tableWithLocation.copy$default$15();
                Option<String> x$16 = tableWithLocation.copy$default$16();
                Seq<String> x$17 = tableWithLocation.copy$default$17();
                boolean x$18 = tableWithLocation.copy$default$18();
                boolean x$19 = tableWithLocation.copy$default$19();
                Map<String, String> x$20 = tableWithLocation.copy$default$20();
                Option<String> x$21 = tableWithLocation.copy$default$21();
                v0 = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)table, (Object)new TableDesc(this, tableWithLocation.copy(x$22, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21)));
            }
        }
    }

    @Override
    public void dropTable(String db, String table, boolean ignoreIfNotExists, boolean purge) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            if (this.tableExists(db, table)) {
                CatalogTable tableMeta = this.getTable(db, table);
                CatalogTableType catalogTableType = tableMeta.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
                if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                    Seq locationAllParts = (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq().map((Function1 & Serializable)x$3 -> x$3.location());
                    locationAllParts.foreach((Function1 & Serializable)loc -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$dropTable$2(this, loc)));
                    Predef$.MODULE$.assert(tableMeta.storage().locationUri().isDefined(), (Function0 & Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                    Path dir = new Path(tableMeta.location());
                    v1 = BoxesRunTime.boxToBoolean((boolean)this.liftedTree4$1(dir, table));
                } else {
                    v1 = BoxedUnit.UNIT;
                }
                v2 = ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)table);
            } else {
                if (!ignoreIfNotExists) {
                    throw new NoSuchTableException(db, table);
                }
                v2 = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void renameTable(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireTableExists(db, oldName);
            this.requireTableNotExists(db, newName);
            TableDesc oldDesc = (TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)oldName);
            CatalogTable qual$1 = oldDesc.table();
            TableIdentifier qual$2 = oldDesc.table().identifier();
            String x$1 = newName;
            Option<String> x$2 = qual$2.copy$default$2();
            Option<String> x$3 = qual$2.copy$default$3();
            TableIdentifier x$4 = qual$2.copy(x$1, x$2, x$3);
            CatalogTableType x$5 = qual$1.copy$default$2();
            CatalogStorageFormat x$6 = qual$1.copy$default$3();
            StructType x$7 = qual$1.copy$default$4();
            Option<String> x$8 = qual$1.copy$default$5();
            Seq<String> x$9 = qual$1.copy$default$6();
            Option<BucketSpec> x$10 = qual$1.copy$default$7();
            String x$11 = qual$1.copy$default$8();
            long x$12 = qual$1.copy$default$9();
            long x$13 = qual$1.copy$default$10();
            String x$14 = qual$1.copy$default$11();
            Map<String, String> x$15 = qual$1.copy$default$12();
            Option<CatalogStatistics> x$16 = qual$1.copy$default$13();
            Option<String> x$17 = qual$1.copy$default$14();
            Option<String> x$18 = qual$1.copy$default$15();
            Option<String> x$19 = qual$1.copy$default$16();
            Seq<String> x$20 = qual$1.copy$default$17();
            boolean x$21 = qual$1.copy$default$18();
            boolean x$22 = qual$1.copy$default$19();
            Map<String, String> x$23 = qual$1.copy$default$20();
            Option<String> x$24 = qual$1.copy$default$21();
            oldDesc.table_$eq(qual$1.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24));
            CatalogTableType catalogTableType = oldDesc.table().tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            if (!(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null)) {
                Predef$.MODULE$.assert(oldDesc.table().storage().locationUri().isDefined(), (Function0 & Serializable)() -> "Managed table should always have table location, as we will assign a default location to it if it doesn't have one.");
                Path oldDir = new Path(oldDesc.table().location());
                Path newDir = new Path(new Path(((DatabaseDesc)this.catalog().apply((Object)db)).db().locationUri()), newName);
                this.liftedTree5$1(oldDir, newDir, oldName, newName);
                CatalogTable qual$3 = oldDesc.table();
                Some x$25 = new Some((Object)newDir.toUri());
                Option<String> x$26 = qual$3.withNewStorage$default$2();
                Option<String> x$27 = qual$3.withNewStorage$default$3();
                boolean x$28 = qual$3.withNewStorage$default$4();
                Option<String> x$29 = qual$3.withNewStorage$default$5();
                Map<String, String> x$30 = qual$3.withNewStorage$default$6();
                oldDesc.table_$eq(qual$3.withNewStorage((Option<URI>)x$25, x$26, x$27, x$28, x$29, x$30));
                HashMap newPartitions = (HashMap)oldDesc.partitions().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Map spec = (Map)tuple2._1();
                        CatalogTablePartition partition = (CatalogTablePartition)tuple2._2();
                        CatalogStorageFormat storage = partition.storage();
                        Option newLocationUri = storage.locationUri().map((Function1 & Serializable)uri -> new Path(uri.toString().replace(oldDir.toString(), newDir.toString())).toUri());
                        CatalogStorageFormat x$31 = storage.copy((Option<URI>)newLocationUri, storage.copy$default$2(), storage.copy$default$3(), storage.copy$default$4(), storage.copy$default$5(), storage.copy$default$6());
                        Map<String, String> x$32 = partition.copy$default$1();
                        Map<String, String> x$33 = partition.copy$default$3();
                        long x$34 = partition.copy$default$4();
                        long x$35 = partition.copy$default$5();
                        Option<CatalogStatistics> x$36 = partition.copy$default$6();
                        CatalogTablePartition newPartition = partition.copy(x$32, x$31, x$33, x$34, x$35, x$36);
                        return new Tuple2((Object)spec, (Object)newPartition);
                    }
                    throw new MatchError((Object)tuple2);
                });
                oldDesc.partitions_$eq((HashMap<Map<String, String>, CatalogTablePartition>)newPartitions);
            }
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().put((Object)newName, (Object)oldDesc);
            ((DatabaseDesc)this.catalog().apply((Object)db)).tables().remove((Object)oldName);
        }
    }

    @Override
    public synchronized void alterTable(CatalogTable tableDefinition) {
        Map updatedProperties;
        Predef$.MODULE$.assert(tableDefinition.identifier().database().isDefined());
        String db = (String)tableDefinition.identifier().database().get();
        this.requireTableExists(db, tableDefinition.identifier().table());
        Map x$1 = updatedProperties = (Map)tableDefinition.properties().filter((Function1 & Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$alterTable$1(kv)));
        TableIdentifier x$2 = tableDefinition.copy$default$1();
        CatalogTableType x$3 = tableDefinition.copy$default$2();
        CatalogStorageFormat x$4 = tableDefinition.copy$default$3();
        StructType x$5 = tableDefinition.copy$default$4();
        Option<String> x$6 = tableDefinition.copy$default$5();
        Seq<String> x$7 = tableDefinition.copy$default$6();
        Option<BucketSpec> x$8 = tableDefinition.copy$default$7();
        String x$9 = tableDefinition.copy$default$8();
        long x$10 = tableDefinition.copy$default$9();
        long x$11 = tableDefinition.copy$default$10();
        String x$12 = tableDefinition.copy$default$11();
        Option<CatalogStatistics> x$13 = tableDefinition.copy$default$13();
        Option<String> x$14 = tableDefinition.copy$default$14();
        Option<String> x$15 = tableDefinition.copy$default$15();
        Option<String> x$16 = tableDefinition.copy$default$16();
        Seq<String> x$17 = tableDefinition.copy$default$17();
        boolean x$18 = tableDefinition.copy$default$18();
        boolean x$19 = tableDefinition.copy$default$19();
        Map<String, String> x$20 = tableDefinition.copy$default$20();
        Option<String> x$21 = tableDefinition.copy$default$21();
        CatalogTable newTableDefinition = tableDefinition.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<String, String>)x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)tableDefinition.identifier().table())).table_$eq(newTableDefinition);
    }

    @Override
    public synchronized void alterTableDataSchema(String db, String table, StructType newDataSchema) {
        StructType newSchema;
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        StructType x$1 = newSchema = StructType$.MODULE$.apply((Seq)newDataSchema.$plus$plus((IterableOnce)origTable.partitionSchema()));
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Option<String> x$16 = origTable.copy$default$16();
        Seq<String> x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        boolean x$19 = origTable.copy$default$19();
        Map<String, String> x$20 = origTable.copy$default$20();
        Option<String> x$21 = origTable.copy$default$21();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
    }

    @Override
    public synchronized void alterTableSchema(String db, String table, StructType newSchema) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Seq<String> partCols = origTable.partitionColumnNames();
        Object object = ((IterableOps)newSchema.map((Function1 & Serializable)x$4 -> x$4.name())).takeRight(partCols.length());
        Seq<String> seq = partCols;
        Predef$.MODULE$.assert(!(object != null ? !object.equals(seq) : seq != null), (Function0 & Serializable)() -> "Partition columns " + partCols.mkString("[", ", ", "]") + " are only supported at the end of the new schema " + newSchema.catalogString() + " for now.");
        StructType x$1 = newSchema;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$42 = origTable.copy$default$3();
        Option<String> x$5 = origTable.copy$default$5();
        Seq<String> x$6 = origTable.copy$default$6();
        Option<BucketSpec> x$7 = origTable.copy$default$7();
        String x$8 = origTable.copy$default$8();
        long x$9 = origTable.copy$default$9();
        long x$10 = origTable.copy$default$10();
        String x$11 = origTable.copy$default$11();
        Map<String, String> x$12 = origTable.copy$default$12();
        Option<CatalogStatistics> x$13 = origTable.copy$default$13();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Option<String> x$16 = origTable.copy$default$16();
        Seq<String> x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        boolean x$19 = origTable.copy$default$19();
        Map<String, String> x$20 = origTable.copy$default$20();
        Option<String> x$21 = origTable.copy$default$21();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$42, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
    }

    @Override
    public synchronized void alterTableStats(String db, String table, Option<CatalogStatistics> stats) {
        this.requireTableExists(db, table);
        CatalogTable origTable = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
        Option<CatalogStatistics> x$1 = stats;
        TableIdentifier x$2 = origTable.copy$default$1();
        CatalogTableType x$3 = origTable.copy$default$2();
        CatalogStorageFormat x$4 = origTable.copy$default$3();
        StructType x$5 = origTable.copy$default$4();
        Option<String> x$6 = origTable.copy$default$5();
        Seq<String> x$7 = origTable.copy$default$6();
        Option<BucketSpec> x$8 = origTable.copy$default$7();
        String x$9 = origTable.copy$default$8();
        long x$10 = origTable.copy$default$9();
        long x$11 = origTable.copy$default$10();
        String x$12 = origTable.copy$default$11();
        Map<String, String> x$13 = origTable.copy$default$12();
        Option<String> x$14 = origTable.copy$default$14();
        Option<String> x$15 = origTable.copy$default$15();
        Option<String> x$16 = origTable.copy$default$16();
        Seq<String> x$17 = origTable.copy$default$17();
        boolean x$18 = origTable.copy$default$18();
        boolean x$19 = origTable.copy$default$19();
        Map<String, String> x$20 = origTable.copy$default$20();
        Option<String> x$21 = origTable.copy$default$21();
        ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table_$eq(origTable.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$1, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21));
    }

    @Override
    public synchronized CatalogTable getTable(String db, String table) {
        this.requireTableExists(db, table);
        return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).table();
    }

    @Override
    public Seq<CatalogTable> getTablesByName(String db, Seq<String> tables) {
        this.requireDbExists(db);
        HashMap<String, TableDesc> hashMap = ((DatabaseDesc)this.catalog().apply((Object)db)).tables();
        return (Seq)((IterableOps)tables.flatMap((Function1 & Serializable)key -> hashMap.get(key))).map((Function1 & Serializable)x$5 -> x$5.table());
    }

    @Override
    public synchronized boolean tableExists(String db, String table) {
        return this.catalog().contains((Object)db) && ((DatabaseDesc)this.catalog().apply((Object)db)).tables().contains((Object)table);
    }

    @Override
    public synchronized Seq<String> listTables(String db) {
        this.requireDbExists(db);
        return (Seq)((DatabaseDesc)this.catalog().apply((Object)db)).tables().keySet().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public synchronized Seq<String> listTables(String db, String pattern) {
        return StringUtils$.MODULE$.filterPattern(this.listTables(db), pattern);
    }

    @Override
    public synchronized Seq<String> listViews(String db, String pattern) {
        this.requireDbExists(db);
        Set views = ((MapOps)((DatabaseDesc)this.catalog().apply((Object)db)).tables().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)InMemoryCatalog.$anonfun$listViews$1(x$6)))).keySet();
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((Seq)views.toSeq().sorted((Ordering)Ordering.String$.MODULE$)), pattern);
    }

    @Override
    public void loadTable(String db, String table, String loadPath, boolean isOverwrite, boolean isSrcLocal) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadTable");
    }

    @Override
    public void loadPartition(String db, String table, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean inheritTableSpecs, boolean isSrcLocal) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadPartition");
    }

    @Override
    public void loadDynamicPartitions(String db, String table, String loadPath, Map<String, String> partition, boolean replace, int numDP) {
        throw QueryExecutionErrors$.MODULE$.methodNotImplementedError("loadDynamicPartitions");
    }

    @Override
    public synchronized void createPartitions(String db, String table, Seq<CatalogTablePartition> newParts, boolean ignoreIfExists) {
        Seq dupSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(newParts);
        if (!ignoreIfExists && (dupSpecs = (Seq)parts.collect((PartialFunction)new Serializable(null, existingParts){
            private static final long serialVersionUID = 0L;
            private final HashMap existingParts$1;

            public final <A1 extends CatalogTablePartition, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (this.existingParts$1.contains(A1.spec())) {
                    return (B1)A1.spec();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CatalogTablePartition x1) {
                CatalogTablePartition catalogTablePartition = x1;
                return this.existingParts$1.contains(catalogTablePartition.spec());
            }
            {
                this.existingParts$1 = existingParts$1;
            }
        })).nonEmpty()) {
            throw new PartitionsAlreadyExistException(db, table, (Seq<Map<String, String>>)dupSpecs);
        }
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        parts.foreach((Function1 & Serializable)p -> {
            Path partitionPath = (Path)p.storage().locationUri().map((Function1 & Serializable)x$7 -> new Path(x$7)).getOrElse((Function0 & Serializable)() -> ExternalCatalogUtils$.MODULE$.generatePartitionPath(p.spec(), partitionColumnNames, tablePath));
            try {
                FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                Object object = !fs.exists(partitionPath) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(partitionPath)) : BoxedUnit.UNIT;
            }
            catch (IOException e) {
                throw QueryExecutionErrors$.MODULE$.unableToCreatePartitionPathError(partitionPath, e);
            }
            CatalogStorageFormat x$1 = p.storage().copy((Option<URI>)new Some((Object)partitionPath.toUri()), p.storage().copy$default$2(), p.storage().copy$default$3(), p.storage().copy$default$4(), p.storage().copy$default$5(), p.storage().copy$default$6());
            Map<String, String> x$2 = p.copy$default$1();
            Map<String, String> x$3 = p.copy$default$3();
            long x$4 = p.copy$default$4();
            long x$5 = p.copy$default$5();
            Option<CatalogStatistics> x$6 = p.copy$default$6();
            return existingParts.put(p.spec(), (Object)p.copy(x$2, x$1, x$3, x$4, x$5, x$6));
        });
    }

    @Override
    public synchronized void dropPartitions(String db, String table, Seq<Map<String, String>> parts, boolean ignoreIfNotExists, boolean purge, boolean retainData) {
        boolean bl;
        Seq missingSpecs;
        this.requireTableExists(db, table);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        Seq<Map<String, String>> partSpecs = this.toCatalogPartitionSpecs(parts);
        if (!ignoreIfNotExists && (missingSpecs = (Seq)partSpecs.collect((PartialFunction)new Serializable(null, existingParts){
            private static final long serialVersionUID = 0L;
            private final HashMap existingParts$2;

            public final <A1 extends Map<String, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (!this.existingParts$2.contains(A1)) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Map<String, String> x1) {
                Map<String, String> map = x1;
                return !this.existingParts$2.contains(map);
            }
            {
                this.existingParts$2 = existingParts$2;
            }
        })).nonEmpty()) {
            throw new NoSuchPartitionsException(db, table, (Seq<Map<String, String>>)missingSpecs);
        }
        if (retainData) {
            bl = false;
        } else {
            CatalogTableType catalogTableType = this.getTable(db, table).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            bl = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        }
        boolean shouldRemovePartitionLocation = bl;
        partSpecs.foreach((Function1 & Serializable)p -> {
            if (existingParts.contains(p) && shouldRemovePartitionLocation) {
                boolean bl;
                Path partitionPath = new Path(((CatalogTablePartition)existingParts.apply(p)).location());
                try {
                    FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
                    bl = fs.delete(partitionPath, true);
                }
                catch (IOException e) {
                    throw QueryExecutionErrors$.MODULE$.unableToDeletePartitionPathError(partitionPath, e);
                }
                v1 = BoxesRunTime.boxToBoolean((boolean)bl);
            } else {
                v1 = BoxedUnit.UNIT;
            }
            return existingParts.remove(p);
        });
    }

    @Override
    public synchronized void renamePartitions(String db, String table, Seq<Map<String, String>> fromSpecs, Seq<Map<String, String>> toSpecs) {
        Seq<Map<String, String>> specs = this.toCatalogPartitionSpecs(fromSpecs);
        Seq<Map<String, String>> newSpecs = this.toCatalogPartitionSpecs(toSpecs);
        Predef$.MODULE$.require(specs.size() == newSpecs.size(), (Function0 & Serializable)() -> "number of old and new partition specs differ");
        this.requirePartitionsExist(db, table, specs);
        this.requirePartitionsNotExist(db, table, newSpecs);
        CatalogTable tableMeta = this.getTable(db, table);
        Seq<String> partitionColumnNames = tableMeta.partitionColumnNames();
        Path tablePath = new Path(tableMeta.location());
        CatalogTableType catalogTableType = this.getTable(db, table).tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        boolean shouldUpdatePartitionLocation = !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
        HashMap<Map<String, String>, CatalogTablePartition> existingParts = ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions();
        ((IterableOnceOps)specs.zip(newSpecs)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CatalogTablePartition catalogTablePartition;
                Map oldSpec = (Map)tuple2._1();
                Map newSpec = (Map)tuple2._2();
                CatalogTablePartition oldPartition = this.getPartition(db, table, (Map<String, String>)oldSpec);
                if (shouldUpdatePartitionLocation) {
                    Path oldPartPath = new Path(oldPartition.location());
                    Path newPartPath = ExternalCatalogUtils$.MODULE$.generatePartitionPath((Map<String, String>)newSpec, partitionColumnNames, tablePath);
                    try {
                        FileSystem fs = tablePath.getFileSystem($this.hadoopConfig);
                        fs.mkdirs(newPartPath);
                        if (!fs.rename(oldPartPath, newPartPath)) {
                            throw new IOException("Renaming partition path from " + oldPartPath + " to " + newPartPath + " returned false");
                        }
                    }
                    catch (IOException e) {
                        throw QueryExecutionErrors$.MODULE$.unableToRenamePartitionPathError(oldPartPath, e);
                    }
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.storage().copy((Option<URI>)new Some((Object)newPartPath.toUri()), oldPartition.storage().copy$default$2(), oldPartition.storage().copy$default$3(), oldPartition.storage().copy$default$4(), oldPartition.storage().copy$default$5(), oldPartition.storage().copy$default$6()), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                } else {
                    catalogTablePartition = oldPartition.copy((Map<String, String>)newSpec, oldPartition.copy$default$2(), oldPartition.copy$default$3(), oldPartition.copy$default$4(), oldPartition.copy$default$5(), oldPartition.copy$default$6());
                }
                CatalogTablePartition newPartition = catalogTablePartition;
                existingParts.remove((Object)oldSpec);
                return existingParts.put((Object)newSpec, (Object)newPartition);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public synchronized void alterPartitions(String db, String table, Seq<CatalogTablePartition> alterParts) {
        Seq<CatalogTablePartition> parts = this.toCatalogPartitionSpec(alterParts);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)((Seq)parts.map((Function1 & Serializable)p -> p.spec())));
        parts.foreach((Function1 & Serializable)p -> ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().put(p.spec(), p));
    }

    @Override
    public synchronized CatalogTablePartition getPartition(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        this.requirePartitionsExist(db, table, (Seq<Map<String, String>>)new .colon.colon((Object)spec, (List)Nil$.MODULE$));
        return (CatalogTablePartition)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec);
    }

    @Override
    public synchronized Option<CatalogTablePartition> getPartitionOption(String db, String table, Map<String, String> partSpec) {
        Map spec = (Map)this.toCatalogPartitionSpec().apply(partSpec);
        if (!this.partitionExists(db, table, (Map<String, String>)spec)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply(((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().apply((Object)spec));
    }

    @Override
    public synchronized Seq<String> listPartitionNames(String db, String table, Option<Map<String, String>> partSpec) {
        Seq<String> partitionColumnNames = this.getTable(db, table).partitionColumnNames();
        Option partialSpec = partSpec.map(this.toCatalogPartitionSpec());
        return (Seq)((SeqOps)this.listPartitions(db, table, (Option<Map<String, String>>)partialSpec).map((Function1 & Serializable)partition -> ((IterableOnceOps)partitionColumnNames.map((Function1 & Serializable)name -> {
            String partValue = partition.spec().apply(name) == null ? ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME() : ExternalCatalogUtils$.MODULE$.escapePathName((String)partition.spec().apply(name));
            return ExternalCatalogUtils$.MODULE$.escapePathName((String)name) + "=" + partValue;
        })).mkString("/"))).sorted((Ordering)Ordering.String$.MODULE$);
    }

    @Override
    public Option<Map<String, String>> listPartitionNames$default$3() {
        return None$.MODULE$;
    }

    @Override
    public synchronized Seq<CatalogTablePartition> listPartitions(String db, String table, Option<Map<String, String>> partialSpec) {
        this.requireTableExists(db, table);
        Option option = partialSpec.map(this.toCatalogPartitionSpec());
        if (None$.MODULE$.equals(option)) {
            return ((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().values().toSeq();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Map partial = (Map)some.value();
            return (Seq)((TableDesc)((DatabaseDesc)this.catalog().apply((Object)db)).tables().apply((Object)table)).partitions().toSeq().collect((PartialFunction)new Serializable(null, partial){
                private static final long serialVersionUID = 0L;
                private final Map partial$1;

                public final <A1 extends Tuple2<Map<String, String>, CatalogTablePartition>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        Map spec = (Map)A1._1();
                        CatalogTablePartition partition = (CatalogTablePartition)A1._2();
                        if (ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)spec)) {
                            return (B1)partition;
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Tuple2<Map<String, String>, CatalogTablePartition> x1) {
                    Map spec;
                    Tuple2<Map<String, String>, CatalogTablePartition> tuple2 = x1;
                    return tuple2 != null && ExternalCatalogUtils$.MODULE$.isPartialPartitionSpec((Map<String, String>)this.partial$1, (Map<String, String>)(spec = (Map)tuple2._1()));
                }
                {
                    this.partial$1 = partial$1;
                }
            });
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Option<Map<String, String>> listPartitions$default$3() {
        return None$.MODULE$;
    }

    @Override
    public Seq<CatalogTablePartition> listPartitionsByFilter(String db, String table, Seq<Expression> predicates, String defaultTimeZoneId) {
        CatalogTable catalogTable = this.getTable(db, table);
        Seq<CatalogTablePartition> allPartitions = this.listPartitions(db, table, this.listPartitions$default$3());
        return ExternalCatalogUtils$.MODULE$.prunePartitionsByFilter(catalogTable, allPartitions, predicates, defaultTimeZoneId);
    }

    @Override
    public void createFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionNotExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void dropFunction(String db, String funcName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, funcName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)funcName);
        }
    }

    @Override
    public void alterFunction(String db, CatalogFunction func) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireDbExists(db);
            this.requireFunctionExists(db, func.identifier().funcName());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)func.identifier().funcName(), (Object)func);
        }
    }

    @Override
    public void renameFunction(String db, String oldName, String newName) {
        InMemoryCatalog inMemoryCatalog = this;
        synchronized (inMemoryCatalog) {
            this.requireFunctionExists(db, oldName);
            this.requireFunctionNotExists(db, newName);
            CatalogFunction oldFunc = this.getFunction(db, oldName);
            CatalogFunction newFunc = oldFunc.copy(oldFunc.identifier().copy(newName, oldFunc.identifier().copy$default$2(), oldFunc.identifier().copy$default$3()), oldFunc.copy$default$2(), oldFunc.copy$default$3());
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().remove((Object)oldName);
            ((DatabaseDesc)this.catalog().apply((Object)db)).functions().put((Object)newName, (Object)newFunc);
        }
    }

    @Override
    public synchronized CatalogFunction getFunction(String db, String funcName) {
        this.requireFunctionExists(db, funcName);
        return (CatalogFunction)((DatabaseDesc)this.catalog().apply((Object)db)).functions().apply((Object)funcName);
    }

    @Override
    public synchronized boolean functionExists(String db, String funcName) {
        this.requireDbExists(db);
        return ((DatabaseDesc)this.catalog().apply((Object)db)).functions().contains((Object)funcName);
    }

    @Override
    public synchronized Seq<String> listFunctions(String db, String pattern) {
        this.requireDbExists(db);
        return StringUtils$.MODULE$.filterPattern((Seq<String>)((DatabaseDesc)this.catalog().apply((Object)db)).functions().keysIterator().toSeq(), pattern);
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsExist$1(InMemoryCatalog $this, String db$1, String table$1, Map s) {
        if (!$this.partitionExists(db$1, table$1, (Map<String, String>)s)) {
            throw new NoSuchPartitionException(db$1, table$1, (Map<String, String>)s);
        }
    }

    public static final /* synthetic */ void $anonfun$requirePartitionsNotExist$1(InMemoryCatalog $this, String db$2, String table$2, Map s) {
        if ($this.partitionExists(db$2, table$2, (Map<String, String>)s)) {
            throw new PartitionsAlreadyExistException(db$2, table$2, (Map<String, String>)s);
        }
    }

    private final /* synthetic */ boolean liftedTree1$1(CatalogDatabase dbDefinition$1) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$1.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(location);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToCreateDatabaseAsFailedToCreateDirectoryError(dbDefinition$1, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree2$1(CatalogDatabase dbDefinition$2) {
        boolean bl;
        try {
            Path location = new Path(dbDefinition$2.locationUri());
            FileSystem fs = location.getFileSystem(this.hadoopConfig);
            bl = fs.delete(location, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDropDatabaseAsFailedToDeleteDirectoryError(dbDefinition$2, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree3$1(Path defaultTableLocation$1, String table$3) {
        boolean bl;
        try {
            FileSystem fs = defaultTableLocation$1.getFileSystem(this.hadoopConfig);
            bl = fs.mkdirs(defaultTableLocation$1);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToCreateTableAsFailedToCreateDirectoryError(table$3, defaultTableLocation$1, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$createTable$1(Tuple2 x$2) {
        Object object = x$2._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$dropTable$2(InMemoryCatalog $this, URI loc) {
        boolean bl;
        Path partitionPath = new Path(loc);
        try {
            FileSystem fs = partitionPath.getFileSystem($this.hadoopConfig);
            bl = fs.delete(partitionPath, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDeletePartitionPathError(partitionPath, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree4$1(Path dir$1, String table$4) {
        boolean bl;
        try {
            FileSystem fs = dir$1.getFileSystem(this.hadoopConfig);
            bl = fs.delete(dir$1, true);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToDropTableAsFailedToDeleteDirectoryError(table$4, dir$1, e);
        }
        return bl;
    }

    private final /* synthetic */ boolean liftedTree5$1(Path oldDir$1, Path newDir$1, String oldName$1, String newName$1) {
        boolean bl;
        try {
            FileSystem fs = oldDir$1.getFileSystem(this.hadoopConfig);
            bl = fs.rename(oldDir$1, newDir$1);
        }
        catch (IOException e) {
            throw QueryExecutionErrors$.MODULE$.unableToRenameTableAsFailedToRenameDirectoryError(oldName$1, newName$1, oldDir$1, e);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$alterTable$1(Tuple2 kv) {
        Object object = kv._1();
        String string = "comment";
        return object == null ? string != null : !object.equals(string);
    }

    public static final /* synthetic */ boolean $anonfun$listViews$1(Tuple2 x$6) {
        CatalogTableType catalogTableType = ((TableDesc)x$6._2()).table().tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        return !(catalogTableType != null ? !((Object)catalogTableType).equals(catalogTableType2) : catalogTableType2 != null);
    }

    public InMemoryCatalog(SparkConf conf, Configuration hadoopConfig) {
        this.hadoopConfig = hadoopConfig;
        ExternalCatalog.$init$(this);
        this.catalog = new HashMap();
    }

    private class DatabaseDesc {
        private CatalogDatabase db;
        private final HashMap<String, TableDesc> tables;
        private final HashMap<String, CatalogFunction> functions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogDatabase db() {
            return this.db;
        }

        public void db_$eq(CatalogDatabase x$1) {
            this.db = x$1;
        }

        public HashMap<String, TableDesc> tables() {
            return this.tables;
        }

        public HashMap<String, CatalogFunction> functions() {
            return this.functions;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$DatabaseDesc$$$outer() {
            return this.$outer;
        }

        public DatabaseDesc(InMemoryCatalog $outer, CatalogDatabase db) {
            this.db = db;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.tables = new HashMap();
            this.functions = new HashMap();
        }
    }

    private class TableDesc {
        private CatalogTable table;
        private HashMap<Map<String, String>, CatalogTablePartition> partitions;
        public final /* synthetic */ InMemoryCatalog $outer;

        public CatalogTable table() {
            return this.table;
        }

        public void table_$eq(CatalogTable x$1) {
            this.table = x$1;
        }

        public HashMap<Map<String, String>, CatalogTablePartition> partitions() {
            return this.partitions;
        }

        public void partitions_$eq(HashMap<Map<String, String>, CatalogTablePartition> x$1) {
            this.partitions = x$1;
        }

        public /* synthetic */ InMemoryCatalog org$apache$spark$sql$catalyst$catalog$InMemoryCatalog$TableDesc$$$outer() {
            return this.$outer;
        }

        public TableDesc(InMemoryCatalog $outer, CatalogTable table) {
            this.table = table;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = new HashMap();
        }
    }
}

