/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unit, startTimestamp, endTimestamp) - Gets the difference between the timestamps `endTimestamp` and `startTimestamp` in the specified units by truncating the fraction part.", arguments="\n    Arguments:\n      * unit - this indicates the units of the difference between the given timestamps.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * startTimestamp - A timestamp which the expression subtracts from `endTimestamp`.\n      * endTimestamp - A timestamp from which the expression subtracts `startTimestamp`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, timestamp_ntz'2022-02-11 20:30:00', timestamp_ntz'2022-02-12 04:30:00');\n       8\n      > SELECT _FUNC_(MONTH, timestamp_ltz'2022-01-01 00:00:00', timestamp_ltz'2022-02-28 00:00:00');\n       1\n      > SELECT _FUNC_(SECOND, date'2022-01-01', timestamp'2021-12-31 23:59:50');\n       -10\n      > SELECT _FUNC_(YEAR, timestamp'2000-01-01 01:02:03.123456', timestamp'2010-01-01 01:02:03.123456');\n       10\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tUd\u0001B\u0017/\u0001nB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\tE\u0002\u0011\t\u0012)A\u00055\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005i\u0001\tE\t\u0015!\u0003f\u0011!I\u0007A!f\u0001\n\u0003!\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B3\t\u0011-\u0004!Q3A\u0005\u00021D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006I!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\u0006c\u0002!\t! \u0005\u0007c\u0002!\t!a\u0001\t\r\u0005-\u0001\u0001\"\u0011e\u0011\u0019\ti\u0001\u0001C!I\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011)\t)\u0004\u0001EC\u0002\u0013%\u0011q\u0007\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBa!!!\u0001\t\u0003J\u0006\"B\u001a\u0001\t\u0003J\u0006bBAB\u0001\u0011E\u0013Q\u0011\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#C\u0011\"a'\u0001#\u0003%\t!!(\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005U\u0006\"CA]\u0001E\u0005I\u0011AA[\u0011%\tY\fAI\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u00033\u0004\u0011\u0011!C\u0001\u00037D\u0011\"!9\u0001\u0003\u0003%\t%a9\t\u0013\u0005E\b!!A\u0005\u0002\u0005M\b\"CA|\u0001\u0005\u0005I\u0011IA}\u0011%\ti\u0010AA\u0001\n\u0003\nypB\u0005\u0003*9\n\t\u0011#\u0001\u0003,\u0019AQFLA\u0001\u0012\u0003\u0011i\u0003\u0003\u0004rK\u0011\u0005!Q\t\u0005\n\u0005\u000f*\u0013\u0011!C#\u0005\u0013B\u0011Ba\u0013&\u0003\u0003%\tI!\u0014\t\u0013\t]S%%A\u0005\u0002\u0005u\u0006\"\u0003B-K\u0005\u0005I\u0011\u0011B.\u0011%\u0011I'JI\u0001\n\u0003\ti\fC\u0005\u0003l\u0015\n\t\u0011\"\u0003\u0003n\tiA+[7fgR\fW\u000e\u001d#jM\u001aT!a\f\u0019\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003cI\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003gQ\n1a]9m\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7\u0001A\n\u0007\u0001q\u00025I\u0012'\u0011\u0005urT\"\u0001\u0018\n\u0005}r#\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0014)\u0003\u0002C]\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u0002>\t&\u0011QI\f\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:\u0004\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002N+:\u0011aj\u0015\b\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#j\na\u0001\u0010:p_Rt\u0014\"A%\n\u0005QC\u0015a\u00029bG.\fw-Z\u0005\u0003-^\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0016%\u0002\tUt\u0017\u000e^\u000b\u00025B\u00111l\u0018\b\u00039v\u0003\"a\u0014%\n\u0005yC\u0015A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!A\u0018%\u0002\u000bUt\u0017\u000e\u001e\u0011\u0002\u001dM$\u0018M\u001d;US6,7\u000f^1naV\tQ\r\u0005\u0002>M&\u0011qM\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017aD:uCJ$H+[7fgR\fW\u000e\u001d\u0011\u0002\u0019\u0015tG\rV5nKN$\u0018-\u001c9\u0002\u001b\u0015tG\rV5nKN$\u0018-\u001c9!\u0003)!\u0018.\\3[_:,\u0017\nZ\u000b\u0002[B\u0019qI\u001c.\n\u0005=D%AB(qi&|g.A\u0006uS6,'l\u001c8f\u0013\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003tiV4x\u000f\u0005\u0002>\u0001!)\u0001,\u0003a\u00015\")1-\u0003a\u0001K\")\u0011.\u0003a\u0001K\"91.\u0003I\u0001\u0002\u0004i\u0017A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002uB\u0011qi_\u0005\u0003y\"\u0013qAQ8pY\u0016\fg\u000eF\u0003t}~\f\t\u0001C\u0003Y\u0017\u0001\u0007!\fC\u0003d\u0017\u0001\u0007Q\rC\u0003j\u0017\u0001\u0007Q\rF\u0004t\u0003\u000b\t9!!\u0003\t\u000bac\u0001\u0019A3\t\u000b\rd\u0001\u0019A3\t\u000b%d\u0001\u0019A3\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAA\n!\u0015i\u0015QCA\r\u0013\r\t9b\u0016\u0002\u0004'\u0016\f\b\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}!'A\u0003usB,7/\u0003\u0003\u0002$\u0005u!\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u0015!\u0011\tY\"a\u000b\n\t\u00055\u0012Q\u0004\u0002\t\t\u0006$\u0018\rV=qK\u0006aq/\u001b;i)&lWMW8oKR\u00191)a\r\t\u000b-\f\u0002\u0019\u0001.\u0002\u0019i|g.Z%e\u0013:,e/\u00197\u0016\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u0005i&lWM\u0003\u0002\u0002D\u0005!!.\u0019<b\u0013\u0011\t9%!\u0010\u0003\ri{g.Z%eQ\r\u0011\u00121\n\t\u0004\u000f\u00065\u0013bAA(\u0011\nIAO]1og&,g\u000e^\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0007\u0003+\nY&a\u0018\u0011\u0007\u001d\u000b9&C\u0002\u0002Z!\u00131!\u00118z\u0011\u001d\tif\u0005a\u0001\u0003+\n1b\u001d;beRl\u0015n\u0019:pg\"9\u0011\u0011M\nA\u0002\u0005U\u0013!C3oI6K7M]8t\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002h\u0005M\u0014Q\u0010\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011Q\u000e\u0018\u0002\u000f\r|G-Z4f]&!\u0011\u0011OA6\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA;)\u0001\u0007\u0011qO\u0001\u0004GRD\b\u0003BA5\u0003sJA!a\u001f\u0002l\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA@)\u0001\u0007\u0011qM\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003t\u0003\u000f\u000bY\t\u0003\u0004\u0002\n^\u0001\r!Z\u0001\b]\u0016<H*\u001a4u\u0011\u0019\tii\u0006a\u0001K\u0006Aa.Z<SS\u001eDG/\u0001\u0003d_BLH#C:\u0002\u0014\u0006U\u0015qSAM\u0011\u001dA\u0006\u0004%AA\u0002iCqa\u0019\r\u0011\u0002\u0003\u0007Q\rC\u0004j1A\u0005\t\u0019A3\t\u000f-D\u0002\u0013!a\u0001[\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAPU\rQ\u0016\u0011U\u0016\u0003\u0003G\u0003B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0016%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0006\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\\U\r)\u0017\u0011U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a0+\u00075\f\t+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000b\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\f\t%\u0001\u0003mC:<\u0017b\u00011\u0002J\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u001b\t\u0004\u000f\u0006U\u0017bAAl\u0011\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QKAo\u0011%\tynHA\u0001\u0002\u0004\t\u0019.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003K\u0004b!a:\u0002n\u0006USBAAu\u0015\r\tY\u000fS\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAx\u0003S\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019!0!>\t\u0013\u0005}\u0017%!AA\u0002\u0005U\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!2\u0002|\"I\u0011q\u001c\u0012\u0002\u0002\u0003\u0007\u00111[\u0001\u0007KF,\u0018\r\\:\u0015\u0007i\u0014\t\u0001C\u0005\u0002`\u000e\n\t\u00111\u0001\u0002V!:\u0002A!\u0002\u0003\f\t5!\u0011\u0003B\n\u0005/\u0011IB!\b\u0003 \t\r\"Q\u0005\t\u0004{\t\u001d\u0011b\u0001B\u0005]\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\b\u0003\u0005\u001dtLR+O\u0007~CSO\\5uY\u0001\u001aH/\u0019:u)&lWm\u001d;b[Bd\u0003%\u001a8e)&lWm\u001d;b[BL\u0003%\f\u0011HKR\u001c\b\u0005\u001e5fA\u0011LgMZ3sK:\u001cW\r\t2fi^,WM\u001c\u0011uQ\u0016\u0004C/[7fgR\fW\u000e]:!A\u0016tG\rV5nKN$\u0018-\u001c9aA\u0005tG\r\t1ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9aA%t\u0007\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007%\u001e8jiN\u0004#-\u001f\u0011ueVt7-\u0019;j]\u001e\u0004C\u000f[3!MJ\f7\r^5p]\u0002\u0002\u0018M\u001d;/\u0003%\t'oZ;nK:$8/\t\u0002\u0003\u0016\u0005!YI\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!k:LG\u000fI\u0017!i\"L7\u000fI5oI&\u001c\u0017\r^3tAQDW\rI;oSR\u001c\be\u001c4!i\",\u0007\u0005Z5gM\u0016\u0014XM\\2fA\t,Go^3f]\u0002\"\b.\u001a\u0011hSZ,g\u000e\t;j[\u0016\u001cH/Y7qg:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003eU;qa>\u0014H/\u001a3!gR\u0014\u0018N\\4!m\u0006dW/Z:!_\u001a\u0004\u0003-\u001e8ji\u0002\u0004\u0013M]3!Q\r\f7/\u001a\u0011j]N,gn]5uSZ,\u0017F\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI-F\u0003J\u0013#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0013+V!S)\u0016\u0013&\u0005I\u0017!g\u0001jwN\u001c;ig*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5{e\n\u0016%#\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#/\u0016+5J\t\u0011.A]\u0002C-Y=t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\t\u0006K&E\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005S(V%\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tj\u0015JT+U\u000b\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\u001aViQ(O\t\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tj\u0015\n\u0014'J'\u0016\u001buJ\u0014##\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b&\u001b%kT*F\u0007>sEI\t\u0006!A\u0001\u0002\u0003\u0005\t\u0016!gR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA5\u0002\u0013\t\t;j[\u0016\u001cH/Y7qA]D\u0017n\u00195!i\",\u0007%\u001a=qe\u0016\u001c8/[8oAM,(\r\u001e:bGR\u001c\bE\u001a:p[\u0002\u0002WM\u001c3US6,7\u000f^1na\u0002t#\u0002\t\u0011!A\u0001\u0002#\u0006I3oIRKW.Z:uC6\u0004\b%\f\u0011BAQLW.Z:uC6\u0004\bE\u001a:p[\u0002:\b.[2iAQDW\rI3yaJ,7o]5p]\u0002\u001aXO\u0019;sC\u000e$8\u000f\t1ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9a])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011Y\"AB@\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"Bu*\u0016*-AQLW.Z:uC6\u0004xL\u001c;{OI\u0002$GM\u00171e5\n\u0014\u0007\t\u001a1uM\u0002$\b\r\u0019(Y\u0001\"\u0018.\\3ti\u0006l\u0007o\u00188uu\u001e\u0012\u0004G\r\u001a.aIj\u0013G\r\u00111ii\u001a\u0004G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)\u001b>sE\u000b\u0013\u0017!i&lWm\u001d;b[B|F\u000e\u001e>(eA\u0012$'\f\u00192[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007M\u0014-AQLW.Z:uC6\u0004x\f\u001c;{OI\u0002$GM\u00171e5\u0012\u0004\b\t\u00191uA\u0002$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015T\u000b\u000e{e\n\u0012\u0017!I\u0006$Xm\n\u001a1eIj\u0003'M\u00171c\u001db\u0003\u0005^5nKN$\u0018-\u001c9(eA\u0012\u0014'L\u00193[M\n\u0004EM\u001a;keRT\u0007M\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)3\u0016\u000b%\u000b\f\u0011uS6,7\u000f^1na\u001e\u0012\u0004\u0007\r\u0019.aEj\u0003'\r\u00111ci\u0002$G\u000f\u00194]E\u00124\u0007N\u001b7O1\u0002C/[7fgR\fW\u000e]\u00143aE\u0002T\u0006M\u0019.aE\u0002\u0003'\r\u001e1ei\u00024GL\u00193gQ*dgJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AE\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0005\u0012A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005O\tQa\r\u00184]A\nQ\u0002V5nKN$\u0018-\u001c9ES\u001a4\u0007CA\u001f&'\u0015)#q\u0006B\u001e!%\u0011\tDa\u000e[K\u0016l7/\u0004\u0002\u00034)\u0019!Q\u0007%\u0002\u000fI,h\u000e^5nK&!!\u0011\bB\u001a\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005{\u0011\u0019%\u0004\u0002\u0003@)!!\u0011IA!\u0003\tIw.C\u0002W\u0005\u007f!\"Aa\u000b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013M\u0014yE!\u0015\u0003T\tU\u0003\"\u0002-)\u0001\u0004Q\u0006\"B2)\u0001\u0004)\u0007\"B5)\u0001\u0004)\u0007bB6)!\u0003\u0005\r!\\\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u00059QO\\1qa2LH\u0003\u0002B/\u0005K\u0002Ba\u00128\u0003`A9qI!\u0019[K\u0016l\u0017b\u0001B2\u0011\n1A+\u001e9mKRB\u0001Ba\u001a+\u0003\u0003\u0005\ra]\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003pA!\u0011q\u0019B9\u0013\u0011\u0011\u0019(!3\u0003\r=\u0013'.Z2u\u0001")
public class TimestampDiff
extends BinaryExpression
implements ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression startTimestamp;
    private final Expression endTimestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampDiff$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampDiff x$0) {
        return TimestampDiff$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return TimestampDiff$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampDiff> tupled() {
        return TimestampDiff$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampDiff>>>> curried() {
        return TimestampDiff$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression startTimestamp() {
        return this.startTimestamp;
    }

    public Expression endTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.startTimestamp();
    }

    @Override
    public Expression right() {
        return this.endTimestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)TimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampDiff timestampDiff = this;
        synchronized (timestampDiff) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.endTimestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object startMicros, Object endMicros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampDiff(this.unit(), BoxesRunTime.unboxToLong((Object)startMicros), BoxesRunTime.unboxToLong((Object)endMicros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(s, e) -> dtu + ".timestampDiff(\"" + this.unit() + "\", " + s + ", " + e + ", " + zid + ")");
    }

    @Override
    public String prettyName() {
        return "timestampdiff";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((IterableOnceOps)((SeqOps)this.children().map((Function1 & Serializable)x$18 -> x$18.sql())).$plus$colon((Object)string)).mkString(", ");
        return this.prettyName() + "(" + childrenSQL + ")";
    }

    @Override
    public TimestampDiff withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampDiff copy(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        return new TimestampDiff(unit, startTimestamp, endTimestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.startTimestamp();
    }

    public Expression copy$default$3() {
        return this.endTimestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampDiff";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.startTimestamp();
            }
            case 2: {
                return this.endTimestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampDiff;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "startTimestamp";
            }
            case 2: {
                return "endTimestamp";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampDiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampDiff timestampDiff = (TimestampDiff)x$1;
        String string = this.unit();
        String string2 = timestampDiff.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.startTimestamp();
        Expression expression2 = timestampDiff.startTimestamp();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.endTimestamp();
        Expression expression4 = timestampDiff.endTimestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampDiff.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampDiff.canEqual(this)) return false;
        return true;
    }

    public TimestampDiff(String unit, Expression startTimestamp, Expression endTimestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public TimestampDiff(String unit, Expression startTimestamp, Expression endTimestamp) {
        this(unit, startTimestamp, endTimestamp, (Option<String>)None$.MODULE$);
    }

    public TimestampDiff(Expression unit, Expression startTimestamp, Expression endTimestamp) {
        this(TimeZoneAwareExpression$.MODULE$.convertExpressionToUnit(unit, "timestamp_diff"), startTimestamp, endTimestamp);
    }
}

