/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.IntervalMathUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the negated value of `expr`.", examples="\n    Examples:\n      > SELECT _FUNC_(1);\n       -1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t5a\u0001\u0002\u0013&\u0001JB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003U\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015i\u0006\u0001\"\u0011T\u0011\u0015A\u0006\u0001\"\u0001_\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\u0001\b\u0001\"\u0011T\u0011\u0015\t\b\u0001\"\u0011s\u0011!Y\b\u0001#b\u0001\n\u0013a\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003K\u0001A\u0011KA\u0014\u0011\u0019Q\u0003\u0001\"\u0011\u0002.!9\u0011q\u0006\u0001\u0005R\u0005E\u0002\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u0011%\ty\u0004AI\u0001\n\u0003\t\t\u0005C\u0005\u0002X\u0001\t\n\u0011\"\u0001\u0002Z!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0013q\f\u0005\n\u0003_\u0002\u0011\u0011!C\u0001\u0003cB\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\r\u0005\"CAI\u0001\u0005\u0005I\u0011AAJ\u0011%\t9\nAA\u0001\n\u0003\nI\nC\u0005\u0002\u001e\u0002\t\t\u0011\"\u0011\u0002 \u001eI\u00111Y\u0013\u0002\u0002#\u0005\u0011Q\u0019\u0004\tI\u0015\n\t\u0011#\u0001\u0002H\"1\u0001\f\bC\u0001\u0003?D\u0001\"\u001d\u000f\u0002\u0002\u0013\u0015\u0013\u0011\u001d\u0005\n\u0003Gd\u0012\u0011!CA\u0003KD\u0011\"a;\u001d#\u0003%\t!!\u0017\t\u0013\u00055H$!A\u0005\u0002\u0006=\b\"\u0003B\u00019E\u0005I\u0011AA-\u0011%\u0011\u0019\u0001HA\u0001\n\u0013\u0011)A\u0001\u0006V]\u0006\u0014\u00180T5okNT!AJ\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q%\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\u0006\u0001M:$\b\u0011\t\u0003iUj\u0011!J\u0005\u0003m\u0015\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003iaJ!!O\u0013\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u0013:\u0011!i\u0012\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bF\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005!c\u0014a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0013\u001f\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u00039\u0003\"\u0001N(\n\u0005A+#AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n1BZ1jY>sWI\u001d:peV\tA\u000b\u0005\u0002<+&\u0011a\u000b\u0010\u0002\b\u0005>|G.Z1o\u000311\u0017-\u001b7P]\u0016\u0013(o\u001c:!\u0003\u0019a\u0014N\\5u}Q\u0019!l\u0017/\u0011\u0005Q\u0002\u0001\"\u0002'\u0006\u0001\u0004q\u0005b\u0002*\u0006!\u0003\u0005\r\u0001V\u0001\u000f]VdG.\u00138u_2,'/\u00198u)\tQv\fC\u0003M\u000f\u0001\u0007a*\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u0019\t\u0004\u0003\u000e,\u0017B\u00013L\u0005\r\u0019V-\u001d\t\u0003M&l\u0011a\u001a\u0006\u0003Q&\nQ\u0001^=qKNL!A[4\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00035\u0004\"A\u001a8\n\u0005=<'\u0001\u0003#bi\u0006$\u0016\u0010]3\u00025\r|g\u000e^3yi&sG-\u001a9f]\u0012,g\u000e\u001e$pY\u0012\f'\r\\3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u001d\t\u0003ibt!!\u001e<\u0011\u0005\rc\u0014BA<=\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]d\u0014a\u00028v[\u0016\u0014\u0018nY\u000b\u0002{B!\u0011I`A\u0001\u0013\ty8JA\u0004Ok6,'/[2\u0011\u0007m\n\u0019!C\u0002\u0002\u0006q\u00121!\u00118z\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\f\u0005]\u0011\u0011\u0005\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0013\u0002\u000f\r|G-Z4f]&!\u0011QCA\b\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\r\u001b\u0001\u0007\u00111D\u0001\u0004GRD\b\u0003BA\u0007\u0003;IA!a\b\u0002\u0010\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u0012\u001b\u0001\u0007\u00111B\u0001\u0003KZ\fAB\\;mYN\u000bg-Z#wC2$B!!\u0001\u0002*!9\u00111\u0006\bA\u0002\u0005\u0005\u0011!B5oaV$X#A:\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\rQ\u00161\u0007\u0005\u0007\u0003k\u0001\u0002\u0019\u0001(\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR)!,a\u000f\u0002>!9A*\u0005I\u0001\u0002\u0004q\u0005b\u0002*\u0012!\u0003\u0005\r\u0001V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019EK\u0002O\u0003\u000bZ#!a\u0012\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003#b\u0014AC1o]>$\u0018\r^5p]&!\u0011QKA&\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYFK\u0002U\u0003\u000b\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nA\u0001\\1oO*\u0011\u00111N\u0001\u0005U\u00064\u0018-C\u0002z\u0003K\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001d\u0011\u0007m\n)(C\u0002\u0002xq\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0001\u0002~!I\u0011q\u0010\f\u0002\u0002\u0003\u0007\u00111O\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0015\u0005CBAD\u0003\u001b\u000b\t!\u0004\u0002\u0002\n*\u0019\u00111\u0012\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0010\u0006%%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2\u0001VAK\u0011%\ty\bGA\u0001\u0002\u0004\t\t!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA1\u00037C\u0011\"a \u001a\u0003\u0003\u0005\r!a\u001d\u0002\r\u0015\fX/\u00197t)\r!\u0016\u0011\u0015\u0005\n\u0003\u007fR\u0012\u0011!a\u0001\u0003\u0003A3\u0003AAS\u0003W\u000bi+!-\u00024\u0006]\u0016\u0011XA_\u0003\u007f\u00032\u0001NAT\u0013\r\tI+\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\ty+A\u001a`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t8fO\u0006$X\r\u001a\u0011wC2,X\rI8gA\u0001,\u0007\u0010\u001d:a]\u0005AQ\r_1na2,7/\t\u0002\u00026\u0006)$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001j\u0013G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\tY,A\u00032]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002B\u0006QQ.\u0019;i?\u001a,hnY:\u0002\u0015Us\u0017M]=NS:,8\u000f\u0005\u000259M)A$!3\u0002VB9\u00111ZAi\u001dRSVBAAg\u0015\r\ty\rP\u0001\beVtG/[7f\u0013\u0011\t\u0019.!4\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0005\u0003\u0002X\u0006uWBAAm\u0015\u0011\tY.!\u001b\u0002\u0005%|\u0017b\u0001&\u0002ZR\u0011\u0011Q\u0019\u000b\u0003\u0003C\nQ!\u00199qYf$RAWAt\u0003SDQ\u0001T\u0010A\u00029CqAU\u0010\u0011\u0002\u0003\u0007A+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$B!!=\u0002~B)1(a=\u0002x&\u0019\u0011Q\u001f\u001f\u0003\r=\u0003H/[8o!\u0015Y\u0014\u0011 (U\u0013\r\tY\u0010\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005}\u0018%!AA\u0002i\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u0001\t\u0005\u0003G\u0012I!\u0003\u0003\u0003\f\u0005\u0015$AB(cU\u0016\u001cG\u000f")
public class UnaryMinus
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return UnaryMinus$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(UnaryMinus x$0) {
        return UnaryMinus$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return UnaryMinus$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, UnaryMinus> tupled() {
        return UnaryMinus$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, UnaryMinus>> curried() {
        return UnaryMinus$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.NumericAndInterval(), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public String toString() {
        return "-" + this.child();
    }

    private Numeric<Object> numeric$lzycompute() {
        UnaryMinus unaryMinus = this;
        synchronized (unaryMinus) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + ".unary_$minus()");
        }
        if ((ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) && this.failOnError()) {
            String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> ev.value() + " = " + mathUtils + ".negateExact(" + eval + ");");
        }
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                String originValue = ctx.freshName("origin");
                return "\n        " + CodeGenerator$.MODULE$.javaType((DataType)numericType) + " " + originValue + " = (" + CodeGenerator$.MODULE$.javaType((DataType)numericType) + ")(" + eval + ");\n        " + ev.value() + " = (" + CodeGenerator$.MODULE$.javaType((DataType)numericType) + ")(-(" + originValue + "));\n      ";
            });
        }
        if (dataType instanceof CalendarIntervalType) {
            String iu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalUtils$.MODULE$.getClass().getCanonicalName()), "$");
            String method = this.failOnError() ? "negateExact" : "negate";
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> iu + "." + method + "(" + c + ")");
        }
        if (dataType instanceof AnsiIntervalType) {
            return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> {
                String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(IntervalMathUtils$.MODULE$.getClass().getCanonicalName()), "$");
                return ev.value() + " = " + mathUtils + ".negateExact(" + eval + ");";
            });
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object input) {
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                return IntervalUtils$.MODULE$.negateExact((CalendarInterval)input);
            }
        }
        if (bl) {
            return IntervalUtils$.MODULE$.negate((CalendarInterval)input);
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            return BoxesRunTime.boxToLong((long)IntervalMathUtils$.MODULE$.negateExact(BoxesRunTime.unboxToLong((Object)input)));
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            return BoxesRunTime.boxToInteger((int)IntervalMathUtils$.MODULE$.negateExact(BoxesRunTime.unboxToInt((Object)input)));
        }
        return this.numeric().negate(input);
    }

    @Override
    public String sql() {
        String string = (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "-");
        switch (string == null ? 0 : string.hashCode()) {
            case 45: {
                if (!"-".equals(string)) break;
                return "(- " + this.child().sql() + ")";
            }
        }
        return string + "(" + this.child().sql() + ")";
    }

    @Override
    public UnaryMinus withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public UnaryMinus copy(Expression child, boolean failOnError) {
        return new UnaryMinus(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "UnaryMinus";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UnaryMinus;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UnaryMinus)) return false;
        boolean bl = true;
        if (!bl) return false;
        UnaryMinus unaryMinus = (UnaryMinus)x$1;
        if (this.failOnError() != unaryMinus.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = unaryMinus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!unaryMinus.canEqual(this)) return false;
        return true;
    }

    public UnaryMinus(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public UnaryMinus(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

