/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TernaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, k, maxItemsTracked) - Returns top k items with their frequency.\n      `k` An optional INTEGER literal greater than 0. If k is not specified, it defaults to 5.\n      `maxItemsTracked` An optional INTEGER literal greater than or equal to k and has upper limit of 1000000. If maxItemsTracked is not specified, it defaults to 10000.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(expr) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT _FUNC_(expr, 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' AS tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n\n      > SELECT _FUNC_(expr, 10, 100) FROM VALUES (0), (1), (1), (2), (2), (2) AS tab(expr);\n       [{\"item\":2,\"count\":3},{\"item\":1,\"count\":2},{\"item\":0,\"count\":1}]\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\rUe\u0001\u0002(P\u0001zC!\"a\u0007\u0001\u0005+\u0007I\u0011AA\u000f\u0011%\ty\u0002\u0001B\tB\u0003%1\u0010\u0003\u0006\u0002\"\u0001\u0011)\u001a!C\u0001\u0003;A\u0011\"a\t\u0001\u0005#\u0005\u000b\u0011B>\t\u0015\u0005\u0015\u0002A!f\u0001\n\u0003\ti\u0002C\u0005\u0002(\u0001\u0011\t\u0012)A\u0005w\"Q\u0011\u0011\u0006\u0001\u0003\u0016\u0004%\t!a\u000b\t\u0015\u0005M\u0002A!E!\u0002\u0013\ti\u0003\u0003\u0006\u00026\u0001\u0011)\u001a!C\u0001\u0003WA!\"a\u000e\u0001\u0005#\u0005\u000b\u0011BA\u0017\u0011\u001d\tI\u0004\u0001C\u0001\u0003wAq!!\u000f\u0001\t\u0003\tI\u0005C\u0004\u0002:\u0001!\t!!\u0016\t\u000f\u0005e\u0002\u0001\"\u0001\u0002^!9\u0011\u0011\b\u0001\u0005\u0002\u0005\r\u0004bBA\u001d\u0001\u0011\u0005\u0011\u0011\u000e\u0005\u000b\u0003[\u0002\u0001R1A\u0005\n\u0005=\u0004BCA?\u0001!\u0015\r\u0011\"\u0003\u0002,!Q\u0011q\u0010\u0001\t\u0006\u0004%I!a\u000b\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u001e!9\u00111\u0011\u0001\u0005B\u0005u\u0001bBAC\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003\u000f\u0003A\u0011IAE\u0011\u001d\t9\n\u0001C!\u00033Cq!a*\u0001\t\u0003\ny\u0007C\u0004\u0002*\u0002!\t%a+\t\u000f\u00055\u0006\u0001\"\u0011\u00020\"9\u0011\u0011\u0019\u0001\u0005B\u0005\r\u0007bBAe\u0001\u0011\u0005\u00131\u001a\u0005\b\u00037\u0004A\u0011IAo\u0011\u001d\ti\u000f\u0001C!\u0003_Dq!!>\u0001\t\u0003\n9\u0010C\u0004\u0003\u0004\u0001!\tE!\u0002\t\u000f\t-\u0001\u0001\"\u0015\u0003\u000e!9!1\u0004\u0001\u0005B\tu\u0001b\u0002B\u0013\u0001\u0011\u0005#q\u0005\u0005\n\u0005s\u0001\u0011\u0011!C\u0001\u0005wA\u0011Ba\u0012\u0001#\u0003%\tA!\u0013\t\u0013\t}\u0003!%A\u0005\u0002\t%\u0003\"\u0003B1\u0001E\u0005I\u0011\u0001B%\u0011%\u0011\u0019\u0007AI\u0001\n\u0003\u0011)\u0007C\u0005\u0003j\u0001\t\n\u0011\"\u0001\u0003f!I!1\u000e\u0001\u0002\u0002\u0013\u0005#Q\u000e\u0005\n\u0005{\u0002\u0011\u0011!C\u0001\u0003WA\u0011Ba \u0001\u0003\u0003%\tA!!\t\u0013\t\u001d\u0005!!A\u0005B\t%\u0005\"\u0003BL\u0001\u0005\u0005I\u0011\u0001BM\u0011%\u0011i\nAA\u0001\n\u0003\u0012y\nC\u0005\u0003$\u0002\t\t\u0011\"\u0011\u0003&\u001e9!\u0011Z(\t\u0002\t-gA\u0002(P\u0011\u0003\u0011i\rC\u0004\u0002:M\"\tAa8\t\u0013\t\u00058G1A\u0005\u0002\u0005-\u0002\u0002\u0003Brg\u0001\u0006I!!\f\t\u0013\t\u00158G1A\u0005\u0002\u0005-\u0002\u0002\u0003Btg\u0001\u0006I!!\f\t\u0013\t%8G1A\u0005\n\u0005-\u0002\u0002\u0003Bvg\u0001\u0006I!!\f\t\u000f\t58\u0007\"\u0001\u0003p\"9!Q`\u001a\u0005\u0002\t}\bbBB\u0002g\u0011\u00051Q\u0001\u0005\b\u0007\u0007\u0019D\u0011AB\u0005\u0011\u001d\u0019ya\rC\u0001\u0007#Aqa!\u00064\t\u0003\u00199\u0002C\u0004\u0004\u001eM\"\taa\b\t\u000f\u0005%6\u0007\"\u0001\u0004$!91QF\u001a\u0005\u0002\r=\u0002bBB\u001cg\u0011\u00051\u0011\b\u0005\b\u0007\u0007\u001aD\u0011AB#\u0011\u001d\u0019)f\rC\u0001\u0007/B\u0011b!\u00194\u0003\u0003%\tia\u0019\t\u0013\r=4'%A\u0005\u0002\t\u0015\u0004\"CB9gE\u0005I\u0011\u0001B3\u0011%\u0019\u0019hMA\u0001\n\u0003\u001b)\bC\u0005\u0004\bN\n\n\u0011\"\u0001\u0003f!I1\u0011R\u001a\u0012\u0002\u0013\u0005!Q\r\u0005\n\u0007\u0017\u001b\u0014\u0011!C\u0005\u0007\u001b\u0013!\"\u00119qe>DHk\u001c9L\u0015\t\u0001\u0016+A\u0005bO\u001e\u0014XmZ1uK*\u0011!kU\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002U+\u0006A1-\u0019;bYf\u001cHO\u0003\u0002W/\u0006\u00191/\u001d7\u000b\u0005aK\u0016!B:qCJ\\'B\u0001.\\\u0003\u0019\t\u0007/Y2iK*\tA,A\u0002pe\u001e\u001c\u0001aE\u0004\u0001?F,h0a\u0001\u0011\u0007\u0001\f7-D\u0001P\u0013\t\u0011wJ\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003-1'/Z9vK:\u001c\u0017.Z:\u000b\u0005!L\u0016\u0001\u00043bi\u0006\u001c8.\u001a;dQ\u0016\u001c\u0018B\u00016f\u0005-IE/Z7t'.,Go\u00195\u0011\u00051|W\"A7\u000b\u00039\fQa]2bY\u0006L!\u0001]7\u0003\u0007\u0005s\u0017\u0010\u0005\u0002sg6\t\u0011+\u0003\u0002u#\n1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002wsnl\u0011a\u001e\u0006\u0003qN\u000bQ\u0001\u001e:fKNL!A_<\u0003\u0017Q+'O\\1ss2K7.\u001a\t\u0003erL!!`)\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002m\u007f&\u0019\u0011\u0011A7\u0003\u000fA\u0013x\u000eZ;diB!\u0011QAA\u000b\u001d\u0011\t9!!\u0005\u000f\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004^\u0003\u0019a$o\\8u}%\ta.C\u0002\u0002\u00145\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0005e!\u0001D*fe&\fG.\u001b>bE2,'bAA\n[\u0006!Q\r\u001f9s+\u0005Y\u0018!B3yaJ\u0004\u0013!A6\u0002\u0005-\u0004\u0013aD7bq&#X-\\:Ue\u0006\u001c7.\u001a3\u0002!5\f\u00070\u0013;f[N$&/Y2lK\u0012\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0005\u00055\u0002c\u00017\u00020%\u0019\u0011\u0011G7\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\r\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013q\t\t\u0003A\u0002Aa!a\u0007\f\u0001\u0004Y\bBBA\u0011\u0017\u0001\u00071\u0010\u0003\u0004\u0002&-\u0001\ra\u001f\u0005\n\u0003SY\u0001\u0013!a\u0001\u0003[A\u0011\"!\u000e\f!\u0003\u0005\r!!\f\u0015\u0011\u0005u\u00121JA(\u0003'Ba!!\u0014\r\u0001\u0004Y\u0018!B2iS2$\u0007BBA)\u0019\u0001\u000710\u0001\u0003u_B\\\u0005BBA\u0013\u0019\u0001\u00071\u0010\u0006\u0005\u0002>\u0005]\u0013\u0011LA.\u0011\u0019\ti%\u0004a\u0001w\"9\u0011\u0011K\u0007A\u0002\u00055\u0002bBA\u0013\u001b\u0001\u0007\u0011Q\u0006\u000b\u0007\u0003{\ty&!\u0019\t\r\u00055c\u00021\u0001|\u0011\u0019\t\tF\u0004a\u0001wR1\u0011QHA3\u0003OBa!!\u0014\u0010\u0001\u0004Y\bbBA)\u001f\u0001\u0007\u0011Q\u0006\u000b\u0005\u0003{\tY\u0007\u0003\u0004\u0002NA\u0001\ra_\u0001\rSR,W\u000eR1uCRK\b/Z\u000b\u0003\u0003c\u0002B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o*\u0016!\u0002;za\u0016\u001c\u0018\u0002BA>\u0003k\u0012\u0001\u0002R1uCRK\b/Z\u0001\u0005WZ\u000bG.\u0001\nnCbLE/Z7t)J\f7m[3e-\u0006d\u0017!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0006j]B,H\u000fV=qKN,\"!a#\u0011\r\u0005\u0015\u0011QRAI\u0013\u0011\ty)!\u0007\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002t\u0005M\u0015\u0002BAK\u0003k\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005m\u0005\u0003BAO\u0003Gk!!a(\u000b\u0007\u0005\u00056+\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t)+a(\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u0001\u0018GJ,\u0017\r^3BO\u001e\u0014XmZ1uS>t')\u001e4gKJ$\u0012aY\u0001\u0007kB$\u0017\r^3\u0015\u000b\r\f\t,!.\t\r\u0005M6\u00041\u0001d\u0003\u0019\u0011WO\u001a4fe\"9\u0011qW\u000eA\u0002\u0005e\u0016!B5oaV$\b\u0003BA^\u0003{k\u0011aU\u0005\u0004\u0003\u007f\u001b&aC%oi\u0016\u0014h.\u00197S_^\fQ!\\3sO\u0016$RaYAc\u0003\u000fDa!a-\u001d\u0001\u0004\u0019\u0007BBA\\9\u0001\u00071-\u0001\u0003fm\u0006dG\u0003BAg\u00033\u0004B!a4\u0002V6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'\u001c\u0016\u0001B;uS2LA!a6\u0002R\n\u0001r)\u001a8fe&\u001c\u0017I\u001d:bs\u0012\u000bG/\u0019\u0005\u0007\u0003gk\u0002\u0019A2\u0002\u0013M,'/[1mSj,G\u0003BAp\u0003W\u0004R\u0001\\Aq\u0003KL1!a9n\u0005\u0015\t%O]1z!\ra\u0017q]\u0005\u0004\u0003Sl'\u0001\u0002\"zi\u0016Da!a-\u001f\u0001\u0004\u0019\u0017a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2aYAy\u0011\u001d\t\u0019p\ba\u0001\u0003?\fQb\u001d;pe\u0006<WMR8s[\u0006$\u0018!H<ji\"tUm^'vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005e\u0018q \t\u0004A\u0006m\u0018bAA\u007f\u001f\n\u0019\u0012*\u001c9fe\u0006$\u0018N^3BO\u001e\u0014XmZ1uK\"9!\u0011\u0001\u0011A\u0002\u00055\u0012!\u00078fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA}\u0005\u000fAqA!\u0003\"\u0001\u0004\ti#A\foK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\bw\n=!1\u0003B\f\u0011\u0019\u0011\tB\ta\u0001w\u00069a.Z<FqB\u0014\bB\u0002B\u000bE\u0001\u000710\u0001\u0003oK^\\\u0005B\u0002B\rE\u0001\u000710\u0001\noK^l\u0015\r_%uK6\u001cHK]1dW\u0016$\u0017\u0001\u00038vY2\f'\r\\3\u0016\u0005\t}\u0001c\u00017\u0003\"%\u0019!1E7\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\t%\u0002\u0003\u0002B\u0016\u0005gqAA!\f\u00030A\u0019\u0011\u0011B7\n\u0007\tER.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005k\u00119D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005ci\u0017\u0001B2paf$B\"!\u0010\u0003>\t}\"\u0011\tB\"\u0005\u000bB\u0001\"a\u0007&!\u0003\u0005\ra\u001f\u0005\t\u0003C)\u0003\u0013!a\u0001w\"A\u0011QE\u0013\u0011\u0002\u0003\u00071\u0010C\u0005\u0002*\u0015\u0002\n\u00111\u0001\u0002.!I\u0011QG\u0013\u0011\u0002\u0003\u0007\u0011QF\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YEK\u0002|\u0005\u001bZ#Aa\u0014\u0011\t\tE#1L\u0007\u0003\u0005'RAA!\u0016\u0003X\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053j\u0017AC1o]>$\u0018\r^5p]&!!Q\fB*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003h)\"\u0011Q\u0006B'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B8!\u0011\u0011\tHa\u001f\u000e\u0005\tM$\u0002\u0002B;\u0005o\nA\u0001\\1oO*\u0011!\u0011P\u0001\u0005U\u00064\u0018-\u0003\u0003\u00036\tM\u0014\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004W\n\r\u0005\"\u0003BC[\u0005\u0005\t\u0019AA\u0017\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0012\t\u0006\u0005\u001b\u0013\u0019j[\u0007\u0003\u0005\u001fS1A!%n\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005+\u0013yI\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u0010\u00057C\u0001B!\"0\u0003\u0003\u0005\ra[\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003p\t\u0005\u0006\"\u0003BCa\u0005\u0005\t\u0019AA\u0017\u0003\u0019)\u0017/^1mgR!!q\u0004BT\u0011!\u0011))MA\u0001\u0002\u0004Y\u0007f\u0005\u0001\u0003,\nE&1\u0017B\\\u0005s\u0013iLa0\u0003D\n\u0015\u0007c\u0001:\u0003.&\u0019!qV)\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!QW\u0001\u0003<*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014H\u0006I6-A5\f\u00070\u0013;f[N$&/Y2lK\u0012L\u0003%\f\u0011SKR,(O\\:!i>\u0004\be\u001b\u0011ji\u0016l7\u000fI<ji\"\u0004C\u000f[3je\u00022'/Z9vK:\u001c\u0017P\f\u0006!A\u0001\u0002\u0003\u0005\t1lA\u0002\ne\u000eI8qi&|g.\u00197!\u0013:#ViR#SA1LG/\u001a:bY\u0002:'/Z1uKJ\u0004C\u000f[1oAAr\u0003%\u00134!W\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011ji\u0002\"WMZ1vYR\u001c\b\u0005^8!k9R\u0001\u0005\t\u0011!A\u0001\u0002W.\u0019=Ji\u0016l7\u000f\u0016:bG.,G\r\u0019\u0011B]\u0002z\u0007\u000f^5p]\u0006d\u0007%\u0013(U\u000b\u001e+%\u000b\t7ji\u0016\u0014\u0018\r\u001c\u0011he\u0016\fG/\u001a:!i\"\fg\u000eI8sA\u0015\fX/\u00197!i>\u00043\u000eI1oI\u0002B\u0017m\u001d\u0011vaB,'\u000f\t7j[&$\be\u001c4!cA\u0002\u0004\u0007\r\u00191]\u0001Je\rI7bq&#X-\\:Ue\u0006\u001c7.\u001a3!SN\u0004cn\u001c;!gB,7-\u001b4jK\u0012d\u0003%\u001b;!I\u00164\u0017-\u001e7ug\u0002\"x\u000eI\u00191aA\u0002dF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B^\u0003\u0011m\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK3yaJL\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QAJC\u0006\t\u00152S1\u0002\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)g%b\u0003\u0005\u000b\u001b*Y\u0001BC'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015fqB\u0014\u0018f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\w\nJG/Z7#uAb#eY8v]R\u0014#HM?-w\nJG/Z7#uQb#eY8v]R\u0014#HM?-w\nJG/Z7#uEb#eY8v]R\u0014#HM?-w\nJG/Z7#uIb#eY8v]R\u0014#(M?-w\nJG/Z7#uMb#eY8v]R\u0014#(M?^\u0015)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CS\r\u001f9sY\u0001\u0012\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003s%Y\u0014-A\u001d\u0012w\u0005\f\u0011(G\u001eb\u0003eJ2(Y\u0001:3m\n\u0017!O\r<C\u0006I\u0014eO1\u0002s\u0005Z\u0014!\u0003N\u0003C/\u00192)Kb\u0004(/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0014\u0013\u000e^3nEi\u00123M\t\u0017#G>,h\u000e\u001e\u0012;iud3PI5uK6\u0014#H\t3#Y\t\u001aw.\u001e8uEi\u0012T0\u0018\u0006\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0015D\bO\u001d\u0017!cAb\u0003%\r\u00191S\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152S1\u0002\u0003&M\u0015-A!\u0012\u0014\u0006\f\u0011)e%b\u0003\u0005\u000b\u001a*A\u0005\u001b\u0006\u0005^1cQ\u0015D\bO]\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!Am[(%\u001b;f[\nR$\u0007\f\u0012d_VtGO\t\u001e4{2Z(%\u001b;f[\nR\u0014\u0007\f\u0012d_VtGO\t\u001e3{2Z(%\u001b;f[\nR\u0004\u0007\f\u0012d_VtGO\t\u001e2{vS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005\u0003\f\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\t\u001d\u0017!\u0002\u001b/c9\u0002\u0014AC!qaJ|\u0007\u0010V8q\u0017B\u0011\u0001mM\n\u0006g\t='Q\u001b\t\u0004Y\nE\u0017b\u0001Bj[\n1\u0011I\\=SK\u001a\u0004BAa6\u0003^6\u0011!\u0011\u001c\u0006\u0005\u00057\u00149(\u0001\u0002j_&!\u0011q\u0003Bm)\t\u0011Y-A\u0005E\u000b\u001a\u000bU\u000b\u0014+`\u0017\u0006QA)\u0012$B+2#vl\u0013\u0011\u00023\u0011+e)Q+M)~k\u0015\tW0J)\u0016k5k\u0018+S\u0003\u000e[U\tR\u0001\u001b\t\u00163\u0015)\u0016'U?6\u000b\u0005lX%U\u000b6\u001bv\f\u0016*B\u0007.+E\tI\u0001\u0018\u001b\u0006Cv,\u0013+F\u001bN{FKU!D\u0017\u0016#u\fT%N\u0013R\u000b\u0001$T!Y?&#V)T*`)J\u000b5iS#E?2KU*\u0013+!\u0003Y\u0019\u0007.Z2l\u000bb\u0004(/Z:tS>tgj\u001c;Ok2dGC\u0002By\u0005o\u0014I\u0010E\u0002m\u0005gL1A!>n\u0005\u0011)f.\u001b;\t\r\u0005m1\b1\u0001|\u0011\u001d\u0011Yp\u000fa\u0001\u0005S\t\u0001\"\u001a=qe:\u000bW.Z\u0001\u0007G\",7m[&\u0015\t\tE8\u0011\u0001\u0005\b\u0003Ca\u0004\u0019AA\u0017\u0003Q\u0019\u0007.Z2l\u001b\u0006D\u0018\n^3ngR\u0013\u0018mY6fIR!!\u0011_B\u0004\u0011\u001d\t)#\u0010a\u0001\u0003[!bA!=\u0004\f\r5\u0001bBA\u0013}\u0001\u0007\u0011Q\u0006\u0005\b\u0003Cq\u0004\u0019AA\u0017\u0003E9W\r\u001e*fgVdG\u000fR1uCRK\b/\u001a\u000b\u0005\u0003c\u001a\u0019\u0002C\u0004\u0002n}\u0002\r!!\u001d\u0002'%\u001cH)\u0019;b)f\u0004XmU;qa>\u0014H/\u001a3\u0015\t\t}1\u0011\u0004\u0005\b\u00077\u0001\u0005\u0019AA9\u0003!IG/Z7UsB,\u0017!D2bY6\u000b\u00070T1q'&TX\r\u0006\u0003\u0002.\r\u0005\u0002bBA\u0013\u0003\u0002\u0007\u0011Q\u0006\u000b\u0006G\u000e\u00152\u0011\u0006\u0005\u0007\u0007O\u0011\u0005\u0019A>\u0002\u001d%$X-\\#yaJ,7o]5p]\"911\u0006\"A\u0002\u00055\u0012AC7bq6\u000b\u0007oU5{K\u0006\u0011R\u000f\u001d3bi\u0016\u001c6.\u001a;dQ\n+hMZ3s)\u001d\u00197\u0011GB\u001a\u0007kAaaa\nD\u0001\u0004Y\bBBAZ\u0007\u0002\u00071\rC\u0004\u00028\u000e\u0003\r!!/\u0002\u001b\u001d,g.\u0012<bYJ+7/\u001e7u)!\tima\u000f\u0004@\r\u0005\u0003BBB\u001f\t\u0002\u00071-A\u0006ji\u0016l7oU6fi\u000eD\u0007bBA\u0011\t\u0002\u0007\u0011Q\u0006\u0005\b\u0003[\"\u0005\u0019AA9\u000399WM\\*lKR\u001c\u0007nU3s\t\u0016$Baa\u0012\u0004TA)1\u0011JB(W6\u001111\n\u0006\u0004\u0007\u001b:\u0017AB2p[6|g.\u0003\u0003\u0004R\r-#!E!se\u0006LxJZ%uK6\u001c8+\u001a:EK\"9\u0011qU#A\u0002\u0005E\u0014AF4fiN[W\r^2i'R\fG/\u001a#bi\u0006$\u0016\u0010]3\u0015\t\re3q\f\t\u0005\u0003g\u001aY&\u0003\u0003\u0004^\u0005U$AC*ueV\u001cG\u000fV=qK\"9\u0011Q\u000e$A\u0002\u0005E\u0014!B1qa2LH\u0003DA\u001f\u0007K\u001a9g!\u001b\u0004l\r5\u0004BBA\u000e\u000f\u0002\u00071\u0010\u0003\u0004\u0002\"\u001d\u0003\ra\u001f\u0005\u0007\u0003K9\u0005\u0019A>\t\u0013\u0005%r\t%AA\u0002\u00055\u0002\"CA\u001b\u000fB\u0005\t\u0019AA\u0017\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aD1qa2LH\u0005Z3gCVdG\u000fJ\u001b\u0002\u000fUt\u0017\r\u001d9msR!1qOBB!\u0015a7\u0011PB?\u0013\r\u0019Y(\u001c\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00151\u001cyh_>|\u0003[\ti#C\u0002\u0004\u00026\u0014a\u0001V;qY\u0016,\u0004\"CBC\u0015\u0006\u0005\t\u0019AA\u001f\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0019y\t\u0005\u0003\u0003r\rE\u0015\u0002BBJ\u0005g\u0012aa\u00142kK\u000e$\b")
public class ApproxTopK
extends TypedImperativeAggregate<ItemsSketch<Object>>
implements ImplicitCastInputTypes,
TernaryLike<Expression>,
Serializable {
    private DataType itemDataType;
    private int kVal;
    private int maxItemsTrackedVal;
    private final Expression expr;
    private final Expression k;
    private final Expression maxItemsTracked;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$5() {
        return ApproxTopK$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return ApproxTopK$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproxTopK x$0) {
        return ApproxTopK$.MODULE$.unapply(x$0);
    }

    public static int apply$default$5() {
        return ApproxTopK$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return ApproxTopK$.MODULE$.apply$default$4();
    }

    public static StructType getSketchStateDataType(DataType itemDataType) {
        return ApproxTopK$.MODULE$.getSketchStateDataType(itemDataType);
    }

    public static ArrayOfItemsSerDe<Object> genSketchSerDe(DataType dataType) {
        return ApproxTopK$.MODULE$.genSketchSerDe(dataType);
    }

    public static GenericArrayData genEvalResult(ItemsSketch<Object> itemsSketch, int k, DataType itemDataType) {
        return ApproxTopK$.MODULE$.genEvalResult(itemsSketch, k, itemDataType);
    }

    public static ItemsSketch<Object> updateSketchBuffer(Expression itemExpression, ItemsSketch<Object> buffer, InternalRow input) {
        return ApproxTopK$.MODULE$.updateSketchBuffer(itemExpression, buffer, input);
    }

    public static int calMaxMapSize(int maxItemsTracked) {
        return ApproxTopK$.MODULE$.calMaxMapSize(maxItemsTracked);
    }

    public static boolean isDataTypeSupported(DataType itemType) {
        return ApproxTopK$.MODULE$.isDataTypeSupported(itemType);
    }

    public static DataType getResultDataType(DataType itemDataType) {
        return ApproxTopK$.MODULE$.getResultDataType(itemDataType);
    }

    public static void checkMaxItemsTracked(int maxItemsTracked, int k) {
        ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTracked, k);
    }

    public static void checkMaxItemsTracked(int maxItemsTracked) {
        ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTracked);
    }

    public static void checkK(int k) {
        ApproxTopK$.MODULE$.checkK(k);
    }

    public static void checkExpressionNotNull(Expression expr, String exprName) {
        ApproxTopK$.MODULE$.checkExpressionNotNull(expr, exprName);
    }

    public static int DEFAULT_MAX_ITEMS_TRACKED() {
        return ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED();
    }

    public static int DEFAULT_K() {
        return ApproxTopK$.MODULE$.DEFAULT_K();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return TernaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return TernaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if (!this.bitmap$trans$0) {
                this.children = TernaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression expr() {
        return this.expr;
    }

    public Expression k() {
        return this.k;
    }

    public Expression maxItemsTracked() {
        return this.maxItemsTracked;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.itemDataType = this.expr().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    /*
     * WARNING - void declaration
     */
    private int kVal$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.checkExpressionNotNull(this.k(), "k");
                int kVal = BoxesRunTime.unboxToInt((Object)this.k().eval(this.k().eval$default$1()));
                ApproxTopK$.MODULE$.checkK(kVal);
                this.kVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.kVal;
    }

    private int kVal() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.kVal$lzycompute();
        }
        return this.kVal;
    }

    /*
     * WARNING - void declaration
     */
    private int maxItemsTrackedVal$lzycompute() {
        ApproxTopK approxTopK = this;
        synchronized (approxTopK) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.checkExpressionNotNull(this.maxItemsTracked(), "maxItemsTracked");
                int maxItemsTrackedVal = BoxesRunTime.unboxToInt((Object)this.maxItemsTracked().eval(this.maxItemsTracked().eval$default$1()));
                ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTrackedVal, this.kVal());
                this.maxItemsTrackedVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.maxItemsTrackedVal;
    }

    private int maxItemsTrackedVal() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.maxItemsTrackedVal$lzycompute();
        }
        return this.maxItemsTrackedVal;
    }

    @Override
    public Expression first() {
        return this.expr();
    }

    @Override
    public Expression second() {
        return this.k();
    }

    @Override
    public Expression third() {
        return this.maxItemsTracked();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!ApproxTopK$.MODULE$.isDataTypeSupported(this.itemDataType())) {
            return new TypeCheckResult.TypeCheckFailure(this.itemDataType().typeName() + " columns are not supported");
        }
        if (!this.k().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("K must be a constant literal");
        }
        if (!this.maxItemsTracked().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("Number of items tracked must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getResultDataType(this.itemDataType());
    }

    @Override
    public ItemsSketch<Object> createAggregationBuffer() {
        int maxMapSize = ApproxTopK$.MODULE$.calMaxMapSize(this.maxItemsTrackedVal());
        return ApproxTopK$.MODULE$.createAggregationBuffer(this.expr(), maxMapSize);
    }

    @Override
    public ItemsSketch<Object> update(ItemsSketch<Object> buffer, InternalRow input) {
        return ApproxTopK$.MODULE$.updateSketchBuffer(this.expr(), buffer, input);
    }

    @Override
    public ItemsSketch<Object> merge(ItemsSketch<Object> buffer, ItemsSketch<Object> input) {
        return buffer.merge(input);
    }

    public GenericArrayData eval(ItemsSketch<Object> buffer) {
        return ApproxTopK$.MODULE$.genEvalResult(buffer, this.kVal(), this.itemDataType());
    }

    @Override
    public byte[] serialize(ItemsSketch<Object> buffer) {
        return buffer.toByteArray(ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ItemsSketch<Object> deserialize(byte[] storageFormat) {
        return ItemsSketch.getInstance((Memory)Memory.wrap((byte[])storageFormat), ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    @Override
    public Expression withNewChildrenInternal(Expression newExpr, Expression newK, Expression newMaxItemsTracked) {
        return this.copy(newExpr, newK, newMaxItemsTracked, this.copy$default$4(), this.copy$default$5());
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k");
    }

    public ApproxTopK copy(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopK(expr, k, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Expression copy$default$2() {
        return this.k();
    }

    public Expression copy$default$3() {
        return this.maxItemsTracked();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopK";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.k();
            }
            case 2: {
                return this.maxItemsTracked();
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 4: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopK;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "k";
            }
            case 2: {
                return "maxItemsTracked";
            }
            case 3: {
                return "mutableAggBufferOffset";
            }
            case 4: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopK)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopK approxTopK = (ApproxTopK)x$1;
        if (this.mutableAggBufferOffset() != approxTopK.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approxTopK.inputAggBufferOffset()) return false;
        Expression expression = this.expr();
        Expression expression2 = approxTopK.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.k();
        Expression expression4 = approxTopK.k();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.maxItemsTracked();
        Expression expression6 = approxTopK.maxItemsTracked();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!approxTopK.canEqual(this)) return false;
        return true;
    }

    public ApproxTopK(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.expr = expr;
        this.k = k;
        this.maxItemsTracked = maxItemsTracked;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        TernaryLike.$init$(this);
    }

    public ApproxTopK(Expression child, Expression topK, Expression maxItemsTracked) {
        this(child, topK, maxItemsTracked, 0, 0);
    }

    public ApproxTopK(Expression child, int topK, int maxItemsTracked) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxItemsTracked)), 0, 0);
    }

    public ApproxTopK(Expression child, Expression topK) {
        this(child, topK, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }

    public ApproxTopK(Expression child, int topK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }

    public ApproxTopK(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_K())), Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }
}

