/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelector;
import io.fabric8.kubernetes.api.model.resource.v1beta1.CounterSet;
import io.fabric8.kubernetes.api.model.resource.v1beta1.CounterSetBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.CounterSetFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta1.Device;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta1.ResourcePool;
import io.fabric8.kubernetes.api.model.resource.v1beta1.ResourcePoolBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.ResourcePoolFluent;
import io.fabric8.kubernetes.api.model.resource.v1beta1.ResourceSliceSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceSliceSpecFluent<A extends ResourceSliceSpecFluent<A>>
extends BaseFluent<A> {
    private Boolean allNodes;
    private ArrayList<DeviceBuilder> devices = new ArrayList();
    private String driver;
    private String nodeName;
    private NodeSelector nodeSelector;
    private Boolean perDeviceNodeSelection;
    private ResourcePoolBuilder pool;
    private ArrayList<CounterSetBuilder> sharedCounters = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ResourceSliceSpecFluent() {
    }

    public ResourceSliceSpecFluent(ResourceSliceSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceSliceSpec instance) {
        ResourceSliceSpec resourceSliceSpec = instance = instance != null ? instance : new ResourceSliceSpec();
        if (instance != null) {
            this.withAllNodes(instance.getAllNodes());
            this.withDevices(instance.getDevices());
            this.withDriver(instance.getDriver());
            this.withNodeName(instance.getNodeName());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPerDeviceNodeSelection(instance.getPerDeviceNodeSelection());
            this.withPool(instance.getPool());
            this.withSharedCounters(instance.getSharedCounters());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAllNodes() {
        return this.allNodes;
    }

    public A withAllNodes(Boolean allNodes) {
        this.allNodes = allNodes;
        return (A)((Object)this);
    }

    public boolean hasAllNodes() {
        return this.allNodes != null;
    }

    public A addToDevices(int index, Device item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        DeviceBuilder builder = new DeviceBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDevices(int index, Device item) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        DeviceBuilder builder = new DeviceBuilder(item);
        if (index < 0 || index >= this.devices.size()) {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        } else {
            this._visitables.get((Object)"devices").add(builder);
            this.devices.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDevices(Device ... items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDevices(Collection<Device> items) {
        if (this.devices == null) {
            this.devices = new ArrayList();
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get((Object)"devices").add(builder);
            this.devices.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDevices(Device ... items) {
        if (this.devices == null) {
            return (A)((Object)this);
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get((Object)"devices").remove((Object)builder);
            this.devices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDevices(Collection<Device> items) {
        if (this.devices == null) {
            return (A)((Object)this);
        }
        for (Device item : items) {
            DeviceBuilder builder = new DeviceBuilder(item);
            this._visitables.get((Object)"devices").remove((Object)builder);
            this.devices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDevices(Predicate<DeviceBuilder> predicate) {
        if (this.devices == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceBuilder> each = this.devices.iterator();
        List visitables = this._visitables.get((Object)"devices");
        while (each.hasNext()) {
            DeviceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Device> buildDevices() {
        return this.devices != null ? ResourceSliceSpecFluent.build(this.devices) : null;
    }

    public Device buildDevice(int index) {
        return this.devices.get(index).build();
    }

    public Device buildFirstDevice() {
        return this.devices.get(0).build();
    }

    public Device buildLastDevice() {
        return this.devices.get(this.devices.size() - 1).build();
    }

    public Device buildMatchingDevice(Predicate<DeviceBuilder> predicate) {
        for (DeviceBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDevice(Predicate<DeviceBuilder> predicate) {
        for (DeviceBuilder item : this.devices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDevices(List<Device> devices) {
        if (this.devices != null) {
            this._visitables.get((Object)"devices").clear();
        }
        if (devices != null) {
            this.devices = new ArrayList();
            for (Device item : devices) {
                this.addToDevices(item);
            }
        } else {
            this.devices = null;
        }
        return (A)((Object)this);
    }

    public A withDevices(Device ... devices) {
        if (this.devices != null) {
            this.devices.clear();
            this._visitables.remove((Object)"devices");
        }
        if (devices != null) {
            for (Device item : devices) {
                this.addToDevices(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDevices() {
        return this.devices != null && !this.devices.isEmpty();
    }

    public DevicesNested<A> addNewDevice() {
        return new DevicesNested(-1, null);
    }

    public DevicesNested<A> addNewDeviceLike(Device item) {
        return new DevicesNested(-1, item);
    }

    public DevicesNested<A> setNewDeviceLike(int index, Device item) {
        return new DevicesNested(index, item);
    }

    public DevicesNested<A> editDevice(int index) {
        if (this.devices.size() <= index) {
            throw new RuntimeException("Can't edit devices. Index exceeds size.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editFirstDevice() {
        if (this.devices.size() == 0) {
            throw new RuntimeException("Can't edit first devices. The list is empty.");
        }
        return this.setNewDeviceLike(0, this.buildDevice(0));
    }

    public DevicesNested<A> editLastDevice() {
        int index = this.devices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last devices. The list is empty.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public DevicesNested<A> editMatchingDevice(Predicate<DeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.devices.size(); ++i) {
            if (!predicate.test(this.devices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching devices. No match found.");
        }
        return this.setNewDeviceLike(index, this.buildDevice(index));
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public A withNodeSelector(NodeSelector nodeSelector) {
        this.nodeSelector = nodeSelector;
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public Boolean getPerDeviceNodeSelection() {
        return this.perDeviceNodeSelection;
    }

    public A withPerDeviceNodeSelection(Boolean perDeviceNodeSelection) {
        this.perDeviceNodeSelection = perDeviceNodeSelection;
        return (A)((Object)this);
    }

    public boolean hasPerDeviceNodeSelection() {
        return this.perDeviceNodeSelection != null;
    }

    public ResourcePool buildPool() {
        return this.pool != null ? this.pool.build() : null;
    }

    public A withPool(ResourcePool pool) {
        this._visitables.remove((Object)"pool");
        if (pool != null) {
            this.pool = new ResourcePoolBuilder(pool);
            this._visitables.get((Object)"pool").add(this.pool);
        } else {
            this.pool = null;
            this._visitables.get((Object)"pool").remove((Object)this.pool);
        }
        return (A)((Object)this);
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public A withNewPool(Long generation, String name, Long resourceSliceCount) {
        return this.withPool(new ResourcePool(generation, name, resourceSliceCount));
    }

    public PoolNested<A> withNewPool() {
        return new PoolNested(null);
    }

    public PoolNested<A> withNewPoolLike(ResourcePool item) {
        return new PoolNested(item);
    }

    public PoolNested<A> editPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(null));
    }

    public PoolNested<A> editOrNewPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(new ResourcePoolBuilder().build()));
    }

    public PoolNested<A> editOrNewPoolLike(ResourcePool item) {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(item));
    }

    public A addToSharedCounters(int index, CounterSet item) {
        if (this.sharedCounters == null) {
            this.sharedCounters = new ArrayList();
        }
        CounterSetBuilder builder = new CounterSetBuilder(item);
        if (index < 0 || index >= this.sharedCounters.size()) {
            this._visitables.get((Object)"sharedCounters").add(builder);
            this.sharedCounters.add(builder);
        } else {
            this._visitables.get((Object)"sharedCounters").add(builder);
            this.sharedCounters.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSharedCounters(int index, CounterSet item) {
        if (this.sharedCounters == null) {
            this.sharedCounters = new ArrayList();
        }
        CounterSetBuilder builder = new CounterSetBuilder(item);
        if (index < 0 || index >= this.sharedCounters.size()) {
            this._visitables.get((Object)"sharedCounters").add(builder);
            this.sharedCounters.add(builder);
        } else {
            this._visitables.get((Object)"sharedCounters").add(builder);
            this.sharedCounters.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSharedCounters(CounterSet ... items) {
        if (this.sharedCounters == null) {
            this.sharedCounters = new ArrayList();
        }
        for (CounterSet item : items) {
            CounterSetBuilder builder = new CounterSetBuilder(item);
            this._visitables.get((Object)"sharedCounters").add(builder);
            this.sharedCounters.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSharedCounters(Collection<CounterSet> items) {
        if (this.sharedCounters == null) {
            this.sharedCounters = new ArrayList();
        }
        for (CounterSet item : items) {
            CounterSetBuilder builder = new CounterSetBuilder(item);
            this._visitables.get((Object)"sharedCounters").add(builder);
            this.sharedCounters.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSharedCounters(CounterSet ... items) {
        if (this.sharedCounters == null) {
            return (A)((Object)this);
        }
        for (CounterSet item : items) {
            CounterSetBuilder builder = new CounterSetBuilder(item);
            this._visitables.get((Object)"sharedCounters").remove((Object)builder);
            this.sharedCounters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSharedCounters(Collection<CounterSet> items) {
        if (this.sharedCounters == null) {
            return (A)((Object)this);
        }
        for (CounterSet item : items) {
            CounterSetBuilder builder = new CounterSetBuilder(item);
            this._visitables.get((Object)"sharedCounters").remove((Object)builder);
            this.sharedCounters.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSharedCounters(Predicate<CounterSetBuilder> predicate) {
        if (this.sharedCounters == null) {
            return (A)((Object)this);
        }
        Iterator<CounterSetBuilder> each = this.sharedCounters.iterator();
        List visitables = this._visitables.get((Object)"sharedCounters");
        while (each.hasNext()) {
            CounterSetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<CounterSet> buildSharedCounters() {
        return this.sharedCounters != null ? ResourceSliceSpecFluent.build(this.sharedCounters) : null;
    }

    public CounterSet buildSharedCounter(int index) {
        return this.sharedCounters.get(index).build();
    }

    public CounterSet buildFirstSharedCounter() {
        return this.sharedCounters.get(0).build();
    }

    public CounterSet buildLastSharedCounter() {
        return this.sharedCounters.get(this.sharedCounters.size() - 1).build();
    }

    public CounterSet buildMatchingSharedCounter(Predicate<CounterSetBuilder> predicate) {
        for (CounterSetBuilder item : this.sharedCounters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSharedCounter(Predicate<CounterSetBuilder> predicate) {
        for (CounterSetBuilder item : this.sharedCounters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSharedCounters(List<CounterSet> sharedCounters) {
        if (this.sharedCounters != null) {
            this._visitables.get((Object)"sharedCounters").clear();
        }
        if (sharedCounters != null) {
            this.sharedCounters = new ArrayList();
            for (CounterSet item : sharedCounters) {
                this.addToSharedCounters(item);
            }
        } else {
            this.sharedCounters = null;
        }
        return (A)((Object)this);
    }

    public A withSharedCounters(CounterSet ... sharedCounters) {
        if (this.sharedCounters != null) {
            this.sharedCounters.clear();
            this._visitables.remove((Object)"sharedCounters");
        }
        if (sharedCounters != null) {
            for (CounterSet item : sharedCounters) {
                this.addToSharedCounters(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSharedCounters() {
        return this.sharedCounters != null && !this.sharedCounters.isEmpty();
    }

    public SharedCountersNested<A> addNewSharedCounter() {
        return new SharedCountersNested(-1, null);
    }

    public SharedCountersNested<A> addNewSharedCounterLike(CounterSet item) {
        return new SharedCountersNested(-1, item);
    }

    public SharedCountersNested<A> setNewSharedCounterLike(int index, CounterSet item) {
        return new SharedCountersNested(index, item);
    }

    public SharedCountersNested<A> editSharedCounter(int index) {
        if (this.sharedCounters.size() <= index) {
            throw new RuntimeException("Can't edit sharedCounters. Index exceeds size.");
        }
        return this.setNewSharedCounterLike(index, this.buildSharedCounter(index));
    }

    public SharedCountersNested<A> editFirstSharedCounter() {
        if (this.sharedCounters.size() == 0) {
            throw new RuntimeException("Can't edit first sharedCounters. The list is empty.");
        }
        return this.setNewSharedCounterLike(0, this.buildSharedCounter(0));
    }

    public SharedCountersNested<A> editLastSharedCounter() {
        int index = this.sharedCounters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sharedCounters. The list is empty.");
        }
        return this.setNewSharedCounterLike(index, this.buildSharedCounter(index));
    }

    public SharedCountersNested<A> editMatchingSharedCounter(Predicate<CounterSetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sharedCounters.size(); ++i) {
            if (!predicate.test(this.sharedCounters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sharedCounters. No match found.");
        }
        return this.setNewSharedCounterLike(index, this.buildSharedCounter(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceSliceSpecFluent that = (ResourceSliceSpecFluent)((Object)o);
        if (!Objects.equals(this.allNodes, that.allNodes)) {
            return false;
        }
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.perDeviceNodeSelection, that.perDeviceNodeSelection)) {
            return false;
        }
        if (!Objects.equals((Object)this.pool, (Object)that.pool)) {
            return false;
        }
        if (!Objects.equals(this.sharedCounters, that.sharedCounters)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allNodes, this.devices, this.driver, this.nodeName, this.nodeSelector, this.perDeviceNodeSelection, this.pool, this.sharedCounters, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allNodes != null) {
            sb.append("allNodes:");
            sb.append(this.allNodes + ",");
        }
        if (this.devices != null && !this.devices.isEmpty()) {
            sb.append("devices:");
            sb.append(String.valueOf(this.devices) + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null) {
            sb.append("nodeSelector:");
            sb.append(String.valueOf(this.nodeSelector) + ",");
        }
        if (this.perDeviceNodeSelection != null) {
            sb.append("perDeviceNodeSelection:");
            sb.append(this.perDeviceNodeSelection + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(String.valueOf((Object)this.pool) + ",");
        }
        if (this.sharedCounters != null && !this.sharedCounters.isEmpty()) {
            sb.append("sharedCounters:");
            sb.append(String.valueOf(this.sharedCounters) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllNodes() {
        return this.withAllNodes(true);
    }

    public A withPerDeviceNodeSelection() {
        return this.withPerDeviceNodeSelection(true);
    }

    public class SharedCountersNested<N>
    extends CounterSetFluent<SharedCountersNested<N>>
    implements Nested<N> {
        CounterSetBuilder builder;
        int index;

        SharedCountersNested(int index, CounterSet item) {
            this.index = index;
            this.builder = new CounterSetBuilder(this, item);
        }

        public N and() {
            return (N)ResourceSliceSpecFluent.this.setToSharedCounters(this.index, this.builder.build());
        }

        public N endSharedCounter() {
            return this.and();
        }
    }

    public class PoolNested<N>
    extends ResourcePoolFluent<PoolNested<N>>
    implements Nested<N> {
        ResourcePoolBuilder builder;

        PoolNested(ResourcePool item) {
            this.builder = new ResourcePoolBuilder(this, item);
        }

        public N and() {
            return (N)ResourceSliceSpecFluent.this.withPool(this.builder.build());
        }

        public N endPool() {
            return this.and();
        }
    }

    public class DevicesNested<N>
    extends DeviceFluent<DevicesNested<N>>
    implements Nested<N> {
        DeviceBuilder builder;
        int index;

        DevicesNested(int index, Device item) {
            this.index = index;
            this.builder = new DeviceBuilder(this, item);
        }

        public N and() {
            return (N)ResourceSliceSpecFluent.this.setToDevices(this.index, this.builder.build());
        }

        public N endDevice() {
            return this.and();
        }
    }
}

