/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import java.io.Closeable;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.HadoopFileWholeTextReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat$;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SerializableConfiguration$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u000f\u001e\u00012BQ!\u0013\u0001\u0005\u0002)CQ!\u0014\u0001\u0005B9CQa\u0016\u0001\u0005B9CQ\u0001\u0017\u0001\u0005\neCQ!\u001a\u0001\u0005\n\u0019DQ\u0001\u001b\u0001\u0005B%Dq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u0002H!9\u0011\u0011\u0013\u0001\u0005\n\u0005M\u0005bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\t\u00033\u0004\u0011\u0011!C\u0001\u0015\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003[\u0004\u0011\u0011!C\u0001\u0003_D\u0011\"a>\u0001\u0003\u0003%\t!!?\t\u0013\t\u0015\u0001!!A\u0005B\t\u001d\u0001\"\u0003B\n\u0001\u0005\u0005I\u0011\u0001B\u000b\u0011%\u0011I\u0002AA\u0001\n\u0003\u0012Y\u0002C\u0005\u0003 \u0001\t\t\u0011\"\u0011\u0003\"!I!1\u0005\u0001\u0002\u0002\u0013\u0005#QE\u0004\n\u0005Si\u0012\u0011!E\u0001\u0005W1\u0001\u0002H\u000f\u0002\u0002#\u0005!Q\u0006\u0005\u0007\u0013Z!\tA!\u0012\t\u0011]3\u0012\u0011!C#\u0005\u000fB\u0001B!\u0013\u0017\u0003\u0003%\tI\u0013\u0005\n\u0005\u00172\u0012\u0011!CA\u0005\u001bB\u0011Ba\u0015\u0017\u0003\u0003%IA!\u0016\u0003\u001dQ+\u0007\u0010\u001e$jY\u00164uN]7bi*\u0011adH\u0001\u0005i\u0016DHO\u0003\u0002!C\u0005YA-\u0019;bg>,(oY3t\u0015\t\u00113%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M)\u0001!L\u00198{A\u0011afL\u0007\u0002?%\u0011\u0001g\b\u0002\u0014)\u0016DHOQ1tK\u00124\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003eUj\u0011a\r\u0006\u0003i\r\nqa]8ve\u000e,7/\u0003\u00027g\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0010$\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\",\u0003\u0019a$o\\8u}%\t!(\u0003\u0002Fs\u00059\u0001/Y2lC\u001e,\u0017BA$I\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0015(\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017B\u0011A\nA\u0007\u0002;\u0005I1\u000f[8si:\u000bW.\u001a\u000b\u0002\u001fB\u0011\u0001\u000b\u0016\b\u0003#J\u0003\"\u0001Q\u001d\n\u0005MK\u0014A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\u001d\u0002\u0011Q|7\u000b\u001e:j]\u001e\fAB^3sS\u001aL8k\u00195f[\u0006$\"AW/\u0011\u0005aZ\u0016B\u0001/:\u0005\u0011)f.\u001b;\t\u000by#\u0001\u0019A0\u0002\rM\u001c\u0007.Z7b!\t\u00017-D\u0001b\u0015\t\u00117%A\u0003usB,7/\u0003\u0002eC\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002!Y,'/\u001b4z%\u0016\fGmU2iK6\fGC\u0001.h\u0011\u0015qV\u00011\u0001`\u0003-I7o\u00159mSR\f'\r\\3\u0015\t)l7\u000f\u001f\t\u0003q-L!\u0001\\\u001d\u0003\u000f\t{w\u000e\\3b]\")aN\u0002a\u0001_\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0001/]\u0007\u0002G%\u0011!o\t\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0006i\u001a\u0001\r!^\u0001\b_B$\u0018n\u001c8t!\u0011\u0001foT(\n\u0005]4&aA'ba\")\u0011P\u0002a\u0001u\u0006!\u0001/\u0019;i!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0003MNT!a`\u0014\u0002\r!\fGm\\8q\u0013\r\t\u0019\u0001 \u0002\u0005!\u0006$\b.A\u0006j]\u001a,'oU2iK6\fG\u0003CA\u0005\u0003\u001f\t\t\"a\u0005\u0011\ta\nYaX\u0005\u0004\u0003\u001bI$AB(qi&|g\u000eC\u0003o\u000f\u0001\u0007q\u000eC\u0003u\u000f\u0001\u0007Q\u000fC\u0004\u0002\u0016\u001d\u0001\r!a\u0006\u0002\u000b\u0019LG.Z:\u0011\u000by\nI\"!\b\n\u0007\u0005m\u0001JA\u0002TKF\u00042a_A\u0010\u0013\r\t\t\u0003 \u0002\u000b\r&dWm\u0015;biV\u001c\u0018\u0001\u00049sKB\f'/Z,sSR,GCCA\u0014\u0003[\ty#a\u0010\u0002BA\u0019a&!\u000b\n\u0007\u0005-rDA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003o\u0011\u0001\u0007q\u000eC\u0004\u00022!\u0001\r!a\r\u0002\u0007)|'\r\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tID`\u0001\n[\u0006\u0004(/\u001a3vG\u0016LA!!\u0010\u00028\t\u0019!j\u001c2\t\u000bQD\u0001\u0019A;\t\r\u0005\r\u0003\u00021\u0001`\u0003)!\u0017\r^1TG\",W.Y\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002J\u0005\u001d\u0014\u0011NA6\u0003_\n\u0019(a \u0002\u0002B9\u0001(a\u0013\u0002P\u0005U\u0013bAA's\tIa)\u001e8di&|g.\r\t\u0004]\u0005E\u0013bAA*?\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003?\u0003/\nY&C\u0002\u0002Z!\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011M\u0012\u0002\u0011\r\fG/\u00197zgRLA!!\u001a\u0002`\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015q\u0017\u00021\u0001p\u0011\u0019\t\u0019%\u0003a\u0001?\"1\u0011QN\u0005A\u0002}\u000bq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003cJ\u0001\u0019A0\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011QO\u0005A\u0002\u0005]\u0014a\u00024jYR,'o\u001d\t\u0006}\u0005e\u0011\u0011\u0010\t\u0004e\u0005m\u0014bAA?g\t1a)\u001b7uKJDQ\u0001^\u0005A\u0002UDq!a!\n\u0001\u0004\t))\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017s\u0018\u0001B2p]\u001aLA!a$\u0002\n\ni1i\u001c8gS\u001e,(/\u0019;j_:\fqB]3bIR{WK\\:bM\u0016lU-\u001c\u000b\t\u0003+\u000b)+a0\u0002BB9\u0001(a\u0013\u0002P\u0005]\u0005#\u0002 \u0002X\u0005e\u0005\u0003BAN\u0003Ck!!!(\u000b\t\u0005}\u0015qL\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u0002$\u0006u%!C+og\u00064WMU8x\u0011\u001d\tYI\u0003a\u0001\u0003O\u0003b!!+\u00020\u0006MVBAAV\u0015\r\ti+J\u0001\nEJ|\u0017\rZ2bgRLA!!-\u0002,\nI!I]8bI\u000e\f7\u000f\u001e\t\u0005\u0003k\u000bY,\u0004\u0002\u00028*\u0019\u0011\u0011X\u0013\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003{\u000b9LA\rTKJL\u0017\r\\5{C\ndWmQ8oM&<WO]1uS>t\u0007BBA9\u0015\u0001\u0007q\fC\u0004\u0002D*\u0001\r!!2\u0002\u0017Q,\u0007\u0010^(qi&|gn\u001d\t\u0004\u0019\u0006\u001d\u0017bAAe;\tYA+\u001a=u\u001fB$\u0018n\u001c8t\u0003=\u0019X\u000f\u001d9peR$\u0015\r^1UsB,Gc\u00016\u0002P\"9\u0011\u0011[\u0006A\u0002\u0005M\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007\u0001\f).C\u0002\u0002X\u0006\u0014\u0001\u0002R1uCRK\b/Z\u0001\u0005G>\u0004\u00180A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003?\u0004B!!9\u0002l6\u0011\u00111\u001d\u0006\u0005\u0003K\f9/\u0001\u0003mC:<'BAAu\u0003\u0011Q\u0017M^1\n\u0007U\u000b\u0019/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002rB\u0019\u0001(a=\n\u0007\u0005U\u0018HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002|\n\u0005\u0001c\u0001\u001d\u0002~&\u0019\u0011q`\u001d\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u0004=\t\t\u00111\u0001\u0002r\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0003\u0011\r\t-!\u0011CA~\u001b\t\u0011iAC\u0002\u0003\u0010e\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tIF!\u0004\u0002\u0011\r\fg.R9vC2$2A\u001bB\f\u0011%\u0011\u0019!EA\u0001\u0002\u0004\tY0\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAp\u0005;A\u0011Ba\u0001\u0013\u0003\u0003\u0005\r!!=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!=\u0002\r\u0015\fX/\u00197t)\rQ'q\u0005\u0005\n\u0005\u0007!\u0012\u0011!a\u0001\u0003w\fa\u0002V3yi\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002M-M)aCa\f\u0003<A)!\u0011\u0007B\u001c\u00176\u0011!1\u0007\u0006\u0004\u0005kI\u0014a\u0002:v]RLW.Z\u0005\u0005\u0005s\u0011\u0019DA\tBEN$(/Y2u\rVt7\r^5p]B\u0002BA!\u0010\u0003D5\u0011!q\b\u0006\u0005\u0005\u0003\n9/\u0001\u0002j_&\u0019qIa\u0010\u0015\u0005\t-BCAAp\u0003\u0015\t\u0007\u000f\u001d7z\u0003\u001d)h.\u00199qYf$2A\u001bB(\u0011!\u0011\tFGA\u0001\u0002\u0004Y\u0015a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u000b\t\u0005\u0003C\u0014I&\u0003\u0003\u0003\\\u0005\r(AB(cU\u0016\u001cG\u000f")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister,
Product,
Serializable {
    public static boolean unapply(TextFileFormat x$0) {
        return TextFileFormat$.MODULE$.unapply(x$0);
    }

    public static TextFileFormat apply() {
        return TextFileFormat$.MODULE$.apply();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public String shortName() {
        return "text";
    }

    public String toString() {
        return "Text";
    }

    private void verifySchema(StructType schema) {
        if (schema.size() != 1) {
            throw QueryCompilationErrors$.MODULE$.textDataSourceWithMultiColumnsError(schema);
        }
    }

    private void verifyReadSchema(StructType schema) {
        if (schema.size() > 1) {
            throw QueryCompilationErrors$.MODULE$.textDataSourceWithMultiColumnsError(schema);
        }
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        TextOptions textOptions = new TextOptions(options);
        return super.isSplitable(sparkSession, options, path) && !textOptions.wholeText();
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1 & Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return ".txt" + CodecStreams$.MODULE$.getCompressionExtension((JobContext)context);
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        this.verifyReadSchema(requiredSchema);
        TextOptions textOptions = new TextOptions(options);
        Broadcast broadcastedHadoopConf = SerializableConfiguration$.MODULE$.broadcast(sparkSession.sparkContext(), hadoopConf);
        return this.readToUnsafeMem((Broadcast<SerializableConfiguration>)broadcastedHadoopConf, requiredSchema, textOptions);
    }

    private Function1<PartitionedFile, Iterator<UnsafeRow>> readToUnsafeMem(Broadcast<SerializableConfiguration> conf, StructType requiredSchema, TextOptions textOptions) {
        return (Function1 & Serializable)file -> {
            Configuration confValue = ((SerializableConfiguration)conf.value()).value();
            Iterator reader = (Iterator)Utils$.MODULE$.createResourceUninterruptiblyIfInTaskThread((Function0 & Serializable)() -> {
                if (!textOptions.wholeText()) {
                    return new HadoopFileLinesReader((PartitionedFile)file, textOptions.lineSeparatorInRead(), confValue);
                }
                return new HadoopFileWholeTextReader((PartitionedFile)file, confValue);
            });
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable)x$1 -> x$1.addTaskCompletionListener((Function1 & Serializable)x$2 -> {
                TextFileFormat.$anonfun$readToUnsafeMem$4(reader, x$2);
                return BoxedUnit.UNIT;
            }));
            if (requiredSchema.isEmpty()) {
                UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                return reader.map((Function1 & Serializable)x$3 -> emptyUnsafeRow);
            }
            UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(1);
            return reader.map((Function1 & Serializable)line -> {
                unsafeRowWriter.reset();
                unsafeRowWriter.write(0, line.getBytes(), 0, line.getLength());
                return unsafeRowWriter.getRow();
            });
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        return dataType instanceof StringType;
    }

    public TextFileFormat copy() {
        return new TextFileFormat();
    }

    public String productPrefix() {
        return "TextFileFormat";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TextFileFormat;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof TextFileFormat && ((TextFileFormat)x$1).canEqual(this);
    }

    public static final /* synthetic */ void $anonfun$readToUnsafeMem$4(Iterator reader$1, TaskContext x$2) {
        ((Closeable)reader$1).close();
    }

    public TextFileFormat() {
        Product.$init$((Product)this);
    }
}

