/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.errors.ExecutionErrors$;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class MathUtils$ {
    public static final MathUtils$ MODULE$ = new MathUtils$();

    public int addExact(int a, int b) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.addExact(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public int addExact(int a, int b, QueryContext context) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.addExact(a, b), "try_add", context));
    }

    public long addExact(long a, long b) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.addExact(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public long addExact(long a, long b, QueryContext context) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.addExact(a, b), "try_add", context));
    }

    public int subtractExact(int a, int b) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.subtractExact(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public int subtractExact(int a, int b, QueryContext context) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.subtractExact(a, b), "try_subtract", context));
    }

    public long subtractExact(long a, long b) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.subtractExact(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public long subtractExact(long a, long b, QueryContext context) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.subtractExact(a, b), "try_subtract", context));
    }

    public int multiplyExact(int a, int b) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.multiplyExact(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public int multiplyExact(int a, int b, QueryContext context) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.multiplyExact(a, b), "try_multiply", context));
    }

    public long multiplyExact(long a, long b) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.multiplyExact(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public long multiplyExact(long a, long b, QueryContext context) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.multiplyExact(a, b), "try_multiply", context));
    }

    public byte negateExact(byte a) {
        if (a == -128) {
            throw ExecutionErrors$.MODULE$.arithmeticOverflowError("byte overflow", ExecutionErrors$.MODULE$.arithmeticOverflowError$default$2(), ExecutionErrors$.MODULE$.arithmeticOverflowError$default$3());
        }
        return -a;
    }

    public short negateExact(short a) {
        if (a == Short.MIN_VALUE) {
            throw ExecutionErrors$.MODULE$.arithmeticOverflowError("short overflow", ExecutionErrors$.MODULE$.arithmeticOverflowError$default$2(), ExecutionErrors$.MODULE$.arithmeticOverflowError$default$3());
        }
        return -a;
    }

    public int negateExact(int a) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.negateExact(a), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public long negateExact(long a) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.negateExact(a), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public int toIntExact(long a) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.toIntExact(a), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public int floorDiv(int a, int b) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.floorDiv(a, b), "try_divide", this.withOverflow$default$3()));
    }

    public long floorDiv(long a, long b) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.floorDiv(a, b), "try_divide", this.withOverflow$default$3()));
    }

    public int floorMod(int a, int b) {
        return BoxesRunTime.unboxToInt(this.withOverflow((Function0)(JFunction0.mcI.sp & Serializable)() -> Math.floorMod(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public long floorMod(long a, long b) {
        return BoxesRunTime.unboxToLong(this.withOverflow((Function0)(JFunction0.mcJ.sp & Serializable)() -> Math.floorMod(a, b), this.withOverflow$default$2(), this.withOverflow$default$3()));
    }

    public <A> A withOverflow(Function0<A> f, String hint, QueryContext context) {
        Object object;
        try {
            object = f.apply();
        }
        catch (ArithmeticException e) {
            throw ExecutionErrors$.MODULE$.arithmeticOverflowError(e.getMessage(), hint, context);
        }
        return (A)object;
    }

    public <A> String withOverflow$default$2() {
        return "";
    }

    public <A> QueryContext withOverflow$default$3() {
        return null;
    }

    public String withOverflowCode(String evalCode, String context) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n       |try {\n       |  " + evalCode + "\n       |} catch (ArithmeticException e) {\n       |  throw QueryExecutionErrors.arithmeticOverflowError(e.getMessage(), \"\", " + context + ");\n       |}\n       |"));
    }

    private MathUtils$() {
    }
}

