/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.connect.client.arrow.TypedArrowVectorReader;
import org.sparkproject.org.apache.arrow.vector.DateDayVector;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00055a!B\b\u0011\u0001Aq\u0002\"\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0012-\u0011!i\u0003A!A!\u0002\u0013q\u0003\"B\u001e\u0001\t\u0003a\u0004b\u0002!\u0001\u0005\u0004%I!\u0011\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\"\t\u0011-\u0003\u0001R1A\u0005\n1CQ!\u0016\u0001\u0005\nYCQ!\u0018\u0001\u0005\nyCQa\u0019\u0001\u0005B\u0011DQa\u001b\u0001\u0005B1DQ!\u001d\u0001\u0005BIDQa\u001e\u0001\u0005BaDQ! \u0001\u0005ByDq!a\u0002\u0001\t\u0003\nIAA\nECR,G)Y=WK\u000e$xN\u001d*fC\u0012,'O\u0003\u0002\u0012%\u0005)\u0011M\u001d:po*\u00111\u0003F\u0001\u0007G2LWM\u001c;\u000b\u0005U1\u0012aB2p]:,7\r\u001e\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7C\u0001\u0001 !\r\u0001\u0013eI\u0007\u0002!%\u0011!\u0005\u0005\u0002\u0017)f\u0004X\rZ!se><h+Z2u_J\u0014V-\u00193feB\u0011A\u0005K\u0007\u0002K)\u0011aeJ\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0005EQ\u0012BA\u0015&\u00055!\u0015\r^3ECf4Vm\u0019;pe\u0006\tao\u0001\u0001\n\u0005\u0019\n\u0013A\u0003;j[\u0016TvN\\3JIB\u0011q\u0006\u000f\b\u0003aY\u0002\"!\r\u001b\u000e\u0003IR!aM\u0016\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005]\"\u0014A\u0002\u001fj]&$h\bF\u0002>}}\u0002\"\u0001\t\u0001\t\u000b)\u001a\u0001\u0019A\u0012\t\u000b5\u001a\u0001\u0019\u0001\u0018\u0002\ti|g.Z\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0005i&lWMC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%#%A\u0002.p]\u0016LE-A\u0003{_:,\u0007%A\u0005g_Jl\u0017\r\u001e;feV\tQ\n\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!Q\u000f^5m\u0015\t\u0011f#\u0001\u0005dCR\fG._:u\u0013\t!vJA\u0007ECR,gi\u001c:nCR$XM]\u0001\u0005I\u0006L8\u000f\u0006\u0002X7B\u0011\u0001,W\u0007\u0002i%\u0011!\f\u000e\u0002\u0004\u0013:$\b\"\u0002/\b\u0001\u00049\u0016!A5\u0002\r5L7M]8t)\ty&\r\u0005\u0002YA&\u0011\u0011\r\u000e\u0002\u0005\u0019>tw\rC\u0003]\u0011\u0001\u0007q+A\u0004hKR$\u0015\r^3\u0015\u0005\u0015T\u0007C\u00014i\u001b\u00059'BA\fG\u0013\tIwM\u0001\u0003ECR,\u0007\"\u0002/\n\u0001\u00049\u0016\u0001D4fi2{7-\u00197ECR,GCA7q!\t\u0019e.\u0003\u0002p\t\nIAj\\2bY\u0012\u000bG/\u001a\u0005\u00069*\u0001\raV\u0001\rO\u0016$H+[7fgR\fW\u000e\u001d\u000b\u0003gZ\u0004\"A\u001a;\n\u0005U<'!\u0003+j[\u0016\u001cH/Y7q\u0011\u0015a6\u00021\u0001X\u0003)9W\r^%ogR\fg\u000e\u001e\u000b\u0003sr\u0004\"a\u0011>\n\u0005m$%aB%ogR\fg\u000e\u001e\u0005\u000692\u0001\raV\u0001\u0011O\u0016$Hj\\2bY\u0012\u000bG/\u001a+j[\u0016$2a`A\u0003!\r\u0019\u0015\u0011A\u0005\u0004\u0003\u0007!%!\u0004'pG\u0006dG)\u0019;f)&lW\rC\u0003]\u001b\u0001\u0007q+A\u0005hKR\u001cFO]5oOR\u0019a&a\u0003\t\u000bqs\u0001\u0019A,")
public class DateDayVectorReader
extends TypedArrowVectorReader<DateDayVector> {
    private DateFormatter formatter;
    private final ZoneId zone;
    private volatile boolean bitmap$0;

    private ZoneId zone() {
        return this.zone;
    }

    private DateFormatter formatter$lzycompute() {
        DateDayVectorReader dateDayVectorReader = this;
        synchronized (dateDayVectorReader) {
            if (!this.bitmap$0) {
                this.formatter = DateFormatter$.MODULE$.apply();
                this.bitmap$0 = true;
            }
        }
        return this.formatter;
    }

    private DateFormatter formatter() {
        if (!this.bitmap$0) {
            return this.formatter$lzycompute();
        }
        return this.formatter;
    }

    private int days(int i) {
        return ((DateDayVector)this.vector()).get(i);
    }

    private long micros(int i) {
        return SparkDateTimeUtils$.MODULE$.daysToMicros(this.days(i), this.zone());
    }

    @Override
    public Date getDate(int i) {
        return SparkDateTimeUtils$.MODULE$.toJavaDate(this.days(i));
    }

    @Override
    public LocalDate getLocalDate(int i) {
        return SparkDateTimeUtils$.MODULE$.daysToLocalDate(this.days(i));
    }

    @Override
    public Timestamp getTimestamp(int i) {
        return SparkDateTimeUtils$.MODULE$.toJavaTimestamp(this.micros(i));
    }

    @Override
    public Instant getInstant(int i) {
        return SparkDateTimeUtils$.MODULE$.microsToInstant(this.micros(i));
    }

    @Override
    public LocalDateTime getLocalDateTime(int i) {
        return SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(this.micros(i));
    }

    @Override
    public String getString(int i) {
        return this.formatter().format(this.getLocalDate(i));
    }

    public DateDayVectorReader(DateDayVector v, String timeZoneId) {
        super(v);
        this.zone = SparkDateTimeUtils$.MODULE$.getZoneId(timeZoneId);
    }
}

