/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.ContainerResizePolicy;
import io.fabric8.kubernetes.api.model.ContainerResizePolicyBuilder;
import io.fabric8.kubernetes.api.model.ContainerResizePolicyFluent;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.EnvFromSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvFromSourceFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluent;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import io.fabric8.kubernetes.api.model.VolumeDevice;
import io.fabric8.kubernetes.api.model.VolumeDeviceBuilder;
import io.fabric8.kubernetes.api.model.VolumeDeviceFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ContainerFluent<A extends ContainerFluent<A>>
extends BaseFluent<A> {
    private List<String> args = new ArrayList<String>();
    private List<String> command = new ArrayList<String>();
    private ArrayList<EnvVarBuilder> env = new ArrayList();
    private ArrayList<EnvFromSourceBuilder> envFrom = new ArrayList();
    private String image;
    private String imagePullPolicy;
    private LifecycleBuilder lifecycle;
    private ProbeBuilder livenessProbe;
    private String name;
    private ArrayList<ContainerPortBuilder> ports = new ArrayList();
    private ProbeBuilder readinessProbe;
    private ArrayList<ContainerResizePolicyBuilder> resizePolicy = new ArrayList();
    private ResourceRequirementsBuilder resources;
    private String restartPolicy;
    private SecurityContextBuilder securityContext;
    private ProbeBuilder startupProbe;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String terminationMessagePath;
    private String terminationMessagePolicy;
    private Boolean tty;
    private ArrayList<VolumeDeviceBuilder> volumeDevices = new ArrayList();
    private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList();
    private String workingDir;
    private Map<String, Object> additionalProperties;

    public ContainerFluent() {
    }

    public ContainerFluent(Container instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Container instance) {
        Container container = instance = instance != null ? instance : new Container();
        if (instance != null) {
            this.withArgs(instance.getArgs());
            this.withCommand(instance.getCommand());
            this.withEnv(instance.getEnv());
            this.withEnvFrom(instance.getEnvFrom());
            this.withImage(instance.getImage());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withLifecycle(instance.getLifecycle());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withName(instance.getName());
            this.withPorts(instance.getPorts());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withResizePolicy(instance.getResizePolicy());
            this.withResources(instance.getResources());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withSecurityContext(instance.getSecurityContext());
            this.withStartupProbe(instance.getStartupProbe());
            this.withStdin(instance.getStdin());
            this.withStdinOnce(instance.getStdinOnce());
            this.withTerminationMessagePath(instance.getTerminationMessagePath());
            this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
            this.withTty(instance.getTty());
            this.withVolumeDevices(instance.getVolumeDevices());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withWorkingDir(instance.getWorkingDir());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)((Object)this);
    }

    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)((Object)this);
    }

    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromArgs(String ... items) {
        if (this.args == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromArgs(Collection<String> items) {
        if (this.args == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withArgs(List<String> args) {
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)((Object)this);
    }

    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
            this._visitables.remove((Object)"args");
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)((Object)this);
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)((Object)this);
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)((Object)this);
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove((Object)"command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        EnvVarBuilder builder = new EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get((Object)"env").add(builder);
            this.env.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").add(builder);
            this.env.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnv(EnvVar ... items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.get((Object)"env").remove((Object)builder);
            this.env.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnv(Predicate<EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)((Object)this);
        }
        Iterator<EnvVarBuilder> each = this.env.iterator();
        List visitables = this._visitables.get((Object)"env");
        while (each.hasNext()) {
            EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvVar> buildEnv() {
        return this.env != null ? ContainerFluent.build(this.env) : null;
    }

    public EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public EnvVar buildMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        for (EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get((Object)"env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)((Object)this);
    }

    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove((Object)"env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(EnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, EnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public A addToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        if (index < 0 || index >= this.envFrom.size()) {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        } else {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEnvFrom(int index, EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
        if (index < 0 || index >= this.envFrom.size()) {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        } else {
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvFrom(EnvFromSource ... items) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").remove((Object)builder);
            this.envFrom.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        for (EnvFromSource item : items) {
            EnvFromSourceBuilder builder = new EnvFromSourceBuilder(item);
            this._visitables.get((Object)"envFrom").remove((Object)builder);
            this.envFrom.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        if (this.envFrom == null) {
            return (A)((Object)this);
        }
        Iterator<EnvFromSourceBuilder> each = this.envFrom.iterator();
        List visitables = this._visitables.get((Object)"envFrom");
        while (each.hasNext()) {
            EnvFromSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EnvFromSource> buildEnvFrom() {
        return this.envFrom != null ? ContainerFluent.build(this.envFrom) : null;
    }

    public EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    public EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    public EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1).build();
    }

    public EnvFromSource buildMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        for (EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnvFrom(List<EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get((Object)"envFrom").clear();
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList();
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = null;
        }
        return (A)((Object)this);
    }

    public A withEnvFrom(EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
            this._visitables.remove((Object)"envFrom");
        }
        if (envFrom != null) {
            for (EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    public EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNested(-1, null);
    }

    public EnvFromNested<A> addNewEnvFromLike(EnvFromSource item) {
        return new EnvFromNested(-1, item);
    }

    public EnvFromNested<A> setNewEnvFromLike(int index, EnvFromSource item) {
        return new EnvFromNested(index, item);
    }

    public EnvFromNested<A> editEnvFrom(int index) {
        if (this.envFrom.size() <= index) {
            throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public EnvFromNested<A> editFirstEnvFrom() {
        if (this.envFrom.size() == 0) {
            throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(0, this.buildEnvFrom(0));
    }

    public EnvFromNested<A> editLastEnvFrom() {
        int index = this.envFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public EnvFromNested<A> editMatchingEnvFrom(Predicate<EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envFrom.size(); ++i) {
            if (!predicate.test(this.envFrom.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envFrom. No match found.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public Lifecycle buildLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    public A withLifecycle(Lifecycle lifecycle) {
        this._visitables.remove((Object)"lifecycle");
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.get((Object)"lifecycle").add(this.lifecycle);
        } else {
            this.lifecycle = null;
            this._visitables.get((Object)"lifecycle").remove((Object)this.lifecycle);
        }
        return (A)((Object)this);
    }

    public boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    public LifecycleNested<A> withNewLifecycle() {
        return new LifecycleNested(null);
    }

    public LifecycleNested<A> withNewLifecycleLike(Lifecycle item) {
        return new LifecycleNested(item);
    }

    public LifecycleNested<A> editLifecycle() {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(null));
    }

    public LifecycleNested<A> editOrNewLifecycle() {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(new LifecycleBuilder().build()));
    }

    public LifecycleNested<A> editOrNewLifecycleLike(Lifecycle item) {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(item));
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove((Object)"livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.get((Object)"livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get((Object)"livenessProbe").remove((Object)this.livenessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToPorts(int index, ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPorts(int index, ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        ContainerPortBuilder builder = new ContainerPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get((Object)"ports").add(builder);
            this.ports.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPorts(ContainerPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPorts(Collection<ContainerPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").add(builder);
            this.ports.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(ContainerPort ... items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPorts(Collection<ContainerPort> items) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.get((Object)"ports").remove((Object)builder);
            this.ports.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPorts(Predicate<ContainerPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerPortBuilder> each = this.ports.iterator();
        List visitables = this._visitables.get((Object)"ports");
        while (each.hasNext()) {
            ContainerPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerPort> buildPorts() {
        return this.ports != null ? ContainerFluent.build(this.ports) : null;
    }

    public ContainerPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public ContainerPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public ContainerPort buildMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        for (ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<ContainerPort> ports) {
        if (this.ports != null) {
            this._visitables.get((Object)"ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)((Object)this);
    }

    public A withPorts(ContainerPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove((Object)"ports");
        }
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public A addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(ContainerPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, ContainerPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove((Object)"readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.get((Object)"readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get((Object)"readinessProbe").remove((Object)this.readinessProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public A addToResizePolicy(int index, ContainerResizePolicy item) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
        if (index < 0 || index >= this.resizePolicy.size()) {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        } else {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToResizePolicy(int index, ContainerResizePolicy item) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
        if (index < 0 || index >= this.resizePolicy.size()) {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        } else {
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToResizePolicy(ContainerResizePolicy ... items) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToResizePolicy(Collection<ContainerResizePolicy> items) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromResizePolicy(ContainerResizePolicy ... items) {
        if (this.resizePolicy == null) {
            return (A)((Object)this);
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").remove((Object)builder);
            this.resizePolicy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromResizePolicy(Collection<ContainerResizePolicy> items) {
        if (this.resizePolicy == null) {
            return (A)((Object)this);
        }
        for (ContainerResizePolicy item : items) {
            ContainerResizePolicyBuilder builder = new ContainerResizePolicyBuilder(item);
            this._visitables.get((Object)"resizePolicy").remove((Object)builder);
            this.resizePolicy.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        if (this.resizePolicy == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerResizePolicyBuilder> each = this.resizePolicy.iterator();
        List visitables = this._visitables.get((Object)"resizePolicy");
        while (each.hasNext()) {
            ContainerResizePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ContainerResizePolicy> buildResizePolicy() {
        return this.resizePolicy != null ? ContainerFluent.build(this.resizePolicy) : null;
    }

    public ContainerResizePolicy buildResizePolicy(int index) {
        return this.resizePolicy.get(index).build();
    }

    public ContainerResizePolicy buildFirstResizePolicy() {
        return this.resizePolicy.get(0).build();
    }

    public ContainerResizePolicy buildLastResizePolicy() {
        return this.resizePolicy.get(this.resizePolicy.size() - 1).build();
    }

    public ContainerResizePolicy buildMatchingResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        for (ContainerResizePolicyBuilder item : this.resizePolicy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        for (ContainerResizePolicyBuilder item : this.resizePolicy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResizePolicy(List<ContainerResizePolicy> resizePolicy) {
        if (this.resizePolicy != null) {
            this._visitables.get((Object)"resizePolicy").clear();
        }
        if (resizePolicy != null) {
            this.resizePolicy = new ArrayList();
            for (ContainerResizePolicy item : resizePolicy) {
                this.addToResizePolicy(item);
            }
        } else {
            this.resizePolicy = null;
        }
        return (A)((Object)this);
    }

    public A withResizePolicy(ContainerResizePolicy ... resizePolicy) {
        if (this.resizePolicy != null) {
            this.resizePolicy.clear();
            this._visitables.remove((Object)"resizePolicy");
        }
        if (resizePolicy != null) {
            for (ContainerResizePolicy item : resizePolicy) {
                this.addToResizePolicy(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasResizePolicy() {
        return this.resizePolicy != null && !this.resizePolicy.isEmpty();
    }

    public A addNewResizePolicy(String resourceName, String restartPolicy) {
        return this.addToResizePolicy(new ContainerResizePolicy(resourceName, restartPolicy));
    }

    public ResizePolicyNested<A> addNewResizePolicy() {
        return new ResizePolicyNested(-1, null);
    }

    public ResizePolicyNested<A> addNewResizePolicyLike(ContainerResizePolicy item) {
        return new ResizePolicyNested(-1, item);
    }

    public ResizePolicyNested<A> setNewResizePolicyLike(int index, ContainerResizePolicy item) {
        return new ResizePolicyNested(index, item);
    }

    public ResizePolicyNested<A> editResizePolicy(int index) {
        if (this.resizePolicy.size() <= index) {
            throw new RuntimeException("Can't edit resizePolicy. Index exceeds size.");
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public ResizePolicyNested<A> editFirstResizePolicy() {
        if (this.resizePolicy.size() == 0) {
            throw new RuntimeException("Can't edit first resizePolicy. The list is empty.");
        }
        return this.setNewResizePolicyLike(0, this.buildResizePolicy(0));
    }

    public ResizePolicyNested<A> editLastResizePolicy() {
        int index = this.resizePolicy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resizePolicy. The list is empty.");
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public ResizePolicyNested<A> editMatchingResizePolicy(Predicate<ContainerResizePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resizePolicy.size(); ++i) {
            if (!predicate.test(this.resizePolicy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resizePolicy. No match found.");
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove((Object)"resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get((Object)"resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get((Object)"resources").remove((Object)this.resources);
        }
        return (A)((Object)this);
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)((Object)this);
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    public A withSecurityContext(SecurityContext securityContext) {
        this._visitables.remove((Object)"securityContext");
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.get((Object)"securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get((Object)"securityContext").remove((Object)this.securityContext);
        }
        return (A)((Object)this);
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNested(null);
    }

    public SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNested(item);
    }

    public SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(null));
    }

    public SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(new SecurityContextBuilder().build()));
    }

    public SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item) {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(item));
    }

    public Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    public A withStartupProbe(Probe startupProbe) {
        this._visitables.remove((Object)"startupProbe");
        if (startupProbe != null) {
            this.startupProbe = new ProbeBuilder(startupProbe);
            this._visitables.get((Object)"startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get((Object)"startupProbe").remove((Object)this.startupProbe);
        }
        return (A)((Object)this);
    }

    public boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNested(null);
    }

    public StartupProbeNested<A> withNewStartupProbeLike(Probe item) {
        return new StartupProbeNested(item);
    }

    public StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(null));
    }

    public StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(new ProbeBuilder().build()));
    }

    public StartupProbeNested<A> editOrNewStartupProbeLike(Probe item) {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(item));
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)((Object)this);
    }

    public boolean hasStdin() {
        return this.stdin != null;
    }

    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)((Object)this);
    }

    public boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public A withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (A)((Object)this);
    }

    public boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public A withTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return (A)((Object)this);
    }

    public boolean hasTerminationMessagePolicy() {
        return this.terminationMessagePolicy != null;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)((Object)this);
    }

    public boolean hasTty() {
        return this.tty != null;
    }

    public A addToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
        if (index < 0 || index >= this.volumeDevices.size()) {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        } else {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeDevices(int index, VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
        if (index < 0 || index >= this.volumeDevices.size()) {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        } else {
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeDevices(VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").remove((Object)builder);
            this.volumeDevices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeDevices(Collection<VolumeDevice> items) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        for (VolumeDevice item : items) {
            VolumeDeviceBuilder builder = new VolumeDeviceBuilder(item);
            this._visitables.get((Object)"volumeDevices").remove((Object)builder);
            this.volumeDevices.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeDevices(Predicate<VolumeDeviceBuilder> predicate) {
        if (this.volumeDevices == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeDeviceBuilder> each = this.volumeDevices.iterator();
        List visitables = this._visitables.get((Object)"volumeDevices");
        while (each.hasNext()) {
            VolumeDeviceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VolumeDevice> buildVolumeDevices() {
        return this.volumeDevices != null ? ContainerFluent.build(this.volumeDevices) : null;
    }

    public VolumeDevice buildVolumeDevice(int index) {
        return this.volumeDevices.get(index).build();
    }

    public VolumeDevice buildFirstVolumeDevice() {
        return this.volumeDevices.get(0).build();
    }

    public VolumeDevice buildLastVolumeDevice() {
        return this.volumeDevices.get(this.volumeDevices.size() - 1).build();
    }

    public VolumeDevice buildMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        for (VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        for (VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeDevices(List<VolumeDevice> volumeDevices) {
        if (this.volumeDevices != null) {
            this._visitables.get((Object)"volumeDevices").clear();
        }
        if (volumeDevices != null) {
            this.volumeDevices = new ArrayList();
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        } else {
            this.volumeDevices = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeDevices(VolumeDevice ... volumeDevices) {
        if (this.volumeDevices != null) {
            this.volumeDevices.clear();
            this._visitables.remove((Object)"volumeDevices");
        }
        if (volumeDevices != null) {
            for (VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeDevices() {
        return this.volumeDevices != null && !this.volumeDevices.isEmpty();
    }

    public A addNewVolumeDevice(String devicePath, String name) {
        return this.addToVolumeDevices(new VolumeDevice(devicePath, name));
    }

    public VolumeDevicesNested<A> addNewVolumeDevice() {
        return new VolumeDevicesNested(-1, null);
    }

    public VolumeDevicesNested<A> addNewVolumeDeviceLike(VolumeDevice item) {
        return new VolumeDevicesNested(-1, item);
    }

    public VolumeDevicesNested<A> setNewVolumeDeviceLike(int index, VolumeDevice item) {
        return new VolumeDevicesNested(index, item);
    }

    public VolumeDevicesNested<A> editVolumeDevice(int index) {
        if (this.volumeDevices.size() <= index) {
            throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeDevicesNested<A> editFirstVolumeDevice() {
        if (this.volumeDevices.size() == 0) {
            throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(0, this.buildVolumeDevice(0));
    }

    public VolumeDevicesNested<A> editLastVolumeDevice() {
        int index = this.volumeDevices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<VolumeDeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeDevices.size(); ++i) {
            if (!predicate.test(this.volumeDevices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get((Object)"volumeMounts").remove((Object)builder);
            this.volumeMounts.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)((Object)this);
        }
        Iterator<VolumeMountBuilder> each = this.volumeMounts.iterator();
        List visitables = this._visitables.get((Object)"volumeMounts");
        while (each.hasNext()) {
            VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<VolumeMount> buildVolumeMounts() {
        return this.volumeMounts != null ? ContainerFluent.build(this.volumeMounts) : null;
    }

    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get((Object)"volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)((Object)this);
    }

    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove((Object)"volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNested(-1, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNested(index, item);
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)((Object)this);
    }

    public boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluent that = (ContainerFluent)((Object)o);
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.envFrom, that.envFrom)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.lifecycle, (Object)that.lifecycle)) {
            return false;
        }
        if (!Objects.equals((Object)this.livenessProbe, (Object)that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals((Object)this.readinessProbe, (Object)that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.resizePolicy, that.resizePolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.resources, (Object)that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.securityContext, (Object)that.securityContext)) {
            return false;
        }
        if (!Objects.equals((Object)this.startupProbe, (Object)that.startupProbe)) {
            return false;
        }
        if (!Objects.equals(this.stdin, that.stdin)) {
            return false;
        }
        if (!Objects.equals(this.stdinOnce, that.stdinOnce)) {
            return false;
        }
        if (!Objects.equals(this.terminationMessagePath, that.terminationMessagePath)) {
            return false;
        }
        if (!Objects.equals(this.terminationMessagePolicy, that.terminationMessagePolicy)) {
            return false;
        }
        if (!Objects.equals(this.tty, that.tty)) {
            return false;
        }
        if (!Objects.equals(this.volumeDevices, that.volumeDevices)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resizePolicy, this.resources, this.restartPolicy, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.args != null && !this.args.isEmpty()) {
            sb.append("args:");
            sb.append(String.valueOf(this.args) + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(String.valueOf(this.command) + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(String.valueOf(this.env) + ",");
        }
        if (this.envFrom != null && !this.envFrom.isEmpty()) {
            sb.append("envFrom:");
            sb.append(String.valueOf(this.envFrom) + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.lifecycle != null) {
            sb.append("lifecycle:");
            sb.append(String.valueOf((Object)this.lifecycle) + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(String.valueOf((Object)this.livenessProbe) + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(String.valueOf(this.ports) + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(String.valueOf((Object)this.readinessProbe) + ",");
        }
        if (this.resizePolicy != null && !this.resizePolicy.isEmpty()) {
            sb.append("resizePolicy:");
            sb.append(String.valueOf(this.resizePolicy) + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(String.valueOf((Object)this.resources) + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(String.valueOf((Object)this.securityContext) + ",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append(String.valueOf((Object)this.startupProbe) + ",");
        }
        if (this.stdin != null) {
            sb.append("stdin:");
            sb.append(this.stdin + ",");
        }
        if (this.stdinOnce != null) {
            sb.append("stdinOnce:");
            sb.append(this.stdinOnce + ",");
        }
        if (this.terminationMessagePath != null) {
            sb.append("terminationMessagePath:");
            sb.append(this.terminationMessagePath + ",");
        }
        if (this.terminationMessagePolicy != null) {
            sb.append("terminationMessagePolicy:");
            sb.append(this.terminationMessagePolicy + ",");
        }
        if (this.tty != null) {
            sb.append("tty:");
            sb.append(this.tty + ",");
        }
        if (this.volumeDevices != null && !this.volumeDevices.isEmpty()) {
            sb.append("volumeDevices:");
            sb.append(String.valueOf(this.volumeDevices) + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(String.valueOf(this.volumeMounts) + ",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withStdin() {
        return this.withStdin(true);
    }

    public A withStdinOnce() {
        return this.withStdinOnce(true);
    }

    public A withTty() {
        return this.withTty(true);
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        VolumeMountBuilder builder;
        int index;

        VolumeMountsNested(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class VolumeDevicesNested<N>
    extends VolumeDeviceFluent<VolumeDevicesNested<N>>
    implements Nested<N> {
        VolumeDeviceBuilder builder;
        int index;

        VolumeDevicesNested(int index, VolumeDevice item) {
            this.index = index;
            this.builder = new VolumeDeviceBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToVolumeDevices(this.index, this.builder.build());
        }

        public N endVolumeDevice() {
            return this.and();
        }
    }

    public class StartupProbeNested<N>
    extends ProbeFluent<StartupProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        StartupProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withStartupProbe(this.builder.build());
        }

        public N endStartupProbe() {
            return this.and();
        }
    }

    public class SecurityContextNested<N>
    extends SecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        SecurityContextBuilder builder;

        SecurityContextNested(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withSecurityContext(this.builder.build());
        }

        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class ResizePolicyNested<N>
    extends ContainerResizePolicyFluent<ResizePolicyNested<N>>
    implements Nested<N> {
        ContainerResizePolicyBuilder builder;
        int index;

        ResizePolicyNested(int index, ContainerResizePolicy item) {
            this.index = index;
            this.builder = new ContainerResizePolicyBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToResizePolicy(this.index, this.builder.build());
        }

        public N endResizePolicy() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        ReadinessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends ContainerPortFluent<PortsNested<N>>
    implements Nested<N> {
        ContainerPortBuilder builder;
        int index;

        PortsNested(int index, ContainerPort item) {
            this.index = index;
            this.builder = new ContainerPortBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        ProbeBuilder builder;

        LivenessProbeNested(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class LifecycleNested<N>
    extends LifecycleFluent<LifecycleNested<N>>
    implements Nested<N> {
        LifecycleBuilder builder;

        LifecycleNested(Lifecycle item) {
            this.builder = new LifecycleBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withLifecycle(this.builder.build());
        }

        public N endLifecycle() {
            return this.and();
        }
    }

    public class EnvFromNested<N>
    extends EnvFromSourceFluent<EnvFromNested<N>>
    implements Nested<N> {
        EnvFromSourceBuilder builder;
        int index;

        EnvFromNested(int index, EnvFromSource item) {
            this.index = index;
            this.builder = new EnvFromSourceBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToEnvFrom(this.index, this.builder.build());
        }

        public N endEnvFrom() {
            return this.and();
        }
    }

    public class EnvNested<N>
    extends EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        EnvVarBuilder builder;
        int index;

        EnvNested(int index, EnvVar item) {
            this.index = index;
            this.builder = new EnvVarBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }
}

