/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.bucketing;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.bucketing.ExtractJoinWithBuckets$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.joins.ShuffledHashJoinExec;
import org.apache.spark.sql.execution.joins.ShuffledJoin;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.collection.BitSet;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class CoalesceBucketsInJoin$
extends Rule<SparkPlan> {
    public static final CoalesceBucketsInJoin$ MODULE$ = new CoalesceBucketsInJoin$();

    private SparkPlan updateNumCoalescedBucketsInScan(SparkPlan plan, int numCoalescedBuckets) {
        return (SparkPlan)plan.transformUp((PartialFunction)new Serializable(numCoalescedBuckets){
            private static final long serialVersionUID = 0L;
            private final int numCoalescedBuckets$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FileSourceScanExec fileSourceScanExec;
                A1 A1 = x1;
                if (A1 instanceof FileSourceScanExec && (fileSourceScanExec = (FileSourceScanExec)A1).relation().bucketSpec().nonEmpty()) {
                    Some x$1 = new Some((Object)BoxesRunTime.boxToInteger((int)this.numCoalescedBuckets$1));
                    HadoopFsRelation x$2 = fileSourceScanExec.copy$default$1();
                    Option<SparkDataStream> x$3 = fileSourceScanExec.copy$default$2();
                    Seq<Attribute> x$4 = fileSourceScanExec.copy$default$3();
                    StructType x$5 = fileSourceScanExec.copy$default$4();
                    Seq<Expression> x$6 = fileSourceScanExec.copy$default$5();
                    Option<BitSet> x$7 = fileSourceScanExec.copy$default$6();
                    Seq<Expression> x$8 = fileSourceScanExec.copy$default$8();
                    Option<TableIdentifier> x$9 = fileSourceScanExec.copy$default$9();
                    boolean x$10 = fileSourceScanExec.copy$default$10();
                    return (B1)fileSourceScanExec.copy(x$2, x$3, x$4, x$5, x$6, x$7, (Option<Object>)x$1, x$8, x$9, x$10);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                FileSourceScanExec fileSourceScanExec;
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof FileSourceScanExec && (fileSourceScanExec = (FileSourceScanExec)sparkPlan).relation().bucketSpec().nonEmpty();
            }
            {
                this.numCoalescedBuckets$1 = numCoalescedBuckets$1;
            }
        });
    }

    public ShuffledJoin org$apache$spark$sql$execution$bucketing$CoalesceBucketsInJoin$$updateNumCoalescedBuckets(ShuffledJoin join, int numLeftBuckets, int numCoalescedBuckets) {
        if (numCoalescedBuckets != numLeftBuckets) {
            SparkPlan leftCoalescedChild = this.updateNumCoalescedBucketsInScan((SparkPlan)join.left(), numCoalescedBuckets);
            ShuffledJoin shuffledJoin = join;
            if (shuffledJoin instanceof SortMergeJoinExec) {
                SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)shuffledJoin;
                SparkPlan x$1 = leftCoalescedChild;
                Seq<Expression> x$2 = sortMergeJoinExec.copy$default$1();
                Seq<Expression> x$3 = sortMergeJoinExec.copy$default$2();
                JoinType x$4 = sortMergeJoinExec.copy$default$3();
                Option<Expression> x$5 = sortMergeJoinExec.copy$default$4();
                SparkPlan x$6 = sortMergeJoinExec.copy$default$6();
                boolean x$7 = sortMergeJoinExec.copy$default$7();
                return sortMergeJoinExec.copy(x$2, x$3, x$4, x$5, x$1, x$6, x$7);
            }
            if (shuffledJoin instanceof ShuffledHashJoinExec) {
                ShuffledHashJoinExec shuffledHashJoinExec = (ShuffledHashJoinExec)shuffledJoin;
                SparkPlan x$8 = leftCoalescedChild;
                Seq<Expression> x$9 = shuffledHashJoinExec.copy$default$1();
                Seq<Expression> x$10 = shuffledHashJoinExec.copy$default$2();
                JoinType x$11 = shuffledHashJoinExec.copy$default$3();
                BuildSide x$12 = shuffledHashJoinExec.copy$default$4();
                Option<Expression> x$13 = shuffledHashJoinExec.copy$default$5();
                SparkPlan x$14 = shuffledHashJoinExec.copy$default$7();
                boolean x$15 = shuffledHashJoinExec.copy$default$8();
                return shuffledHashJoinExec.copy(x$9, x$10, x$11, x$12, x$13, x$8, x$14, x$15);
            }
            throw new MatchError((Object)shuffledJoin);
        }
        SparkPlan rightCoalescedChild = this.updateNumCoalescedBucketsInScan((SparkPlan)join.right(), numCoalescedBuckets);
        ShuffledJoin shuffledJoin = join;
        if (shuffledJoin instanceof SortMergeJoinExec) {
            SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)shuffledJoin;
            SparkPlan x$16 = rightCoalescedChild;
            Seq<Expression> x$17 = sortMergeJoinExec.copy$default$1();
            Seq<Expression> x$18 = sortMergeJoinExec.copy$default$2();
            JoinType x$19 = sortMergeJoinExec.copy$default$3();
            Option<Expression> x$20 = sortMergeJoinExec.copy$default$4();
            SparkPlan x$21 = sortMergeJoinExec.copy$default$5();
            boolean x$22 = sortMergeJoinExec.copy$default$7();
            return sortMergeJoinExec.copy(x$17, x$18, x$19, x$20, x$21, x$16, x$22);
        }
        if (shuffledJoin instanceof ShuffledHashJoinExec) {
            ShuffledHashJoinExec shuffledHashJoinExec = (ShuffledHashJoinExec)shuffledJoin;
            SparkPlan x$23 = rightCoalescedChild;
            Seq<Expression> x$24 = shuffledHashJoinExec.copy$default$1();
            Seq<Expression> x$25 = shuffledHashJoinExec.copy$default$2();
            JoinType x$26 = shuffledHashJoinExec.copy$default$3();
            BuildSide x$27 = shuffledHashJoinExec.copy$default$4();
            Option<Expression> x$28 = shuffledHashJoinExec.copy$default$5();
            SparkPlan x$29 = shuffledHashJoinExec.copy$default$6();
            boolean x$30 = shuffledHashJoinExec.copy$default$8();
            return shuffledHashJoinExec.copy(x$24, x$25, x$26, x$27, x$28, x$29, x$23, x$30);
        }
        throw new MatchError((Object)shuffledJoin);
    }

    public boolean org$apache$spark$sql$execution$bucketing$CoalesceBucketsInJoin$$isCoalesceSHJStreamSide(ShuffledHashJoinExec join, int numLeftBuckets, int numCoalescedBuckets) {
        if (numCoalescedBuckets == numLeftBuckets) {
            BuildSide buildSide = join.buildSide();
            BuildRight$ buildRight$ = BuildRight$.MODULE$;
            return buildSide == null ? buildRight$ != null : !buildSide.equals(buildRight$);
        }
        BuildSide buildSide = join.buildSide();
        BuildLeft$ buildLeft$ = BuildLeft$.MODULE$;
        return buildSide == null ? buildLeft$ != null : !buildSide.equals(buildLeft$);
    }

    public SparkPlan apply(SparkPlan plan) {
        if (!this.conf().coalesceBucketsInJoinEnabled()) {
            return plan;
        }
        return (SparkPlan)plan.transform((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option<Tuple3<ShuffledJoin, Object, Object>> option;
                A1 A1 = x1;
                if (A1 != null && !(option = ExtractJoinWithBuckets$.MODULE$.unapply(A1)).isEmpty()) {
                    int numRightBuckets;
                    ShuffledJoin join = (ShuffledJoin)((Tuple3)option.get())._1();
                    int numLeftBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._2());
                    if (package$.MODULE$.max(numLeftBuckets, numRightBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3())) / package$.MODULE$.min(numLeftBuckets, numRightBuckets) <= CoalesceBucketsInJoin$.MODULE$.conf().coalesceBucketsInJoinMaxBucketRatio()) {
                        ShuffledHashJoinExec shuffledHashJoinExec;
                        int numCoalescedBuckets = package$.MODULE$.min(numLeftBuckets, numRightBuckets);
                        ShuffledJoin shuffledJoin = join;
                        if (shuffledJoin instanceof SortMergeJoinExec) {
                            SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)shuffledJoin;
                            return (B1)((SparkPlan)((Object)CoalesceBucketsInJoin$.MODULE$.org$apache$spark$sql$execution$bucketing$CoalesceBucketsInJoin$$updateNumCoalescedBuckets(sortMergeJoinExec, numLeftBuckets, numCoalescedBuckets)));
                        }
                        if (shuffledJoin instanceof ShuffledHashJoinExec && CoalesceBucketsInJoin$.MODULE$.org$apache$spark$sql$execution$bucketing$CoalesceBucketsInJoin$$isCoalesceSHJStreamSide(shuffledHashJoinExec = (ShuffledHashJoinExec)shuffledJoin, numLeftBuckets, numCoalescedBuckets)) {
                            return (B1)((SparkPlan)((Object)CoalesceBucketsInJoin$.MODULE$.org$apache$spark$sql$execution$bucketing$CoalesceBucketsInJoin$$updateNumCoalescedBuckets(shuffledHashJoinExec, numLeftBuckets, numCoalescedBuckets)));
                        }
                        return (B1)((SparkPlan)((Object)shuffledJoin));
                    }
                }
                return (B1)A1;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                int numRightBuckets;
                int numLeftBuckets;
                Option<Tuple3<ShuffledJoin, Object, Object>> option;
                SparkPlan sparkPlan = x1;
                if (sparkPlan != null && !(option = ExtractJoinWithBuckets$.MODULE$.unapply(sparkPlan)).isEmpty() && package$.MODULE$.max(numLeftBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._2()), numRightBuckets = BoxesRunTime.unboxToInt((Object)((Tuple3)option.get())._3())) / package$.MODULE$.min(numLeftBuckets, numRightBuckets) <= CoalesceBucketsInJoin$.MODULE$.conf().coalesceBucketsInJoinMaxBucketRatio()) {
                    return true;
                }
                return true;
            }
        });
    }

    private CoalesceBucketsInJoin$() {
    }
}

