/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSBuilder;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FutureDataInputStreamBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CompressedSplitLineReader;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SplitLineReader;
import org.apache.hadoop.mapreduce.lib.input.UncompressedSplitLineReader;
import org.apache.hadoop.util.functional.FutureIO;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.io.HadoopCodecStreams;
import scala.Option;

public class HadoopLineRecordReader
extends RecordReader<LongWritable, Text> {
    public static final String MAX_LINE_LENGTH = "mapreduce.input.linerecordreader.line.maxlength";
    private static final SparkLogger LOG = SparkLoggerFactory.getLogger(HadoopLineRecordReader.class);
    private long start;
    private long pos;
    private long end;
    private SplitLineReader in;
    private FSDataInputStream fileIn;
    private Seekable filePosition;
    private int maxLineLength;
    private LongWritable key;
    private Text value;
    private boolean isCompressedInput;
    private Decompressor decompressor;
    private byte[] recordDelimiterBytes;

    public HadoopLineRecordReader() {
    }

    public HadoopLineRecordReader(byte[] recordDelimiter) {
        this.recordDelimiterBytes = recordDelimiter;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        FileSplit split = (FileSplit)genericSplit;
        Configuration job = context.getConfiguration();
        this.maxLineLength = job.getInt(MAX_LINE_LENGTH, Integer.MAX_VALUE);
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        FutureDataInputStreamBuilder builder = file.getFileSystem(job).openFile(file);
        builder.optLong("fs.option.openfile.split.start", this.start);
        builder.optLong("fs.option.openfile.split.end", this.end);
        FutureIO.propagateOptions((FSBuilder)builder, (Configuration)job, (String)"mapreduce.job.input.file.option.", (String)"mapreduce.job.input.file.must.");
        this.fileIn = (FSDataInputStream)FutureIO.awaitFuture((Future)builder.build());
        try {
            block11: {
                Option codecOpt = HadoopCodecStreams.getDecompressionCodec((Configuration)job, (Path)file);
                if (codecOpt.isDefined()) {
                    CompressionCodec codec = (CompressionCodec)codecOpt.get();
                    this.isCompressedInput = true;
                    try {
                        this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                        if (codec instanceof SplittableCompressionCodec) {
                            SplitCompressionInputStream cIn = ((SplittableCompressionCodec)codec).createInputStream((InputStream)this.fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.BYBLOCK);
                            this.in = new CompressedSplitLineReader(cIn, job, this.recordDelimiterBytes);
                            this.start = cIn.getAdjustedStart();
                            this.end = cIn.getAdjustedEnd();
                            this.filePosition = cIn;
                            break block11;
                        }
                        if (this.start != 0L) {
                            throw new IOException("Cannot seek in " + codec.getClass().getSimpleName() + " compressed stream");
                        }
                        this.in = new SplitLineReader((InputStream)codec.createInputStream((InputStream)this.fileIn, this.decompressor), job, this.recordDelimiterBytes);
                        this.filePosition = this.fileIn;
                    }
                    catch (RuntimeException e) {
                        Option decompressedStreamOpt = HadoopCodecStreams.createZstdInputStream((Path)file, (InputStream)this.fileIn);
                        if (decompressedStreamOpt.isEmpty()) {
                            throw e;
                        }
                        InputStream decompressedStream = (InputStream)decompressedStreamOpt.get();
                        if (this.start != 0L) {
                            decompressedStream.close();
                            throw new IOException("Cannot seek in " + file.getName() + " compressed stream");
                        }
                        this.isCompressedInput = true;
                        this.in = new SplitLineReader(decompressedStream, job, this.recordDelimiterBytes);
                        this.filePosition = this.fileIn;
                    }
                } else {
                    this.fileIn.seek(this.start);
                    this.in = new UncompressedSplitLineReader(this.fileIn, job, this.recordDelimiterBytes, split.getLength());
                    this.filePosition = this.fileIn;
                }
            }
            if (this.start != 0L) {
                this.start += (long)this.in.readLine(new Text(), 0, this.maxBytesToConsume(this.start));
            }
            this.pos = this.start;
        }
        catch (Exception e) {
            this.fileIn.close();
            throw e;
        }
    }

    private int maxBytesToConsume(long pos) {
        return this.isCompressedInput ? Integer.MAX_VALUE : (int)Math.max(Math.min(Integer.MAX_VALUE, this.end - pos), (long)this.maxLineLength);
    }

    private long getFilePosition() throws IOException {
        long retVal = this.isCompressedInput && null != this.filePosition ? this.filePosition.getPos() : this.pos;
        return retVal;
    }

    private int skipUtfByteOrderMark() throws IOException {
        int newMaxLineLength = (int)Math.min(3L + (long)this.maxLineLength, Integer.MAX_VALUE);
        int newSize = this.in.readLine(this.value, newMaxLineLength, this.maxBytesToConsume(this.pos));
        this.pos += (long)newSize;
        int textLength = this.value.getLength();
        byte[] textBytes = this.value.getBytes();
        if (textLength >= 3 && textBytes[0] == -17 && textBytes[1] == -69 && textBytes[2] == -65) {
            LOG.info("Found UTF-8 BOM and skipped it");
            newSize -= 3;
            if ((textLength -= 3) > 0) {
                textBytes = this.value.copyBytes();
                this.value.set(textBytes, 3, textLength);
            } else {
                this.value.clear();
            }
        }
        return newSize;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.key == null) {
            this.key = new LongWritable();
        }
        this.key.set(this.pos);
        if (this.value == null) {
            this.value = new Text();
        }
        int newSize = 0;
        while (this.getFilePosition() <= this.end || this.in.needAdditionalRecordAfterSplit()) {
            if (this.pos == 0L) {
                newSize = this.skipUtfByteOrderMark();
            } else {
                newSize = this.in.readLine(this.value, this.maxLineLength, this.maxBytesToConsume(this.pos));
                this.pos += (long)newSize;
            }
            if (newSize == 0 || newSize < this.maxLineLength) break;
            LOG.info("Skipped line of size " + newSize + " at pos " + (this.pos - (long)newSize));
        }
        if (newSize == 0) {
            this.key = null;
            this.value = null;
            return false;
        }
        return true;
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public Text getCurrentValue() {
        return this.value;
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getFilePosition() - this.start) / (float)(this.end - this.start));
    }

    public synchronized void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        finally {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
                this.decompressor = null;
            }
        }
    }
}

