/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.timers;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TimerKeyEncoder;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.statefulprocessor.ImplicitGroupingKeyTracker$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.timers.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.RangeKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.apache.spark.sql.execution.streaming.state.StateStoreIterator;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.NextIterator;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u000f\u001f\u0001MB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003Z\u0001\u0011\u0005!\fC\u0004a\u0001\t\u0007I\u0011B1\t\r!\u0004\u0001\u0015!\u0003c\u0011\u001dI\u0007A1A\u0005\n)Da!\u001d\u0001!\u0002\u0013Y\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\u0007y\u0002\u0001\u000b\u0011\u0002;\t\u000fu\u0004!\u0019!C\u0005}\"9\u0011q\u0001\u0001!\u0002\u0013y\b\u0002CA\u0005\u0001\t\u0007I\u0011\u00026\t\u000f\u0005-\u0001\u0001)A\u0005W\"A\u0011Q\u0002\u0001C\u0002\u0013%1\u000fC\u0004\u0002\u0010\u0001\u0001\u000b\u0011\u0002;\t\u0011\u0005E\u0001A1A\u0005\n)Dq!a\u0005\u0001A\u0003%1\u000e\u0003\u0005\u0002\u0016\u0001\u0011\r\u0011\"\u0003t\u0011\u001d\t9\u0002\u0001Q\u0001\nQDq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u00026\u0001!I!a\u000e\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\ti\b\u0001C\u0005\u0003\u007fBq!a#\u0001\t\u0003\tiI\u0001\bUS6,'o\u0015;bi\u0016LU\u000e\u001d7\u000b\u0005}\u0001\u0013A\u0002;j[\u0016\u00148O\u0003\u0002\"E\u0005\u0011BO]1og\u001a|'/\\<ji\"\u001cH/\u0019;f\u0015\t\u0019C%\u0001\u0005ti\u0006$XMZ;m\u0015\t)c%A\u0005pa\u0016\u0014\u0018\r^8sg*\u0011q\u0005K\u0001\ngR\u0014X-Y7j]\u001eT!!\u000b\u0016\u0002\u0013\u0015DXmY;uS>t'BA\u0016-\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003[9\nQa\u001d9be.T!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u00011c\u0001\u00015uA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\u0004\"a\u000f \u000e\u0003qR!!\u0010\u0017\u0002\u0011%tG/\u001a:oC2L!a\u0010\u001f\u0003\u000f1{wmZ5oO\u0006)1\u000f^8sKB\u0011!)R\u0007\u0002\u0007*\u0011AIJ\u0001\u0006gR\fG/Z\u0005\u0003\r\u000e\u0013!b\u0015;bi\u0016\u001cFo\u001c:f\u0003!!\u0018.\\3N_\u0012,\u0007CA%L\u001b\u0005Q%BA\u0014+\u0013\ta%J\u0001\u0005US6,Wj\u001c3f\u0003)YW-_#yaJ,en\u0019\t\u0004\u001fR3V\"\u0001)\u000b\u0005E\u0013\u0016\u0001C3oG>$WM]:\u000b\u0005MS\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005U\u0003&!E#yaJ,7o]5p]\u0016s7m\u001c3feB\u0011QgV\u0005\u00031Z\u00121!\u00118z\u0003\u0019a\u0014N\\5u}Q!1,\u00180`!\ta\u0006!D\u0001\u001f\u0011\u0015\u0001E\u00011\u0001B\u0011\u00159E\u00011\u0001I\u0011\u0015iE\u00011\u0001O\u0003%)U\n\u0015+Z?J{u+F\u0001c!\t\u0019g-D\u0001e\u0015\t)'+A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA4e\u0005%)fn]1gKJ{w/\u0001\u0006F\u001bB#\u0016l\u0018*P/\u0002\n\u0011c]2iK6\fgi\u001c:WC2,XMU8x+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018+\u0003\u0015!\u0018\u0010]3t\u0013\t\u0001XN\u0001\u0006TiJ,8\r\u001e+za\u0016\f!c]2iK6\fgi\u001c:WC2,XMU8xA\u0005YA/[7fe\u000e3e*Y7f+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u00111P\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019QLW.\u001a:D\r:\u000bW.\u001a\u0011\u0002\u0015I|w/\u00128d_\u0012,'/F\u0001\u0000!\u0011\t\t!a\u0001\u000e\u0003\u0001J1!!\u0002!\u0005=!\u0016.\\3s\u0017\u0016LXI\\2pI\u0016\u0014\u0018a\u0003:po\u0016s7m\u001c3fe\u0002\nqb]2iK6\fgi\u001c:LKf\u0014vn^\u0001\u0011g\u000eDW-\\1G_J\\U-\u001f*po\u0002\nQb[3z)>$6o\u0011$OC6,\u0017AD6fsR{Gk]\"G\u001d\u0006lW\rI\u0001\u0015W\u0016L8k\u00195f[\u00064uN]*fG&sG-\u001a=\u0002+-,\u0017pU2iK6\fgi\u001c:TK\u000eLe\u000eZ3yA\u0005iAo\u001d+p\u0017\u0016L8I\u0012(b[\u0016\fa\u0002^:U_.+\u0017p\u0011$OC6,\u0007%\u0001\bhKR<%o\\;qS:<7*Z=\u0015\u0007Y\u000bi\u0002C\u0004\u0002 U\u0001\r!!\t\u0002\r\r4g*Y7f!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003O1TBAA\u0015\u0015\r\tYCM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=b'\u0001\u0004Qe\u0016$WMZ\u0005\u0004w\u0006M\"bAA\u0018m\u00051Q\r_5tiN$b!!\u000f\u0002@\u0005\r\u0003cA\u001b\u0002<%\u0019\u0011Q\b\u001c\u0003\u000f\t{w\u000e\\3b]\"1\u0011\u0011\t\fA\u0002Y\u000b1b\u001a:pkBLgnZ&fs\"9\u0011Q\t\fA\u0002\u0005\u001d\u0013!E3ya&\u0014\u0018\u0010V5nKN$\u0018-\u001c9NgB\u0019Q'!\u0013\n\u0007\u0005-cG\u0001\u0003M_:<\u0017aB4fi&k\u0007\u000f\u001c\u000b\u0006E\u0006E\u00131\u000b\u0005\u0007\u0003\u0003:\u0002\u0019\u0001,\t\u000f\u0005\u0015s\u00031\u0001\u0002H\u0005i!/Z4jgR,'\u000fV5nKJ$B!!\u0017\u0002`A\u0019Q'a\u0017\n\u0007\u0005ucG\u0001\u0003V]&$\bbBA#1\u0001\u0007\u0011qI\u0001\fI\u0016dW\r^3US6,'\u000f\u0006\u0003\u0002Z\u0005\u0015\u0004bBA#3\u0001\u0007\u0011qI\u0001\u000bY&\u001cH\u000fV5nKJ\u001cHCAA6!\u0019\ti'a\u001e\u0002H9!\u0011qNA:\u001d\u0011\t9#!\u001d\n\u0003]J1!!\u001e7\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001f\u0002|\tA\u0011\n^3sCR|'OC\u0002\u0002vY\nqcZ3u)&lWM\u001d*po\u001a\u0013x.\\*fG&sG-\u001a=\u0015\t\u0005\u0005\u0015q\u0011\t\u0007k\u0005\re+a\u0012\n\u0007\u0005\u0015eG\u0001\u0004UkBdWM\r\u0005\u0007\u0003\u0013[\u0002\u0019\u00012\u0002\r-,\u0017PU8x\u0003A9W\r^#ya&\u0014X\r\u001a+j[\u0016\u00148\u000f\u0006\u0003\u0002\u0010\u0006E\u0005CBA7\u0003o\n\t\tC\u0004\u0002Fq\u0001\r!a\u0012")
public class TimerStateImpl
implements Logging {
    private final StateStore store;
    private final ExpressionEncoder<Object> keyExprEnc;
    private final UnsafeRow EMPTY_ROW;
    private final StructType schemaForValueRow;
    private final String timerCFName;
    private final TimerKeyEncoder rowEncoder;
    private final StructType schemaForKeyRow;
    private final String keyToTsCFName;
    private final StructType keySchemaForSecIndex;
    private final String tsToKeyCFName;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private UnsafeRow EMPTY_ROW() {
        return this.EMPTY_ROW;
    }

    private StructType schemaForValueRow() {
        return this.schemaForValueRow;
    }

    private String timerCFName() {
        return this.timerCFName;
    }

    private TimerKeyEncoder rowEncoder() {
        return this.rowEncoder;
    }

    private StructType schemaForKeyRow() {
        return this.schemaForKeyRow;
    }

    private String keyToTsCFName() {
        return this.keyToTsCFName;
    }

    private StructType keySchemaForSecIndex() {
        return this.keySchemaForSecIndex;
    }

    private String tsToKeyCFName() {
        return this.tsToKeyCFName;
    }

    private Object getGroupingKey(String cfName) {
        Option<Object> keyOption = ImplicitGroupingKeyTracker$.MODULE$.getImplicitKeyOption();
        if (keyOption.isEmpty()) {
            throw StateStoreErrors$.MODULE$.implicitKeyNotFound(cfName);
        }
        return keyOption.get();
    }

    private boolean exists(Object groupingKey, long expiryTimestampMs) {
        return this.getImpl(groupingKey, expiryTimestampMs) != null;
    }

    private UnsafeRow getImpl(Object groupingKey, long expiryTimestampMs) {
        return this.store.get(this.rowEncoder().encodedKey(groupingKey, expiryTimestampMs), this.keyToTsCFName());
    }

    public void registerTimer(long expiryTimestampMs) {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        if (this.exists(groupingKey, expiryTimestampMs)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to register timer for key=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.KEY, groupingKey)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp=", " ms since it already exists"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXPIRY_TIMESTAMP, BoxesRunTime.boxToLong((long)expiryTimestampMs))})))));
            return;
        }
        this.store.put(this.rowEncoder().encodedKey(groupingKey, expiryTimestampMs), this.EMPTY_ROW(), this.keyToTsCFName());
        this.store.put(this.rowEncoder().encodeSecIndexKey(groupingKey, expiryTimestampMs), this.EMPTY_ROW(), this.tsToKeyCFName());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Registered timer for key=" + groupingKey + " and timestamp=" + expiryTimestampMs);
    }

    public void deleteTimer(long expiryTimestampMs) {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        if (!this.exists(groupingKey, expiryTimestampMs)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to delete timer for key=", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.KEY, groupingKey)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp=", " ms since it does not exist"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXPIRY_TIMESTAMP, BoxesRunTime.boxToLong((long)expiryTimestampMs))})))));
            return;
        }
        this.store.remove(this.rowEncoder().encodedKey(groupingKey, expiryTimestampMs), this.keyToTsCFName());
        this.store.remove(this.rowEncoder().encodeSecIndexKey(groupingKey, expiryTimestampMs), this.tsToKeyCFName());
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Deleted timer for key=" + groupingKey + " and timestamp=" + expiryTimestampMs);
    }

    public Iterator<Object> listTimers() {
        Object groupingKey = this.getGroupingKey(this.keyToTsCFName());
        UnsafeRow encodedGroupingKey = this.rowEncoder().encodePrefixKey(groupingKey);
        StateStoreIterator<UnsafeRowPair> iter = this.store.prefixScan(encodedGroupingKey, this.keyToTsCFName());
        return iter.map((Function1 & Serializable)kv -> BoxesRunTime.boxToLong((long)TimerStateImpl.$anonfun$listTimers$1(kv)));
    }

    public Tuple2<Object, Object> org$apache$spark$sql$execution$streaming$operators$stateful$transformwithstate$timers$TimerStateImpl$$getTimerRowFromSecIndex(UnsafeRow keyRow) {
        UnsafeRow retUnsafeRow = keyRow.getStruct(1, this.keyExprEnc.schema().length());
        Object keyObj = this.rowEncoder().decodePrefixKey(retUnsafeRow);
        long expiryTimestampMs = keyRow.getLong(0);
        return new Tuple2(keyObj, (Object)BoxesRunTime.boxToLong((long)expiryTimestampMs));
    }

    public Iterator<Tuple2<Object, Object>> getExpiredTimers(long expiryTimestampMs) {
        StateStoreIterator<UnsafeRowPair> iter = this.store.iterator(this.tsToKeyCFName());
        return new NextIterator<Tuple2<Object, Object>>(this, iter, expiryTimestampMs){
            private final /* synthetic */ TimerStateImpl $outer;
            private final StateStoreIterator iter$1;
            private final long expiryTimestampMs$3;

            public Tuple2<Object, Object> getNext() {
                if (this.iter$1.hasNext()) {
                    UnsafeRowPair rowPair = (UnsafeRowPair)this.iter$1.next();
                    UnsafeRow keyRow = rowPair.key();
                    Tuple2<Object, Object> result = this.$outer.org$apache$spark$sql$execution$streaming$operators$stateful$transformwithstate$timers$TimerStateImpl$$getTimerRowFromSecIndex(keyRow);
                    if (result._2$mcJ$sp() <= this.expiryTimestampMs$3) {
                        return result;
                    }
                    this.finished_$eq(true);
                    return null;
                }
                this.finished_$eq(true);
                return null;
            }

            public void close() {
                this.iter$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$1 = iter$1;
                this.expiryTimestampMs$3 = expiryTimestampMs$3;
            }
        };
    }

    public static final /* synthetic */ long $anonfun$listTimers$1(UnsafeRowPair kv) {
        UnsafeRow keyRow = kv.key();
        return keyRow.getLong(1);
    }

    public TimerStateImpl(StateStore store, TimeMode timeMode, ExpressionEncoder<Object> keyExprEnc) {
        this.store = store;
        this.keyExprEnc = keyExprEnc;
        Logging.$init$((Logging)this);
        this.EMPTY_ROW = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{NullType$.MODULE$})).apply(InternalRow$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{null})));
        this.schemaForValueRow = new StructType((StructField[])((Object[])new StructField[]{new StructField("__dummy__", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        TimeMode timeMode2 = timeMode;
        TimeMode timeMode3 = TimeMode.ProcessingTime();
        this.timerCFName = !(timeMode2 != null ? !timeMode2.equals(timeMode3) : timeMode3 != null) ? TimerStateUtils$.MODULE$.PROC_TIMERS_STATE_NAME() : TimerStateUtils$.MODULE$.EVENT_TIMERS_STATE_NAME();
        this.rowEncoder = new TimerKeyEncoder(keyExprEnc);
        this.schemaForKeyRow = this.rowEncoder().schemaForKeyRow();
        this.keyToTsCFName = this.timerCFName() + TimerStateUtils$.MODULE$.KEY_TO_TIMESTAMP_CF();
        store.createColFamilyIfAbsent(this.keyToTsCFName(), this.schemaForKeyRow(), this.schemaForValueRow(), new PrefixKeyScanStateEncoderSpec(this.schemaForKeyRow(), 1), false, true);
        this.keySchemaForSecIndex = this.rowEncoder().keySchemaForSecIndex();
        this.tsToKeyCFName = this.timerCFName() + TimerStateUtils$.MODULE$.TIMESTAMP_TO_KEY_CF();
        store.createColFamilyIfAbsent(this.tsToKeyCFName(), this.keySchemaForSecIndex(), this.schemaForValueRow(), new RangeKeyScanStateEncoderSpec(this.keySchemaForSecIndex(), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})))), false, true);
    }
}

