/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc;

import javax.annotation.Nullable;
import org.sparkproject.connect.grpc.ExperimentalApi;
import org.sparkproject.connect.grpc.Status;
import org.sparkproject.guava.base.MoreObjects;
import org.sparkproject.guava.base.Objects;
import org.sparkproject.guava.base.Preconditions;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11563")
public class StatusOr<T> {
    @Nullable
    private final Status status;
    private final T value;

    private StatusOr(Status status, T value) {
        this.status = status;
        this.value = value;
    }

    public static <T> StatusOr<T> fromValue(T value) {
        StatusOr<T> result = new StatusOr<T>(null, value);
        return result;
    }

    public static <T> StatusOr<T> fromStatus(Status status) {
        StatusOr<Object> result = new StatusOr<Object>((Status)Preconditions.checkNotNull((Object)status, (Object)"status"), null);
        Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (String)"cannot use OK status: %s", (Object)status);
        return result;
    }

    public boolean hasValue() {
        return this.status == null;
    }

    public T getValue() {
        if (this.status != null) {
            throw new IllegalStateException("No value present.");
        }
        return this.value;
    }

    public Status getStatus() {
        return this.status == null ? Status.OK : this.status;
    }

    public boolean equals(Object other) {
        if (!(other instanceof StatusOr)) {
            return false;
        }
        StatusOr otherStatus = (StatusOr)other;
        if (this.hasValue() != otherStatus.hasValue()) {
            return false;
        }
        if (this.hasValue()) {
            return Objects.equal(this.value, otherStatus.value);
        }
        return Objects.equal((Object)this.status, (Object)otherStatus.status);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.value});
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this);
        if (this.status == null) {
            stringHelper.add("value", this.value);
        } else {
            stringHelper.add("error", (Object)this.status);
        }
        return stringHelper.toString();
    }
}

