/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.AllFieldsConstructor;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.JavaParserMetaModel;
import com.github.javaparser.metamodel.SwitchEntryStmtMetaModel;
import com.github.javaparser.utils.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class SwitchEntryStmt
extends Statement
implements NodeWithStatements<SwitchEntryStmt> {
    private Expression label;
    private NodeList<Statement> statements;

    public SwitchEntryStmt() {
        this(null, null, new NodeList<Statement>());
    }

    @AllFieldsConstructor
    public SwitchEntryStmt(Expression label, NodeList<Statement> statements) {
        this(null, label, statements);
    }

    public SwitchEntryStmt(TokenRange tokenRange, Expression label, NodeList<Statement> statements) {
        super(tokenRange);
        this.setLabel(label);
        this.setStatements((NodeList)statements);
        this.customInitialization();
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Optional<Expression> getLabel() {
        return Optional.ofNullable(this.label);
    }

    @Override
    public NodeList<Statement> getStatements() {
        return this.statements;
    }

    public SwitchEntryStmt setLabel(Expression label) {
        if (label == this.label) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.LABEL, this.label, label);
        if (this.label != null) {
            this.label.setParentNode(null);
        }
        this.label = label;
        this.setAsParentNodeOf(label);
        return this;
    }

    @Override
    public SwitchEntryStmt setStatements(NodeList<Statement> statements) {
        Utils.assertNotNull(statements);
        if (statements == this.statements) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.STATEMENTS, this.statements, statements);
        if (this.statements != null) {
            this.statements.setParentNode(null);
        }
        this.statements = statements;
        this.setAsParentNodeOf(statements);
        return this;
    }

    @Override
    public List<NodeList<?>> getNodeLists() {
        return Arrays.asList(this.getStatements());
    }

    @Override
    public boolean remove(Node node) {
        if (node == null) {
            return false;
        }
        if (this.label != null && node == this.label) {
            this.removeLabel();
            return true;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i) != node) continue;
            this.statements.remove(i);
            return true;
        }
        return super.remove(node);
    }

    public SwitchEntryStmt removeLabel() {
        return this.setLabel(null);
    }

    @Override
    public SwitchEntryStmt clone() {
        return (SwitchEntryStmt)this.accept(new CloneVisitor(), null);
    }

    @Override
    public SwitchEntryStmtMetaModel getMetaModel() {
        return JavaParserMetaModel.switchEntryStmtMetaModel;
    }

    public SwitchEntryStmt replaceLabel(Expression replacement) {
        return this.setLabel(replacement);
    }

    @Override
    public boolean replace(Node node, Node replacementNode) {
        if (node == null) {
            return false;
        }
        if (this.label != null && node == this.label) {
            this.replaceLabel((Expression)replacementNode);
            return true;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i) != node) continue;
            this.statements.set(i, (Statement)replacementNode);
            return true;
        }
        return super.replace(node, replacementNode);
    }
}

