/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.python;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.AccumulatorV2;
import org.apache.spark.util.CollectionAccumulator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b!\u0002\f\u0018\u0001m\t\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011B\u001d\t\u0011!\u0003!\u0011!Q\u0001\niB\u0001\"\u0014\u0001\u0003\u0006\u0004%IA\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001f\"AA\u000b\u0001BC\u0002\u0013%\u0011\b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003;\u0011!1\u0006A!b\u0001\n\u0013I\u0004\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u000be\u0003A\u0011\u0001.\t\u000be\u0003A\u0011A1\t\u000be\u0003A\u0011A2\t\u000f\u001d\u0004!\u0019!C\u0001Q\"1\u0011\u000e\u0001Q\u0001\nACqA\u001b\u0001C\u0002\u0013\u00051\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\na\u0002\u0001\r\u00111A\u0005\nED\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\t\u0015\u0005\u001d\u0001\u00011A\u0001B\u0003&!\u000fC\u0004\u0002\f\u0001!I!!\u0004\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u00111\u0003\u0001\u0005B\u0005U!a\u0005)zi\"|g.Q2dk6,H.\u0019;peZ\u0013$B\u0001\r\u001a\u0003\u0019\u0001\u0018\u0010\u001e5p]*\u0011!dG\u0001\u0004CBL'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0014\u0007\u0001\u0011\u0013\u0007E\u0002$M!j\u0011\u0001\n\u0006\u0003Km\tA!\u001e;jY&\u0011q\u0005\n\u0002\u0016\u0007>dG.Z2uS>t\u0017iY2v[Vd\u0017\r^8s!\rICFL\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t)\u0011I\u001d:bsB\u0011\u0011fL\u0005\u0003a)\u0012AAQ=uKB\u0011!'N\u0007\u0002g)\u0011AgG\u0001\tS:$XM\u001d8bY&\u0011ag\r\u0002\b\u0019><w-\u001b8h\u0003)\u0019XM\u001d<fe\"{7\u000f^\u0002\u0001+\u0005Q\u0004cA\u0015<{%\u0011AH\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005y*eBA D!\t\u0001%&D\u0001B\u0015\t\u0011\u0005(\u0001\u0004=e>|GOP\u0005\u0003\t*\na\u0001\u0015:fI\u00164\u0017B\u0001$H\u0005\u0019\u0019FO]5oO*\u0011AIK\u0001\fg\u0016\u0014h/\u001a:I_N$\b\u0005\u000b\u0002\u0003\u0015B\u0011\u0011fS\u0005\u0003\u0019*\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0015M,'O^3s!>\u0014H/F\u0001P!\rI3\b\u0015\t\u0003SEK!A\u0015\u0016\u0003\u0007%sG/A\u0006tKJ4XM\u001d)peR\u0004\u0013aC:fGJ,G\u000fV8lK:\fAb]3de\u0016$Hk\\6f]\u0002\n!b]8dW\u0016$\b+\u0019;i\u0003-\u0019xnY6fiB\u000bG\u000f\u001b\u0011)\u0005!Q\u0015A\u0002\u001fj]&$h\bF\u0003\\;z{\u0006\r\u0005\u0002]\u00015\tq\u0003C\u00038\u0013\u0001\u0007!\bC\u0003N\u0013\u0001\u0007q\nC\u0003U\u0013\u0001\u0007!\bC\u0003W\u0013\u0001\u0007!\b\u0006\u0002\\E\")aK\u0003a\u0001{Q!1\fZ3g\u0011\u001594\u00021\u0001>\u0011\u0015i5\u00021\u0001Q\u0011\u0015!6\u00021\u0001>\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002!\u0006Y!-\u001e4gKJ\u001c\u0016N_3!\u0003AI7/\u00168jq\u0012{W.Y5o'>\u001c7.F\u0001m!\tIS.\u0003\u0002oU\t9!i\\8mK\u0006t\u0017!E5t+:L\u0007\u0010R8nC&t7k\\2lA\u000511o\\2lKR,\u0012A\u001d\t\u0003gjl\u0011\u0001\u001e\u0006\u0003kZ\f\u0001b\u00195b]:,Gn\u001d\u0006\u0003ob\f1A\\5p\u0015\u0005I\u0018\u0001\u00026bm\u0006L!a\u001f;\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003)\u0019xnY6fi~#S-\u001d\u000b\u0004}\u0006\r\u0001CA\u0015\u0000\u0013\r\t\tA\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0006E\t\t\u00111\u0001s\u0003\rAH%M\u0001\bg>\u001c7.\u001a;!Q\t\u0011\"*\u0001\u0006pa\u0016t7k\\2lKR$\u0012A]\u0001\rG>\u0004\u00180\u00118e%\u0016\u001cX\r\u001e\u000b\u00027\u0006)Q.\u001a:hKR\u0019a0a\u0006\t\u000f\u0005eQ\u00031\u0001\u0002\u001c\u0005)q\u000e\u001e5feB11%!\b)\u0003CI1!a\b%\u00055\t5mY;nk2\fGo\u001c:WeA)\u00111EA\u0014Q5\u0011\u0011Q\u0005\u0006\u0003KaLA!!\u000b\u0002&\t!A*[:u\u0001")
public class PythonAccumulatorV2
extends CollectionAccumulator<byte[]>
implements Logging {
    private final transient Option<String> serverHost;
    private final Option<Object> serverPort;
    private final Option<String> secretToken;
    private final transient Option<String> socketPath;
    private final int bufferSize;
    private final boolean isUnixDomainSock;
    private transient SocketChannel socket;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<String> serverHost() {
        return this.serverHost;
    }

    private Option<Object> serverPort() {
        return this.serverPort;
    }

    private Option<String> secretToken() {
        return this.secretToken;
    }

    private Option<String> socketPath() {
        return this.socketPath;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public boolean isUnixDomainSock() {
        return this.isUnixDomainSock;
    }

    private SocketChannel socket() {
        return this.socket;
    }

    private void socket_$eq(SocketChannel x$1) {
        this.socket = x$1;
    }

    private synchronized SocketChannel openSocket() {
        block2: {
            if (this.socket() != null && this.socket().isOpen()) break block2;
            if (this.isUnixDomainSock()) {
                this.socket_$eq(SocketChannel.open(UnixDomainSocketAddress.of((String)this.socketPath().get())));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to AccumulatorServer at socket: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SOCKET_ADDRESS, this.socketPath().get())}))));
            } else {
                this.socket_$eq(SocketChannel.open(new InetSocketAddress((String)this.serverHost().get(), BoxesRunTime.unboxToInt((Object)this.serverPort().get()))));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Connected to AccumulatorServer at host: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.HOST, this.serverHost().get())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" port: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PORT, this.serverPort().get())})))));
            }
            this.secretToken().foreach((Function1 & Serializable)token -> {
                PythonAccumulatorV2.$anonfun$openSocket$3(this, token);
                return BoxedUnit.UNIT;
            });
        }
        return this.socket();
    }

    @Override
    public PythonAccumulatorV2 copyAndReset() {
        return new PythonAccumulatorV2(this.serverHost(), this.serverPort(), this.secretToken(), this.socketPath());
    }

    @Override
    public synchronized void merge(AccumulatorV2<byte[], List<byte[]>> other) {
        PythonAccumulatorV2 otherPythonAccumulator = (PythonAccumulatorV2)other;
        if (this.serverHost() == null) {
            super.merge(otherPythonAccumulator);
            return;
        }
        SocketChannel socket = this.openSocket();
        InputStream in = Channels.newInputStream(socket);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Channels.newOutputStream(socket), this.bufferSize()));
        List<byte[]> values = other.value();
        out.writeInt(values.size());
        CollectionConverters$.MODULE$.ListHasAsScala(values).asScala().foreach((Function1 & Serializable)array -> {
            PythonAccumulatorV2.$anonfun$merge$1(out, array);
            return BoxedUnit.UNIT;
        });
        out.flush();
        int byteRead = in.read();
        if (byteRead == -1) {
            throw new SparkException("EOF reached before Python server acknowledged");
        }
    }

    public static final /* synthetic */ void $anonfun$openSocket$3(PythonAccumulatorV2 $this, String token) {
        Channels.newOutputStream($this.socket()).write(token.getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ void $anonfun$merge$1(DataOutputStream out$2, byte[] array) {
        out$2.writeInt(array.length);
        out$2.write(array);
    }

    public PythonAccumulatorV2(Option<String> serverHost, Option<Object> serverPort, Option<String> secretToken, Option<String> socketPath) {
        this.serverHost = serverHost;
        this.serverPort = serverPort;
        this.secretToken = secretToken;
        this.socketPath = socketPath;
        Logging.$init$((Logging)this);
        serverHost.foreach((Function1 & Serializable)host -> {
            Utils$.MODULE$.checkHost(host);
            return BoxedUnit.UNIT;
        });
        this.bufferSize = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.BUFFER_SIZE()));
        this.isUnixDomainSock = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(Python$.MODULE$.PYTHON_UNIX_DOMAIN_SOCKET_ENABLED()));
    }

    public PythonAccumulatorV2(String socketPath) {
        this((Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)socketPath));
    }

    public PythonAccumulatorV2(String serverHost, int serverPort, String secretToken) {
        this((Option<String>)new Some((Object)serverHost), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)serverPort)), (Option<String>)new Some((Object)secretToken), (Option<String>)None$.MODULE$);
    }
}

