/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.KeyToPath;
import java.io.File;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.MalformedInputException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.ArrayImplicits$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@Unstable
@DeveloperApi
public final class KubernetesClientUtils$
implements Logging {
    public static final KubernetesClientUtils$ MODULE$ = new KubernetesClientUtils$();
    private static final String configMapNameExecutor;
    private static final String configMapNameDriver;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        configMapNameExecutor = MODULE$.configMapName("spark-exec-" + KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1()));
        configMapNameDriver = MODULE$.configMapName("spark-drv-" + KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1()));
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String configMapName(String prefix) {
        String suffix = "-conf-map";
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(prefix), Config$.MODULE$.KUBERNETES_DNS_SUBDOMAIN_NAME_MAX_LENGTH() - suffix.length()) + suffix;
    }

    public String configMapNameExecutor() {
        return configMapNameExecutor;
    }

    public String configMapNameDriver() {
        return configMapNameDriver;
    }

    private String buildStringFromPropertiesMap(String configMapName, scala.collection.immutable.Map<String, String> propertiesMap) {
        Properties properties = new Properties();
        propertiesMap.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return properties.setProperty(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        StringWriter propertiesWriter = new StringWriter();
        properties.store(propertiesWriter, "Java properties built from Kubernetes config map with name: " + configMapName);
        return propertiesWriter.toString();
    }

    public synchronized Map<String, String> buildSparkConfDirFilesMapJava(String configMapName, SparkConf sparkConf, Map<String, String> resolvedPropertiesMap) {
        return CollectionConverters$.MODULE$.MapHasAsJava(this.buildSparkConfDirFilesMap(configMapName, sparkConf, (scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(resolvedPropertiesMap).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).asJava();
    }

    public synchronized scala.collection.immutable.Map<String, String> buildSparkConfDirFilesMap(String configMapName, SparkConf sparkConf, scala.collection.immutable.Map<String, String> resolvedPropertiesMap) {
        scala.collection.immutable.Map<String, String> loadedConfFilesMap = this.loadSparkConfDirFiles(sparkConf);
        if (resolvedPropertiesMap.nonEmpty()) {
            String resolvedProperties = this.buildStringFromPropertiesMap(configMapName, resolvedPropertiesMap);
            return (scala.collection.immutable.Map)loadedConfFilesMap.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_CONF_FILE_NAME()), (Object)resolvedProperties)})));
        }
        return loadedConfFilesMap;
    }

    public List<KeyToPath> buildKeyToPathObjectsJava(Map<String, String> confFilesMap) {
        return CollectionConverters$.MODULE$.SeqHasAsJava(this.buildKeyToPathObjects((scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(confFilesMap).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).asJava();
    }

    public Seq<KeyToPath> buildKeyToPathObjects(scala.collection.immutable.Map<String, String> confFilesMap) {
        return (Seq)((IterableOnceOps)confFilesMap.map((Function1 & Serializable)x0$1 -> {
            String fileName;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (fileName = (String)tuple2._1()) != null) {
                String string = fileName;
                if (tuple2._2() != null) {
                    int filePermissionMode = 420;
                    return new KeyToPath(string, Predef$.MODULE$.int2Integer(filePermissionMode), string);
                }
            }
            throw new MatchError((Object)tuple2);
        })).toList().sortBy((Function1 & Serializable)x -> x.getKey(), (Ordering)Ordering.String$.MODULE$);
    }

    public ConfigMap buildConfigMapJava(String configMapName, Map<String, String> confFileMap, Map<String, String> withLabels) {
        return this.buildConfigMap(configMapName, (scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(confFileMap).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (scala.collection.immutable.Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(withLabels).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public ConfigMap buildConfigMap(String configMapName, scala.collection.immutable.Map<String, String> confFileMap, scala.collection.immutable.Map<String, String> withLabels) {
        String configMapNameSpace = (String)confFileMap.getOrElse((Object)Config$.MODULE$.KUBERNETES_NAMESPACE().key(), (Function0 & Serializable)() -> Config$.MODULE$.KUBERNETES_NAMESPACE().defaultValueString());
        return ((ConfigMapBuilder)((ConfigMapFluent)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(configMapName).withNamespace(configMapNameSpace).withLabels(CollectionConverters$.MODULE$.MapHasAsJava(withLabels).asJava())).endMetadata()).withImmutable(Predef$.MODULE$.boolean2Boolean(true)).addToData(CollectionConverters$.MODULE$.MapHasAsJava(confFileMap).asJava())).build();
    }

    public scala.collection.immutable.Map<String, String> buildConfigMap$default$3() {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private Seq<File> orderFilesBySize(Seq<File> confFiles) {
        Seq fileToFileSizePairs = (Seq)confFiles.map((Function1 & Serializable)f -> new Tuple2(f, (Object)BoxesRunTime.boxToLong((long)((long)f.getName().length() + f.length()))));
        return (Seq)((IterableOps)((SeqOps)fileToFileSizePairs.sortBy((Function1 & Serializable)f -> (File)f._1(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).sortBy((Function1 & Serializable)f -> BoxesRunTime.boxToLong((long)f._2$mcJ$sp()), (Ordering)Ordering.Long$.MODULE$)).map((Function1 & Serializable)x$1 -> (File)x$1._1());
    }

    public scala.collection.immutable.Map<String, String> loadSparkConfDirFiles(SparkConf conf) {
        Option confDir = Option$.MODULE$.apply((Object)conf.getenv(Constants$.MODULE$.ENV_SPARK_CONF_DIR())).orElse((Function0 & Serializable)() -> conf.getOption("spark.home").map((Function1 & Serializable)dir -> dir + "/conf"));
        long maxSize = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.CONFIG_MAP_MAXSIZE()));
        if (confDir.isDefined()) {
            Seq<File> confFiles = this.listConfFiles((String)confDir.get(), maxSize);
            Seq<File> orderedConfFiles = this.orderFilesBySize(confFiles);
            LongRef truncatedMapSize = LongRef.create((long)0L);
            HashMap truncatedMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            HashSet skippedFiles = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            ObjectRef source = ObjectRef.create((Object)Source$.MODULE$.fromString(""));
            orderedConfFiles.foreach((Function1 & Serializable)file -> {
                Object object;
                block7: {
                    try {
                        try {
                            source$1.elem = Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8());
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file.getName()), (Object)((Source)source$1.elem).mkString());
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            String fileName = (String)tuple2._1();
                            String fileContent = (String)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)fileName, (Object)fileContent);
                            String fileName2 = (String)tuple22._1();
                            String fileContent2 = (String)tuple22._2();
                            if (truncatedMapSize$1.elem + (long)fileName2.length() + (long)fileContent2.length() < maxSize) {
                                truncatedMap.put((Object)fileName2, (Object)fileContent2);
                                truncatedMapSize$1.elem += (long)(fileName2.length() + fileContent2.length());
                                object = BoxedUnit.UNIT;
                                break block7;
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)skippedFiles.add((Object)fileName2));
                        }
                        catch (MalformedInputException e) {
                            MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read a non UTF-8 encoded file "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Skipping..."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, file.getAbsolutePath())})))), (Throwable)e);
                            object = BoxedUnit.UNIT;
                        }
                    }
                    finally {
                        ((Source)source$1.elem).close();
                    }
                }
                return object;
            });
            if (truncatedMap.nonEmpty()) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Spark configuration files loaded from ", " : "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, confDir)})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATHS, truncatedMap.keys().mkString(","))})))));
            }
            if (skippedFiles.nonEmpty()) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped conf file(s) ", ", due to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATHS, skippedFiles.mkString(","))})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"size constraint. Please see, config: "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"`", "` for more details."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.CONFIG, Config$.MODULE$.CONFIG_MAP_MAXSIZE().key())})))));
            }
            return truncatedMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return Predef$.MODULE$.Map().empty();
    }

    private Seq<File> listConfFiles(String confDir, long maxSize) {
        Function1 & Serializable fileFilter = (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)KubernetesClientUtils$.$anonfun$listConfFiles$1(maxSize, f));
        File dir = new File(confDir);
        Nil$ confFiles = dir.isDirectory() ? ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)KubernetesClientUtils$.$anonfun$listConfFiles$2(fileFilter, x)))).toImmutableArraySeq() : Nil$.MODULE$;
        return confFiles;
    }

    private static final boolean testIfTooLargeOrBinary$1(File f, long maxSize$2) {
        return f.length() + (long)f.getName().length() > maxSize$2 || f.getName().matches(".*\\.(gz|zip|jar|tar)");
    }

    private static final boolean testIfSparkConfOrTemplates$1(File f) {
        return f.getName().matches(".*\\.template") || f.getName().matches("spark.*(conf|properties)");
    }

    public static final /* synthetic */ boolean $anonfun$listConfFiles$1(long maxSize$2, File f) {
        return f.isFile() && !KubernetesClientUtils$.testIfTooLargeOrBinary$1(f, maxSize$2) && !KubernetesClientUtils$.testIfSparkConfOrTemplates$1(f);
    }

    public static final /* synthetic */ boolean $anonfun$listConfFiles$2(Function1 fileFilter$1, File x) {
        return BoxesRunTime.unboxToBoolean((Object)fileFilter$1.apply((Object)x));
    }

    private KubernetesClientUtils$() {
    }
}

