/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.filters;

import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.VersionUtil;
import org.sparkproject.jpmml.model.filters.PMMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class ImportFilter
extends PMMLFilter {
    private boolean extensions = true;

    public ImportFilter() {
        this(true);
    }

    public ImportFilter(boolean extensions) {
        super(Version.PMML_4_4);
        this.setExtensions(extensions);
    }

    public ImportFilter(XMLReader reader) {
        this(reader, true);
    }

    public ImportFilter(XMLReader reader, boolean extensions) {
        super(reader, Version.PMML_4_4);
        this.setExtensions(extensions);
    }

    @Override
    public String filterLocalName(String localName) {
        Version source = this.getSource();
        if ("Trend".equals(localName) && source.compareTo(Version.PMML_4_0) == 0) {
            return "Trend_ExpoSmooth";
        }
        return localName;
    }

    @Override
    public Attributes filterAttributes(String localName, Attributes attributes) {
        Version source = this.getSource();
        if ("Apply".equals(localName)) {
            Version functionVersion;
            String function;
            if (source.compareTo(Version.PMML_4_1) == 0) {
                attributes = ImportFilter.renameAttribute(attributes, "mapMissingTo", "defaultValue");
            }
            if (source.compareTo(Version.PMML_4_4) <= 0 && (function = ImportFilter.getAttribute(attributes, "function")) != null && function.startsWith("x-") && (functionVersion = VersionUtil.getVersion(function.substring("x-".length()))) != null && functionVersion.compareTo(Version.PMML_4_4) <= 0) {
                attributes = ImportFilter.setAttribute(attributes, "function", function.substring("x-".length()));
            }
        } else if ("MiningField".equals(localName)) {
            if (source.compareTo(Version.PMML_4_3) <= 0) {
                attributes = ImportFilter.renameAttribute(attributes, "x-invalidValueReplacement", "invalidValueReplacement");
            }
            if (source.compareTo(Version.PMML_4_4) <= 0) {
                String missingValueTreatment = ImportFilter.getAttribute(attributes, "missingValueTreatment");
                String invalidValueTreatment = ImportFilter.getAttribute(attributes, "invalidValueTreatment");
                if (missingValueTreatment != null) {
                    switch (missingValueTreatment) {
                        case "x-returnInvalid": {
                            attributes = ImportFilter.setAttribute(attributes, "missingValueTreatment", missingValueTreatment.substring("x-".length()));
                            break;
                        }
                    }
                }
                if (invalidValueTreatment != null) {
                    switch (invalidValueTreatment) {
                        case "asIs": {
                            attributes = ImportFilter.setAttribute(attributes, "invalidValueTreatment", "asValue");
                            break;
                        }
                        case "asValue": {
                            break;
                        }
                    }
                }
            }
        } else if ("PMML".equals(localName)) {
            Version target = this.getTarget();
            if (this.getExtensions()) {
                attributes = ImportFilter.renameAttribute(attributes, "version", "x-baseVersion");
            }
            attributes = ImportFilter.setAttribute(attributes, "version", target.getVersion());
        } else if ("Segmentation".equals(localName)) {
            if (source.compareTo(Version.PMML_4_3) <= 0) {
                String multipleModelMethod = ImportFilter.getAttribute(attributes, "multipleModelMethod");
                if (multipleModelMethod != null) {
                    switch (multipleModelMethod) {
                        case "x-weightedMedian": 
                        case "x-weightedSum": {
                            attributes = ImportFilter.setAttribute(attributes, "multipleModelMethod", multipleModelMethod.substring("x-".length()));
                            break;
                        }
                    }
                }
                attributes = ImportFilter.renameAttribute(attributes, "x-missingPredictionTreatment", "missingPredictionTreatment");
                attributes = ImportFilter.renameAttribute(attributes, "x-missingThreshold", "missingThreshold");
            }
        } else if ("TargetValue".equals(localName) && source.compareTo(Version.PMML_3_1) <= 0) {
            attributes = ImportFilter.renameAttribute(attributes, "rawDataValue", "displayValue");
        }
        return attributes;
    }

    public boolean getExtensions() {
        return this.extensions;
    }

    private void setExtensions(boolean extensions) {
        this.extensions = extensions;
    }
}

