/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.package$;
import org.apache.spark.sql.catalyst.expressions.AggregateWindowFunction;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameLessOffsetWindowFunction;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RankLike;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.UnspecifiedFrame$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowFunction;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ListAgg;
import org.apache.spark.sql.catalyst.expressions.aggregate.Median;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileCont;
import org.apache.spark.sql.catalyst.expressions.aggregate.PercentileDisc;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class WindowResolution$ {
    public static final WindowResolution$ MODULE$ = new WindowResolution$();

    public WindowExpression resolveFrame(WindowExpression windowExpression) {
        WindowExpression windowExpression2 = windowExpression;
        if (windowExpression2 != null) {
            Expression wf = windowExpression2.windowFunction();
            WindowSpecDefinition windowSpecDefinition = windowExpression2.windowSpec();
            if (wf instanceof FrameLessOffsetWindowFunction) {
                WindowFrame f;
                FrameLessOffsetWindowFunction frameLessOffsetWindowFunction = (FrameLessOffsetWindowFunction)wf;
                if (windowSpecDefinition != null && (f = windowSpecDefinition.frameSpecification()) instanceof SpecifiedWindowFrame) {
                    SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)f;
                    WindowFrame windowFrame = frameLessOffsetWindowFunction.frame();
                    SpecifiedWindowFrame specifiedWindowFrame2 = specifiedWindowFrame;
                    if (windowFrame == null ? specifiedWindowFrame2 != null : !windowFrame.equals(specifiedWindowFrame2)) {
                        throw QueryCompilationErrors$.MODULE$.cannotSpecifyWindowFrameError(frameLessOffsetWindowFunction.prettyName());
                    }
                }
            }
        }
        if (windowExpression2 != null) {
            Expression wf = windowExpression2.windowFunction();
            WindowSpecDefinition windowSpecDefinition = windowExpression2.windowSpec();
            if (wf instanceof WindowFunction) {
                WindowFrame f;
                WindowFunction windowFunction = (WindowFunction)((Object)wf);
                if (windowSpecDefinition != null && (f = windowSpecDefinition.frameSpecification()) instanceof SpecifiedWindowFrame) {
                    SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)f;
                    WindowFrame windowFrame = windowFunction.frame();
                    UnspecifiedFrame$ unspecifiedFrame$ = UnspecifiedFrame$.MODULE$;
                    if (windowFrame == null ? unspecifiedFrame$ != null : !windowFrame.equals(unspecifiedFrame$)) {
                        WindowFrame windowFrame2 = windowFunction.frame();
                        SpecifiedWindowFrame specifiedWindowFrame3 = specifiedWindowFrame;
                        if (windowFrame2 == null ? specifiedWindowFrame3 != null : !windowFrame2.equals(specifiedWindowFrame3)) {
                            throw QueryCompilationErrors$.MODULE$.windowFrameNotMatchRequiredFrameError(specifiedWindowFrame, windowFunction.frame());
                        }
                    }
                }
            }
        }
        if (windowExpression2 != null) {
            Expression wf = windowExpression2.windowFunction();
            WindowSpecDefinition s = windowExpression2.windowSpec();
            if (wf instanceof WindowFunction) {
                WindowFrame windowFrame;
                WindowFunction windowFunction = (WindowFunction)((Object)wf);
                if (s != null && UnspecifiedFrame$.MODULE$.equals(windowFrame = s.frameSpecification())) {
                    WindowFrame windowFrame3 = windowFunction.frame();
                    UnspecifiedFrame$ unspecifiedFrame$ = UnspecifiedFrame$.MODULE$;
                    if (windowFrame3 == null ? unspecifiedFrame$ != null : !windowFrame3.equals(unspecifiedFrame$)) {
                        WindowFrame x$1 = windowFunction.frame();
                        Seq<Expression> x$2 = s.copy$default$1();
                        Seq<SortOrder> x$3 = s.copy$default$2();
                        return new WindowExpression((Expression)((Object)windowFunction), s.copy(x$2, x$3, x$1));
                    }
                }
            }
        }
        if (windowExpression2 != null) {
            Expression e = windowExpression2.windowFunction();
            WindowSpecDefinition s = windowExpression2.windowSpec();
            if (s != null) {
                Seq<SortOrder> o = s.orderSpec();
                WindowFrame windowFrame = s.frameSpecification();
                if (UnspecifiedFrame$.MODULE$.equals(windowFrame) && e.resolved()) {
                    SpecifiedWindowFrame frame;
                    SpecifiedWindowFrame x$4 = frame = o.nonEmpty() ? new SpecifiedWindowFrame(RangeFrame$.MODULE$, UnboundedPreceding$.MODULE$, CurrentRow$.MODULE$) : new SpecifiedWindowFrame(RowFrame$.MODULE$, UnboundedPreceding$.MODULE$, UnboundedFollowing$.MODULE$);
                    Seq<Expression> x$5 = s.copy$default$1();
                    Seq<SortOrder> x$6 = s.copy$default$2();
                    WindowSpecDefinition x$7 = s.copy(x$5, x$6, x$4);
                    Expression x$8 = windowExpression2.copy$default$1();
                    return windowExpression2.copy(x$8, x$7);
                }
            }
        }
        return windowExpression2;
    }

    public WindowExpression resolveOrder(WindowExpression windowExpression) {
        WindowExpression windowExpression2 = windowExpression;
        if (windowExpression2 != null) {
            Expression wf = windowExpression2.windowFunction();
            WindowSpecDefinition spec = windowExpression2.windowSpec();
            if (wf instanceof WindowFunction) {
                WindowFunction windowFunction = (WindowFunction)((Object)wf);
                if (spec.orderSpec().isEmpty()) {
                    throw QueryCompilationErrors$.MODULE$.windowFunctionWithWindowFrameNotOrderedError(windowFunction);
                }
            }
        }
        if (windowExpression2 != null) {
            Expression rank = windowExpression2.windowFunction();
            WindowSpecDefinition spec = windowExpression2.windowSpec();
            if (rank instanceof RankLike) {
                RankLike rankLike = (RankLike)rank;
                if (spec.resolved()) {
                    Seq order = (Seq)spec.orderSpec().map((Function1 & Serializable)x$1 -> x$1.child());
                    return new WindowExpression(rankLike.withOrder((Seq<Expression>)order), spec);
                }
            }
        }
        return windowExpression2;
    }

    public void validateResolvedWindowExpression(WindowExpression windowExpression) {
        this.checkWindowFunctionAndFrameMismatch(windowExpression);
        this.checkWindowFunction(windowExpression);
    }

    public void checkWindowFunctionAndFrameMismatch(WindowExpression windowExpression) {
        WindowExpression windowExpression2 = windowExpression;
        if (windowExpression2 != null) {
            Expression windowFunction = windowExpression2.windowFunction();
            WindowSpecDefinition windowSpecDefinition = windowExpression2.windowSpec();
            if (windowFunction instanceof FrameLessOffsetWindowFunction) {
                FrameLessOffsetWindowFunction frameLessOffsetWindowFunction = (FrameLessOffsetWindowFunction)windowFunction;
                if (windowSpecDefinition != null) {
                    Seq<SortOrder> order = windowSpecDefinition.orderSpec();
                    WindowFrame frame = windowSpecDefinition.frameSpecification();
                    if (frame instanceof SpecifiedWindowFrame) {
                        SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)frame;
                        if (order.isEmpty() || !specifiedWindowFrame.isOffset()) {
                            throw package$.MODULE$.AnalysisErrorAt(windowExpression).failAnalysis("WINDOW_FUNCTION_AND_FRAME_MISMATCH", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)TypeUtils$.MODULE$.toSQLExpr(frameLessOffsetWindowFunction)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowExpr"), (Object)TypeUtils$.MODULE$.toSQLExpr(windowExpression))}))));
                        }
                    }
                }
            }
        }
    }

    public void checkWindowFunction(WindowExpression windowExpression) {
        Expression expression;
        block11: {
            AggregateExpression aggregateExpression;
            block12: {
                boolean bl;
                block9: {
                    block10: {
                        ListAgg listAgg;
                        AggregateFunction fun;
                        bl = false;
                        aggregateExpression = null;
                        expression = windowExpression.windowFunction();
                        if (expression instanceof AggregateExpression) {
                            bl = true;
                            aggregateExpression = (AggregateExpression)expression;
                            boolean bl2 = aggregateExpression.isDistinct();
                            if (bl2) {
                                throw package$.MODULE$.AnalysisErrorAt(windowExpression).failAnalysis("DISTINCT_WINDOW_FUNCTION_UNSUPPORTED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowExpr"), (Object)TypeUtils$.MODULE$.toSQLExpr(windowExpression))}))));
                            }
                        }
                        if (!bl || !((fun = aggregateExpression.aggregateFunction()) instanceof ListAgg) || !(listAgg = (ListAgg)fun).orderingFilled()) break block9;
                        if (windowExpression.windowSpec().orderSpec().nonEmpty()) break block10;
                        WindowFrame windowFrame = windowExpression.windowSpec().frameSpecification();
                        SpecifiedWindowFrame specifiedWindowFrame = new SpecifiedWindowFrame(RowFrame$.MODULE$, UnboundedPreceding$.MODULE$, UnboundedFollowing$.MODULE$);
                        if (!(windowFrame == null ? specifiedWindowFrame != null : !windowFrame.equals(specifiedWindowFrame))) break block9;
                    }
                    throw package$.MODULE$.AnalysisErrorAt(aggregateExpression).failAnalysis("INVALID_WINDOW_SPEC_FOR_AGGREGATION_FUNC", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aggFunc"), (Object)TypeUtils$.MODULE$.toSQLExpr(aggregateExpression.aggregateFunction()))}))));
                }
                if (!bl || !(aggregateExpression.aggregateFunction() instanceof PercentileCont ? true : (aggregateExpression.aggregateFunction() instanceof PercentileDisc ? true : aggregateExpression.aggregateFunction() instanceof Median))) break block11;
                if (windowExpression.windowSpec().orderSpec().nonEmpty()) break block12;
                WindowFrame windowFrame = windowExpression.windowSpec().frameSpecification();
                SpecifiedWindowFrame specifiedWindowFrame = new SpecifiedWindowFrame(RowFrame$.MODULE$, UnboundedPreceding$.MODULE$, UnboundedFollowing$.MODULE$);
                if (!(windowFrame == null ? specifiedWindowFrame != null : !windowFrame.equals(specifiedWindowFrame))) break block11;
            }
            throw package$.MODULE$.AnalysisErrorAt(aggregateExpression).failAnalysis("INVALID_WINDOW_SPEC_FOR_AGGREGATION_FUNC", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aggFunc"), (Object)TypeUtils$.MODULE$.toSQLExpr(aggregateExpression.aggregateFunction()))}))));
        }
        if (expression instanceof AggregateExpression ? true : (expression instanceof FrameLessOffsetWindowFunction ? true : expression instanceof AggregateWindowFunction)) {
            return;
        }
        throw package$.MODULE$.AnalysisErrorAt(expression).failAnalysis("UNSUPPORTED_EXPR_FOR_WINDOW", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)TypeUtils$.MODULE$.toSQLExpr(expression))}))));
    }

    private WindowResolution$() {
    }
}

