/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.CurrentUserContext$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple21;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class CatalogTable$
implements Serializable {
    public static final CatalogTable$ MODULE$ = new CatalogTable$();
    private static final String VIEW_PREFIX = "view.";
    private static final String VIEW_DEFAULT_DATABASE = MODULE$.VIEW_PREFIX() + "default.database";
    private static final String VIEW_CATALOG_AND_NAMESPACE = MODULE$.VIEW_PREFIX() + "catalogAndNamespace.numParts";
    private static final String VIEW_CATALOG_AND_NAMESPACE_PART_PREFIX = MODULE$.VIEW_PREFIX() + "catalogAndNamespace.part.";
    private static final String VIEW_SQL_CONFIG_PREFIX = MODULE$.VIEW_PREFIX() + "sqlConfig.";
    private static final String VIEW_QUERY_OUTPUT_PREFIX = MODULE$.VIEW_PREFIX() + "query.out.";
    private static final String VIEW_QUERY_OUTPUT_NUM_COLUMNS = MODULE$.VIEW_QUERY_OUTPUT_PREFIX() + "numCols";
    private static final String VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX = MODULE$.VIEW_QUERY_OUTPUT_PREFIX() + "col.";
    private static final String VIEW_REFERRED_TEMP_VIEW_NAMES = MODULE$.VIEW_PREFIX() + "referredTempViewNames";
    private static final String VIEW_REFERRED_TEMP_FUNCTION_NAMES = MODULE$.VIEW_PREFIX() + "referredTempFunctionsNames";
    private static final String VIEW_REFERRED_TEMP_VARIABLE_NAMES = MODULE$.VIEW_PREFIX() + "referredTempVariablesNames";
    private static final String VIEW_SCHEMA_MODE = MODULE$.VIEW_PREFIX() + "schemaMode";
    private static final String VIEW_STORING_ANALYZED_PLAN = MODULE$.VIEW_PREFIX() + "storingAnalyzedPlan";
    private static final String PROP_CLUSTERING_COLUMNS = "clusteringColumns";

    public Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$6() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<BucketSpec> $lessinit$greater$default$7() {
        return None$.MODULE$;
    }

    public String $lessinit$greater$default$8() {
        return CurrentUserContext$.MODULE$.getCurrentUserOrEmpty();
    }

    public long $lessinit$greater$default$9() {
        return System.currentTimeMillis();
    }

    public long $lessinit$greater$default$10() {
        return -1L;
    }

    public String $lessinit$greater$default$11() {
        return "";
    }

    public Map<String, String> $lessinit$greater$default$12() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogStatistics> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$14() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$15() {
        return None$.MODULE$;
    }

    public Option<String> $lessinit$greater$default$16() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$17() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean $lessinit$greater$default$18() {
        return false;
    }

    public boolean $lessinit$greater$default$19() {
        return true;
    }

    public Map<String, String> $lessinit$greater$default$20() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> $lessinit$greater$default$21() {
        return None$.MODULE$;
    }

    public String VIEW_PREFIX() {
        return VIEW_PREFIX;
    }

    public String VIEW_DEFAULT_DATABASE() {
        return VIEW_DEFAULT_DATABASE;
    }

    public String VIEW_CATALOG_AND_NAMESPACE() {
        return VIEW_CATALOG_AND_NAMESPACE;
    }

    public String VIEW_CATALOG_AND_NAMESPACE_PART_PREFIX() {
        return VIEW_CATALOG_AND_NAMESPACE_PART_PREFIX;
    }

    public Map<String, String> catalogAndNamespaceToProps(String currentCatalog, Seq<String> currentNamespace) {
        HashMap props;
        block0: {
            props = new HashMap();
            String string = currentCatalog;
            Seq parts = (Seq)currentNamespace.$plus$colon((Object)string);
            if (!parts.nonEmpty()) break block0;
            props.put((Object)this.VIEW_CATALOG_AND_NAMESPACE(), (Object)Integer.toString(parts.length()));
            ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return props.put((Object)(MODULE$.VIEW_CATALOG_AND_NAMESPACE_PART_PREFIX() + index), (Object)name);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return props.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String VIEW_SQL_CONFIG_PREFIX() {
        return VIEW_SQL_CONFIG_PREFIX;
    }

    public String VIEW_QUERY_OUTPUT_PREFIX() {
        return VIEW_QUERY_OUTPUT_PREFIX;
    }

    public String VIEW_QUERY_OUTPUT_NUM_COLUMNS() {
        return VIEW_QUERY_OUTPUT_NUM_COLUMNS;
    }

    public String VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX() {
        return VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX;
    }

    public String VIEW_REFERRED_TEMP_VIEW_NAMES() {
        return VIEW_REFERRED_TEMP_VIEW_NAMES;
    }

    public String VIEW_REFERRED_TEMP_FUNCTION_NAMES() {
        return VIEW_REFERRED_TEMP_FUNCTION_NAMES;
    }

    public String VIEW_REFERRED_TEMP_VARIABLE_NAMES() {
        return VIEW_REFERRED_TEMP_VARIABLE_NAMES;
    }

    public String VIEW_SCHEMA_MODE() {
        return VIEW_SCHEMA_MODE;
    }

    public String VIEW_STORING_ANALYZED_PLAN() {
        return VIEW_STORING_ANALYZED_PLAN;
    }

    public String PROP_CLUSTERING_COLUMNS() {
        return PROP_CLUSTERING_COLUMNS;
    }

    public void splitLargeTableProp(String key, String value, Function2<String, String, BoxedUnit> addProp, int defaultThreshold) {
        int threshold = BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.HIVE_TABLE_PROPERTY_LENGTH_THRESHOLD()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> defaultThreshold));
        if (value.length() <= threshold) {
            addProp.apply((Object)key, (Object)value);
            return;
        }
        Seq parts = StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(value), threshold).toSeq();
        addProp.apply((Object)(key + ".numParts"), (Object)Integer.toString(parts.length()));
        ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            CatalogTable$.$anonfun$splitLargeTableProp$2(addProp, key, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<String> readLargeTableProp(Map<String, String> props, String key) {
        return props.get((Object)key).orElse((Function0 & Serializable)() -> props.get((Object)(key + ".numParts")).map((Function1 & Serializable)numParts -> {
            IndexedSeq parts = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(numParts))).map((Function1 & Serializable)index -> CatalogTable$.$anonfun$readLargeTableProp$3(key, props, numParts, BoxesRunTime.unboxToInt((Object)index)));
            return parts.mkString();
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLargeTableProp(String originalKey, String propKey) {
        String string = propKey;
        String string2 = originalKey;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = propKey;
        String string4 = originalKey + ".numParts";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!propKey.startsWith(originalKey + ".part.")) return false;
        return true;
    }

    public CatalogTable normalize(CatalogTable table) {
        Set nondeterministicProps = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"CreateTime", "transient_lastDdlTime", "grantTime", "lastUpdateTime", "last_modified_by", "last_modified_time", "Owner:", "totalNumberFiles", "maxFileSize", "minFileSize"}));
        long x$1 = 0L;
        long x$2 = 0L;
        Map x$3 = (Map)((MapOps)table.properties().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CatalogTable$.$anonfun$normalize$1(nondeterministicProps, x0$1)))).map((Function1 & Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x));
        None$ x$4 = None$.MODULE$;
        Map x$5 = Predef$.MODULE$.Map().empty();
        TableIdentifier x$6 = table.copy$default$1();
        CatalogTableType x$7 = table.copy$default$2();
        CatalogStorageFormat x$8 = table.copy$default$3();
        StructType x$9 = table.copy$default$4();
        Option<String> x$10 = table.copy$default$5();
        Seq<String> x$11 = table.copy$default$6();
        Option<BucketSpec> x$12 = table.copy$default$7();
        String x$13 = table.copy$default$8();
        String x$14 = table.copy$default$11();
        Option<String> x$15 = table.copy$default$14();
        Option<String> x$16 = table.copy$default$15();
        Option<String> x$17 = table.copy$default$16();
        Seq<String> x$18 = table.copy$default$17();
        boolean x$19 = table.copy$default$18();
        boolean x$20 = table.copy$default$19();
        Option<String> x$21 = table.copy$default$21();
        return table.copy(x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, 0L, 0L, x$14, (Map<String, String>)x$3, (Option<CatalogStatistics>)x$4, x$15, x$16, x$17, x$18, x$19, x$20, (Map<String, String>)x$5, x$21);
    }

    public CatalogTable apply(TableIdentifier identifier, CatalogTableType tableType, CatalogStorageFormat storage, StructType schema, Option<String> provider, Seq<String> partitionColumnNames, Option<BucketSpec> bucketSpec, String owner, long createTime, long lastAccessTime, String createVersion, Map<String, String> properties, Option<CatalogStatistics> stats, Option<String> viewText, Option<String> comment, Option<String> collation, Seq<String> unsupportedFeatures, boolean tracksPartitionsInCatalog, boolean schemaPreservesCase, Map<String, String> ignoredProperties, Option<String> viewOriginalText) {
        return new CatalogTable(identifier, tableType, storage, schema, provider, partitionColumnNames, bucketSpec, owner, createTime, lastAccessTime, createVersion, properties, stats, viewText, comment, collation, unsupportedFeatures, tracksPartitionsInCatalog, schemaPreservesCase, ignoredProperties, viewOriginalText);
    }

    public long apply$default$10() {
        return -1L;
    }

    public String apply$default$11() {
        return "";
    }

    public Map<String, String> apply$default$12() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogStatistics> apply$default$13() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$14() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$15() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$16() {
        return None$.MODULE$;
    }

    public Seq<String> apply$default$17() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public boolean apply$default$18() {
        return false;
    }

    public boolean apply$default$19() {
        return true;
    }

    public Map<String, String> apply$default$20() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<String> apply$default$21() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Seq<String> apply$default$6() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<BucketSpec> apply$default$7() {
        return None$.MODULE$;
    }

    public String apply$default$8() {
        return CurrentUserContext$.MODULE$.getCurrentUserOrEmpty();
    }

    public long apply$default$9() {
        return System.currentTimeMillis();
    }

    public Option<Tuple21<TableIdentifier, CatalogTableType, CatalogStorageFormat, StructType, Option<String>, Seq<String>, Option<BucketSpec>, String, Object, Object, String, Map<String, String>, Option<CatalogStatistics>, Option<String>, Option<String>, Option<String>, Seq<String>, Object, Object, Map<String, String>, Option<String>>> unapply(CatalogTable x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple21((Object)x$0.identifier(), (Object)x$0.tableType(), (Object)x$0.storage(), (Object)x$0.schema(), x$0.provider(), x$0.partitionColumnNames(), x$0.bucketSpec(), (Object)x$0.owner(), (Object)BoxesRunTime.boxToLong((long)x$0.createTime()), (Object)BoxesRunTime.boxToLong((long)x$0.lastAccessTime()), (Object)x$0.createVersion(), x$0.properties(), x$0.stats(), x$0.viewText(), x$0.comment(), x$0.collation(), x$0.unsupportedFeatures(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.tracksPartitionsInCatalog()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.schemaPreservesCase()), x$0.ignoredProperties(), x$0.viewOriginalText()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CatalogTable$.class);
    }

    public static final /* synthetic */ void $anonfun$splitLargeTableProp$2(Function2 addProp$1, String key$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String part = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)addProp$1.apply((Object)(key$2 + ".part." + index), (Object)part);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ String $anonfun$readLargeTableProp$3(String key$3, Map props$2, String numParts$2, int index) {
        String keyPart = key$3 + ".part." + index;
        return (String)props$2.getOrElse((Object)keyPart, (Function0 & Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.insufficientTablePropertyPartError(keyPart, numParts$2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$normalize$1(Set nondeterministicProps$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !nondeterministicProps$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    private CatalogTable$() {
    }
}

