/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.FileResource$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceType;
import org.apache.spark.sql.catalyst.catalog.SQLFunction;
import org.apache.spark.sql.catalyst.catalog.UserDefinedFunction$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.json4s.JArray;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SQLFunction$
implements Serializable {
    public static final SQLFunction$ MODULE$ = new SQLFunction$();
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX = "sqlFunction.";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$INPUT_PARAM = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "inputParam";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$RETURN_TYPE = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "returnType";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$EXPRESSION = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "expression";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$QUERY = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "query";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$COMMENT = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "comment";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$DETERMINISTIC = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "deterministic";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$CONTAINS_SQL = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "containsSQL";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$IS_TABLE_FUNC = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "isTableFunc";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$OWNER = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "owner";
    private static final String org$apache$spark$sql$catalyst$catalog$SQLFunction$$CREATE_TIME = MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() + "createTime";
    private static final String FUNCTION_CATALOG_AND_NAMESPACE = "catalogAndNamespace.numParts";
    private static final String FUNCTION_CATALOG_AND_NAMESPACE_PART_PREFIX = "catalogAndNamespace.part.";
    private static final String FUNCTION_REFERRED_TEMP_VIEW_NAMES = "referredTempViewNames";
    private static final String FUNCTION_REFERRED_TEMP_FUNCTION_NAMES = "referredTempFunctionsNames";
    private static final String FUNCTION_REFERRED_TEMP_VARIABLE_NAMES = "referredTempVariableNames";

    public Option<String> $lessinit$greater$default$11() {
        return None$.MODULE$;
    }

    public long $lessinit$greater$default$12() {
        return System.currentTimeMillis();
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$INPUT_PARAM() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$INPUT_PARAM;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$RETURN_TYPE() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$RETURN_TYPE;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$EXPRESSION() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$EXPRESSION;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$QUERY() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$QUERY;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$COMMENT() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$COMMENT;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$DETERMINISTIC() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$DETERMINISTIC;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$CONTAINS_SQL() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$CONTAINS_SQL;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$IS_TABLE_FUNC() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$IS_TABLE_FUNC;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$OWNER() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$OWNER;
    }

    public String org$apache$spark$sql$catalyst$catalog$SQLFunction$$CREATE_TIME() {
        return org$apache$spark$sql$catalyst$catalog$SQLFunction$$CREATE_TIME;
    }

    private String FUNCTION_CATALOG_AND_NAMESPACE() {
        return FUNCTION_CATALOG_AND_NAMESPACE;
    }

    private String FUNCTION_CATALOG_AND_NAMESPACE_PART_PREFIX() {
        return FUNCTION_CATALOG_AND_NAMESPACE_PART_PREFIX;
    }

    private String FUNCTION_REFERRED_TEMP_VIEW_NAMES() {
        return FUNCTION_REFERRED_TEMP_VIEW_NAMES;
    }

    private String FUNCTION_REFERRED_TEMP_FUNCTION_NAMES() {
        return FUNCTION_REFERRED_TEMP_FUNCTION_NAMES;
    }

    private String FUNCTION_REFERRED_TEMP_VARIABLE_NAMES() {
        return FUNCTION_REFERRED_TEMP_VARIABLE_NAMES;
    }

    public SQLFunction fromCatalogFunction(CatalogFunction function, ParserInterface parser) {
        SQLFunction sQLFunction;
        try {
            Seq parts = (Seq)function.resources().collect((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends FunctionResource, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 != null) {
                        FunctionResourceType functionResourceType = A1.resourceType();
                        String uri = A1.uri();
                        if (FileResource$.MODULE$.equals(functionResourceType)) {
                            int index = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(uri.substring(0, UserDefinedFunction$.MODULE$.INDEX_LENGTH())));
                            String body = uri.substring(UserDefinedFunction$.MODULE$.INDEX_LENGTH());
                            return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)index)), (Object)body);
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(FunctionResource x1) {
                    FunctionResourceType functionResourceType;
                    FunctionResource functionResource = x1;
                    return functionResource != null && FileResource$.MODULE$.equals(functionResourceType = functionResource.resourceType());
                }
            });
            String blob = ((IterableOnceOps)((IterableOps)parts.sortBy((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$9 -> (String)x$9._2())).mkString();
            Map props = (Map)UserDefinedFunction$.MODULE$.mapper().readValue(blob, Map.class);
            boolean isTableFunc = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)props.apply((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$IS_TABLE_FUNC())));
            Option<Either<DataType, StructType>> returnType = this.parseReturnTypeText((String)props.apply((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$RETURN_TYPE()), isTableFunc, parser);
            sQLFunction = new SQLFunction(function.identifier(), (Option<StructType>)props.get((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$INPUT_PARAM()).map((Function1 & Serializable)x$10 -> UserDefinedFunction$.MODULE$.parseRoutineParam((String)x$10, parser)), (Either<DataType, StructType>)((Either)returnType.get()), (Option<String>)props.get((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$EXPRESSION()), (Option<String>)props.get((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$QUERY()), (Option<String>)props.get((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$COMMENT()), (Option<Object>)props.get((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$DETERMINISTIC()).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$11)))), (Option<Object>)props.get((Object)this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$CONTAINS_SQL()).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$12)))), isTableFunc, (Map<String, String>)((Map)props.filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SQLFunction$.$anonfun$fromCatalogFunction$6(x$13)))), this.apply$default$11(), this.apply$default$12());
        }
        catch (Exception e) {
            throw new AnalysisException("CORRUPTED_CATALOG_FUNCTION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"identifier"), (Object)String.valueOf(function.identifier())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"className"), (Object)String.valueOf(function.className()))})), (Option)new Some((Object)e));
        }
        return sQLFunction;
    }

    public Expression parseDefault(String text, ParserInterface parser) {
        return parser.parseExpression(text);
    }

    public Option<Either<DataType, StructType>> parseReturnTypeText(String text, boolean isTableFunc, ParserInterface parser) {
        if (!isTableFunc) {
            if (text.isEmpty()) {
                return Option$.MODULE$.empty();
            }
            return new Some((Object)new Left((Object)UserDefinedFunction$.MODULE$.parseDataType(text, parser)));
        }
        if (text.equalsIgnoreCase("table")) {
            return Option$.MODULE$.empty();
        }
        return new Some((Object)new Right((Object)UserDefinedFunction$.MODULE$.parseTableSchema(text, parser)));
    }

    public boolean isSQLFunction(String className) {
        String string = className;
        String string2 = this.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Map<String, String> catalogAndNamespaceToProps(String currentCatalog, Seq<String> currentNamespace) {
        HashMap props;
        block0: {
            props = new HashMap();
            String string = currentCatalog;
            Seq parts = (Seq)currentNamespace.$plus$colon((Object)string);
            if (!parts.nonEmpty()) break block0;
            props.put((Object)this.FUNCTION_CATALOG_AND_NAMESPACE(), (Object)Integer.toString(parts.length()));
            ((IterableOnceOps)parts.zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return props.put((Object)(MODULE$.FUNCTION_CATALOG_AND_NAMESPACE_PART_PREFIX() + index), (Object)name);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return props.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, String> referredTempNamesToProps(Seq<Seq<String>> viewNames, Seq<String> functionsNames, Seq<Seq<String>> variableNames) {
        JArray viewNamesJson = new JArray(((IterableOnceOps)viewNames.map((Function1 & Serializable)nameParts -> new JArray(((IterableOnceOps)nameParts.map((Function1)JsonAST$.MODULE$.JString())).toList()))).toList());
        JArray functionsNamesJson = new JArray(((IterableOnceOps)functionsNames.map((Function1)JsonAST$.MODULE$.JString())).toList());
        JArray variableNamesJson = new JArray(((IterableOnceOps)variableNames.map((Function1 & Serializable)nameParts -> new JArray(((IterableOnceOps)nameParts.map((Function1)JsonAST$.MODULE$.JString())).toList()))).toList());
        HashMap props = new HashMap();
        props.put((Object)this.FUNCTION_REFERRED_TEMP_VIEW_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)viewNamesJson, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
        props.put((Object)this.FUNCTION_REFERRED_TEMP_FUNCTION_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)functionsNamesJson, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
        props.put((Object)this.FUNCTION_REFERRED_TEMP_VARIABLE_NAMES(), (Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)variableNamesJson, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
        return props.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public SQLFunction apply(FunctionIdentifier name, Option<StructType> inputParam, Either<DataType, StructType> returnType, Option<String> exprText, Option<String> queryText, Option<String> comment, Option<Object> deterministic, Option<Object> containsSQL, boolean isTableFunc, Map<String, String> properties, Option<String> owner, long createTimeMs) {
        return new SQLFunction(name, inputParam, returnType, exprText, queryText, comment, deterministic, containsSQL, isTableFunc, properties, owner, createTimeMs);
    }

    public Option<String> apply$default$11() {
        return None$.MODULE$;
    }

    public long apply$default$12() {
        return System.currentTimeMillis();
    }

    public Option<Tuple12<FunctionIdentifier, Option<StructType>, Either<DataType, StructType>, Option<String>, Option<String>, Option<String>, Option<Object>, Option<Object>, Object, Map<String, String>, Option<String>, Object>> unapply(SQLFunction x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple12((Object)x$0.name(), x$0.inputParam(), x$0.returnType(), x$0.exprText(), x$0.queryText(), x$0.comment(), x$0.deterministic(), x$0.containsSQL(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isTableFunc()), x$0.properties(), x$0.owner(), (Object)BoxesRunTime.boxToLong((long)x$0.createTimeMs())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SQLFunction$.class);
    }

    public static final /* synthetic */ boolean $anonfun$fromCatalogFunction$6(Tuple2 x$13) {
        return ((String)x$13._1()).startsWith(MODULE$.org$apache$spark$sql$catalyst$catalog$SQLFunction$$SQL_FUNCTION_PREFIX());
    }

    private SQLFunction$() {
    }
}

