/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerExactNumeric$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongExactNumeric$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the absolute value of the numeric or interval value.", examples="\n    Examples:\n      > SELECT _FUNC_(-1);\n       1\n      > SELECT _FUNC_(INTERVAL -'1-1' YEAR TO MONTH);\n       1-1\n  ", since="1.2.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\u0012%\u0001FB\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0001\tE\t\u0015!\u0003T\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015a\u0006\u0001\"\u0011S\u0011\u00159\u0006\u0001\"\u0001^\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015y\u0007\u0001\"\u0011S\u0011!\u0001\b\u0001#b\u0001\n\u0013\t\b\"\u0002=\u0001\t\u0003J\bbBA\b\u0001\u0011E\u0013\u0011\u0003\u0005\b\u0003/\u0001A\u0011IA\r\u0011\u001d\t\t\u0003\u0001C)\u0003GA\u0011\"!\u000b\u0001\u0003\u0003%\t!a\u000b\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005M\u0002\"CA%\u0001E\u0005I\u0011AA&\u0011%\ty\u0005AA\u0001\n\u0003\n\t\u0006C\u0005\u0002d\u0001\t\t\u0011\"\u0001\u0002f!I\u0011Q\u000e\u0001\u0002\u0002\u0013\u0005\u0011q\u000e\u0005\n\u0003k\u0002\u0011\u0011!C!\u0003oB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u0005%\u0005!!A\u0005B\u0005-\u0005\"CAH\u0001\u0005\u0005I\u0011IAI\u000f%\t)\fJA\u0001\u0012\u0003\t9L\u0002\u0005$I\u0005\u0005\t\u0012AA]\u0011\u001996\u0004\"\u0001\u0002R\"I\u00111[\u000e\u0002\u0002\u0013\u0015\u0013Q\u001b\u0005\n\u0003/\\\u0012\u0011!CA\u00033D\u0011\"a8\u001c#\u0003%\t!a\u0013\t\u0013\u0005\u00058$!A\u0005\u0002\u0006\r\b\"CA{7E\u0005I\u0011AA&\u0011%\t9pGA\u0001\n\u0013\tIPA\u0002BENT!!\n\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003O!\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003S)\n1a]9m\u0015\tYC&A\u0003ta\u0006\u00148N\u0003\u0002.]\u00051\u0011\r]1dQ\u0016T\u0011aL\u0001\u0004_J<7\u0001A\n\u0006\u0001I2\u0014h\u0010\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003g]J!\u0001\u000f\u0013\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002A\u0011:\u0011\u0011I\u0012\b\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tB\na\u0001\u0010:p_Rt\u0014\"\u0001\u001f\n\u0005\u001d[\u0014a\u00029bG.\fw-Z\u0005\u0003\u0013*\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!aR\u001e\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u00035\u0003\"a\r(\n\u0005=##AC#yaJ,7o]5p]\u000611\r[5mI\u0002\n1BZ1jY>sWI\u001d:peV\t1\u000b\u0005\u0002;)&\u0011Qk\u000f\u0002\b\u0005>|G.Z1o\u000311\u0017-\u001b7P]\u0016\u0013(o\u001c:!\u0003\u0019a\u0014N\\5u}Q\u0019\u0011LW.\u0011\u0005M\u0002\u0001\"B&\u0006\u0001\u0004i\u0005bB)\u0006!\u0003\u0005\raU\u0001\u000f]VdG.\u00138u_2,'/\u00198u)\tIf\fC\u0003L\u000f\u0001\u0007Q*\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0019\t\u0004\u0001\n$\u0017BA2K\u0005\r\u0019V-\u001d\t\u0003K\"l\u0011A\u001a\u0006\u0003O\"\nQ\u0001^=qKNL!!\u001b4\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00031\u0004\"!Z7\n\u000594'\u0001\u0003#bi\u0006$\u0016\u0010]3\u00025\r|g\u000e^3yi&sG-\u001a9f]\u0012,g\u000e\u001e$pY\u0012\f'\r\\3\u0002\u000f9,X.\u001a:jGV\t!\u000fE\u0002AgVL!\u0001\u001e&\u0003\u000f9+X.\u001a:jGB\u0011!H^\u0005\u0003on\u00121!\u00118z\u0003%!wnR3o\u0007>$W\rF\u0003{\u0003\u0003\tY\u0001\u0005\u0002|}6\tAP\u0003\u0002~I\u000591m\u001c3fO\u0016t\u0017BA@}\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0002\u0019\u0001\u0007\u0011QA\u0001\u0004GRD\bcA>\u0002\b%\u0019\u0011\u0011\u0002?\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u0011Q\u0002\u0007A\u0002i\f!!\u001a<\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007U\f\u0019\u0002\u0003\u0004\u0002\u00165\u0001\r!^\u0001\u0006S:\u0004X\u000f^\u0001\u000eM2\fG/\u0011:hk6,g\u000e^:\u0016\u0005\u0005m\u0001\u0003\u0002!\u0002\u001eUL1!a\bK\u0005!IE/\u001a:bi>\u0014\u0018\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002Z\u0003KAa!a\n\u0010\u0001\u0004i\u0015\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\u00063\u00065\u0012q\u0006\u0005\b\u0017B\u0001\n\u00111\u0001N\u0011\u001d\t\u0006\u0003%AA\u0002M\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00026)\u001aQ*a\u000e,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0011<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002N)\u001a1+a\u000e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0006\u0005\u0003\u0002V\u0005}SBAA,\u0015\u0011\tI&a\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0003;\nAA[1wC&!\u0011\u0011MA,\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\r\t\u0004u\u0005%\u0014bAA6w\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019Q/!\u001d\t\u0013\u0005MT#!AA\u0002\u0005\u001d\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002zA)\u00111PAAk6\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fZ\u0014AC2pY2,7\r^5p]&!\u0011qDA?\u0003!\u0019\u0017M\\#rk\u0006dGcA*\u0002\b\"A\u00111O\f\u0002\u0002\u0003\u0007Q/\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA*\u0003\u001bC\u0011\"a\u001d\u0019\u0003\u0003\u0005\r!a\u001a\u0002\r\u0015\fX/\u00197t)\r\u0019\u00161\u0013\u0005\t\u0003gJ\u0012\u0011!a\u0001k\"\u001a\u0002!a&\u0002\u001e\u0006}\u00151UAS\u0003S\u000bY+a,\u00022B\u00191'!'\n\u0007\u0005mEEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0005\u0016aS0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u00192t_2,H/\u001a\u0011wC2,X\rI8gAQDW\r\t8v[\u0016\u0014\u0018n\u0019\u0011pe\u0002Jg\u000e^3sm\u0006d\u0007E^1mk\u0016t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u001d\u0016A\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)[EJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q%sE+\u0012*W\u00032\u0003SfJ\u0019.c\u001d\u0002\u0013,R!SAQ{\u0005%T(O)\"K3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019.c)\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002.\u0006)\u0011G\f\u001a/a\u0005)qM]8va\u0006\u0012\u00111W\u0001\u000b[\u0006$\bn\u00184v]\u000e\u001c\u0018aA!cgB\u00111gG\n\u00067\u0005m\u0016q\u0019\t\b\u0003{\u000b\u0019-T*Z\u001b\t\tyLC\u0002\u0002Bn\nqA];oi&lW-\u0003\u0003\u0002F\u0006}&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011\u0011ZAh\u001b\t\tYM\u0003\u0003\u0002N\u0006m\u0013AA5p\u0013\rI\u00151\u001a\u000b\u0003\u0003o\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003'\nQ!\u00199qYf$R!WAn\u0003;DQa\u0013\u0010A\u00025Cq!\u0015\u0010\u0011\u0002\u0003\u00071+A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$B!!:\u0002rB)!(a:\u0002l&\u0019\u0011\u0011^\u001e\u0003\r=\u0003H/[8o!\u0015Q\u0014Q^'T\u0013\r\tyo\u000f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005M\b%!AA\u0002e\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u00111 \t\u0005\u0003+\ni0\u0003\u0003\u0002\u0000\u0006]#AB(cU\u0016\u001cG\u000f")
public class Abs
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private Numeric<Object> numeric;
    private final Expression child;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$2() {
        return Abs$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Abs x$0) {
        return Abs$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$2() {
        return Abs$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Abs> tupled() {
        return Abs$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Abs>> curried() {
        return Abs$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.NumericAndAnsiInterval(), (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    private Numeric<Object> numeric$lzycompute() {
        Abs abs = this;
        synchronized (abs) {
            if (!this.bitmap$0) {
                DataType dataType = this.dataType();
                this.numeric = dataType instanceof DayTimeIntervalType ? LongExactNumeric$.MODULE$ : (dataType instanceof YearMonthIntervalType ? IntegerExactNumeric$.MODULE$ : TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError()));
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        if (!this.bitmap$0) {
            return this.numeric$lzycompute();
        }
        return this.numeric;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.dataType();
        if (dataType instanceof DecimalType) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + ".abs()");
        }
        if ((ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)))) && this.failOnError()) {
            String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + " < 0 ? " + mathUtils + ".negateExact(" + c + ") : " + c);
        }
        if (dataType instanceof AnsiIntervalType) {
            String mathUtils = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(MathUtils$.MODULE$.getClass().getCanonicalName()), "$");
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> c + " < 0 ? " + mathUtils + ".negateExact(" + c + ") : " + c);
        }
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)c -> "(" + CodeGenerator$.MODULE$.javaType((DataType)numericType) + ")(java.lang.Math.abs(" + c + "))");
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.numeric().abs(input);
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Abs withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Abs copy(Expression child, boolean failOnError) {
        return new Abs(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Abs";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.failOnError());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Abs;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "failOnError";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Abs)) return false;
        boolean bl = true;
        if (!bl) return false;
        Abs abs = (Abs)x$1;
        if (this.failOnError() != abs.failOnError()) return false;
        Expression expression = this.child();
        Expression expression2 = abs.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!abs.canEqual(this)) return false;
        return true;
    }

    public Abs(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
    }

    public Abs(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

