/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetJsonObject$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.json.GetJsonObjectEvaluator;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(json_txt, path) - Extracts a json object from `path`.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":\"b\"}', '$.a');\n       b\n      > SELECT _FUNC_('[{\"a\":\"b\"},{\"a\":\"c\"}]', '$[0].a');\n       b\n      > SELECT _FUNC_('[{\"a\":\"b\"},{\"a\":\"c\"}]', '$[*].a');\n       [\"b\",\"c\"]\n  ", group="json_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u0011\"\u0001:B\u0001b\u0013\u0001\u0003\u0016\u0004%\t\u0001\u0014\u0005\t!\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0011\u000b\u0001BK\u0002\u0013\u0005A\n\u0003\u0005S\u0001\tE\t\u0015!\u0003N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u0015A\u0006\u0001\"\u0011M\u0011\u0015I\u0006\u0001\"\u0011M\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015)\u0007\u0001\"\u0011g\u0011\u0015Q\u0007\u0001\"\u0011l\u0011!!\b\u0001#b\u0001\n\u0013)\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002\u0016\u0001!\t\"a\u0006\t\u000f\u0005M\u0002\u0001\"\u0015\u00026!I\u0011q\b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u0003\u000f\u0002\u0011\u0013!C\u0001\u0003\u0013B\u0011\"a\u0018\u0001#\u0003%\t!!\u0013\t\u0013\u0005\u0005\u0004!!A\u0005B\u0005\r\u0004\"CA:\u0001\u0005\u0005I\u0011AA;\u0011%\ti\bAA\u0001\n\u0003\ty\bC\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\"I\u0011Q\u0013\u0001\u0002\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;C\u0011\"!)\u0001\u0003\u0003%\t%a)\b\u0013\u0005\u001d\u0017%!A\t\u0002\u0005%g\u0001\u0003\u0011\"\u0003\u0003E\t!a3\t\rMSB\u0011AAr\u0011%\t)OGA\u0001\n\u000b\n9\u000fC\u0005\u0002jj\t\t\u0011\"!\u0002l\"I\u0011\u0011\u001f\u000e\u0002\u0002\u0013\u0005\u00151\u001f\u0005\n\u0005\u000bQ\u0012\u0011!C\u0005\u0005\u000f\u0011QbR3u\u0015N|gn\u00142kK\u000e$(B\u0001\u0012$\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0011*\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001y3GN\u001d@!\t\u0001\u0014'D\u0001\"\u0013\t\u0011\u0014E\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011\u0001\u0007N\u0005\u0003k\u0005\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t\u0001t'\u0003\u00029C\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u0011%\u000f\u0005\u00053eB\u0001\"F\u001b\u0005\u0019%B\u0001#.\u0003\u0019a$o\\8u}%\tA(\u0003\u0002Hw\u00059\u0001/Y2lC\u001e,\u0017BA%K\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t95(\u0001\u0003kg>tW#A'\u0011\u0005Ar\u0015BA(\"\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006UN|g\u000eI\u0001\u0005a\u0006$\b.A\u0003qCRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004+Z;\u0006C\u0001\u0019\u0001\u0011\u0015YU\u00011\u0001N\u0011\u0015\tV\u00011\u0001N\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001]!\r\u0001UlX\u0005\u0003=*\u00131aU3r!\t\u00017-D\u0001b\u0015\t\u0011W%A\u0003usB,7/\u0003\u0002eC\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\t]VdG.\u00192mKV\tq\r\u0005\u0002;Q&\u0011\u0011n\u000f\u0002\b\u0005>|G.Z1o\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002YB\u0011Q.\u001d\b\u0003]>\u0004\"AQ\u001e\n\u0005A\\\u0014A\u0002)sK\u0012,g-\u0003\u0002sg\n11\u000b\u001e:j]\u001eT!\u0001]\u001e\u0002\u0013\u00154\u0018\r\\;bi>\u0014X#\u0001<\u0011\u0005]LX\"\u0001=\u000b\u0005-\u000b\u0013B\u0001>y\u0005Y9U\r\u001e&t_:|%M[3di\u00163\u0018\r\\;bi>\u0014\bFA\u0006}!\tQT0\u0003\u0002\u007fw\tIAO]1og&,g\u000e^\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\u0004\u0005%\u0001c\u0001\u001e\u0002\u0006%\u0019\u0011qA\u001e\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\f1\u0001\n\u00111\u0001\u0002\u000e\u0005)\u0011N\u001c9viB!\u0011qBA\t\u001b\u0005\u0019\u0013bAA\nG\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002\u001a\u0005\u0015\u0012q\u0006\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD\u0011\u0002\u000f\r|G-Z4f]&!\u00111EA\u000f\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0014\u001b\u0001\u0007\u0011\u0011F\u0001\u0004GRD\b\u0003BA\u000e\u0003WIA!!\f\u0002\u001e\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u0019\u001b\u0001\u0007\u0011\u0011D\u0001\u0003KZ\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bU\u000b9$a\u000f\t\r\u0005eb\u00021\u0001N\u0003\u001dqWm\u001e'fMRDa!!\u0010\u000f\u0001\u0004i\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006+\u0006\r\u0013Q\t\u0005\b\u0017>\u0001\n\u00111\u0001N\u0011\u001d\tv\u0002%AA\u00025\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002L)\u001aQ*!\u0014,\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0017<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\n\u0019FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003K\u0002B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0003mC:<'BAA8\u0003\u0011Q\u0017M^1\n\u0007I\fI'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002xA\u0019!(!\u001f\n\u0007\u0005m4HA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0004\u0005\u0005\u0005\"CAB)\u0005\u0005\t\u0019AA<\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0012\t\u0007\u0003\u0017\u000b\t*a\u0001\u000e\u0005\u00055%bAAHw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002h\u00033C\u0011\"a!\u0017\u0003\u0003\u0005\r!a\u0001\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003K\ny\nC\u0005\u0002\u0004^\t\t\u00111\u0001\u0002x\u00051Q-];bYN$2aZAS\u0011%\t\u0019\tGA\u0001\u0002\u0004\t\u0019\u0001K\n\u0001\u0003S\u000by+!-\u00026\u0006]\u00161XA_\u0003\u0003\f\u0019\rE\u00021\u0003WK1!!,\"\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a-\u0002y}3UKT\"`Q)\u001cxN\\0uqRd\u0003\u0005]1uQ&\u0002S\u0006I#yiJ\f7\r^:!C\u0002R7o\u001c8!_\nTWm\u0019;!MJ|W\u000e\t1qCRD\u0007ML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011X\u0001\u0002(*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001f\u0012bEi\u0012#MI?(Y\u0001:CEL1(SmR\u0001\u0005\t\u0011!A\u0001\u0002#M\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(7n\u0014\u0013M\t\u001e#E\njHf\u001f\u0012bEi\u00123MI?^O1\u0002s\u0005J.1;:\nw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!E*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CseW>#C\nR$E\u0019\u0012~Ym\u0014\u0013M\t\u001e#G\njXl\n\u0017!O\u0011Z&&\u0018\u0018bO%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012cE1\u00123MI/\u000bA\u0001\nQa\u001a:pkB\f#!a0\u0002\u0015)\u001cxN\\0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002F\u0006)\u0011GL\u001b/a\u0005iq)\u001a;Kg>twJ\u00196fGR\u0004\"\u0001\r\u000e\u0014\u000bi\ti-!7\u0011\u000f\u0005=\u0017Q['N+6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'\\\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003/\f\tNA\tBEN$(/Y2u\rVt7\r^5p]J\u0002B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0005\u0003?\fi'\u0001\u0002j_&\u0019\u0011*!8\u0015\u0005\u0005%\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0014!B1qa2LH#B+\u0002n\u0006=\b\"B&\u001e\u0001\u0004i\u0005\"B)\u001e\u0001\u0004i\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003k\u0014\t\u0001E\u0003;\u0003o\fY0C\u0002\u0002zn\u0012aa\u00149uS>t\u0007#\u0002\u001e\u0002~6k\u0015bAA\u0000w\t1A+\u001e9mKJB\u0001Ba\u0001\u001f\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B\u0005!\u0011\t9Ga\u0003\n\t\t5\u0011\u0011\u000e\u0002\u0007\u001f\nTWm\u0019;")
public class GetJsonObject
extends BinaryExpression
implements ExpectsInputTypes,
DefaultStringProducingExpression,
Serializable {
    private transient GetJsonObjectEvaluator evaluator;
    private final Expression json;
    private final Expression path;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(GetJsonObject x$0) {
        return GetJsonObject$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, GetJsonObject> tupled() {
        return GetJsonObject$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, GetJsonObject>> curried() {
        return GetJsonObject$.MODULE$.curried();
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression json() {
        return this.json;
    }

    public Expression path() {
        return this.path;
    }

    @Override
    public Expression left() {
        return this.json();
    }

    @Override
    public Expression right() {
        return this.path();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public String prettyName() {
        return "get_json_object";
    }

    private GetJsonObjectEvaluator evaluator$lzycompute() {
        GetJsonObject getJsonObject = this;
        synchronized (getJsonObject) {
            if (!this.bitmap$trans$0) {
                this.evaluator = this.path().foldable() ? new GetJsonObjectEvaluator((UTF8String)this.path().eval(this.path().eval$default$1())) : new GetJsonObjectEvaluator();
                this.bitmap$trans$0 = true;
            }
        }
        return this.evaluator;
    }

    private GetJsonObjectEvaluator evaluator() {
        if (!this.bitmap$trans$0) {
            return this.evaluator$lzycompute();
        }
        return this.evaluator;
    }

    @Override
    public Object eval(InternalRow input) {
        block0: {
            this.evaluator().setJson((UTF8String)this.json().eval(input));
            if (this.path().foldable()) break block0;
            this.evaluator().setPath((UTF8String)this.path().eval(input));
        }
        return this.evaluator().evaluate();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String string;
        String evaluatorClass = GetJsonObjectEvaluator.class.getName();
        boolean bl = this.path().foldable();
        if (bl && this.path().eval(this.path().eval$default$1()) != null) {
            UTF8String cachedPath = (UTF8String)this.path().eval(this.path().eval$default$1());
            String refCachedPath = ctx.addReferenceObj("cachedPath", cachedPath, ctx.addReferenceObj$default$3());
            string = "new " + evaluatorClass + "(" + refCachedPath + ")";
        } else {
            string = "new " + evaluatorClass + "()";
        }
        String initEvaluator = string;
        String evaluator = ctx.addMutableState(evaluatorClass, "evaluator", (Function1<String, String>)(Function1 & Serializable)v -> v + " = " + initEvaluator + ";", true, ctx.addMutableState$default$5());
        ExprCode jsonEval = this.json().genCode(ctx);
        ExprCode pathEval = this.path().genCode(ctx);
        String setJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + jsonEval.isNull() + ") {\n         |  " + evaluator + ".setJson(null);\n         |} else {\n         |  " + evaluator + ".setJson(" + jsonEval.value() + ");\n         |}\n         |"));
        String setPath = !this.path().foldable() ? StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |if (" + pathEval.isNull() + ") {\n         |  " + evaluator + ".setPath(null);\n         |} else {\n         |  " + evaluator + ".setPath(" + pathEval.value() + ");\n         |}\n         |")) : "";
        String resultType = CodeGenerator$.MODULE$.boxedType(this.dataType());
        String resultTerm = ctx.freshName("result");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", "\n         |", "\n         |", " ", " = (", ") ", ".evaluate();\n         |boolean ", " = ", " == null;\n         |", " ", " = ", ";\n         |if (!", ") {\n         |  ", " = ", ";\n         |}\n         |"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{jsonEval.code(), pathEval.code(), setJson, setPath, resultType, resultTerm, resultType, evaluator, ev.isNull(), resultTerm, CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), resultTerm})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public GetJsonObject withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public GetJsonObject copy(Expression json, Expression path) {
        return new GetJsonObject(json, path);
    }

    public Expression copy$default$1() {
        return this.json();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "GetJsonObject";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.json();
            }
            case 1: {
                return this.path();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GetJsonObject;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "json";
            }
            case 1: {
                return "path";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GetJsonObject)) return false;
        boolean bl = true;
        if (!bl) return false;
        GetJsonObject getJsonObject = (GetJsonObject)x$1;
        Expression expression = this.json();
        Expression expression2 = getJsonObject.json();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = getJsonObject.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!getJsonObject.canEqual(this)) return false;
        return true;
    }

    public GetJsonObject(Expression json, Expression path) {
        this.json = json;
        this.path = path;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

