/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.st;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.GeographyType$;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.GeometryType$;
import org.apache.spark.sql.types.IntegerType$;
import scala.Predef$;
import scala.runtime.BoxesRunTime;

public final class STExpressionUtils$ {
    public static final STExpressionUtils$ MODULE$ = new STExpressionUtils$();

    public boolean isGeoSpatialType(DataType dt) {
        DataType dataType = dt;
        return dataType instanceof GeometryType ? true : dataType instanceof GeographyType;
    }

    public DataType geospatialTypeWithSrid(DataType sourceType, Expression srid) {
        DataType dataType = sourceType;
        if (!SQLConf$.MODULE$.get().geospatialEnabled()) {
            throw new AnalysisException("UNSUPPORTED_FEATURE.GEOSPATIAL_DISABLED", Predef$.MODULE$.Map().empty());
        }
        if (dataType instanceof GeometryType) {
            return this.geometryTypeWithSrid(srid);
        }
        if (dataType instanceof GeographyType) {
            return this.geographyTypeWithSrid(srid);
        }
        throw new IllegalArgumentException("Unexpected data type: " + sourceType + ".");
    }

    private GeometryType geometryTypeWithSrid(Expression srid) {
        Expression expression = srid;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object sridValue = literal.value();
            DataType dataType = literal.dataType();
            if (sridValue instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)sridValue);
                if (IntegerType$.MODULE$.equals(dataType)) {
                    return GeometryType$.MODULE$.apply(n);
                }
            }
        }
        return GeometryType$.MODULE$.apply("ANY");
    }

    private GeographyType geographyTypeWithSrid(Expression srid) {
        Expression expression = srid;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object sridValue = literal.value();
            DataType dataType = literal.dataType();
            if (sridValue instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)sridValue);
                if (IntegerType$.MODULE$.equals(dataType)) {
                    return GeographyType$.MODULE$.apply(n);
                }
            }
        }
        return GeographyType$.MODULE$.apply("ANY");
    }

    private STExpressionUtils$() {
    }
}

