/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class ColumnAccessAnalyzer {
    private final ParseContext pGraphContext;

    public ColumnAccessAnalyzer() {
        this.pGraphContext = null;
    }

    public ColumnAccessAnalyzer(ParseContext pactx) {
        this.pGraphContext = pactx;
    }

    public ColumnAccessInfo analyzeColumnAccess(ColumnAccessInfo columnAccessInfo) throws SemanticException {
        if (columnAccessInfo == null) {
            columnAccessInfo = new ColumnAccessInfo();
        }
        Collection<TableScanOperator> topOps = this.pGraphContext.getTopOps().values();
        for (TableScanOperator top : topOps) {
            PrunedPartitionList parts;
            if (top.isInsideView()) continue;
            Table table = ((TableScanDesc)top.getConf()).getTableMetadata();
            String tableName = table.getCompleteName();
            List<String> referenced = top.getReferencedColumns();
            for (String column : referenced) {
                columnAccessInfo.add(tableName, column);
            }
            if (!table.isPartitioned() || (parts = this.pGraphContext.getPrunedPartitions(table.getTableName(), top)).getReferredPartCols() == null) continue;
            for (String partKey : parts.getReferredPartCols()) {
                columnAccessInfo.add(tableName, partKey);
            }
        }
        return columnAccessInfo;
    }
}

