/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.classic.ClassicConversions$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DescribeCommandBase;
import org.apache.spark.sql.execution.command.DescribeTableCommand$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001B\u0012%\u0001FB\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0015\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005i\u0001\tE\t\u0015!\u0003T\u0011!I\u0007A!f\u0001\n\u0003Q\u0007\u0002\u00038\u0001\u0005#\u0005\u000b\u0011B6\t\u0011=\u0004!Q3A\u0005BAD\u0001B\u001f\u0001\u0003\u0012\u0003\u0006I!\u001d\u0005\u0006w\u0002!\t\u0001 \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\u0012\u0001\t\u0013\t9\u0005C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X!9\u00111\u000e\u0001\u0005\n\u00055\u0004\"CAA\u0001\u0005\u0005I\u0011AAB\u0011%\ti\tAI\u0001\n\u0003\ty\tC\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002(\"I\u00111\u0016\u0001\u0012\u0002\u0013\u0005\u0011Q\u0016\u0005\n\u0003c\u0003\u0011\u0013!C\u0001\u0003gC\u0011\"a.\u0001\u0003\u0003%\t%!/\t\u0013\u0005-\u0007!!A\u0005\u0002\u00055\u0007\"CAk\u0001\u0005\u0005I\u0011AAl\u0011%\t\u0019\u000fAA\u0001\n\u0003\n)\u000fC\u0005\u0002p\u0002\t\t\u0011\"\u0001\u0002r\"I\u0011Q\u001f\u0001\u0002\u0002\u0013\u0005\u0013q\u001f\u0005\n\u0003w\u0004\u0011\u0011!C!\u0003{<\u0011B!\u0001%\u0003\u0003E\tAa\u0001\u0007\u0011\r\"\u0013\u0011!E\u0001\u0005\u000bAaa_\u000f\u0005\u0002\tu\u0001\"\u0003B\u0010;\u0005\u0005IQ\tB\u0011\u0011%\u0011\u0019#HA\u0001\n\u0003\u0013)\u0003C\u0005\u00030u\t\t\u0011\"!\u00032!I!1I\u000f\u0002\u0002\u0013%!Q\t\u0002\u0015\t\u0016\u001c8M]5cKR\u000b'\r\\3D_6l\u0017M\u001c3\u000b\u0005\u00152\u0013aB2p[6\fg\u000e\u001a\u0006\u0003O!\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%R\u0013aA:rY*\u00111\u0006L\u0001\u0006gB\f'o\u001b\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011d\u0007\u0010\t\u0003gQj\u0011\u0001J\u0005\u0003k\u0011\u00121\u0003R3tGJL'-Z\"p[6\fg\u000e\u001a\"bg\u0016\u0004\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002>\u000b:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003B\na\u0001\u0010:p_Rt\u0014\"A\u001d\n\u0005\u0011C\u0014a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u0012\u001d\u0002\u000bQ\f'\r\\3\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S!!\u0014\u0015\u0002\u0011\r\fG/\u00197zgRL!a\u0014'\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fa\u0001^1cY\u0016\u0004\u0013!\u00049beRLG/[8o'B,7-F\u0001T!\t!VM\u0004\u0002VE:\u0011a\u000b\u0019\b\u0003/~s!\u0001\u00170\u000f\u0005ekfB\u0001.]\u001d\ty4,C\u00010\u0013\tic&\u0003\u0002,Y%\u0011\u0011FK\u0005\u0003\u001b\"J!!\u0019'\u0002\u000f\r\fG/\u00197pO&\u00111\rZ\u0001\r\u0007\u0006$\u0018\r\\8h)f\u0004Xm\u001d\u0006\u0003C2K!AZ4\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0003G\u0012\fa\u0002]1si&$\u0018n\u001c8Ta\u0016\u001c\u0007%\u0001\u0006jg\u0016CH/\u001a8eK\u0012,\u0012a\u001b\t\u0003o1L!!\u001c\u001d\u0003\u000f\t{w\u000e\\3b]\u0006Y\u0011n]#yi\u0016tG-\u001a3!\u0003\u0019yW\u000f\u001e9viV\t\u0011\u000fE\u0002>eRL!a]$\u0003\u0007M+\u0017\u000f\u0005\u0002vq6\taO\u0003\u0002x\u0019\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\tIhOA\u0005BiR\u0014\u0018NY;uK\u00069q.\u001e;qkR\u0004\u0013A\u0002\u001fj]&$h\bF\u0004~}~\f\t!a\u0001\u0011\u0005M\u0002\u0001\"\u0002%\n\u0001\u0004Q\u0005\"B)\n\u0001\u0004\u0019\u0006\"B5\n\u0001\u0004Y\u0007\"B8\n\u0001\u0004\t\u0018a\u0001:v]R!\u0011\u0011BA\n!\u0011i$/a\u0003\u0011\t\u00055\u0011qB\u0007\u0002Q%\u0019\u0011\u0011\u0003\u0015\u0003\u0007I{w\u000fC\u0004\u0002\u0016)\u0001\r!a\u0006\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u00055\u0011\u0011D\u0005\u0004\u00037A#\u0001D*qCJ\\7+Z:tS>t\u0017!\u00063fg\u000e\u0014\u0018NY3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u0007\u0003C\t9#!\r\u0011\u0007]\n\u0019#C\u0002\u0002&a\u0012A!\u00168ji\"1\u0001j\u0003a\u0001\u0003S\u0001B!a\u000b\u0002.5\tA-C\u0002\u00020\u0011\u0014AbQ1uC2|w\rV1cY\u0016Dq!a\r\f\u0001\u0004\t)$\u0001\u0004ck\u001a4WM\u001d\t\u0007\u0003o\t\t%a\u0003\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tq!\\;uC\ndWMC\u0002\u0002@a\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019%!\u000f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\u0017I\u0016\u001c8M]5cK\u000ecWo\u001d;fe&tw-\u00138g_R1\u0011\u0011EA%\u0003\u0017Ba\u0001\u0013\u0007A\u0002\u0005%\u0002bBA\u001a\u0019\u0001\u0007\u0011QG\u0001\u001bI\u0016\u001c8M]5cK\u001a{'/\\1ui\u0016$G+\u00192mK&sgm\u001c\u000b\u0007\u0003C\t\t&a\u0015\t\r!k\u0001\u0019AA\u0015\u0011\u001d\t\u0019$\u0004a\u0001\u0003k\tQ\u0004Z3tGJL'-\u001a#fi\u0006LG.\u001a3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u000b\u0003C\tI&a\u0017\u0002d\u0005\u001d\u0004BB\u0016\u000f\u0001\u0004\t9\u0002\u0003\u0004b\u001d\u0001\u0007\u0011Q\f\t\u0005\u0003W\ty&C\u0002\u0002b\u0011\u0014abU3tg&|gnQ1uC2|w\rC\u0004\u0002f9\u0001\r!!\u000b\u0002\u00115,G/\u00193bi\u0006Dq!!\u001b\u000f\u0001\u0004\t)$\u0001\u0004sKN,H\u000e^\u0001'I\u0016\u001c8M]5cK\u001a{'/\\1ui\u0016$G)\u001a;bS2,G\rU1si&$\u0018n\u001c8J]\u001a|GCCA\u0011\u0003_\n\u0019(!\u001e\u0002\u0000!1\u0011\u0011O\bA\u0002)\u000bq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\u0007\u0011>\u0001\r!!\u000b\t\u000f\u0005]t\u00021\u0001\u0002z\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0003W\tY(C\u0002\u0002~\u0011\u0014QcQ1uC2|w\rV1cY\u0016\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u00024=\u0001\r!!\u000e\u0002\t\r|\u0007/\u001f\u000b\n{\u0006\u0015\u0015qQAE\u0003\u0017Cq\u0001\u0013\t\u0011\u0002\u0003\u0007!\nC\u0004R!A\u0005\t\u0019A*\t\u000f%\u0004\u0002\u0013!a\u0001W\"9q\u000e\u0005I\u0001\u0002\u0004\t\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003#S3ASAJW\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u0013Ut7\r[3dW\u0016$'bAAPq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0016\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003SS3aUAJ\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a,+\u0007-\f\u0019*\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005U&fA9\u0002\u0014\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a/\u0011\t\u0005u\u0016qY\u0007\u0003\u0003\u007fSA!!1\u0002D\u0006!A.\u00198h\u0015\t\t)-\u0001\u0003kCZ\f\u0017\u0002BAe\u0003\u007f\u0013aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAAh!\r9\u0014\u0011[\u0005\u0004\u0003'D$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAm\u0003?\u00042aNAn\u0013\r\ti\u000e\u000f\u0002\u0004\u0003:L\b\"CAq/\u0005\u0005\t\u0019AAh\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u001d\t\u0007\u0003S\fY/!7\u000e\u0005\u0005u\u0012\u0002BAw\u0003{\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u00191.a=\t\u0013\u0005\u0005\u0018$!AA\u0002\u0005e\u0017A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a/\u0002z\"I\u0011\u0011\u001d\u000e\u0002\u0002\u0003\u0007\u0011qZ\u0001\u0007KF,\u0018\r\\:\u0015\u0007-\fy\u0010C\u0005\u0002bn\t\t\u00111\u0001\u0002Z\u0006!B)Z:de&\u0014W\rV1cY\u0016\u001cu.\\7b]\u0012\u0004\"aM\u000f\u0014\u000bu\u00119Aa\u0005\u0011\u0013\t%!q\u0002&TWFlXB\u0001B\u0006\u0015\r\u0011i\u0001O\u0001\beVtG/[7f\u0013\u0011\u0011\tBa\u0003\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0005\u0003\u0003\u0016\tmQB\u0001B\f\u0015\u0011\u0011I\"a1\u0002\u0005%|\u0017b\u0001$\u0003\u0018Q\u0011!1A\u0001\ti>\u001cFO]5oOR\u0011\u00111X\u0001\u0006CB\u0004H.\u001f\u000b\n{\n\u001d\"\u0011\u0006B\u0016\u0005[AQ\u0001\u0013\u0011A\u0002)CQ!\u0015\u0011A\u0002MCQ!\u001b\u0011A\u0002-DQa\u001c\u0011A\u0002E\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u00034\t}\u0002#B\u001c\u00036\te\u0012b\u0001B\u001cq\t1q\n\u001d;j_:\u0004ra\u000eB\u001e\u0015N[\u0017/C\u0002\u0003>a\u0012a\u0001V;qY\u0016$\u0004\u0002\u0003B!C\u0005\u0005\t\u0019A?\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003HA!\u0011Q\u0018B%\u0013\u0011\u0011Y%a0\u0003\r=\u0013'.Z2u\u0001")
public class DescribeTableCommand
extends DescribeCommandBase
implements Serializable {
    private final TableIdentifier table;
    private final Map<String, String> partitionSpec;
    private final boolean isExtended;
    private final Seq<Attribute> output;

    public static Option<Tuple4<TableIdentifier, Map<String, String>, Object, Seq<Attribute>>> unapply(DescribeTableCommand x$0) {
        return DescribeTableCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple4<TableIdentifier, Map<String, String>, Object, Seq<Attribute>>, DescribeTableCommand> tupled() {
        return DescribeTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Map<String, String>, Function1<Object, Function1<Seq<Attribute>, DescribeTableCommand>>>> curried() {
        return DescribeTableCommand$.MODULE$.curried();
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Map<String, String> partitionSpec() {
        return this.partitionSpec;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    @Override
    public Seq<Attribute> output() {
        return this.output;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        ArrayBuffer result = new ArrayBuffer();
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (catalog.isTempView(this.table())) {
            if (this.partitionSpec().nonEmpty()) {
                throw QueryCompilationErrors$.MODULE$.descPartitionNotAllowedOnTempView(this.table().identifier());
            }
            StructType schema = catalog.getTempViewOrPermanentTableMetadata(this.table()).schema();
            this.describeSchema(schema, (ArrayBuffer<Row>)result, false);
        } else {
            CatalogTable metadata = catalog.getTableRawMetadata(this.table());
            if (metadata.schema().isEmpty()) {
                this.describeSchema(ClassicConversions$.MODULE$.castToImpl(sparkSession).table(metadata.identifier()).schema(), (ArrayBuffer<Row>)result, false);
            } else {
                this.describeSchema(metadata.schema(), (ArrayBuffer<Row>)result, false);
            }
            this.describePartitionInfo(metadata, (ArrayBuffer<Row>)result);
            this.describeClusteringInfo(metadata, (ArrayBuffer<Row>)result);
            if (this.partitionSpec().nonEmpty()) {
                this.describeDetailedPartitionInfo(sparkSession, catalog, metadata, (ArrayBuffer<Row>)result);
            } else if (this.isExtended()) {
                this.describeFormattedTableInfo(metadata, (ArrayBuffer<Row>)result);
            }
            ResolveDefaultColumns$.MODULE$.getDescribeMetadata(metadata.schema()).foreach((Function1 & Serializable)row -> {
                this.append((ArrayBuffer<Row>)result, (String)row._1(), (String)row._2(), (String)row._3());
                return BoxedUnit.UNIT;
            });
        }
        return result.toSeq();
    }

    private void describePartitionInfo(CatalogTable table, ArrayBuffer<Row> buffer) {
        if (table.partitionColumnNames().nonEmpty()) {
            this.append(buffer, "# Partition Information", "", "");
            this.describeSchema(table.partitionSchema(), buffer, true);
            return;
        }
    }

    private void describeClusteringInfo(CatalogTable table, ArrayBuffer<Row> buffer) {
        table.clusterBySpec().foreach((Function1 & Serializable)clusterBySpec -> {
            this.append(buffer, "# Clustering Information", "", "");
            this.append(buffer, "# " + ((NamedExpression)this.output().head()).name(), ((NamedExpression)this.output().apply(1)).name(), ((NamedExpression)this.output().apply(2)).name());
            return (Seq)((IterableOps)clusterBySpec.columnNames().map((Function1 & Serializable)fieldNames -> {
                Option nestedField = table.schema().findNestedField((Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])fieldNames.fieldNames())), table.schema().findNestedField$default$2(), table.schema().findNestedField$default$3(), table.schema().findNestedField$default$4());
                Predef$.MODULE$.assert(nestedField.isDefined(), (Function0 & Serializable)() -> "The clustering column " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fieldNames.fieldNames()), (Function1 & Serializable)part -> package$.MODULE$.quoteIfNeeded(part), ClassTag$.MODULE$.apply(String.class))).mkString(".") + " was not found in the table schema " + table.schema().catalogString() + ".");
                return (Tuple2)nestedField.get();
            })).map((Function1 & Serializable)x0$1 -> {
                DescribeTableCommand.$anonfun$describeClusteringInfo$5(this, buffer, x0$1);
                return BoxedUnit.UNIT;
            });
        });
    }

    private void describeFormattedTableInfo(CatalogTable table, ArrayBuffer<Row> buffer) {
        .colon.colon excludedTableInfo = new .colon.colon((Object)"Partition Columns", (List)new .colon.colon((Object)"Schema", (List)Nil$.MODULE$));
        this.append(buffer, "", "", "");
        this.append(buffer, "# Detailed Table Information", "", "");
        ((LinkedHashMap)table.toLinkedHashMap().filter(arg_0 -> DescribeTableCommand.$anonfun$describeFormattedTableInfo$1$adapted((Seq)excludedTableInfo, arg_0))).foreach((Function1 & Serializable)s -> {
            this.append((ArrayBuffer<Row>)buffer, (String)s._1(), (String)s._2(), "");
            return BoxedUnit.UNIT;
        });
    }

    private void describeDetailedPartitionInfo(SparkSession spark, SessionCatalog catalog, CatalogTable metadata, ArrayBuffer<Row> result) {
        CatalogTableType catalogTableType = metadata.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.descPartitionNotAllowedOnView(this.table().identifier());
        }
        DDLUtils$.MODULE$.verifyPartitionProviderIsHive(spark, metadata, "DESC PARTITION");
        Map normalizedPartSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec(this.partitionSpec(), metadata.partitionSchema(), this.table().quotedString(), spark.sessionState().conf().resolver());
        CatalogTablePartition partition = catalog.getPartition(this.table(), normalizedPartSpec);
        if (this.isExtended()) {
            this.describeFormattedDetailedPartitionInfo(this.table(), metadata, partition, result);
            return;
        }
    }

    private void describeFormattedDetailedPartitionInfo(TableIdentifier tableIdentifier, CatalogTable table, CatalogTablePartition partition, ArrayBuffer<Row> buffer) {
        this.append(buffer, "", "", "");
        this.append(buffer, "# Detailed Partition Information", "", "");
        this.append(buffer, "Database", table.database(), "");
        this.append(buffer, "Table", tableIdentifier.table(), "");
        partition.toLinkedHashMap().foreach((Function1 & Serializable)s -> {
            this.append((ArrayBuffer<Row>)buffer, (String)s._1(), (String)s._2(), "");
            return BoxedUnit.UNIT;
        });
        this.append(buffer, "", "", "");
        this.append(buffer, "# Storage Information", "", "");
        Option option = table.bucketSpec();
        if (option instanceof Some) {
            Some some = (Some)option;
            BucketSpec spec = (BucketSpec)some.value();
            spec.toLinkedHashMap().foreach((Function1 & Serializable)s -> {
                this.append((ArrayBuffer<Row>)buffer, (String)s._1(), (String)s._2(), "");
                return BoxedUnit.UNIT;
            });
        }
        table.storage().toLinkedHashMap().foreach((Function1 & Serializable)s -> {
            this.append((ArrayBuffer<Row>)buffer, (String)s._1(), (String)s._2(), "");
            return BoxedUnit.UNIT;
        });
    }

    public DescribeTableCommand copy(TableIdentifier table, Map<String, String> partitionSpec, boolean isExtended, Seq<Attribute> output) {
        return new DescribeTableCommand(table, partitionSpec, isExtended, output);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Map<String, String> copy$default$2() {
        return this.partitionSpec();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public Seq<Attribute> copy$default$4() {
        return this.output();
    }

    public String productPrefix() {
        return "DescribeTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.table();
            }
            case 1: {
                return this.partitionSpec();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.isExtended());
            }
            case 3: {
                return this.output();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DescribeTableCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "table";
            }
            case 1: {
                return "partitionSpec";
            }
            case 2: {
                return "isExtended";
            }
            case 3: {
                return "output";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DescribeTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DescribeTableCommand describeTableCommand = (DescribeTableCommand)x$1;
        if (this.isExtended() != describeTableCommand.isExtended()) return false;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = describeTableCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map = this.partitionSpec();
        Map<String, String> map2 = describeTableCommand.partitionSpec();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Seq<Attribute> seq = this.output();
        Seq<Attribute> seq2 = describeTableCommand.output();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!describeTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$describeClusteringInfo$5(DescribeTableCommand $this, ArrayBuffer buffer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq path = (Seq)tuple2._1();
            StructField field = (StructField)tuple2._2();
            $this.append((ArrayBuffer<Row>)buffer$2, ((IterableOnceOps)((IterableOps)path.$colon$plus((Object)field.name())).map((Function1 & Serializable)part -> package$.MODULE$.quoteIfNeeded(part))).mkString("."), field.dataType().simpleString(), (String)field.getComment().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$describeFormattedTableInfo$1(Seq excludedTableInfo$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !excludedTableInfo$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public DescribeTableCommand(TableIdentifier table, Map<String, String> partitionSpec, boolean isExtended, Seq<Attribute> output) {
        this.table = table;
        this.partitionSpec = partitionSpec;
        this.isExtended = isExtended;
        this.output = output;
    }

    public static final /* synthetic */ Object $anonfun$describeFormattedTableInfo$1$adapted(Seq excludedTableInfo$1, Tuple2 x0$1) {
        return BoxesRunTime.boxToBoolean((boolean)DescribeTableCommand.$anonfun$describeFormattedTableInfo$1(excludedTableInfo$1, x0$1));
    }
}

