/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import java.io.Serializable;
import java.util.ArrayDeque;
import org.apache.spark.QueryContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.analysis.resolver.AutoGeneratedAliasProvider;
import org.apache.spark.sql.catalyst.analysis.resolver.CoercesExpressionTypes;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolutionContext;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionResolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversal;
import org.apache.spark.sql.catalyst.analysis.resolver.ExpressionTreeTraversalStack;
import org.apache.spark.sql.catalyst.analysis.resolver.GroupingAndAggregateExpressionsExtractor;
import org.apache.spark.sql.catalyst.analysis.resolver.Resolver;
import org.apache.spark.sql.catalyst.analysis.resolver.ResolvesExpressionChildren;
import org.apache.spark.sql.catalyst.analysis.resolver.SubqueryRegistry;
import org.apache.spark.sql.catalyst.analysis.resolver.TreeNodeResolver;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.OuterReference;
import org.apache.spark.sql.catalyst.expressions.OuterReference$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.SubExprUtils$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ListAgg;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005c\u0001B\u000b\u0017\u0001\u0015B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\")!\n\u0001C\u0001\u0017\"9q\n\u0001b\u0001\n\u0013\u0001\u0006B\u0002+\u0001A\u0003%\u0011\u000bC\u0004V\u0001\t\u0007I\u0011\u0002,\t\r\t\u0004\u0001\u0015!\u0003X\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Da\u0001\u001b\u0001!\u0002\u0013)\u0007bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007]\u0002\u0001\u000b\u0011B6\t\u000b=\u0004A\u0011\t9\t\u000bM\u0004A\u0011\u0001;\t\u000bY\u0004A\u0011B<\t\u000bi\u0004A\u0011B>\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011q\u0001\u0001\u0005\n\u0005%\u0001bBA\u000f\u0001\u0011%\u0011q\u0004\u0005\b\u0003c\u0001A\u0011BA\u001a\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\u00111$Q4he\u0016<\u0017\r^3FqB\u0014Xm]:j_:\u0014Vm]8mm\u0016\u0014(BA\f\u0019\u0003!\u0011Xm]8mm\u0016\u0014(BA\r\u001b\u0003!\tg.\u00197zg&\u001c(BA\u000e\u001d\u0003!\u0019\u0017\r^1msN$(BA\u000f\u001f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sO\u000e\u00011#\u0002\u0001'Yqz\u0004CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0003.]ABT\"\u0001\f\n\u0005=2\"\u0001\u0005+sK\u0016tu\u000eZ3SKN|GN^3s!\t\td'D\u00013\u0015\t\u0019D'A\u0005bO\u001e\u0014XmZ1uK*\u0011QGG\u0001\fKb\u0004(/Z:tS>t7/\u0003\u00028e\t\u0019\u0012iZ4sK\u001e\fG/Z#yaJ,7o]5p]B\u0011\u0011HO\u0007\u0002i%\u00111\b\u000e\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA\u0017>\u0013\tqdC\u0001\u000eSKN|GN^3t\u000bb\u0004(/Z:tS>t7\t[5mIJ,g\u000e\u0005\u0002.\u0001&\u0011\u0011I\u0006\u0002\u0017\u0007>,'oY3t\u000bb\u0004(/Z:tS>tG+\u001f9fg\u0006\u0001r\u000e]3sCR|'OU3t_24XM\u001d\t\u0003[\u0011K!!\u0012\f\u0003\u0011I+7o\u001c7wKJ\f!#\u001a=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<feB\u0011Q\u0006S\u0005\u0003\u0013Z\u0011!#\u0012=qe\u0016\u001c8/[8o%\u0016\u001cx\u000e\u001c<fe\u00061A(\u001b8jiz\"2\u0001T'O!\ti\u0003\u0001C\u0003C\u0007\u0001\u00071\tC\u0003G\u0007\u0001\u0007q)\u0001\u0006ue\u00064XM]:bYN,\u0012!\u0015\t\u0003[IK!a\u0015\f\u00039\u0015C\bO]3tg&|g\u000e\u0016:fKR\u0013\u0018M^3sg\u0006d7\u000b^1dW\u0006YAO]1wKJ\u001c\u0018\r\\:!\u0003\u0001*\u0007\u0010\u001d:fgNLwN\u001c*fg>dW\u000f^5p]\u000e{g\u000e^3yiN#\u0018mY6\u0016\u0003]\u00032\u0001W/`\u001b\u0005I&B\u0001.\\\u0003\u0011)H/\u001b7\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u000b\u0003J\u0014\u0018-\u001f#fcV,\u0007CA\u0017a\u0013\t\tgCA\u000eFqB\u0014Xm]:j_:\u0014Vm]8mkRLwN\\\"p]R,\u0007\u0010^\u0001\"Kb\u0004(/Z:tS>t'+Z:pYV$\u0018n\u001c8D_:$X\r\u001f;Ti\u0006\u001c7\u000eI\u0001\u0011gV\u0014\u0017/^3ssJ+w-[:uef,\u0012!\u001a\t\u0003[\u0019L!a\u001a\f\u0003!M+(-];fef\u0014VmZ5tiJL\u0018!E:vEF,XM]=SK\u001eL7\u000f\u001e:zA\u0005Q\u0012-\u001e;p\u000f\u0016tWM]1uK\u0012\fE.[1t!J|g/\u001b3feV\t1\u000e\u0005\u0002.Y&\u0011QN\u0006\u0002\u001b\u0003V$xnR3oKJ\fG/\u001a3BY&\f7\u000f\u0015:pm&$WM]\u0001\u001cCV$xnR3oKJ\fG/\u001a3BY&\f7\u000f\u0015:pm&$WM\u001d\u0011\u0002\u000fI,7o\u001c7wKR\u0011\u0001(\u001d\u0005\u0006e2\u0001\r\u0001M\u0001\u0014C\u001e<'/Z4bi\u0016,\u0005\u0010\u001d:fgNLwN\\\u0001$e\u0016\u001cx\u000e\u001c<f/&$\bn\\;u%\u0016\u001cWO]:j]\u001eLe\u000e^8DQ&dGM]3o)\tAT\u000fC\u0003s\u001b\u0001\u0007\u0001'A\u0017iC:$G.Z!hOJ,w-\u0019;f\u000bb\u0004(/Z:tS>tw+\u001b;i\u0007\"LG\u000e\u001a:f]J+7o\u001c7wK\u0012$\"\u0001\u000f=\t\u000bet\u0001\u0019\u0001\u0019\u0002O\u0005<wM]3hCR,W\t\u001f9sKN\u001c\u0018n\u001c8XSRD7\t[5mIJ,gNU3t_24X\rZ\u0001$m\u0006d\u0017\u000eZ1uKJ+7o\u001c7wK\u0012\fum\u001a:fO\u0006$X-\u0012=qe\u0016\u001c8/[8o)\tax\u0010\u0005\u0002({&\u0011a\u0010\u000b\u0002\u0005+:LG\u000fC\u0003s\u001f\u0001\u0007\u0001'\u0001\u0010iC:$G.Z(vi\u0016\u0014\u0018iZ4sK\u001e\fG/Z#yaJ,7o]5p]R\u0019\u0001(!\u0002\t\u000bI\u0004\u0002\u0019\u0001\u0019\u0002?\u0015DHO]1di>+H/\u001a:BO\u001e\u0014XmZ1uK\u0016C\bO]3tg&|g\u000e\u0006\u0004\u0002\f\u0005E\u00111\u0003\t\u0004s\u00055\u0011bAA\bi\tqq*\u001e;feJ+g-\u001a:f]\u000e,\u0007\"\u0002:\u0012\u0001\u0004\u0001\u0004bBA\u000b#\u0001\u0007\u0011qC\u0001\u001eC\u001e<'/Z4bi\u0016,\u0005\u0010\u001d:fgNLwN\\:FqR\u0014\u0018m\u0019;peB\u0019Q&!\u0007\n\u0007\u0005maC\u0001\u0015He>,\b/\u001b8h\u0003:$\u0017iZ4sK\u001e\fG/Z#yaJ,7o]5p]N,\u0005\u0010\u001e:bGR|'/\u0001\u0017uQJ|wOR;oGRLwN\\!oI>\u0013H-\u001a:FqB\u0014Xm]:j_:l\u0015n]7bi\u000eDWI\u001d:peR!\u0011\u0011EA\u0014!\r9\u00131E\u0005\u0004\u0003KA#a\u0002(pi\"Lgn\u001a\u0005\b\u0003S\u0011\u0002\u0019AA\u0016\u0003\u001da\u0017n\u001d;BO\u001e\u00042!MA\u0017\u0013\r\tyC\r\u0002\b\u0019&\u001cH/Q4h\u0003q!\bN]8x\u001d\u0016\u001cH/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:$B!!\t\u00026!)!o\u0005a\u0001a\u0005!D\u000f\u001b:po\u0006;wM]3hCR,g)\u001e8di&|gnV5uQ:{g\u000eZ3uKJl\u0017N\\5ti&\u001cW\t\u001f9sKN\u001c\u0018n\u001c8\u0015\r\u0005\u0005\u00121HA\u001f\u0011\u0015\u0011H\u00031\u00011\u0011\u0019\ty\u0004\u0006a\u0001q\u0005)bn\u001c8EKR,'/\\5oSN$\u0018nY\"iS2$\u0007")
public class AggregateExpressionResolver
implements TreeNodeResolver<AggregateExpression, Expression>,
ResolvesExpressionChildren,
CoercesExpressionTypes {
    private final ExpressionResolver expressionResolver;
    private final ExpressionTreeTraversalStack traversals;
    private final ArrayDeque<ExpressionResolutionContext> expressionResolutionContextStack;
    private final SubqueryRegistry subqueryRegistry;
    private final AutoGeneratedAliasProvider autoGeneratedAliasProvider;
    private Seq<Function1<Expression, Expression>> ansiTransformations;
    private Seq<Function1<Expression, Expression>> nonAnsiTransformations;

    @Override
    public Expression coerceExpressionTypes(Expression expression, ExpressionTreeTraversal expressionTreeTraversal) {
        return CoercesExpressionTypes.coerceExpressionTypes$(this, expression, expressionTreeTraversal);
    }

    @Override
    public Expression withResolvedChildren(UnaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(BinaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(TernaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(QuaternaryExpression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public Expression withResolvedChildren(Expression unresolvedExpression, Function1<Expression, Expression> resolveChild) {
        return ResolvesExpressionChildren.withResolvedChildren$((ResolvesExpressionChildren)this, unresolvedExpression, resolveChild);
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    @Override
    public SQLConf conf() {
        return SQLConfHelper.conf$(this);
    }

    @Override
    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$(this, pairs, f);
    }

    @Override
    public Seq<Function1<Expression, Expression>> ansiTransformations() {
        return this.ansiTransformations;
    }

    @Override
    public Seq<Function1<Expression, Expression>> nonAnsiTransformations() {
        return this.nonAnsiTransformations;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$ansiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.ansiTransformations = x$1;
    }

    @Override
    public void org$apache$spark$sql$catalyst$analysis$resolver$CoercesExpressionTypes$_setter_$nonAnsiTransformations_$eq(Seq<Function1<Expression, Expression>> x$1) {
        this.nonAnsiTransformations = x$1;
    }

    private ExpressionTreeTraversalStack traversals() {
        return this.traversals;
    }

    private ArrayDeque<ExpressionResolutionContext> expressionResolutionContextStack() {
        return this.expressionResolutionContextStack;
    }

    private SubqueryRegistry subqueryRegistry() {
        return this.subqueryRegistry;
    }

    private AutoGeneratedAliasProvider autoGeneratedAliasProvider() {
        return this.autoGeneratedAliasProvider;
    }

    @Override
    public Expression resolve(AggregateExpression aggregateExpression) {
        this.expressionResolutionContextStack().peek().resolvingTreeUnderAggregateExpression_$eq(true);
        AggregateExpression aggregateExpressionWithChildrenResolved = (AggregateExpression)this.withResolvedChildren(aggregateExpression, (Function1<Expression, Expression>)(Function1 & Serializable)unresolvedExpression -> $this.expressionResolver.resolve((Expression)unresolvedExpression));
        return this.handleAggregateExpressionWithChildrenResolved(aggregateExpressionWithChildrenResolved);
    }

    public Expression resolveWithoutRecursingIntoChildren(AggregateExpression aggregateExpression) {
        AggregateExpression aggregateExpressionWithTypeCoercedChildren = (AggregateExpression)aggregateExpression.mapChildren((Function1 & Serializable)expression -> this.coerceExpressionTypes((Expression)expression, this.traversals().current()));
        return this.handleAggregateExpressionWithChildrenResolved(aggregateExpressionWithTypeCoercedChildren);
    }

    private Expression handleAggregateExpressionWithChildrenResolved(AggregateExpression aggregateExpressionWithChildrenResolved) {
        ExpressionResolutionContext expressionResolutionContext = this.expressionResolutionContextStack().peek();
        this.validateResolvedAggregateExpression(aggregateExpressionWithChildrenResolved);
        expressionResolutionContext.hasAggregateExpressions_$eq(true);
        expressionResolutionContext.hasAttributeOutsideOfAggregateExpressions_$eq(false);
        if (expressionResolutionContext.hasOuterReferences()) {
            return this.handleOuterAggregateExpression(aggregateExpressionWithChildrenResolved);
        }
        return aggregateExpressionWithChildrenResolved;
    }

    private void validateResolvedAggregateExpression(AggregateExpression aggregateExpression) {
        AggregateFunction listAgg;
        AggregateExpression aggregateExpression2 = aggregateExpression;
        if (aggregateExpression2 != null && (listAgg = aggregateExpression2.aggregateFunction()) instanceof ListAgg) {
            ListAgg listAgg2 = (ListAgg)listAgg;
            if (aggregateExpression2.isDistinct() && listAgg2.needSaveOrderValue()) {
                throw this.throwFunctionAndOrderExpressionMismatchError(listAgg2);
            }
        }
        if (this.expressionResolutionContextStack().peek().hasAggregateExpressions()) {
            throw this.throwNestedAggregateFunction(aggregateExpression);
        }
        aggregateExpression.aggregateFunction().children().foreach((Function1 & Serializable)child -> {
            AggregateExpressionResolver.$anonfun$validateResolvedAggregateExpression$1(this, aggregateExpression, child);
            return BoxedUnit.UNIT;
        });
    }

    private Expression handleOuterAggregateExpression(AggregateExpression aggregateExpression) {
        if (this.expressionResolutionContextStack().peek().hasLocalReferences()) {
            throw QueryCompilationErrors$.MODULE$.mixedRefsInAggFunc(aggregateExpression.sql(), aggregateExpression.origin());
        }
        Expression resolvedOuterAggregateExpression = this.subqueryRegistry().currentScope().aggregateExpressionsExtractor().isDefined() ? this.extractOuterAggregateExpression(aggregateExpression, (GroupingAndAggregateExpressionsExtractor)this.subqueryRegistry().currentScope().aggregateExpressionsExtractor().get()) : aggregateExpression;
        AggregateExpression aggregateExpression2 = resolvedOuterAggregateExpression;
        if (aggregateExpression2 instanceof OuterReference) {
            OuterReference outerReference = (OuterReference)((Object)aggregateExpression2);
            outerReference.setTagValue(OuterReference$.MODULE$.SINGLE_PASS_SQL_STRING_OVERRIDE(), package$.MODULE$.toPrettySQL(aggregateExpression, package$.MODULE$.toPrettySQL$default$2()));
            return outerReference;
        }
        return aggregateExpression2;
    }

    private OuterReference extractOuterAggregateExpression(AggregateExpression aggregateExpression, GroupingAndAggregateExpressionsExtractor aggregateExpressionsExtractor) {
        Option referencedAggregateExpressionAlias;
        AggregateExpression aggregateExpressionWithStrippedOuterReferences = SubExprUtils$.MODULE$.stripOuterReference(aggregateExpression);
        Alias outerAggregateExpressionAlias = this.autoGeneratedAliasProvider().newOuterAlias(aggregateExpressionWithStrippedOuterReferences, this.autoGeneratedAliasProvider().newOuterAlias$default$2(), this.autoGeneratedAliasProvider().newOuterAlias$default$3());
        Tuple2<Option<Expression>, Option<Alias>> tuple2 = aggregateExpressionsExtractor.collectFirstAggregateExpression(aggregateExpressionWithStrippedOuterReferences);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option referencedAggregateExpressionAlias2 = (Option)tuple2._2();
        Option option = referencedAggregateExpressionAlias = referencedAggregateExpressionAlias2;
        if (option instanceof Some) {
            Some some = (Some)option;
            Alias alias = (Alias)some.value();
            this.subqueryRegistry().currentScope().addAliasForOuterAggregateExpression(alias);
            return new OuterReference(alias.toAttribute());
        }
        if (None$.MODULE$.equals(option)) {
            this.subqueryRegistry().currentScope().addAliasForOuterAggregateExpression(outerAggregateExpressionAlias);
            return new OuterReference(outerAggregateExpressionAlias.toAttribute());
        }
        throw new MatchError((Object)option);
    }

    private Nothing$ throwFunctionAndOrderExpressionMismatchError(ListAgg listAgg) {
        throw QueryCompilationErrors$.MODULE$.functionAndOrderExpressionMismatchError(listAgg.prettyName(), listAgg.child(), listAgg.orderExpressions());
    }

    private Nothing$ throwNestedAggregateFunction(AggregateExpression aggregateExpression) {
        throw new AnalysisException("NESTED_AGGREGATE_FUNCTION", Predef$.MODULE$.Map().empty(), aggregateExpression.origin());
    }

    private Nothing$ throwAggregateFunctionWithNondeterministicExpression(AggregateExpression aggregateExpression, Expression nonDeterministicChild) {
        throw new AnalysisException("AGGREGATE_FUNCTION_WITH_NONDETERMINISTIC_EXPRESSION", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlExpr"), (Object)this.toSQLExpr(aggregateExpression))})), nonDeterministicChild.origin());
    }

    public static final /* synthetic */ void $anonfun$validateResolvedAggregateExpression$1(AggregateExpressionResolver $this, AggregateExpression aggregateExpression$1, Expression child) {
        if (!child.deterministic()) {
            throw $this.throwAggregateFunctionWithNondeterministicExpression(aggregateExpression$1, child);
        }
    }

    public AggregateExpressionResolver(Resolver operatorResolver, ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        SQLConfHelper.$init$(this);
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolvesExpressionChildren.$init$(this);
        CoercesExpressionTypes.$init$(this);
        this.traversals = expressionResolver.getExpressionTreeTraversals();
        this.expressionResolutionContextStack = expressionResolver.getExpressionResolutionContextStack();
        this.subqueryRegistry = operatorResolver.getSubqueryRegistry();
        this.autoGeneratedAliasProvider = new AutoGeneratedAliasProvider(expressionResolver.getExpressionIdAssigner());
        Statics.releaseFence();
    }
}

