/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.python.BasePythonRunner;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.execution.GroupedIterator$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PandasGroupUtils$ {
    public static final PandasGroupUtils$ MODULE$ = new PandasGroupUtils$();

    public <T> Iterator<InternalRow> executePython(Iterator<T> data, Seq<Attribute> output, BasePythonRunner<T, ColumnarBatch> runner) {
        TaskContext context = TaskContext$.MODULE$.get();
        Iterator columnarBatchIter = runner.compute(data, context.partitionId(), context);
        UnsafeProjection unsafeProj = UnsafeProjection$.MODULE$.create(output, output);
        return columnarBatchIter.flatMap((Function1 & Serializable)batch -> {
            ArrowColumnVector structVector = (ArrowColumnVector)batch.column(0);
            IndexedSeq outputVectors = output.indices().map((Function1 & Serializable)x$1 -> structVector.getChild(BoxesRunTime.unboxToInt((Object)x$1)));
            ColumnarBatch flattenedBatch = new ColumnarBatch((ColumnVector[])outputVectors.toArray(ClassTag$.MODULE$.apply(ColumnVector.class)));
            flattenedBatch.setNumRows(batch.numRows());
            return CollectionConverters$.MODULE$.IteratorHasAsScala(flattenedBatch.rowIterator()).asScala();
        }).map((Function1)unsafeProj);
    }

    public Iterator<Tuple2<InternalRow, Iterator<InternalRow>>> groupAndProject(Iterator<InternalRow> input, Seq<Attribute> groupingAttributes, Seq<Attribute> inputSchema, Seq<Attribute> dedupSchema) {
        Iterator<Tuple2<InternalRow, Iterator<InternalRow>>> groupedIter = GroupedIterator$.MODULE$.apply(input, groupingAttributes, inputSchema);
        UnsafeProjection dedupProj = UnsafeProjection$.MODULE$.create(dedupSchema, inputSchema);
        return groupedIter.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                InternalRow k = (InternalRow)tuple2._1();
                Iterator groupedRowIter = (Iterator)tuple2._2();
                return new Tuple2((Object)k, (Object)groupedRowIter.map((Function1)dedupProj));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Tuple2<Seq<Attribute>, int[]> resolveArgOffsets(Seq<Attribute> attributes, Seq<Attribute> groupingAttributes) {
        Seq dataAttributes = (Seq)attributes.drop(groupingAttributes.length());
        Seq groupingIndicesInData = (Seq)groupingAttributes.map((Function1 & Serializable)attribute -> BoxesRunTime.boxToInteger((int)dataAttributes.indexWhere((Function1 & Serializable)other -> BoxesRunTime.boxToBoolean((boolean)attribute.semanticEquals(other)))));
        ArrayBuffer groupingArgOffsets = new ArrayBuffer();
        ArrayBuffer nonDupGroupingAttributes = new ArrayBuffer();
        int nonDupGroupingSize = groupingIndicesInData.count((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 == -1);
        ((IterableOnceOps)groupingAttributes.zip((IterableOnce)groupingIndicesInData)).foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Attribute attribute = (Attribute)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (index == -1) {
                    groupingArgOffsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)nonDupGroupingAttributes.length()));
                    return (ArrayBuffer)nonDupGroupingAttributes.$plus$eq((Object)attribute);
                }
                return (ArrayBuffer)groupingArgOffsets.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(index + nonDupGroupingSize)));
            }
            throw new MatchError((Object)tuple2);
        });
        Range dataArgOffsets = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(nonDupGroupingAttributes.length()), nonDupGroupingAttributes.length() + dataAttributes.length());
        int argOffsetsLength = groupingAttributes.length() + dataArgOffsets.length() + 1;
        int[] argOffsets = (int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.intArrayOps(new int[]{argOffsetsLength, groupingAttributes.length()}), (IterableOnce)groupingArgOffsets, (ClassTag)ClassTag$.MODULE$.Int())), (IterableOnce)dataArgOffsets, (ClassTag)ClassTag$.MODULE$.Int());
        ArrayBuffer dedupAttributes = (ArrayBuffer)nonDupGroupingAttributes.$plus$plus((IterableOnce)dataAttributes);
        return new Tuple2((Object)dedupAttributes.toSeq(), (Object)argOffsets);
    }

    private PandasGroupUtils$() {
    }
}

