/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAccumulate$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopKAggregateBuffer$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(expr, maxItemsTracked) - Accumulates items into a sketch.\n      `maxItemsTracked` An optional positive INTEGER literal with upper limit of 1000000. If maxItemsTracked is not specified, it defaults to 10000.\n  ", examples="\n    Examples:\n      > SELECT approx_top_k_estimate(_FUNC_(expr)) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT approx_top_k_estimate(_FUNC_(expr, 100), 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' AS tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n  ", group="agg_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tMf\u0001\u0002\u001c8\u0001\u001aC\u0001\u0002\u001d\u0001\u0003\u0016\u0004%\t!\u001d\u0005\te\u0002\u0011\t\u0012)A\u0005=\"A1\u000f\u0001BK\u0002\u0013\u0005\u0011\u000f\u0003\u0005u\u0001\tE\t\u0015!\u0003_\u0011!)\bA!f\u0001\n\u00031\b\u0002\u0003>\u0001\u0005#\u0005\u000b\u0011B<\t\u0011m\u0004!Q3A\u0005\u0002YD\u0001\u0002 \u0001\u0003\u0012\u0003\u0006Ia\u001e\u0005\u0006{\u0002!\tA \u0005\u0007{\u0002!\t!!\u0003\t\ru\u0004A\u0011AA\t\u0011\u0019i\b\u0001\"\u0001\u0002\u0018!Q\u00111\u0004\u0001\t\u0006\u0004%I!!\b\t\u0013\u0005-\u0002\u0001#b\u0001\n\u00131\bBBA\u0017\u0001\u0011\u0005\u0013\u000f\u0003\u0004\u00020\u0001!\t%\u001d\u0005\b\u0003c\u0001A\u0011IA\u001a\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007Bq!!\u0015\u0001\t\u0003\ni\u0002C\u0004\u0002T\u0001!\t%!\u0016\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!a%\u0001\t\u0003\n)\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005%\u0006\u0001\"\u0015\u0002,\"9\u0011Q\u0017\u0001\u0005B\u0005]\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\n\u0003'\u0004\u0011\u0011!C\u0001\u0003+D\u0011\"a8\u0001#\u0003%\t!!9\t\u0013\u0005]\b!%A\u0005\u0002\u0005\u0005\b\"CA}\u0001E\u0005I\u0011AA~\u0011%\ty\u0010AI\u0001\n\u0003\tY\u0010C\u0005\u0003\u0002\u0001\t\t\u0011\"\u0011\u0003\u0004!A!1\u0003\u0001\u0002\u0002\u0013\u0005a\u000fC\u0005\u0003\u0016\u0001\t\t\u0011\"\u0001\u0003\u0018!I!Q\u0004\u0001\u0002\u0002\u0013\u0005#q\u0004\u0005\n\u0005[\u0001\u0011\u0011!C\u0001\u0005_A\u0011Ba\r\u0001\u0003\u0003%\tE!\u000e\t\u0013\te\u0002!!A\u0005B\tmr!\u0003B0o\u0005\u0005\t\u0012\u0001B1\r!1t'!A\t\u0002\t\r\u0004BB?-\t\u0003\u0011Y\bC\u0005\u0003~1\n\t\u0011\"\u0012\u0003\u0000!I!\u0011\u0011\u0017\u0002\u0002\u0013\u0005%1\u0011\u0005\n\u0005\u001bc\u0013\u0013!C\u0001\u0003wD\u0011Ba$-#\u0003%\t!a?\t\u0013\tEE&!A\u0005\u0002\nM\u0005\"\u0003BSYE\u0005I\u0011AA~\u0011%\u00119\u000bLI\u0001\n\u0003\tY\u0010C\u0005\u0003*2\n\t\u0011\"\u0003\u0003,\n!\u0012\t\u001d9s_b$v\u000e]&BG\u000e,X.\u001e7bi\u0016T!\u0001O\u001d\u0002\u0013\u0005<wM]3hCR,'B\u0001\u001e<\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005qj\u0014\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005yz\u0014aA:rY*\u0011\u0001)Q\u0001\u0006gB\f'o\u001b\u0006\u0003\u0005\u000e\u000ba!\u00199bG\",'\"\u0001#\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u00019E\u000bW1e!\rA\u0015jS\u0007\u0002o%\u0011!j\u000e\u0002\u0019)f\u0004X\rZ%na\u0016\u0014\u0018\r^5wK\u0006;wM]3hCR,\u0007c\u0001%M\u001d&\u0011Qj\u000e\u0002\u001a\u0003B\u0004(o\u001c=U_B\\\u0015iZ4sK\u001e\fG/\u001a\"vM\u001a,'\u000f\u0005\u0002P%6\t\u0001KC\u0001R\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0006KA\u0002B]f\u0004\"!\u0016,\u000e\u0003eJ!aV\u001d\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u00042!\u0017/_\u001b\u0005Q&BA.<\u0003\u0015!(/Z3t\u0013\ti&L\u0001\u0006CS:\f'/\u001f'jW\u0016\u0004\"!V0\n\u0005\u0001L$AC#yaJ,7o]5p]B\u0011qJY\u0005\u0003GB\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002f[:\u0011am\u001b\b\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0016\u000ba\u0001\u0010:p_Rt\u0014\"A)\n\u00051\u0004\u0016a\u00029bG.\fw-Z\u0005\u0003]>\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001\u001c)\u0002\t\u0015D\bO]\u000b\u0002=\u0006)Q\r\u001f9sA\u0005yQ.\u0019=Ji\u0016l7\u000f\u0016:bG.,G-\u0001\tnCbLE/Z7t)J\f7m[3eA\u00051R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G/F\u0001x!\ty\u00050\u0003\u0002z!\n\u0019\u0011J\u001c;\u0002/5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\u0004\u0013\u0001F5oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bj]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002\rqJg.\u001b;?)%y\u0018\u0011AA\u0002\u0003\u000b\t9\u0001\u0005\u0002I\u0001!)\u0001/\u0003a\u0001=\")1/\u0003a\u0001=\"9Q/\u0003I\u0001\u0002\u00049\bbB>\n!\u0003\u0005\ra\u001e\u000b\u0006\u007f\u0006-\u0011q\u0002\u0005\u0007\u0003\u001bQ\u0001\u0019\u00010\u0002\u000b\rD\u0017\u000e\u001c3\t\u000bMT\u0001\u0019\u00010\u0015\u000b}\f\u0019\"!\u0006\t\r\u000551\u00021\u0001_\u0011\u0015\u00198\u00021\u0001x)\ry\u0018\u0011\u0004\u0005\u0007\u0003\u001ba\u0001\u0019\u00010\u0002\u0019%$X-\u001c#bi\u0006$\u0016\u0010]3\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Oi!!a\t\u000b\u0007\u0005\u0015R(A\u0003usB,7/\u0003\u0003\u0002*\u0005\r\"\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002%5\f\u00070\u0013;f[N$&/Y2lK\u00124\u0016\r\\\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\"!!\u000e\u0011\u000b\u0015\f9$a\u000f\n\u0007\u0005erNA\u0002TKF\u0004B!!\t\u0002>%!\u0011qHA\u0012\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0002FA!\u0011qIA'\u001b\t\tIEC\u0002\u0002Lm\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0003\u001f\nIEA\bUsB,7\t[3dWJ+7/\u001e7u\u0003!!\u0017\r^1UsB,\u0017aF2sK\u0006$X-Q4he\u0016<\u0017\r^5p]\n+hMZ3s)\u0005Y\u0015AB;qI\u0006$X\rF\u0003L\u00037\ny\u0006\u0003\u0004\u0002^U\u0001\raS\u0001\u0007EV4g-\u001a:\t\u000f\u0005\u0005T\u00031\u0001\u0002d\u0005)\u0011N\u001c9viB!\u0011QMA4\u001b\u0005Y\u0014bAA5w\tY\u0011J\u001c;fe:\fGNU8x\u0003\u0015iWM]4f)\u0015Y\u0015qNA9\u0011\u0019\tiF\u0006a\u0001\u0017\"1\u0011\u0011\r\fA\u0002-\u000bA!\u001a<bYR\u0019a*a\u001e\t\r\u0005us\u00031\u0001L\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0002~\u0005%\u0005#B(\u0002\u0000\u0005\r\u0015bAAA!\n)\u0011I\u001d:bsB\u0019q*!\"\n\u0007\u0005\u001d\u0005K\u0001\u0003CsR,\u0007BBA/1\u0001\u00071*A\u0006eKN,'/[1mSj,GcA&\u0002\u0010\"9\u0011\u0011S\rA\u0002\u0005u\u0014!D:u_J\fw-\u001a$pe6\fG/A\u000fxSRDg*Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u)\u0011\t9*!(\u0011\u0007!\u000bI*C\u0002\u0002\u001c^\u00121#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016Da!a(\u001b\u0001\u00049\u0018!\u00078fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\f1d^5uQ:+w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BAL\u0003KCa!a*\u001c\u0001\u00049\u0018a\u00068fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003_\u0003[\u000b\t\f\u0003\u0004\u00020r\u0001\rAX\u0001\b]\u0016<H*\u001a4u\u0011\u0019\t\u0019\f\ba\u0001=\u0006Aa.Z<SS\u001eDG/\u0001\u0005ok2d\u0017M\u00197f+\t\tI\fE\u0002P\u0003wK1!!0Q\u0005\u001d\u0011un\u001c7fC:\f!\u0002\u001d:fiRLh*Y7f+\t\t\u0019\r\u0005\u0003\u0002F\u00065g\u0002BAd\u0003\u0013\u0004\"a\u001a)\n\u0007\u0005-\u0007+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\f\tN\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017\u0004\u0016\u0001B2paf$\u0012b`Al\u00033\fY.!8\t\u000fA|\u0002\u0013!a\u0001=\"91o\bI\u0001\u0002\u0004q\u0006bB; !\u0003\u0005\ra\u001e\u0005\bw~\u0001\n\u00111\u0001x\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a9+\u0007y\u000b)o\u000b\u0002\u0002hB!\u0011\u0011^Az\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018!C;oG\",7m[3e\u0015\r\t\t\u0010U\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA{\u0003W\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002~*\u001aq/!:\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0002\u0011\t\t\u001d!\u0011C\u0007\u0003\u0005\u0013QAAa\u0003\u0003\u000e\u0005!A.\u00198h\u0015\t\u0011y!\u0001\u0003kCZ\f\u0017\u0002BAh\u0005\u0013\tA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002O\u00053A\u0001Ba\u0007'\u0003\u0003\u0005\ra^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0002#\u0002B\u0012\u0005SqUB\u0001B\u0013\u0015\r\u00119\u0003U\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0016\u0005K\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u0018B\u0019\u0011!\u0011Y\u0002KA\u0001\u0002\u0004q\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u0002\u00038!A!1D\u0015\u0002\u0002\u0003\u0007q/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\u0013i\u0004\u0003\u0005\u0003\u001c)\n\t\u00111\u0001OQM\u0001!\u0011\tB$\u0005\u0013\u0012iEa\u0014\u0003T\tU#\u0011\fB.!\r)&1I\u0005\u0004\u0005\u000bJ$!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005\u0017\n\u00111\u0018\u0006!A\u0001\u0002sLR+O\u0007~CS\r\u001f9sY\u0001j\u0017\r_%uK6\u001cHK]1dW\u0016$\u0017\u0006I\u0017!\u0003\u000e\u001cW/\\;mCR,7\u000fI5uK6\u001c\b%\u001b8u_\u0002\n\u0007e]6fi\u000eDgF\u0003\u0011!A\u0001\u0002\u0003\u0005Y7bq&#X-\\:Ue\u0006\u001c7.\u001a3aA\u0005s\u0007e\u001c9uS>t\u0017\r\u001c\u0011q_NLG/\u001b<fA%sE+R$F%\u0002b\u0017\u000e^3sC2\u0004s/\u001b;iAU\u0004\b/\u001a:!Y&l\u0017\u000e\u001e\u0011pM\u0002\n\u0004\u0007\r\u00191aAr\u0003%\u00134![\u0006D\u0018\n^3ngR\u0013\u0018mY6fI\u0002J7\u000f\t8pi\u0002\u001a\b/Z2jM&,G\r\f\u0011ji\u0002\"WMZ1vYR\u001c\b\u0005^8!cA\u0002\u0004\u0007\r\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0005#\n1q\u000b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!CB\u0004(o\u001c=`i>\u0004xl[0fgRLW.\u0019;fQ}3UKT\"`Q\u0015D\bO]\u0015*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005\u000b\u0019*Y\u0001B\u0013'\u000b\u0017!QEJC\u0006\t\u00153S1\u0002\u0003fM\u0015-A!\"\u0014\u0006\f\u0011)i%\u0002\u0013i\u0015\u0011uC\nDS\r\u001f9sSmR\u0001\u0005\t\u0011!A\u0001\u00023l\u001f\u0012ji\u0016l'E\u000f\u0019-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'E\u000f\u001b-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'EO\u0019-E\r|WO\u001c;#uIjHf\u001f\u0012ji\u0016l'E\u000f\u001a-E\r|WO\u001c;#uEjHf\u001f\u0012ji\u0016l'EO\u001a-E\r|WO\u001c;#uEjXL\u0003\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!CB\u0004(o\u001c=`i>\u0004xl[0fgRLW.\u0019;fQ}3UKT\"`Q\u0015D\bO\u001d\u0017!cA\u0002\u0014\u0006\f\u00113S\u00012%kT'!-\u0006cU+R*!O\u0005<C\u0006I\u0014cO1\u0002seY\u0014-A\u001d\u001aw\u0005\f\u0011(G\u001eb\u0003eJ2(Y\u0001:Cm\n\u0017!O\u0011<\u0003%Q*!i\u0006\u0014\u0007&\u001a=qe&Z$\u0002\t\u0011!A\u0001\u0002\u0003eW>#SR,WN\t\u001e#G\nb#eY8v]R\u0014#\bN?-w\nJG/Z7#u\t\"'\u0005\f\u0012d_VtGO\t\u001e3{vS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0005/\n\u0011\"Y4h?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\tu\u0013!\u0002\u001b/c9\u0002\u0014\u0001F!qaJ|\u0007\u0010V8q\u0017\u0006\u001b7-^7vY\u0006$X\r\u0005\u0002IYM)AF!\u001a\u0003rAI!q\rB7=z;xo`\u0007\u0003\u0005SR1Aa\u001bQ\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u001c\u0003j\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0011\t\tM$\u0011P\u0007\u0003\u0005kRAAa\u001e\u0003\u000e\u0005\u0011\u0011n\\\u0005\u0004]\nUDC\u0001B1\u0003!!xn\u0015;sS:<GC\u0001B\u0003\u0003\u0015\t\u0007\u000f\u001d7z)%y(Q\u0011BD\u0005\u0013\u0013Y\tC\u0003q_\u0001\u0007a\fC\u0003t_\u0001\u0007a\fC\u0004v_A\u0005\t\u0019A<\t\u000fm|\u0003\u0013!a\u0001o\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!&\u0003\"B)qJa&\u0003\u001c&\u0019!\u0011\u0014)\u0003\r=\u0003H/[8o!\u001dy%Q\u00140_o^L1Aa(Q\u0005\u0019!V\u000f\u001d7fi!A!1\u0015\u001a\u0002\u0002\u0003\u0007q0A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003.B!!q\u0001BX\u0013\u0011\u0011\tL!\u0003\u0003\r=\u0013'.Z2u\u0001")
public class ApproxTopKAccumulate
extends TypedImperativeAggregate<ApproxTopKAggregateBuffer<Object>>
implements ImplicitCastInputTypes,
BinaryLike<Expression>,
Serializable {
    private DataType itemDataType;
    private int maxItemsTrackedVal;
    private final Expression expr;
    private final Expression maxItemsTracked;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$4() {
        return ApproxTopKAccumulate$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return ApproxTopKAccumulate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Expression, Object, Object>> unapply(ApproxTopKAccumulate x$0) {
        return ApproxTopKAccumulate$.MODULE$.unapply(x$0);
    }

    public static int apply$default$4() {
        return ApproxTopKAccumulate$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return ApproxTopKAccumulate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Expression, Object, Object>, ApproxTopKAccumulate> tupled() {
        return ApproxTopKAccumulate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, ApproxTopKAccumulate>>>> curried() {
        return ApproxTopKAccumulate$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        ApproxTopKAccumulate approxTopKAccumulate = this;
        synchronized (approxTopKAccumulate) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    public Expression expr() {
        return this.expr;
    }

    public Expression maxItemsTracked() {
        return this.maxItemsTracked;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopKAccumulate approxTopKAccumulate = this;
        synchronized (approxTopKAccumulate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.itemDataType = this.expr().dataType();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    /*
     * WARNING - void declaration
     */
    private int maxItemsTrackedVal$lzycompute() {
        ApproxTopKAccumulate approxTopKAccumulate = this;
        synchronized (approxTopKAccumulate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_2;
                ApproxTopK$.MODULE$.checkExpressionNotNull(this.maxItemsTracked(), "maxItemsTracked");
                int maxItemsTrackedVal = BoxesRunTime.unboxToInt((Object)this.maxItemsTracked().eval(this.maxItemsTracked().eval$default$1()));
                ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTrackedVal);
                this.maxItemsTrackedVal = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.maxItemsTrackedVal;
    }

    private int maxItemsTrackedVal() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.maxItemsTrackedVal$lzycompute();
        }
        return this.maxItemsTrackedVal;
    }

    @Override
    public Expression left() {
        return this.expr();
    }

    @Override
    public Expression right() {
        return this.maxItemsTracked();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)AnyDataType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!ApproxTopK$.MODULE$.isDataTypeSupported(this.itemDataType())) {
            return new TypeCheckResult.TypeCheckFailure(this.itemDataType().typeName() + " columns are not supported");
        }
        if (!this.maxItemsTracked().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("Number of items tracked must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getSketchStateDataType(this.itemDataType());
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> createAggregationBuffer() {
        int maxMapSize = ApproxTopK$.MODULE$.calMaxMapSize(this.maxItemsTrackedVal());
        ItemsSketch<Object> sketch = ApproxTopK$.MODULE$.createItemsSketch(this.expr(), maxMapSize);
        return new ApproxTopKAggregateBuffer<Object>(sketch, 0L);
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> update(ApproxTopKAggregateBuffer<Object> buffer, InternalRow input) {
        return buffer.update(this.expr(), input);
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> merge(ApproxTopKAggregateBuffer<Object> buffer, ApproxTopKAggregateBuffer<Object> input) {
        return buffer.merge(input);
    }

    @Override
    public Object eval(ApproxTopKAggregateBuffer<Object> buffer) {
        byte[] sketchBytes = this.serialize(buffer);
        String itemDataTypeDDL = ApproxTopK$.MODULE$.dataTypeToDDL(this.itemDataType());
        return InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{sketchBytes, BoxesRunTime.boxToInteger((int)this.maxItemsTrackedVal()), null, UTF8String.fromString((String)itemDataTypeDDL)}));
    }

    @Override
    public byte[] serialize(ApproxTopKAggregateBuffer<Object> buffer) {
        return buffer.serialize(ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ApproxTopKAggregateBuffer<Object> deserialize(byte[] storageFormat) {
        return ApproxTopKAggregateBuffer$.MODULE$.deserialize(storageFormat, ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, x$1, x$4);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        int x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, x$1);
    }

    @Override
    public Expression withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3(), this.copy$default$4());
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k_accumulate");
    }

    public ApproxTopKAccumulate copy(Expression expr, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopKAccumulate(expr, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.expr();
    }

    public Expression copy$default$2() {
        return this.maxItemsTracked();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopKAccumulate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return this.maxItemsTracked();
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 3: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopKAccumulate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "maxItemsTracked";
            }
            case 2: {
                return "mutableAggBufferOffset";
            }
            case 3: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopKAccumulate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopKAccumulate approxTopKAccumulate = (ApproxTopKAccumulate)x$1;
        if (this.mutableAggBufferOffset() != approxTopKAccumulate.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approxTopKAccumulate.inputAggBufferOffset()) return false;
        Expression expression = this.expr();
        Expression expression2 = approxTopKAccumulate.expr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.maxItemsTracked();
        Expression expression4 = approxTopKAccumulate.maxItemsTracked();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!approxTopKAccumulate.canEqual(this)) return false;
        return true;
    }

    public ApproxTopKAccumulate(Expression expr, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.expr = expr;
        this.maxItemsTracked = maxItemsTracked;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
        BinaryLike.$init$(this);
    }

    public ApproxTopKAccumulate(Expression child, Expression maxItemsTracked) {
        this(child, maxItemsTracked, 0, 0);
    }

    public ApproxTopKAccumulate(Expression child, int maxItemsTracked) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)maxItemsTracked)), 0, 0);
    }

    public ApproxTopKAccumulate(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_MAX_ITEMS_TRACKED())), 0, 0);
    }
}

