/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging;

import java.lang.reflect.Constructor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogException;
import org.apache.ibatis.logging.commons.JakartaCommonsLoggingImpl;
import org.apache.ibatis.logging.jdk14.Jdk14LoggingImpl;
import org.apache.ibatis.logging.log4j.Log4jImpl;
import org.apache.ibatis.logging.log4j2.Log4j2Impl;
import org.apache.ibatis.logging.nologging.NoLoggingImpl;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.logging.stdout.StdOutImpl;

public final class LogFactory {
    public static final String MARKER = "MYBATIS";
    private static Constructor<? extends Log> logConstructor;

    private LogFactory() {
    }

    public static Log getLog(Class<?> clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String logger) {
        try {
            return logConstructor.newInstance(logger);
        }
        catch (Throwable t) {
            throw new LogException("Error creating logger for logger " + logger + ".  Cause: " + t, t);
        }
    }

    public static synchronized void useCustomLogging(Class<? extends Log> clazz) {
        LogFactory.setImplementation(clazz);
    }

    public static synchronized void useSlf4jLogging() {
        LogFactory.setImplementation(Slf4jImpl.class);
    }

    public static synchronized void useCommonsLogging() {
        LogFactory.setImplementation(JakartaCommonsLoggingImpl.class);
    }

    @Deprecated
    public static synchronized void useLog4JLogging() {
        LogFactory.setImplementation(Log4jImpl.class);
    }

    public static synchronized void useLog4J2Logging() {
        LogFactory.setImplementation(Log4j2Impl.class);
    }

    public static synchronized void useJdkLogging() {
        LogFactory.setImplementation(Jdk14LoggingImpl.class);
    }

    public static synchronized void useStdOutLogging() {
        LogFactory.setImplementation(StdOutImpl.class);
    }

    public static synchronized void useNoLogging() {
        LogFactory.setImplementation(NoLoggingImpl.class);
    }

    private static void tryImplementation(Runnable runnable) {
        if (logConstructor == null) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void setImplementation(Class<? extends Log> implClass) {
        try {
            Constructor<? extends Log> candidate = implClass.getConstructor(String.class);
            Log log = candidate.newInstance(LogFactory.class.getName());
            if (log.isDebugEnabled()) {
                log.debug("Logging initialized using '" + implClass + "' adapter.");
            }
            logConstructor = candidate;
        }
        catch (Throwable t) {
            throw new LogException("Error setting Log implementation.  Cause: " + t, t);
        }
    }

    static {
        LogFactory.tryImplementation(LogFactory::useSlf4jLogging);
        LogFactory.tryImplementation(LogFactory::useCommonsLogging);
        LogFactory.tryImplementation(LogFactory::useLog4J2Logging);
        LogFactory.tryImplementation(LogFactory::useLog4JLogging);
        LogFactory.tryImplementation(LogFactory::useJdkLogging);
        LogFactory.tryImplementation(LogFactory::useNoLogging);
    }
}

