/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.util.Iterator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.sampling.DistributedRandomSampler;
import org.apache.flink.api.java.sampling.IntermediateSampleData;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithReplacement;
import org.apache.flink.api.java.sampling.ReservoirSamplerWithoutReplacement;
import org.apache.flink.util.Collector;

@Internal
public class SampleInCoordinator<T>
implements GroupReduceFunction<IntermediateSampleData<T>, T> {
    private boolean withReplacement;
    private int numSample;
    private long seed;

    public SampleInCoordinator(boolean withReplacement, int numSample, long seed) {
        this.withReplacement = withReplacement;
        this.numSample = numSample;
        this.seed = seed;
    }

    public void reduce(Iterable<IntermediateSampleData<T>> values, Collector<T> out) throws Exception {
        DistributedRandomSampler sampler = this.withReplacement ? new ReservoirSamplerWithReplacement(this.numSample, this.seed) : new ReservoirSamplerWithoutReplacement(this.numSample, this.seed);
        Iterator<T> sampled = sampler.sampleInCoordinator(values.iterator());
        while (sampled.hasNext()) {
            out.collect(sampled.next());
        }
    }
}

