/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.concurrent;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.iterative.io.SerializedUpdateBuffer;

public class BlockingBackChannel {
    private final SerializedUpdateBuffer buffer;
    private final BlockingQueue<SerializedUpdateBuffer> queue;

    public BlockingBackChannel(SerializedUpdateBuffer buffer) {
        this.buffer = buffer;
        this.queue = new ArrayBlockingQueue<SerializedUpdateBuffer>(1);
    }

    public DataInputView getReadEndAfterSuperstepEnded() {
        try {
            return this.queue.take().switchBuffers();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public DataOutputView getWriteEnd() {
        return this.buffer;
    }

    public void notifyOfEndOfSuperstep() {
        this.queue.offer(this.buffer);
    }
}

